/*
 * Decompiled with CFR 0.152.
 */
package com.magmic;

import com.magmic.Font;
import com.magmic.MagmicGame;
import com.magmic.MagmicStringBuffer;
import com.magmic.Window;
import com.magmic.pykegame.MagmicLayer;
import com.magmic.ui.MagmicGraphics;

public class MessageWindow
extends Window {
    public Font font;
    public char[] message;
    public int message_offset;
    public int message_length;
    public int messageLinesCount;
    public int currentLine;
    public int controlLinesCount;
    public int visibleOptionCount;
    public int selectedOptionIndex;
    public int escapeOptionIndex;
    public int defaultOptionIndex;
    public int optionsCount;
    public int optionsOffset;
    public int[] optionsId;
    public int selectedOptionId;
    public boolean closeOnConfirmOption;
    public int topOption;
    public boolean receivedKeyDown;

    public MessageWindow(MagmicGame magmicGame) {
        super(magmicGame);
        this.left_softkey_label = " Back";
    }

    public void pack(boolean bl) {
        int n;
        int n2;
        this.setBounds(0, 0, 2000, 2000, 0);
        int n3 = this.center_h - this.font.line_height * this.visibleOptionCount;
        int n4 = 0;
        MagmicStringBuffer magmicStringBuffer = MagmicStringBuffer.global_buffer;
        for (n2 = 0; n2 < this.optionsCount; ++n2) {
            magmicStringBuffer.clear();
            this.maglet.strings.append_string(this.optionsId[this.optionsOffset + n2], magmicStringBuffer);
            n = this.font.get_chars_width(magmicStringBuffer.chars, 0, magmicStringBuffer.length);
            if (n <= n4) continue;
            n4 = n;
        }
        magmicStringBuffer.clear();
        if (this.titleString != null) {
            magmicStringBuffer.append(this.titleString);
        }
        if (this.titleId != -1) {
            this.maglet.strings.append_string(this.titleId, magmicStringBuffer);
        }
        if ((n2 = this.font.get_chars_width(magmicStringBuffer.chars, 0, magmicStringBuffer.length)) > n4) {
            n4 = n2;
        }
        n = this.center_w - n4;
        this.setSizeAndCenter(this.w - n, this.h - n3, bl ? 2 : 0);
    }

    public void setupMessage(Font font, char[] cArray, int n, int n2) {
        this.font = font;
        this.message = cArray;
        this.message_offset = n;
        this.message_length = n2;
        this.controlLinesCount = 1;
        this.updatePageCount();
    }

    public void setupOptions(int[] nArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.optionsId = nArray;
        this.optionsOffset = n;
        this.optionsCount = n2;
        this.defaultOptionIndex = this.getOptionIndex(n3);
        this.escapeOptionIndex = this.getOptionIndex(n4);
        this.visibleOptionCount = n5;
        this.selectedOptionIndex = this.defaultOptionIndex;
        this.updateSelectedOptionId();
        this.right_softkey_label = this.optionsCount > 0 && bl ? "Help " : "";
        this.maglet.updateSoftKeys = true;
    }

    public void setuptNoOptions() {
        this.setupOptions(null, 0, 0, 0, 0, 0, false);
    }

    public void updateCenterDimension() {
        super.updateCenterDimension();
        this.updatePageCount();
    }

    public void updatePageCount() {
        if (this.font != null) {
            this.messageLinesCount = this.font.get_chars_line_count(this.message, this.message_offset, this.message_length, this.center_w);
            this.currentLine = 0;
        }
    }

    public void open(MagmicLayer magmicLayer) {
        super.open(magmicLayer);
        this.currentLine = 0;
        this.receivedKeyDown = false;
        this.selectedOptionIndex = this.defaultOptionIndex;
        this.topOption = Math.max(0, Math.min(this.selectedOptionIndex, this.optionsCount - this.visibleOptionCount));
        this.updateSelectedOptionId();
    }

    public void open(MagmicLayer magmicLayer, int n) {
        super.open(magmicLayer);
        this.currentLine = 0;
        this.receivedKeyDown = false;
        this.setSelection(n);
    }

    public void setSelection(int n) {
        this.selectedOptionIndex = this.getOptionIndex(n);
        this.updateSelectedOptionId();
    }

    public void updateSelectedOptionId() {
        if (this.optionsCount > 0) {
            this.selectedOptionId = this.optionsId[this.optionsOffset + this.selectedOptionIndex];
        }
    }

    public int getOptionIndex(int n) {
        for (int i = 0; i < this.optionsCount; ++i) {
            if (this.optionsId[this.optionsOffset + i] != n) continue;
            return i;
        }
        return 0;
    }

    public void paint(MagmicGraphics magmicGraphics) {
        super.paint(magmicGraphics);
        if (this.isTransiting()) {
            return;
        }
        int n = this.getLinesPerPage();
        this.font.paint_chars(magmicGraphics, this.message, this.message_offset, this.message_length, this.center_x, this.center_y, this.center_w, this.currentLine, n);
        MagmicStringBuffer magmicStringBuffer = MagmicStringBuffer.global_buffer;
        magmicStringBuffer.clear();
        if ((!this.isFirstPage() || this.isLastPage()) && this.optionsCount == 0 && this.getLinesPerPage() <= this.messageLinesCount) {
            this.maglet.strings.append_string(100, magmicStringBuffer);
            this.font.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, this.center_x, this.center_y + this.center_h - this.font.line_height);
        }
        if (!this.isLastPage()) {
            magmicStringBuffer.clear();
            this.maglet.strings.append_string(98, magmicStringBuffer);
            this.font.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, this.center_x + this.center_w - this.font.get_chars_width(magmicStringBuffer.chars, 0, magmicStringBuffer.length), this.center_y + this.center_h - this.font.line_height);
        } else if (this.optionsCount != 0) {
            int n2 = this.topOption;
            for (int i = 0; i < this.visibleOptionCount; ++i) {
                magmicStringBuffer.clear();
                this.maglet.strings.append_string(this.optionsId[this.optionsOffset + n2 + i], magmicStringBuffer);
                int n3 = this.font.get_chars_width(magmicStringBuffer.chars, 0, magmicStringBuffer.length);
                int n4 = this.font.base_line;
                int n5 = this.center_x + (this.center_w - n3) / 2;
                int n6 = this.center_y + this.center_h - this.font.line_height * (this.visibleOptionCount - i);
                this.font.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n5, n6);
                if (n2 + i == this.selectedOptionIndex) {
                    int n7 = this.maglet.menuIcon.getWidth();
                    int n8 = n6 + (n4 - this.maglet.menuIcon.getHeight()) / 2;
                    this.maglet.menuIcon.draw(magmicGraphics, this.center_x - n7, n8);
                    this.maglet.menuIcon.draw(magmicGraphics, this.center_x + this.center_w, n8);
                }
                if (i == this.visibleOptionCount - 1 && i + n2 < this.optionsCount - 1) {
                    this.maglet.arrowDown.draw(magmicGraphics, this.center_x + (this.center_w - this.maglet.arrowDown.getWidth()) / 2, n6 + n4);
                }
                if (i != 0 || n2 <= 0) continue;
                this.maglet.arrowUp.draw(magmicGraphics, this.center_x + (this.center_w - this.maglet.arrowUp.getWidth()) / 2, n6 - this.maglet.arrowUp.getHeight());
            }
        }
    }

    public boolean tick(int n) {
        return super.tick(n);
    }

    public boolean key_down(int n, int n2) {
        boolean bl;
        if (this.isTransiting()) {
            return false;
        }
        this.receivedKeyDown = true;
        switch (n) {
            case 4: {
                if (this.topOption == this.selectedOptionIndex) {
                    --this.topOption;
                }
                --this.selectedOptionIndex;
                if (this.selectedOptionIndex < 0) {
                    this.selectedOptionIndex = this.optionsCount - 1;
                    this.topOption = Math.max(0, Math.min(this.selectedOptionIndex, this.optionsCount - this.visibleOptionCount));
                }
                this.updateSelectedOptionId();
                bl = true;
                break;
            }
            case 5: {
                if (this.topOption == this.selectedOptionIndex - this.visibleOptionCount + 1) {
                    ++this.topOption;
                }
                ++this.selectedOptionIndex;
                if (this.selectedOptionIndex >= this.optionsCount) {
                    this.selectedOptionIndex = 0;
                    this.topOption = Math.max(0, Math.min(this.selectedOptionIndex, this.optionsCount - this.visibleOptionCount));
                }
                this.updateSelectedOptionId();
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (this.listener != null) {
            this.listener.window_key_down(this, n, n2);
        }
        return bl;
    }

    public boolean key_up(int n, int n2) {
        boolean bl;
        if (this.isTransiting()) {
            return false;
        }
        if (!this.receivedKeyDown) {
            return false;
        }
        switch (n) {
            case 2: {
                if ((!this.isFirstPage() || this.isLastPage()) && this.optionsCount == 0) {
                    if (this.isLastPage()) {
                        ++this.currentLine;
                    }
                    this.currentLine -= this.getLinesPerPage();
                    if (this.currentLine < 0) {
                        this.currentLine = 0;
                    }
                }
                bl = true;
                break;
            }
            case 3: {
                if (this.optionsCount != 0) {
                    bl = true;
                    break;
                }
            }
            case 6: {
                if (!this.isLastPage()) {
                    this.currentLine += this.getLinesPerPage();
                    if (this.currentLine >= this.messageLinesCount) {
                        this.currentLine -= this.getLinesPerPage();
                    }
                } else {
                    if (this.optionsCount != 0 && this.listener != null) {
                        this.listener.window_confirm_option(this, n, n2, this.selectedOptionId);
                    }
                    if (this.closeOnConfirmOption && this.optionsCount != 0) {
                        this.close();
                    }
                }
                bl = true;
                break;
            }
            case 1: {
                this.selectedOptionIndex = this.escapeOptionIndex;
                this.updateSelectedOptionId();
                if (this.optionsCount != 0 && this.listener != null) {
                    this.listener.window_confirm_option(this, n, n2, this.selectedOptionId);
                }
                if (this.closeOnConfirmOption || this.optionsCount == 0) {
                    this.close();
                }
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (this.listener != null) {
            this.listener.window_key_up(this, n, n2);
        }
        return bl;
    }

    public int getLinesPerPage() {
        int n = this.center_h / this.font.line_height;
        if (this.visibleOptionCount > n) {
            this.visibleOptionCount = n;
        }
        if (this.currentLine + (n -= this.controlLinesCount) >= this.messageLinesCount) {
            n += this.controlLinesCount;
            n -= this.visibleOptionCount;
        }
        return n;
    }

    public boolean isFirstPage() {
        return this.currentLine < this.getLinesPerPage();
    }

    public boolean isLastPage() {
        return this.currentLine + this.getLinesPerPage() >= this.messageLinesCount;
    }
}

