/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.slic;

import com.magmic.maglet.Maglet;
import com.magmic.slic.Slic;
import com.magmic.slic.Spr;
import com.magmic.ui.MagmicGraphics;
import java.io.IOException;
import java.io.InputStream;

public class MetaSprite {
    private static final int MODE_WIDTH = 0;
    private static final int MODE_HEIGHT = 1;
    private static final int MODE_MINX = 2;
    private static final int MODE_MINY = 3;
    private static final String EXTENSION = ".meta.spr";
    public int version;
    public int[] metaSeqOffsets;
    public int[] layerCount;
    public int[] sprites;
    public int[] spriteSeqs;
    public int[] xAnchors;
    public int[] yAnchors;
    public Spr[] slicSprites;
    public int numMetaSeqs;
    public int totalNumLayers;
    public int currentSeq;
    private Slic slic;
    public boolean loaded;
    private int loadSeq;
    public boolean useTimers;
    public int[] timerDelays;
    public int[] tempTimers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaSprite(Slic slic, int n) {
        this.slic = slic;
        this.loaded = false;
        this.loadSeq = 0;
        String string = "/" + Integer.toString(n) + EXTENSION;
        Maglet.getInstance();
        InputStream inputStream = Maglet.getResourceInputStream(string);
        try {
            this.version = MetaSprite.readS32(inputStream);
            this.numMetaSeqs = MetaSprite.readS32(inputStream);
            this.metaSeqOffsets = new int[this.numMetaSeqs];
            this.layerCount = new int[this.numMetaSeqs];
            this.totalNumLayers = MetaSprite.readS32(inputStream);
            this.sprites = new int[this.totalNumLayers];
            this.spriteSeqs = new int[this.totalNumLayers];
            this.xAnchors = new int[this.totalNumLayers];
            this.yAnchors = new int[this.totalNumLayers];
            if (this.version == 2) {
                this.useTimers = true;
                this.timerDelays = new int[this.totalNumLayers];
            } else {
                this.useTimers = false;
            }
            this.slicSprites = new Spr[this.totalNumLayers];
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < this.numMetaSeqs; ++i) {
                n4 = MetaSprite.readS32(inputStream);
                this.layerCount[n4] = n3 = MetaSprite.readS32(inputStream);
                this.metaSeqOffsets[n4] = n2;
                for (int j = 0; j < n3; ++j) {
                    this.sprites[n2 + j] = MetaSprite.readS32(inputStream);
                    this.spriteSeqs[n2 + j] = MetaSprite.readS32(inputStream);
                    this.xAnchors[n2 + j] = MetaSprite.readS32(inputStream);
                    this.yAnchors[n2 + j] = MetaSprite.readS32(inputStream);
                    if (!this.useTimers) continue;
                    this.timerDelays[n2 + j] = MetaSprite.readS32(inputStream);
                }
                n2 += n3;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.currentSeq = 0;
    }

    public void paint(MagmicGraphics magmicGraphics, int n, int n2) {
        if (!this.loaded) {
            return;
        }
        int n3 = this.layerCount[this.currentSeq];
        int n4 = this.metaSeqOffsets[this.currentSeq];
        for (int i = 0; i < n3; ++i) {
            if (this.slicSprites[n4 + i] == null) continue;
            this.slicSprites[n4 + i].paint(magmicGraphics, n + this.xAnchors[n4 + i], n2 + this.yAnchors[n4 + i]);
        }
    }

    public void setSeq(int n) {
        this.currentSeq = n;
        if (!this.loaded) {
            return;
        }
        int n2 = this.layerCount[this.currentSeq];
        int n3 = this.metaSeqOffsets[this.currentSeq];
        if (this.useTimers) {
            this.tempTimers = null;
            this.tempTimers = new int[n2];
        }
        for (int i = 0; i < n2; ++i) {
            if (this.useTimers) {
                this.tempTimers[i] = this.timerDelays[n3 + i];
            }
            this.slicSprites[n3 + i].setSeq(this.spriteSeqs[n3 + i]);
        }
    }

    public int getSeq() {
        return this.currentSeq;
    }

    public int getSeqCount() {
        return this.numMetaSeqs;
    }

    public void calc(int n) {
        if (!this.loaded) {
            return;
        }
        int n2 = this.layerCount[this.currentSeq];
        int n3 = this.metaSeqOffsets[this.currentSeq];
        for (int i = 0; i < n2; ++i) {
            if (this.slicSprites[n3 + i] == null) continue;
            if (this.useTimers && this.tempTimers[i] > 0) {
                int n4 = i;
                this.tempTimers[n4] = this.tempTimers[n4] - n;
                continue;
            }
            this.slicSprites[n3 + i].calc(n);
        }
    }

    public int get_curr_frame_w() {
        if (!this.loaded) {
            return 0;
        }
        return this.getDimension(0);
    }

    public int get_curr_frame_h() {
        if (!this.loaded) {
            return 0;
        }
        return this.getDimension(1);
    }

    private final int getDimension(int n) {
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = this.layerCount[this.currentSeq];
        int n5 = this.metaSeqOffsets[this.currentSeq];
        short s = 0;
        int n6 = 0;
        boolean bl = true;
        for (int i = 0; i < n4; ++i) {
            Spr spr = this.slicSprites[n5 + i];
            if (spr == null) continue;
            bl = false;
            if (n == 0 || n == 2) {
                s = spr.get_curr_frame_w();
                n6 = this.xAnchors[n5 + i] - spr.get_curr_frame_x();
            } else if (n == 1 || n == 3) {
                s = spr.get_curr_frame_h();
                n6 = this.yAnchors[n5 + i] - spr.get_curr_frame_y();
            }
            if (s <= 0) continue;
            if (n6 < n2) {
                n2 = n6;
            }
            if (n6 + s <= n3) continue;
            n3 = n6 + s;
        }
        if (bl) {
            return 0;
        }
        if (n == 0 || n == 1) {
            return n3 - n2;
        }
        if (n == 2 || n == 3) {
            return n2;
        }
        return 0;
    }

    public boolean isProgramDone() {
        int n = this.layerCount[this.currentSeq];
        int n2 = this.metaSeqOffsets[this.currentSeq];
        for (int i = 0; i < n; ++i) {
            if (this.slicSprites[n2 + i].isProgramDone()) continue;
            return false;
        }
        return true;
    }

    public boolean loadSprites() {
        if (this.loaded) {
            return true;
        }
        this.loadMetaSeq(this.loadSeq);
        ++this.loadSeq;
        if (this.loadSeq == this.numMetaSeqs) {
            this.loaded = true;
            return true;
        }
        return false;
    }

    private void loadMetaSeq(int n) {
        int n2 = this.metaSeqOffsets[n];
        int n3 = this.layerCount[n];
        for (int i = 0; i < n3; ++i) {
            this.slicSprites[n2 + i] = new Spr(this.slic, this.sprites[n2 + i]);
            this.slicSprites[n2 + i].setSeq(this.spriteSeqs[n2 + i]);
        }
    }

    public void destroy() {
        this.metaSeqOffsets = null;
        this.layerCount = null;
        this.sprites = null;
        this.spriteSeqs = null;
        this.xAnchors = null;
        this.yAnchors = null;
        this.timerDelays = null;
        this.tempTimers = null;
        if (this.slicSprites != null) {
            for (int i = 0; i < this.totalNumLayers; ++i) {
                if (this.slicSprites[i] == null) continue;
                this.slicSprites[i].destroy();
                this.slicSprites[i] = null;
            }
            this.slicSprites = null;
        }
    }

    private static int readS32(InputStream inputStream) throws IOException {
        return (inputStream.read() & 0xFF) + ((inputStream.read() & 0xFF) << 8) + ((inputStream.read() & 0xFF) << 16) + ((inputStream.read() & 0xFF) << 24);
    }
}

