/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.net;

import com.magmic.lang.CommonStrings;
import com.magmic.net.NetClient;
import com.magmic.net.NetClientListener;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class OnlineMenu
extends Form
implements CommandListener,
NetClientListener {
    private CommandListener listener;
    private NetClient netClient;
    private Display display;
    private static final Command CMD_LOGIN_CREATE = new Command(CommonStrings.PROCEED, 1, 1);
    private static final Command CMD_LOGIN = new Command(CommonStrings.LOGIN, 1, 1);
    private static final Command CMD_CREATE = new Command(CommonStrings.CREATE, 1, 1);
    private static final Command CMD_LOGOUT = new Command(CommonStrings.LOGOUT, 1, 1);
    private static final Command CMD_CANCEL = new Command(CommonStrings.CANCEL, 2, 1);
    private static final Command CMD_BACK_TO_MENU = new Command(CommonStrings.BACK, 2, 1);
    private static final Command CMD_BACK = new Command(CommonStrings.BACK, 2, 1);
    private boolean waitingForNetResponse = false;
    private TextField usernameField = new TextField(CommonStrings.LABEL_NAME, "", 14, 0);
    private TextField passwordField = new TextField(CommonStrings.LABEL_PASS, "", 14, 65536);
    private TextField emailField = new TextField(CommonStrings.LABEL_EMAIL, "", 50, 1);

    public OnlineMenu(NetClient netClient, Display display, CommandListener commandListener) {
        super(CommonStrings.MAGMIC_ONLINE);
        this.listener = commandListener;
        this.display = display;
        this.netClient = netClient;
        this.netClient.setListener(this);
    }

    private boolean isInputValide(String string) {
        string = string.toLowerCase();
        char[] cArray = string.toCharArray();
        block3: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case ' ': 
                case ',': 
                case '-': 
                case '.': 
                case '@': 
                case '_': {
                    continue block3;
                }
                default: {
                    if (cArray[i] >= 'a' && cArray[i] <= 'z' || cArray[i] >= '0' && cArray[i] <= '9') continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkTextFieldsInput() {
        if (!this.isInputValide(this.usernameField.getString()) || !this.isInputValide(this.passwordField.getString())) {
            this.showErrorScreen(CommonStrings.INVALID_INPUT_MSG);
            return false;
        }
        return true;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == CMD_BACK_TO_MENU) {
            this.netClient.setListener(null);
            this.listener.commandAction(CMD_BACK_TO_MENU, (Displayable)this);
        } else if (command == CMD_LOGIN) {
            if (!this.checkTextFieldsInput()) {
                return;
            }
            if (!this.waitingForNetResponse) {
                this.waitingForNetResponse = true;
                this.showWorkingScreen();
                this.netClient.setUsername(this.usernameField.getString().toLowerCase());
                this.netClient.setPassword(this.passwordField.getString().toLowerCase());
                this.netClient.setEmail(this.emailField.getString());
                this.netClient.request((byte)2);
            }
        } else if (command == CMD_CREATE) {
            if (!this.checkTextFieldsInput()) {
                return;
            }
            if (!this.waitingForNetResponse) {
                this.waitingForNetResponse = true;
                this.showWorkingScreen();
                this.netClient.setUsername(this.usernameField.getString().toLowerCase());
                this.netClient.setPassword(this.passwordField.getString().toLowerCase());
                this.netClient.setEmail(this.emailField.getString().toLowerCase());
                this.netClient.request((byte)1);
            }
        } else if (command == CMD_LOGIN_CREATE) {
            this.showLoginCreateScreen();
        } else if (command == CMD_BACK) {
            this.waitingForNetResponse = false;
            this.showLoginCreateScreen();
        } else if (command == CMD_CANCEL) {
            this.waitingForNetResponse = false;
            this.showMainScreen();
        } else if (command == CMD_LOGOUT) {
            this.netClient.logout();
            this.showMainScreen();
        }
    }

    private void showLoginCreateScreen() {
        Form form = new Form(CommonStrings.MAGMIC_ONLINE);
        String string = this.netClient.getUsername();
        String string2 = this.netClient.getPassword();
        String string3 = this.netClient.getEmail();
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        this.usernameField = new TextField(CommonStrings.LABEL_NAME, string, 14, 0);
        this.passwordField = new TextField(CommonStrings.LABEL_PASS, string2, 14, 65536);
        this.emailField = new TextField(CommonStrings.LABEL_EMAIL, string3, 50, 1);
        form.append((Item)this.usernameField);
        form.append((Item)this.passwordField);
        form.append((Item)this.emailField);
        form.addCommand(CMD_CANCEL);
        form.addCommand(CMD_LOGIN);
        form.addCommand(CMD_CREATE);
        form.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)form);
    }

    private void showWorkingScreen() {
        Form form = new Form(CommonStrings.MAGMIC_ONLINE);
        form.append(CommonStrings.PLEASE_WAIT_CONNECTING);
        form.addCommand(CMD_CANCEL);
        form.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)form);
    }

    public void netClientEvent(byte by, int n, Object object) {
        this.waitingForNetResponse = false;
        if (n != 100) {
            this.showErrorScreen(NetClient.respToString(n));
        } else {
            this.showMainScreen();
        }
    }

    public void showMainScreen() {
        Form form = new Form(CommonStrings.MAGMIC_ONLINE);
        if (this.netClient.isLoggedIn()) {
            form.append(CommonStrings.YOU_ARE_CURRENTLY + CommonStrings.STATUS_CONNECTED);
        } else {
            form.append(CommonStrings.YOU_ARE_CURRENTLY + CommonStrings.STATUS_DISCONNECTED + ". ");
            form.append(CommonStrings.Proceed_LOGIN);
        }
        if (this.netClient.isLoggedIn()) {
            form.addCommand(CMD_LOGOUT);
        } else {
            form.addCommand(CMD_LOGIN_CREATE);
        }
        form.addCommand(CMD_BACK_TO_MENU);
        form.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)form);
    }

    private void showErrorScreen(String string) {
        Form form = new Form(CommonStrings.MAGMIC_ONLINE);
        form.append(CommonStrings.ERROR + ": " + string);
        form.addCommand(CMD_BACK);
        form.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)form);
    }
}

