/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.net;

import com.magmic.net.DateParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public class HttpConnectionImpl {
    protected static final String ILLEGAL_STATE = "Illegal State";
    protected static final String NO_RESOURCE = "No Resource";
    protected static final String TIMEOUT = "Timeout";
    protected static final String USER_ABORT = "User Abort";
    protected static final String HTTP_ERROR = "Http Error";
    protected static final String UNDEFINED = "Undefined";
    protected static final String MALFORMED_URL = "Malformed URL";
    protected static final String MALFORMED_RESPONSE = "Malformed Response Message";
    protected static final String ALREADY_CONNECTED = "Already Connected";
    protected static final String ILLEGAL_MODE = "Illegal Mode";
    protected static final String CONNECTION_CLOSED = "Connection Closed";
    protected static final String ALREADY_OPEN = "Already Open";
    protected static final String READ_ONLY = "Read Only Connection";
    protected static final String WRITE_ONLY = "Write Only Connection";
    protected static final String CALLED_BEFORE_CONNECT = "Called before connect()";
    protected static final String CALLED_AFTER_CONNECT = "Called after connect()";
    protected static final String GET = "GET";
    protected static final String POST = "POST";
    protected static final String HEAD = "HEAD";
    protected static final int DEFAULT_HTTP_PORT = 80;
    protected static final String DEFAULT_PROTOCOL = "http";
    protected static final String HTTP_VERSION = "HTTP/1.1";
    protected static final String LINE_TERMINATOR = "\n";
    protected static final byte[] LINE_TERMINATOR_BYTES = "\n".getBytes();
    protected static final int STRING_BUFFER_SIZE = 32;
    protected static final int RESPONSE_BUFFER_SIZE = 512;
    protected static final int OUTPUT_BUFFER_SIZE = 512;
    protected static final int SLEEP_TIME = 20;
    protected static final int NUM_WAITS = 50;
    protected static final int TX_QUEUE_SIZE = 4;
    protected static final int RX_QUEUE_SIZE = 16;
    private static final int NUM_TRIES = 5;
    protected static StreamConnection m_connection;
    protected int index;
    protected String url;
    protected String protocol = "http";
    protected String host;
    protected String file;
    protected String ref;
    protected String query;
    protected int port = 80;
    protected int responseCode = -1;
    protected String responseMsg;
    protected Hashtable reqProperties = new Hashtable();
    protected Hashtable headerFields = new Hashtable();
    protected String[] headerFieldNames;
    protected String[] headerFieldValues;
    protected String method = "GET";
    protected int opens = 0;
    protected int mode;
    protected boolean timeout;
    protected boolean connected = false;
    protected ByteArrayOutputStream m_response;
    protected PrivateInputStream in;
    protected PrivateOutputStream out;
    protected MyInputStream m_in;
    protected StringBuffer stringbuffer = new StringBuffer(32);

    public HttpConnectionImpl() {
        this.m_response = new ByteArrayOutputStream(512);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void close() throws IOException {
        if (this.opens == 0) {
            this.disconnect();
        }
    }

    public void open(String string, int n, boolean bl) throws IOException {
        if (this.opens > 0) {
            this.throwException("already connected: opens = " + this.opens);
        }
        if (n != 1 && n != 2 && n != 3) {
            this.throwException("illegal mode: " + n);
        }
        if (string == null) {
            this.throwException("URL cannot be null");
        }
        this.url = this.stripProtocol(string);
        this.mode = n;
        this.timeout = bl;
        this.parseURL();
        try {
            m_connection = (StreamConnection)Connector.open((String)("socket://" + this.host + ":" + this.port));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public InputStream openInputStream() throws IOException {
        if (this.mode == 2) {
            this.throwException(WRITE_ONLY);
        }
        if (!this.connected) {
            throw new RuntimeException(CALLED_BEFORE_CONNECT);
        }
        if (this.in == null) {
            this.throwException(CONNECTION_CLOSED);
        }
        ++this.opens;
        return this.in;
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.connected) {
            throw new RuntimeException(CALLED_AFTER_CONNECT);
        }
        if (this.out != null) {
            this.throwException(ALREADY_OPEN);
        }
        if (this.mode == 1) {
            this.throwException(READ_ONLY);
        }
        this.out = new PrivateOutputStream(512);
        ++this.opens;
        return this.out;
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        if (this.mode == 1) {
            this.throwException(READ_ONLY);
        }
        if (this.out != null) {
            this.throwException(ALREADY_OPEN);
        }
        this.openOutputStream();
        return new DataOutputStream(this.out);
    }

    public String getURL() {
        return this.protocol + ":" + (this.url == null ? "" : this.url);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        if (this.host != null) {
            return this.host.length() == 0 ? null : this.host;
        }
        return null;
    }

    public String getFile() {
        if (this.file != null) {
            return this.file.length() == 0 ? "/" : this.file;
        }
        return null;
    }

    public String getRef() {
        if (this.ref != null) {
            return this.ref.length() == 0 ? null : this.ref;
        }
        return null;
    }

    public String getQuery() {
        if (this.query != null) {
            return this.query.length() == 0 ? null : this.query;
        }
        return null;
    }

    public int getPort() {
        return this.port;
    }

    public String getRequestMethod() {
        if (this.method == null) {
            return GET;
        }
        return this.method;
    }

    public void setRequestMethod(String string) throws IOException {
        if (this.connected) {
            throw new RuntimeException(CALLED_AFTER_CONNECT);
        }
        if (!(string.equals(HEAD) || string.equals(GET) || string.equals(POST))) {
            throw new IllegalArgumentException("Invalid Request method");
        }
        this.method = new String(string);
    }

    public void setIfModifiedSince(long l) {
        if (this.connected) {
            throw new RuntimeException(CALLED_AFTER_CONNECT);
        }
        try {
            this.setRequestProperty("if-Modified-since", String.valueOf(l));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getRequestProperty(String string) {
        return (String)this.reqProperties.get(string);
    }

    public void setRequestProperty(String string, String string2) throws IOException {
        if (this.connected) {
            throw new RuntimeException(CALLED_AFTER_CONNECT);
        }
        this.reqProperties.put(string, string2);
    }

    public int getResponseCode() throws IOException {
        if (!this.connected) {
            throw new RuntimeException(CALLED_BEFORE_CONNECT);
        }
        return this.responseCode;
    }

    public String getResponseMessage() throws IOException {
        if (!this.connected) {
            throw new RuntimeException(CALLED_BEFORE_CONNECT);
        }
        return this.responseMsg;
    }

    public long getLength() {
        if (!this.connected) {
            throw new RuntimeException(CALLED_BEFORE_CONNECT);
        }
        try {
            return this.getHeaderFieldInt("content-length", -1);
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    public String getType() {
        if (!this.connected) {
            throw new RuntimeException(CALLED_BEFORE_CONNECT);
        }
        try {
            return this.getHeaderField("content-type");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getEncoding() {
        if (!this.connected) {
            throw new RuntimeException(CALLED_BEFORE_CONNECT);
        }
        try {
            return this.getHeaderField("content-encoding");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public long getExpiration() {
        if (!this.connected) {
            throw new RuntimeException(CALLED_BEFORE_CONNECT);
        }
        try {
            return this.getHeaderFieldDate("expires", 0L);
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public long getDate() {
        if (!this.connected) {
            throw new RuntimeException(CALLED_BEFORE_CONNECT);
        }
        try {
            return this.getHeaderFieldDate("date", 0L);
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public long getLastModified() {
        if (!this.connected) {
            throw new RuntimeException(CALLED_BEFORE_CONNECT);
        }
        try {
            return this.getHeaderFieldDate("last-modified", 0L);
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public String getHeaderField(String string) throws IOException {
        if (!this.connected) {
            throw new RuntimeException(CALLED_BEFORE_CONNECT);
        }
        return (String)this.headerFields.get(this.toLowerCase(string));
    }

    public String getHeaderField(int n) throws IOException {
        if (this.headerFieldValues == null) {
            this.makeHeaderFieldValues();
        }
        if (n >= this.headerFieldValues.length) {
            return null;
        }
        return this.headerFieldValues[n];
    }

    public String getHeaderFieldKey(int n) throws IOException {
        if (this.headerFieldNames == null) {
            this.makeHeaderFields();
        }
        if (n >= this.headerFieldNames.length) {
            return null;
        }
        return this.headerFieldNames[n];
    }

    protected void makeHeaderFields() {
        int n = 0;
        this.headerFieldNames = new String[this.headerFields.size()];
        Enumeration enumeration = this.headerFields.keys();
        while (enumeration.hasMoreElements()) {
            this.headerFieldNames[n++] = (String)enumeration.nextElement();
        }
    }

    protected void makeHeaderFieldValues() {
        int n = 0;
        this.headerFieldValues = new String[this.headerFields.size()];
        Enumeration enumeration = this.headerFields.keys();
        while (enumeration.hasMoreElements()) {
            this.headerFieldValues[n++] = (String)this.headerFields.get(enumeration.nextElement());
        }
    }

    public int getHeaderFieldInt(String string, int n) throws IOException {
        try {
            return Integer.parseInt(this.getHeaderField(string));
        }
        catch (Throwable throwable) {
            return n;
        }
    }

    public long getHeaderFieldDate(String string, long l) throws IOException {
        try {
            return DateParser.parse(this.getHeaderField(string));
        }
        catch (Throwable throwable) {
            return l;
        }
    }

    protected String buildRequestLine() {
        String string = this.getRef();
        String string2 = this.getQuery();
        return this.getRequestMethod() + " " + this.getFile() + (string == null ? "" : "#" + string) + (string2 == null ? "" : "?" + string2) + " " + HTTP_VERSION;
    }

    protected boolean isRequestMethodValid() {
        String string = this.method;
        return string.equals(GET) || string.equals(HEAD) || string.equals(POST);
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        try {
            Object object;
            if (!this.isRequestMethodValid()) {
                this.throwException(ILLEGAL_STATE);
            }
            OutputStream outputStream = m_connection.openOutputStream();
            byte[] byArray = LINE_TERMINATOR_BYTES;
            if (this.getRequestProperty("Content-Length") == null) {
                this.setRequestProperty("Content-Length", "" + (this.out == null ? 0 : this.out.size()));
            }
            String string = this.buildRequestLine();
            outputStream.write(string.getBytes());
            outputStream.write(byArray);
            this.setRequestProperty("Host", this.getHost() + ':' + this.port);
            Enumeration enumeration = this.reqProperties.keys();
            StringBuffer stringBuffer = this.stringbuffer;
            while (enumeration.hasMoreElements()) {
                stringBuffer.setLength(0);
                object = (String)enumeration.nextElement();
                stringBuffer.append((String)object);
                stringBuffer.append(": ");
                stringBuffer.append(this.reqProperties.get(object));
                outputStream.write(stringBuffer.toString().getBytes());
                outputStream.write(byArray);
            }
            outputStream.write(byArray);
            if (this.out != null) {
                this.out.writeTo(outputStream);
                outputStream.write(byArray);
            }
            outputStream.flush();
            object = m_connection.openInputStream();
            this.readResponseMessage((InputStream)object);
            this.readHeaders((InputStream)object);
            this.connected = true;
            String string2 = this.getHeaderField("Transfer-Encoding");
            if (string2 != null && string2.equals("chunked")) {
                this.readChunkedBody((InputStream)object);
            } else {
                long l = this.getLength();
                this.readMessageBody((InputStream)object, l);
            }
            ((InputStream)object).close();
            outputStream.close();
            m_connection.close();
            this.in = new PrivateInputStream(this.m_response.toByteArray());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.handleFatalError();
            return;
        }
    }

    protected void readEntireResponse(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = this.m_response;
        int n = 40;
        int n2 = 0;
        while (inputStream.available() < 1) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        while (true) {
            int n3 = 0;
            try {
                n3 = inputStream.available();
            }
            catch (IOException iOException) {
                break;
            }
            if (n3 == 0) {
                if (n < 1) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --n;
                continue;
            }
            int n4 = inputStream.read();
            if (n4 == -1) break;
            ((OutputStream)byteArrayOutputStream).write((byte)n4);
            ++n2;
            n = 100;
        }
    }

    protected void readResponseMessage(InputStream inputStream) throws IOException {
        block3: {
            int n;
            String string;
            int n2;
            String string2 = this.readLine(inputStream);
            this.responseCode = -1;
            this.responseMsg = null;
            if (string2 != null && (n2 = string2.indexOf(32)) >= 0 && (string = string2.substring(0, n2)).startsWith("HTTP") && string2.length() > n2 && (n = string2.substring(n2 + 1).indexOf(32)) >= 0 && string2.length() > (n += n2 + 1)) {
                try {
                    this.responseCode = Integer.parseInt(string2.substring(n2 + 1, n));
                }
                catch (NumberFormatException numberFormatException) {
                    break block3;
                }
                this.responseMsg = string2.substring(n + 1);
                return;
            }
        }
        this.throwException(MALFORMED_RESPONSE);
    }

    protected void readHeaders(InputStream inputStream) throws IOException {
        String string;
        while ((string = this.readLine(inputStream)) != null && !string.equals("")) {
            String string2;
            int n = string.indexOf(58);
            if (n < 0) {
                this.throwException("malformed header field");
            }
            if ((string2 = string.substring(0, n)).length() == 0) {
                this.throwException("malformed header field");
            }
            String string3 = string.length() <= n + 2 ? "" : string.substring(n + 2);
            this.headerFields.put(this.toLowerCase(string2), string3);
        }
        return;
    }

    protected void readChunkedBody(InputStream inputStream) throws IOException {
        int n = -1;
        boolean bl = false;
        byte[] byArray = new byte[512];
        while (!bl) {
            String string;
            String string2 = this.readLine(inputStream);
            if (string2.equals("")) {
                this.throwException("malformed chunk data");
            }
            if (bl) continue;
            int n2 = string2.indexOf(59);
            if (n2 < 0) {
                n2 = string2.length();
            }
            if ((string = string2.substring(0, n2)).length() < 1) {
                this.throwException("malformed chunk header");
            }
            try {
                n = Integer.parseInt(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                this.throwException("malformed chunk header");
            }
            if (n < 0) {
                this.throwException("malformed chunk header");
            } else if (n == 0) {
                bl = true;
            } else {
                int n3 = 0;
                int n4 = n;
                int n5 = 0;
                for (int i = 0; i < n; ++i) {
                    n5 = inputStream.read();
                    if (n5 < 0) {
                        this.throwException("malformed chunk response");
                    }
                    byArray[n3] = (byte)(n5 & 0xFF);
                    if (++n3 != 512) continue;
                    this.m_response.write(byArray, 0, 512);
                    n3 -= 512;
                }
                if (n3 > 0) {
                    this.m_response.write(byArray, 0, n3);
                }
            }
            if ((string2 = this.readLine(inputStream)).equals("")) continue;
            this.throwException("malformed chunk footer");
        }
        this.m_response.flush();
    }

    protected void readMessageBody(InputStream inputStream, long l) throws IOException {
        byte[] byArray = new byte[(int)l];
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.readFully(byArray, 0, (int)l);
        this.m_response.write(byArray, 0, (int)l);
    }

    protected String readLine(InputStream inputStream) {
        this.stringbuffer.setLength(0);
        while (true) {
            int n;
            try {
                while (true) {
                    if ((n = inputStream.read()) < 0) {
                        return null;
                    }
                    if (n == 13) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                return null;
            }
            if (n == 10) break;
            this.stringbuffer.append((char)n);
        }
        return this.stringbuffer.toString();
    }

    protected void disconnect() throws IOException {
        if (!this.connected) {
            return;
        }
        this.reqProperties.clear();
        this.headerFields.clear();
        this.headerFieldNames = null;
        this.headerFieldValues = null;
        if (this.in != null) {
            this.in.httpClose();
            this.in = null;
        }
        if (this.out != null) {
            this.out.httpClose();
            this.out = null;
        }
        this.m_response.reset();
        if (m_connection != null) {
            m_connection.close();
        }
        this.responseCode = -1;
        this.responseMsg = null;
        this.connected = false;
    }

    protected void handleFatalError() throws IOException {
        if (this.in != null) {
            this.in.httpClose();
            this.in = null;
        }
        if (this.out != null) {
            this.out.httpClose();
            this.out = null;
        }
        this.m_response.reset();
    }

    protected String stripProtocol(String string) throws IOException {
        int n = string.indexOf(58);
        n = n < 0 ? 0 : ++n;
        String string2 = string.substring(n);
        return string2;
    }

    protected String parseHostname() throws IOException {
        int n;
        String string = this.url.substring(this.index);
        if (string.startsWith("//")) {
            string = string.substring(2);
            this.index += 2;
        }
        if ((n = string.indexOf(58)) < 0) {
            n = string.indexOf(47);
        }
        if (n < 0) {
            n = string.length();
        }
        String string2 = string.substring(0, n);
        this.index += n;
        return string2;
    }

    protected int parsePort() throws IOException {
        int n = 80;
        String string = this.url.substring(this.index);
        if (!string.startsWith(":")) {
            return n;
        }
        string = string.substring(1);
        ++this.index;
        int n2 = string.indexOf(47);
        if (n2 < 0) {
            n2 = string.length();
        }
        try {
            String string2 = string.substring(0, n2);
            n = Integer.parseInt(string2);
            if (n <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.throwException("invalid port: " + n);
        }
        this.index += n2;
        return n;
    }

    protected String parseFile() throws IOException {
        String string = "";
        String string2 = this.url.substring(this.index);
        if (string2.length() == 0) {
            return string;
        }
        if (!string2.startsWith("/")) {
            this.throwException("invalid path");
        }
        int n = string2.indexOf(35);
        int n2 = string2.indexOf(63);
        if (n < 0 && n2 < 0) {
            n = string2.length();
        } else if (n < 0 || n2 > 0 && n2 < n) {
            n = n2;
        }
        string = string2.substring(0, n);
        this.index += n;
        return string;
    }

    protected String parseRef() throws IOException {
        int n;
        String string = this.url.substring(this.index);
        if (string.length() == 0 || string.charAt(0) == '?') {
            return "";
        }
        if (!string.startsWith("#")) {
            this.throwException("invalid ref");
        }
        if ((n = string.indexOf(63)) < 0) {
            n = string.length();
        }
        this.index += n;
        return string.substring(1, n);
    }

    protected String parseQuery() throws IOException {
        String string = this.url.substring(this.index);
        if (string.length() == 0) {
            return "";
        }
        if (string.startsWith("?")) {
            String string2 = string.substring(1);
            int n = string.indexOf(35);
            if (n > 0) {
                string2 = string.substring(1, n);
                this.index += n;
            }
            return string2;
        }
        return "";
    }

    protected synchronized void parseURL() throws IOException {
        this.index = 0;
        this.host = this.parseHostname();
        this.port = this.parsePort();
        this.file = this.parseFile();
        this.query = this.parseQuery();
        this.ref = this.parseRef();
    }

    protected void throwException(String string) throws IOException {
        throw new IOException(string);
    }

    protected String toLowerCase(String string) {
        this.stringbuffer.setLength(0);
        for (int i = 0; i < string.length(); ++i) {
            this.stringbuffer.append(Character.toLowerCase(string.charAt(i)));
        }
        return this.stringbuffer.toString();
    }

    protected class PrivateOutputStream
    extends ByteArrayOutputStream {
        public PrivateOutputStream(int n) {
            super(n);
        }

        public PrivateOutputStream() {
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            outputStream.write(this.buf, 0, this.count);
            outputStream.flush();
        }

        public void close() throws IOException {
            if (!HttpConnectionImpl.this.connected) {
                HttpConnectionImpl.this.connect();
            }
            super.close();
            if (HttpConnectionImpl.this.opens > 0) {
                --HttpConnectionImpl.this.opens;
            }
        }

        public void httpClose() throws IOException {
            super.close();
            if (HttpConnectionImpl.this.opens > 0) {
                --HttpConnectionImpl.this.opens;
            }
        }
    }

    protected class PrivateInputStream
    extends ByteArrayInputStream {
        public PrivateInputStream(byte[] byArray) {
            super(byArray);
        }

        public PrivateInputStream(byte[] byArray, int n, int n2) {
            super(byArray, n, n2);
        }

        public void setDone() {
            this.pos = this.count;
        }

        public void close() throws IOException {
            if (HttpConnectionImpl.this.opens > 0) {
                --HttpConnectionImpl.this.opens;
                HttpConnectionImpl.this.close();
            }
            super.close();
        }

        public void httpClose() throws IOException {
            if (HttpConnectionImpl.this.opens > 0) {
                --HttpConnectionImpl.this.opens;
            }
            super.close();
        }
    }

    protected class MyInputStream
    extends InputStream {
        private InputStream m_is;

        public MyInputStream(InputStream inputStream) {
            if (inputStream == null) {
                throw new NullPointerException();
            }
            this.m_is = inputStream;
        }

        public int read() throws IOException {
            return this.m_is.read();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new IOException("Buffer cannot be null!!");
            }
            return this.m_is.read(byArray, n, n2);
        }

        public int available() throws IOException {
            return this.m_is.available();
        }

        public void close() throws IOException {
            if (HttpConnectionImpl.this.opens > 0) {
                --HttpConnectionImpl.this.opens;
                HttpConnectionImpl.this.close();
            }
            super.close();
        }

        public void httpClose() throws IOException {
            if (HttpConnectionImpl.this.opens > 0) {
                --HttpConnectionImpl.this.opens;
            }
            super.close();
        }
    }
}

