/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.maglet.registration.widgets;

import com.magmic.maglet.registration.widgets.AutoTextDialogListener;
import net.rim.device.api.system.Application;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.Keypad;
import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.AutoTextEditField;
import net.rim.device.api.ui.component.BasicEditField;
import net.rim.device.api.ui.component.ButtonField;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.EmailAddressEditField;
import net.rim.device.api.ui.component.PasswordEditField;
import net.rim.device.api.ui.container.HorizontalFieldManager;
import net.rim.device.api.ui.text.TextFilter;

public class AutoTextDialog
extends Dialog {
    public static final byte TYPE_AUTOTEXT = 0;
    public static final byte TYPE_PASSWORD = 1;
    public static final byte TYPE_EMAIL = 2;
    public static final byte TYPE_LOWERCASE = 3;
    public static final byte TYPE_UPPERCASE = 4;
    public static final byte TYPE_NUMERIC = 5;
    public static final byte TYPE_INTEGER = 6;
    protected static final String TEXT_OK = "OK";
    protected static final String TEXT_CANCEL = "Cancel";
    protected static final String TEXT_ENTER_TEXT = "Field must contain at least one character.";
    protected static final String TEXT_INVALID_STRING = "This field contains invalid characters.";
    protected static final String TEXT_INVALID_EMAIL_ADDRESS = "The email address entered is not valid.";
    private BasicEditField textInputField;
    private ButtonField okButton;
    private ButtonField cancelButton;
    private int textInputType;
    private AutoTextDialogListener listener;

    public AutoTextDialog(String string, int n, String string2, int n2) {
        super(string, null, null, 0, null);
        this.textInputType = n2;
        switch (n2) {
            case 0: {
                this.textInputField = new AutoTextEditField(null, string2, n, 0x80000000L);
                break;
            }
            case 1: {
                this.textInputField = new PasswordEditField(null, string2, n, 0x10000000000000L);
                break;
            }
            case 2: {
                this.textInputField = new EmailAddressEditField("", string2);
                break;
            }
            case 3: {
                this.textInputField = new AutoTextEditField(null, string2, n, 0x80000000L);
                this.textInputField.setFilter(TextFilter.get((int)3));
                break;
            }
            case 4: {
                this.textInputField = new AutoTextEditField(null, string2, n, 0x80000000L);
                this.textInputField.setFilter(TextFilter.get((int)2));
                break;
            }
            case 5: {
                this.textInputField = new AutoTextEditField(null, string2, n, 0x80000000L);
                this.textInputField.setFilter(TextFilter.get((int)1));
                break;
            }
            case 6: {
                this.textInputField = new AutoTextEditField(null, string2, n, 0x80000000L);
                this.textInputField.setFilter(TextFilter.get((int)5));
            }
        }
        HorizontalFieldManager horizontalFieldManager = new HorizontalFieldManager(0x300000000L);
        this.okButton = new ButtonField(TEXT_OK, 65536L);
        this.okButton.setChangeListener((FieldChangeListener)this);
        horizontalFieldManager.add((Field)this.okButton);
        this.cancelButton = new ButtonField(TEXT_CANCEL, 65536L);
        this.cancelButton.setChangeListener((FieldChangeListener)this);
        horizontalFieldManager.add((Field)this.cancelButton);
        this.add((Field)this.textInputField);
        this.add((Field)horizontalFieldManager);
        this.showDialog();
    }

    public void setClickListener(AutoTextDialogListener autoTextDialogListener) {
        this.listener = autoTextDialogListener;
    }

    public void fieldChanged(Field field, int n) {
        if (field == this.okButton) {
            String string = this.textInputField.getText();
            if (!this.validateText(string)) {
                this.showInvalidInputDialog();
                return;
            }
            if (string.length() != 0) {
                this.listener.onClickOk();
                this.hideDialog();
            } else {
                Dialog.inform((String)TEXT_ENTER_TEXT);
            }
        } else if (field == this.cancelButton) {
            this.listener.onClickCancel();
            this.hideDialog();
        }
    }

    public String getTextField() {
        return this.textInputField.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showDialog() {
        Object object = Application.getEventLock();
        synchronized (object) {
            UiApplication.getUiApplication().pushScreen((Screen)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hideDialog() {
        Object object = Application.getEventLock();
        synchronized (object) {
            UiApplication.getUiApplication().popScreen((Screen)this);
        }
    }

    private boolean validateText(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (this.textInputField.getFilter().validate(string.charAt(i))) continue;
            return false;
        }
        switch (this.textInputType) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
            case 2: {
                return this.validateEmailAddress(string);
            }
        }
        return false;
    }

    private boolean validateEmailAddress(String string) {
        int n = string.indexOf("@");
        int n2 = string.lastIndexOf(46);
        if (n == 0) {
            return false;
        }
        if (n > n2) {
            return false;
        }
        if (Math.abs(n - n2) <= 1) {
            return false;
        }
        if (n2 == string.length() - 1) {
            return false;
        }
        return n2 >= 0 && n >= 0;
    }

    private void showInvalidInputDialog() {
        switch (this.textInputType) {
            case 2: {
                Dialog.inform((String)TEXT_INVALID_EMAIL_ADDRESS);
                break;
            }
            default: {
                Dialog.inform((String)TEXT_INVALID_STRING);
            }
        }
    }

    protected boolean keyDown(int n, int n2) {
        switch (Keypad.key((int)n)) {
            case 27: {
                this.listener.onClickCancel();
            }
        }
        return false;
    }
}

