/*
 * Decompiled with CFR 0.152.
 */
package com.magmic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class MagmicArchiveReader {
    public static final int TYPE_SEARCH_NODE = 0;
    public static final int TYPE_LEAF_NODE = 1;
    public static final int TYPE_NULL_NODE = 2;
    public String base_path;
    private byte[] index;
    private InputStream chunk;
    private int chunk_id;
    private byte[] read_buffer = new byte[128];
    private static final int BRANCH_LEFT = 0;
    private static final int BRANCH_EQUAL = 1;
    private static final int BRANCH_RIGTH = 2;
    private static final int BRANCH_ROOT = 3;

    public MagmicArchiveReader(String string, String string2) {
        try {
            this.base_path = string;
            this.index = this.readIndex(string + string2);
        }
        catch (IOException iOException) {
            throw new RuntimeException("MagmicArchiveException::failed to read index: " + iOException);
        }
    }

    public byte[] readFile(String string) throws IOException {
        long l = this.getFileId(string);
        this.chunk_id = (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
        int n = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        if (this.chunk_id == -1 || n == -1) {
            return null;
        }
        this.open(n);
        if (!this.testFilename(string)) {
            return null;
        }
        int n2 = this.read_s32();
        byte[] byArray = new byte[n2];
        this.read(byArray, 0, byArray.length);
        this.finalizeChunk();
        return byArray;
    }

    public int readFile(String string, byte[] byArray, int n) throws IOException {
        long l = this.getFileId(string);
        this.chunk_id = (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
        int n2 = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        if (this.chunk_id == -1 || n2 == -1) {
            return -1;
        }
        this.open(n2);
        if (!this.testFilename(string)) {
            return -1;
        }
        int n3 = this.read_s32();
        if (n3 > byArray.length - n) {
            return -1;
        }
        this.read(byArray, n, n3);
        this.finalizeChunk();
        return n3;
    }

    public InputStream getInputStream(String string) throws IOException {
        byte[] byArray = this.readFile(string);
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    private void open(int n) throws IOException {
        this.chunk = this.getClass().getResourceAsStream(this.base_path + this.chunk_id + ".mar");
        while (n > 0) {
            n -= this.chunk.read(this.read_buffer, 0, n > this.read_buffer.length ? this.read_buffer.length : n);
        }
    }

    private void finalizeChunk() throws IOException {
        if (this.chunk != null) {
            this.chunk.close();
        }
        this.chunk = null;
        ++this.chunk_id;
    }

    private int read_s8() throws IOException {
        int n;
        if (this.chunk == null) {
            this.open(0);
        }
        if ((n = this.chunk.read()) == -1) {
            this.finalizeChunk();
            this.open(0);
            n = this.chunk.read();
        }
        return (byte)n;
    }

    private void read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (this.chunk == null) {
            this.open(0);
        }
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = this.chunk.read(byArray, n + n3, n2 - n3);
            if (n4 == -1) {
                this.finalizeChunk();
                this.open(0);
                n4 = this.chunk.read(byArray, n + n3, n2 - n3);
            }
            if (n4 != -1) continue;
            throw new IOException("Failed to read any bytes: " + n3);
        }
        if (n3 != n2) {
            throw new IOException("Read bad amount of bytes: " + n3 + " " + n2);
        }
    }

    private char read_ascii() throws IOException {
        return (char)this.read_s8();
    }

    private int read_s16() throws IOException {
        return (this.read_s8() & 0xFF) << 8 | this.read_s8() & 0xFF;
    }

    private int read_s32() throws IOException {
        return (this.read_s8() & 0xFF) << 24 | (this.read_s8() & 0xFF) << 16 | (this.read_s8() & 0xFF) << 8 | this.read_s8() & 0xFF;
    }

    private long getFileId(String string) {
        return this.getFileId(string, 0, 0, 3);
    }

    private long getFileId(String string, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        if (n3 == 1) {
            ++n;
        }
        int n7 = MagmicArchiveReader.read_s8(this.index, n2);
        ++n2;
        if (n3 != 3) {
            n6 = n2;
            n5 = n6 + this.getLengthOfSegment(n7 >> 4 & 3);
            n4 = n5 + this.getLengthOfSegment(n7 >> 2 & 3);
            switch (n3) {
                case 0: {
                    n2 = n6;
                    n7 = n7 >> 4 & 3;
                    break;
                }
                case 1: {
                    n2 = n5;
                    n7 = n7 >> 2 & 3;
                    break;
                }
                case 2: {
                    n2 = n4;
                    n7 &= 3;
                }
            }
        }
        switch (n7) {
            case 0: {
                n6 = n2;
                n5 = MagmicArchiveReader.read_s8(this.index, n2);
                n4 = MagmicArchiveReader.read_s16(this.index, ++n2);
                n2 += 2;
                byte by = (byte)MagmicArchiveReader.charAt(string, n);
                n3 = by < n5 ? 0 : (by > n5 ? 2 : 1);
                return this.getFileId(string, n, n6 + n4, n3);
            }
            case 1: {
                byte by = MagmicArchiveReader.read_s8(this.index, n2);
                int n8 = MagmicArchiveReader.read_s32(this.index, ++n2);
                n2 += 4;
                return (long)by << 32 | (long)n8;
            }
            case 2: {
                return -1L;
            }
        }
        return -1L;
    }

    private int getLengthOfSegment(int n) {
        switch (n) {
            case 0: {
                return 3;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 0;
            }
        }
        return 0;
    }

    private byte[] readIndex(String string) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        int n = inputStream.available();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n > 0 ? n : 32);
        int n2 = 0;
        do {
            if ((n2 = inputStream.read(this.read_buffer, 0, this.read_buffer.length)) <= 0) continue;
            byteArrayOutputStream.write(this.read_buffer, 0, n2);
        } while (n2 == this.read_buffer.length);
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static char charAt(String string, int n) {
        if (n < string.length()) {
            return string.charAt(n);
        }
        return '\u0000';
    }

    private boolean testFilename(String string) throws IOException {
        int n = this.read_s8();
        if (n != string.length()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == (c = this.read_ascii())) continue;
            return false;
        }
        return true;
    }

    public static int read_s32(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public static short read_s16(byte[] byArray, int n) {
        return (short)((byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
    }

    public static byte read_s8(byte[] byArray, int n) {
        return byArray[n];
    }
}

