/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.util;

import java.io.IOException;
import java.util.Vector;
import net.rim.device.api.system.ApplicationDescriptor;
import net.rim.device.api.system.PersistentObject;
import net.rim.device.api.system.PersistentStore;

public final class MagmicRecordStore {
    private PersistentObject theRecordStore;

    public static MagmicRecordStore openRecordStore(String string, boolean bl) throws IOException {
        long l = (ApplicationDescriptor.currentApplicationDescriptor().getName() + string).hashCode();
        PersistentObject persistentObject = PersistentStore.getPersistentObject((long)l);
        if (persistentObject.getContents() == null) {
            if (bl) {
                Vector<Object> vector = new Vector<Object>();
                vector.addElement(null);
                persistentObject.setContents(vector);
                persistentObject.commit();
            } else {
                throw new IOException("Open RecordStore Failed: Unable to find RecordStore " + string);
            }
        }
        return new MagmicRecordStore(persistentObject);
    }

    public static void deleteRecordStore(String string) throws IOException {
        long l = (ApplicationDescriptor.currentApplicationDescriptor().getName() + string).hashCode();
        try {
            PersistentStore.destroyPersistentObject((long)l);
        }
        catch (Exception exception) {
            throw new IOException("Delete RecordStore " + string + " Failed: Caller does not have replace permissions (ControlledAccessException)");
        }
    }

    public MagmicRecordStore(PersistentObject persistentObject) {
        this.theRecordStore = persistentObject;
    }

    public void closeRecordStore() throws IOException {
        this.theRecordStore.commit();
    }

    public byte[] getRecord(int n) throws IOException {
        Vector vector = (Vector)this.theRecordStore.getContents();
        if (n >= vector.size()) {
            throw new IOException();
        }
        byte[] byArray = (byte[])vector.elementAt(n);
        return byArray;
    }

    public int getRecord(int n, byte[] byArray, int n2) throws IOException {
        Vector vector = (Vector)this.theRecordStore.getContents();
        if (n >= vector.size()) {
            throw new IOException();
        }
        byte[] byArray2 = (byte[])vector.elementAt(n);
        if (byArray2 == null) {
            throw new IOException();
        }
        int n3 = byArray2.length;
        for (int i = 0; i < n3; ++i) {
            byArray[n2 + i] = byArray2[i];
        }
        return n3;
    }

    public int getNumRecords() throws IOException {
        return ((Vector)this.theRecordStore.getContents()).size() - 1;
    }

    public int addRecord(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2;
        if (n != 0 || n2 != byArray.length) {
            byArray2 = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                byArray2[i] = byArray[n + i];
            }
        } else {
            byArray2 = byArray;
        }
        Vector vector = (Vector)this.theRecordStore.getContents();
        vector.addElement(byArray2);
        this.theRecordStore.setContents((Object)vector);
        this.theRecordStore.commit();
        return vector.size() - 1;
    }

    public int getNextRecordID() throws IOException {
        return ((Vector)this.theRecordStore.getContents()).size();
    }

    public void deleteRecord(int n) throws IOException {
        Vector vector = (Vector)this.theRecordStore.getContents();
        if (n >= vector.size()) {
            return;
        }
        vector.setElementAt(null, n);
        this.theRecordStore.setContents((Object)vector);
        this.theRecordStore.commit();
    }

    public void setRecord(int n, byte[] byArray, int n2, int n3) throws IOException {
        Vector vector;
        byte[] byArray2;
        if (n2 != 0 || n3 != byArray.length) {
            byArray2 = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                byArray2[i] = byArray[n2 + i];
            }
        } else {
            byArray2 = byArray;
        }
        if (n >= (vector = (Vector)this.theRecordStore.getContents()).size()) {
            throw new IOException();
        }
        vector.setElementAt(byArray2, n);
        this.theRecordStore.setContents((Object)vector);
        this.theRecordStore.commit();
    }

    private Vector createVector(byte[] byArray) {
        Vector<Byte> vector = new Vector<Byte>();
        for (int i = 0; i < byArray.length; ++i) {
            vector.addElement(new Byte(byArray[i]));
        }
        return vector;
    }

    private byte[] createByteArray(Vector vector) {
        byte[] byArray = new byte[vector.size()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (Byte)vector.elementAt(i);
        }
        return byArray;
    }
}

