/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.ui;

import com.magmic.maglet.Maglet;
import com.magmic.rim.util.Utilities;
import com.magmic.ui.MagmicGraphics;
import com.magmic.ui.MagmicImage;
import com.magmic.ui.MagmicSplashInterface;
import java.util.Random;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.system.EncodedImage;
import net.rim.device.api.ui.Graphics;

public class MagmicSplash2
implements MagmicSplashInterface {
    public static final int STATE_LOAD = 0;
    public static final int STATE_ANIMATE = 1;
    public static final int STATE_DELAY = 2;
    public static final int STATE_EXIT = 3;
    private Maglet app;
    private int state;
    private int stateDeltaTime;
    private int deltaTime = 0;
    private long lastTime;
    private static final int DELAY_TIME = 1500;
    private static final int TRANS_COLOUR = 255;
    private static final int FRAME_TIME = 50;
    private static final int TILE_DIM = 8;
    private static final int TILE_SIZE = 32;
    private int timeCode;
    private int[] pixels;
    private int[] tileList;
    private int numRows;
    private int numCols;
    private int tileIndex;
    private int numToAdd;
    private EncodedImage bgImage;
    private Bitmap magmicImage;
    private int COL_BUFFER = 8;
    private int ROW_BUFFER = 8;
    private int magmicImage_width;
    private int magmicImage_height;
    private Bitmap buffer = null;
    private final Object MUTEX = new Object();
    private int screenWidth;
    private int screenHeight;

    public boolean processEvent(int n, int n2, int n3, Object object) {
        switch (n) {
            case 4: {
                this.app = Maglet.getInstance();
                this.app.enableTickEvents(50L);
                this.state = 0;
                this.app.invalidateScreen();
                this.lastTime = System.currentTimeMillis();
                break;
            }
            case 7: {
                this.app.enableTickEvents(0L);
                this.freeResources();
                return false;
            }
            case 3: {
                this.tick();
                this.app.invalidateScreen();
                break;
            }
            case 1: {
                MagmicGraphics magmicGraphics = (MagmicGraphics)object;
                this.paint(magmicGraphics.getGraphics());
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.lastTime = System.currentTimeMillis();
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            default: {
                return true;
            }
        }
        return this.state != 3;
    }

    public int getState() {
        return this.state;
    }

    public void initMagmicSplash() {
        this.loadMagmicSplash(Utilities.loadEncodedImage(new MagmicSplash2().getClass(), "/lib-intro_bg.png", 2048), MagmicImage.loadMagmicImage("lib-intro_magmic_logo.png").getNativeFormat());
    }

    private void loadMagmicSplash(EncodedImage encodedImage, Bitmap bitmap) {
        int n;
        int n2;
        int n3;
        this.bgImage = encodedImage;
        this.magmicImage = bitmap;
        this.screenWidth = this.app.getWidth();
        this.screenHeight = this.app.getHeight();
        this.magmicImage_width = this.magmicImage.getWidth();
        this.magmicImage_height = this.magmicImage.getHeight();
        this.pixels = new int[this.magmicImage_width * this.magmicImage_height];
        this.numRows = this.magmicImage_height / 8;
        this.numCols = this.magmicImage_width / 8;
        this.tileList = new int[this.numRows * this.numCols];
        for (n3 = 0; n3 < this.tileList.length; ++n3) {
            this.tileList[n3] = n3;
        }
        this.magmicImage.getARGB(this.pixels, 0, this.magmicImage_width, 0, 0, this.magmicImage_width, this.magmicImage_height);
        for (n3 = 0; n3 < this.pixels.length; ++n3) {
            if (this.pixels[n3] >>> 24 != 255) continue;
            int n4 = n3;
            this.pixels[n4] = this.pixels[n4] & 0xFFFFFF;
        }
        this.magmicImage.setARGB(this.pixels, 0, this.magmicImage_width, 0, 0, this.magmicImage_width, this.magmicImage_height);
        Random random = new Random();
        for (n2 = 0; n2 < 2; ++n2) {
            for (n = 0; n < this.tileList.length; ++n) {
                int n5 = n + (random.nextInt() & Integer.MAX_VALUE) % (this.tileList.length - n);
                int n6 = this.tileList[n5];
                this.tileList[n5] = this.tileList[n];
                this.tileList[n] = n6;
            }
        }
        n2 = this.screenWidth / 32 * 32;
        n = this.screenHeight / 32 * 32;
        this.COL_BUFFER = (this.screenWidth - n2) / 2;
        this.ROW_BUFFER = (this.screenHeight - n) / 2;
        this.numToAdd = 1;
    }

    public void tick() {
        long l = System.currentTimeMillis();
        if (l > this.lastTime) {
            this.deltaTime += (int)(l - this.lastTime);
        }
        this.lastTime = l;
        switch (this.state) {
            case 0: {
                this.initMagmicSplash();
                this.setBuffer(new Bitmap(this.app.getWidth(), this.app.getHeight()));
                this.deltaTime = 0;
                this.state = 1;
                break;
            }
            case 1: {
                try {
                    this.magmicImage.getARGB(this.pixels, 0, this.magmicImage_width, 0, 0, this.magmicImage_width, this.magmicImage_height);
                    while (this.deltaTime > 50) {
                        this.deltaTime -= 50;
                        for (int i = 0; i < this.numToAdd; ++i) {
                            if (this.tileIndex >= this.tileList.length) {
                                this.state = 2;
                                this.stateDeltaTime = 0;
                                break;
                            }
                            int n = this.tileList[this.tileIndex++];
                            this.makeTileOpaque(this.pixels, n, this.magmicImage_width);
                        }
                        ++this.numToAdd;
                    }
                    this.magmicImage.setARGB(this.pixels, 0, this.magmicImage_width, 0, 0, this.magmicImage_width, this.magmicImage_height);
                }
                catch (Exception exception) {}
                break;
            }
            case 2: {
                this.stateDeltaTime += this.deltaTime;
                this.deltaTime = 0;
                if (this.stateDeltaTime <= 1500) break;
                this.state = 3;
            }
        }
    }

    private void makeTileOpaque(int[] nArray, int n, int n2) {
        int n3 = n % this.numCols * 8;
        int n4 = n / this.numCols * 8;
        int n5 = n4 * n2 + n3;
        for (int i = 8; i > 0; --i) {
            if ((nArray[n5] & 0xFFFFFF) != 255) {
                int n6 = n5;
                nArray[n6] = nArray[n6] | 0xFF000000;
            }
            if ((nArray[n5 + 1] & 0xFFFFFF) != 255) {
                int n7 = n5 + 1;
                nArray[n7] = nArray[n7] | 0xFF000000;
            }
            if ((nArray[n5 + 2] & 0xFFFFFF) != 255) {
                int n8 = n5 + 2;
                nArray[n8] = nArray[n8] | 0xFF000000;
            }
            if ((nArray[n5 + 3] & 0xFFFFFF) != 255) {
                int n9 = n5 + 3;
                nArray[n9] = nArray[n9] | 0xFF000000;
            }
            if ((nArray[n5 + 4] & 0xFFFFFF) != 255) {
                int n10 = n5 + 4;
                nArray[n10] = nArray[n10] | 0xFF000000;
            }
            if ((nArray[n5 + 5] & 0xFFFFFF) != 255) {
                int n11 = n5 + 5;
                nArray[n11] = nArray[n11] | 0xFF000000;
            }
            if ((nArray[n5 + 6] & 0xFFFFFF) != 255) {
                int n12 = n5 + 6;
                nArray[n12] = nArray[n12] | 0xFF000000;
            }
            if ((nArray[n5 + 7] & 0xFFFFFF) != 255) {
                int n13 = n5 + 7;
                nArray[n13] = nArray[n13] | 0xFF000000;
            }
            n5 += n2;
        }
    }

    public void paint(Graphics graphics) {
        System.out.println("graphics: " + graphics);
        if (this.buffer == null) {
            return;
        }
        graphics.drawBitmap(0, 0, this.screenWidth, this.screenHeight, this.buffer, 0, 0);
        try {
            graphics.drawBitmap(this.screenWidth - this.magmicImage_width >> 1, this.screenHeight - this.magmicImage_height >> 1, this.magmicImage_width, this.magmicImage_height, this.magmicImage, 0, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawBackground(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
        int n = this.screenWidth / 32;
        int n2 = this.screenHeight / 32;
        int n3 = 0;
        int n4 = 0;
        if (this.bgImage != null) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n5 = this.COL_BUFFER + j * 32;
                    int n6 = this.ROW_BUFFER + i * 32;
                    n4 = i == n2 - 1 ? 64 : (i == 0 ? 0 : 32);
                    n3 = j == n - 1 ? 64 : (j == 0 ? 0 : 32);
                    graphics.drawImage(n5, n6, 32, 32, this.bgImage, 0, n3, n4);
                }
            }
        }
    }

    public void setBuffer(Bitmap bitmap) {
        this.buffer = bitmap;
        Graphics graphics = new Graphics(bitmap);
        graphics.setBackgroundColor(0);
        graphics.clear();
        this.drawBackground(graphics);
    }

    public Bitmap getBuffer() {
        return this.buffer;
    }

    public void freeResources() {
        this.buffer = null;
        this.magmicImage = null;
        this.bgImage = null;
    }
}

