/*
 * Decompiled with CFR 0.152.
 */
package com.magmic;

import com.magmic.Font;
import com.magmic.MagmicGame;
import com.magmic.MagmicStringBuffer;
import com.magmic.pykegame.MagmicLayer;
import com.magmic.pykegame.WindowData;
import com.magmic.ui.MagmicGraphics;

public class Window
extends MagmicLayer {
    public static final int WINDOW_TYPE_FILL = 0;
    public static final int WINDOW_TYPE_PYKE = 1;
    public static final int WINDOW_BOUNDS_EXACT = 0;
    public static final int WINDOW_BOUNDS_FLOOR = 1;
    public static final int WINDOW_BOUNDS_CEIL = 2;
    public static final int WINDOW_BOUNDS_ROUND = 3;
    public static final int WINDOW_TRANSITION_INSTANT = 0;
    public static final int WINDOW_TRANSITION_GROWTH = 1;
    public static final int WINDOW_TRANSITION_SLIDE = 2;
    public static final int WINDOW_FROM_EAST = 0;
    public static final int WINDOW_FROM_WEST = 1;
    public static final int WINDOW_FROM_NORTH = 2;
    public static final int WINDOW_FROM_SOUTH = 3;
    public int windowType;
    public int x;
    public int y;
    public int w;
    public int h;
    public int center_x;
    public int center_y;
    public int center_w;
    public int center_h;
    public MagmicLayer listener;
    public int borderColor;
    public int fillColor;
    public int borderSize;
    public WindowData windowData;
    public int innerMarginSize;
    public Font titleFont;
    public int titleId;
    public String titleString;
    public int titleVGap;
    public int transition;
    public int transitionDuration;
    public int transitionProgress;
    public int transitionParam1;
    public int transitionParam2;
    public boolean transitionOnClose;
    public boolean closing;
    public boolean keyModal;
    public boolean paintModal;
    public boolean tickModal;
    public boolean pauseResume;

    public Window(MagmicGame magmicGame) {
        super(magmicGame);
    }

    public void open(MagmicLayer magmicLayer) {
        this.listener = magmicLayer;
        this.keyModal = true;
        this.paintModal = false;
        this.tickModal = false;
        this.pauseResume = false;
        this.closing = false;
        this.transitionProgress = 0;
        if (!this.isTransiting() || this.transition == 1) {
            this.maglet.repaintFullscreenBackbuffer = true;
        }
        this.maglet.push_layer(this, this.keyModal, this.paintModal, this.tickModal, this.pauseResume, (byte)0);
    }

    public void close() {
        this.maglet.repaintFullscreenBackbuffer = true;
        this.closing = true;
        this.transitionProgress = 0;
        this.validateTransition();
        if (!this.isTransiting() || !this.transitionOnClose) {
            this._close();
        }
    }

    public void _close() {
        this.closing = false;
        this.maglet.remove_layer(this, false);
        if (this.listener != null) {
            this.listener.window_closed(this);
        }
    }

    public void setSizeAndCenter(int n, int n2, int n3) {
        int n4 = (this.maglet.get_width() - n) / 2;
        int n5 = (this.maglet.get_height() - n2) / 2;
        this.setBounds(n4, n5, n, n2, n3);
    }

    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        switch (this.windowType) {
            case 1: {
                if (this.windowData == null || n5 == 0) break;
                int n6 = this.windowData.wnw + this.windowData.wne;
                int n7 = this.windowData.hnw + this.windowData.hsw;
                int n8 = n3 - n6;
                int n9 = n4 - n7;
                int n10 = n8 % this.windowData.wn;
                int n11 = n9 % this.windowData.hw;
                int n12 = n5;
                int n13 = n5;
                if (n5 == 3) {
                    n12 = n10 < this.windowData.wn / 2 ? 1 : 2;
                    int n14 = n13 = n11 < this.windowData.hw / 2 ? 1 : 2;
                }
                if (n12 == 1) {
                    n3 -= n10;
                    n += n10 / 2;
                } else if (n11 != 0) {
                    n3 += this.windowData.wn - n10;
                    n -= (this.windowData.wn - n10) / 2;
                }
                if (n13 == 1) {
                    n4 -= n11;
                    n2 += n11 / 2;
                    break;
                }
                if (n11 == 0) break;
                n4 += this.windowData.hw - n11;
                n2 -= (this.windowData.hw - n11) / 2;
            }
        }
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
        this.updateCenterDimension();
    }

    public void setupFillRect(int n, int n2, int n3, int n4) {
        this.windowType = 0;
        this.borderColor = n;
        this.fillColor = n2;
        this.borderSize = n3;
        this.innerMarginSize = n4;
        this.updateCenterDimension();
    }

    public void setupPykeWindow(WindowData windowData, int n) {
        this.windowType = 1;
        this.windowData = windowData;
        this.innerMarginSize = n;
        this.updateCenterDimension();
    }

    public void setupTransition(int n, int n2, int n3, int n4, boolean bl) {
        this.transition = n;
        this.transitionDuration = n2;
        this.transitionProgress = 0;
        this.transitionParam1 = n3;
        this.transitionParam2 = n4;
        this.transitionOnClose = bl;
        this.validateTransition();
    }

    public void validateTransition() {
        switch (this.transition) {
            case 1: {
                if (this.transitionParam1 != this.w || this.transitionParam2 != this.h) break;
                this.transition = 0;
            }
        }
    }

    public boolean isTransiting() {
        return this.transitionProgress < this.transitionDuration && this.transition != 0;
    }

    public void setTitle(Font font, int n) {
        this.titleFont = font;
        this.titleId = n;
        this.titleString = null;
        this.titleVGap = font.line_height / 2;
        this.updateCenterDimension();
        MagmicGame.maglet.repaintFullscreenBackbuffer = true;
    }

    public void setTitle(Font font, String string) {
        this.titleFont = font;
        this.titleString = string;
        this.titleId = -1;
        this.titleVGap = font.line_height / 2;
        this.updateCenterDimension();
        MagmicGame.maglet.repaintFullscreenBackbuffer = true;
    }

    public void updateCenterDimension() {
        switch (this.windowType) {
            case 0: {
                this.center_x = this.x + this.borderSize + this.innerMarginSize;
                this.center_y = this.y + this.borderSize + this.innerMarginSize;
                this.center_w = this.w - 2 * (this.borderSize + this.innerMarginSize);
                this.center_h = this.h - 2 * (this.borderSize + this.innerMarginSize);
                break;
            }
            case 1: {
                if (this.windowData == null) break;
                this.center_x = this.x + this.windowData.ww + this.innerMarginSize;
                this.center_y = this.y + this.windowData.hn + this.innerMarginSize;
                this.center_w = this.w - this.windowData.ww - this.windowData.we - 2 * this.innerMarginSize;
                this.center_h = this.h - this.windowData.hn - this.windowData.hs - 2 * this.innerMarginSize;
            }
        }
        if (this.titleExists()) {
            int n = this.titleFont.line_height + this.titleVGap;
            this.center_h -= n;
            this.center_y += n;
        }
    }

    public boolean tick(int n) {
        if (this.isTransiting()) {
            this.transitionProgress += n;
            if (this.transitionProgress > this.transitionDuration) {
                this.transitionProgress = this.transitionDuration;
            }
            if (this.closing && !this.isTransiting()) {
                this._close();
            } else if (!this.closing && !this.isTransiting()) {
                this.maglet.repaintFullscreenBackbuffer = true;
            }
            return true;
        }
        return false;
    }

    public void paintBackBuffer(MagmicGraphics magmicGraphics) {
        if (!this.isTransiting()) {
            this.paintFrame(magmicGraphics);
        }
    }

    public void paint(MagmicGraphics magmicGraphics) {
        if (this.isTransiting()) {
            this.paintFrame(magmicGraphics);
        }
    }

    public void paintFrame(MagmicGraphics magmicGraphics) {
        int n;
        int n2 = this.maglet.get_width();
        int n3 = this.maglet.get_height();
        int n4 = 0;
        if (this.titleExists()) {
            n4 = this.titleFont.line_height + this.titleVGap;
        }
        int n5 = this.w;
        int n6 = this.h;
        int n7 = this.x;
        int n8 = this.y;
        if (this.isTransiting()) {
            n = this.closing ? this.transitionDuration - this.transitionProgress : this.transitionProgress;
            switch (this.transition) {
                case 2: {
                    switch (this.transitionParam1) {
                        case 0: {
                            n7 = n2 - (n2 - this.x) * n / this.transitionDuration;
                            break;
                        }
                        case 1: {
                            n7 = -this.w + (this.w + this.x) * n / this.transitionDuration;
                            break;
                        }
                        case 2: {
                            n8 = -this.h + (this.h + this.y) * n / this.transitionDuration;
                            break;
                        }
                        case 3: {
                            n8 = n3 - (n3 - this.y) * n / this.transitionDuration;
                        }
                    }
                    break;
                }
                case 1: {
                    n5 = this.transitionParam1 + (this.w - this.transitionParam1) * n / this.transitionDuration;
                    n6 = this.transitionParam2 + (this.h - this.transitionParam2) * n / this.transitionDuration;
                    n7 += (this.w - n5) / 2;
                    n8 += (this.h - n6) / 2;
                }
            }
        }
        n = this.center_x;
        int n9 = this.center_x;
        int n10 = this.center_x;
        int n11 = this.center_x;
        switch (this.windowType) {
            case 0: {
                n = n7 + this.borderSize + this.innerMarginSize;
                n9 = n8 + this.borderSize + this.innerMarginSize;
                n10 = n5 - 2 * (this.borderSize + this.innerMarginSize);
                n11 = n6 - 2 * (this.borderSize + this.innerMarginSize);
                break;
            }
            case 1: {
                if (this.windowData == null) break;
                n = n7 + this.windowData.ww + this.innerMarginSize;
                n9 = n8 + this.windowData.hn + this.innerMarginSize;
                n10 = n5 - this.windowData.ww - this.windowData.we - 2 * this.innerMarginSize;
                n11 = n6 - this.windowData.hn - this.windowData.hs - 2 * this.innerMarginSize;
            }
        }
        n11 -= n4;
        n9 += n4;
        switch (this.windowType) {
            case 0: {
                magmicGraphics.setColor(this.borderColor);
                for (int i = 0; i < this.borderSize; ++i) {
                    magmicGraphics.drawRect(n7 + i, n8 + i, n5 - i - i, n6 - i - i);
                }
                magmicGraphics.setColor(this.fillColor);
                magmicGraphics.fillRect(n7 + this.borderSize, n8 + this.borderSize, n5 - this.borderSize * 2, n6 - this.borderSize * 2);
                break;
            }
            case 1: {
                this.windowData.draw_frame(magmicGraphics, n7, n8, n5, n6);
                this.windowData.draw_center_piece(magmicGraphics, n - this.innerMarginSize, n9 - n4 - this.innerMarginSize, n10 + 2 * this.innerMarginSize, n11 + n4 + 2 * this.innerMarginSize);
            }
        }
        if ((!this.isTransiting() || this.transition == 2 && this.transitionParam2 != 0) && this.titleExists()) {
            MagmicStringBuffer magmicStringBuffer = MagmicStringBuffer.global_buffer;
            magmicStringBuffer.clear();
            if (this.titleString != null) {
                magmicStringBuffer.append(this.titleString);
            }
            if (this.titleId != -1) {
                this.maglet.strings.append_string(this.titleId, magmicStringBuffer);
            }
            int n12 = this.titleFont.get_chars_width(magmicStringBuffer.chars, 0, magmicStringBuffer.length);
            this.titleFont.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n7 + (n5 - n12) / 2, n9 - this.titleFont.line_height - this.titleVGap);
        }
    }

    public boolean titleExists() {
        return this.titleFont != null && (this.titleId != -1 || this.titleString != null);
    }
}

