/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.ui;

import com.magmic.maglet.Maglet;
import com.magmic.ui.MagmicGraphics;
import java.io.IOException;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.ui.Graphics;

public final class MagmicImage {
    private Bitmap img;
    private int w;
    private int h;

    private MagmicImage() {
    }

    public MagmicImage(int n, int n2) {
        this.w = n;
        this.h = n2;
        this.img = new Bitmap(n, n2);
    }

    public MagmicImage(Bitmap bitmap) {
        this.img = bitmap;
        this.w = bitmap.getWidth();
        this.h = bitmap.getHeight();
    }

    private static Bitmap loadNativeImage(String string) {
        int n;
        byte[] byArray;
        String string2 = string.charAt(0) == '/' ? string.substring(1) : string;
        if (string != null && string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        try {
            Maglet.getInstance();
            byArray = Maglet.archiveReader.readFile(string);
        }
        catch (IOException iOException) {
            byArray = null;
        }
        if (byArray == null) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmapFromPNG((byte[])byArray, (int)0, (int)byArray.length);
        if (bitmap == null && (n = string.lastIndexOf(47)) >= 0 && n + 1 < string.length()) {
            string2 = string.substring(n + 1);
            bitmap = MagmicImage.loadBitmap(string2);
        }
        return bitmap;
    }

    public static MagmicImage loadMagmicImage(String string) {
        MagmicImage magmicImage = new MagmicImage();
        magmicImage.img = MagmicImage.loadNativeImage(string);
        if (magmicImage.img == null) {
            return null;
        }
        magmicImage.w = magmicImage.img.getWidth();
        magmicImage.h = magmicImage.img.getHeight();
        return magmicImage;
    }

    private static Bitmap loadNativeImageFromBytes(byte[] byArray, int n, int n2) {
        Bitmap bitmap;
        try {
            bitmap = Bitmap.createBitmapFromPNG((byte[])byArray, (int)n, (int)n2);
        }
        catch (Throwable throwable) {
            return null;
        }
        return bitmap;
    }

    public static MagmicImage loadMagmicImageFromBytes(byte[] byArray, int n, int n2) {
        MagmicImage magmicImage = new MagmicImage();
        magmicImage.img = MagmicImage.loadNativeImageFromBytes(byArray, n, n2);
        if (magmicImage.img == null) {
            return null;
        }
        magmicImage.w = magmicImage.img.getWidth();
        magmicImage.h = magmicImage.img.getHeight();
        return magmicImage;
    }

    public static MagmicImage loadMutableMagmicImage(String string) {
        MagmicImage magmicImage = new MagmicImage();
        magmicImage.img = MagmicImage.loadNativeImage(string);
        if (magmicImage.img == null) {
            return null;
        }
        magmicImage.w = magmicImage.img.getWidth();
        magmicImage.h = magmicImage.img.getHeight();
        return magmicImage;
    }

    private static Bitmap loadBitmap(String string) {
        Bitmap bitmap = Bitmap.getBitmapResource((String)string);
        return bitmap;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public void drawRegion(MagmicGraphics magmicGraphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Graphics graphics = magmicGraphics.getGraphics();
        graphics.drawBitmap(n, n2, n3, n4, this.img, n5, n6);
    }

    public void draw(MagmicGraphics magmicGraphics, int n, int n2) {
        Graphics graphics = magmicGraphics.getGraphics();
        graphics.drawBitmap(n, n2, this.w, this.h, this.img, 0, 0);
    }

    public MagmicGraphics getGraphics() {
        return new MagmicGraphics(new Graphics(this.img));
    }

    public Bitmap getNativeFormat() {
        return this.img;
    }
}

