/*
 * Decompiled with CFR 0.152.
 */
package com.magmic;

import com.magmic.AutoTextDialog;
import com.magmic.Font;
import com.magmic.MagmicGame;
import com.magmic.MagmicStringBuffer;
import com.magmic.ui.MagmicGraphics;
import net.rim.device.api.system.Application;

public final class TextField {
    public TextField self;
    public char[] value;
    public int length;
    public int capacity;
    public boolean selected;
    public Font font;
    public int selectedColor;
    public int unselectedColor;
    public int borderColor;
    public boolean isPassword;
    public char passwordHideCharacter = (char)64;
    public char cursorCharacter = (char)95;
    public long lastChangeTime;
    public long selectionTimeThreshold = 1250L;
    public static final String VALID_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ.,@_- 0123456789";
    public char defaultChar = (char)45;

    public TextField(int n) {
        this.self = this;
        this.capacity = n;
        this.value = new char[n];
        this.length = 0;
    }

    public void setLayout(Font font, int n, int n2, int n3, boolean bl) {
        this.font = font;
        this.selectedColor = n;
        this.unselectedColor = n2;
        this.borderColor = n3;
        this.isPassword = bl;
    }

    public int getHeight() {
        if (this.font != null) {
            return this.font.line_height + 2;
        }
        return 0;
    }

    public boolean setValue(String string) {
        boolean bl = true;
        this.length = 0;
        for (int i = 0; i < string.length() && i < this.capacity; ++i) {
            char c = string.charAt(i);
            char c2 = this.getValidChar(c);
            this.value[this.length++] = c2;
            if (c >= 'a' && c <= 'z' || c == c2) continue;
            bl = false;
        }
        if (string.length() > this.capacity) {
            bl = false;
        }
        return bl;
    }

    public char getValidChar(char c) {
        if (c >= 'a' && c <= 'z') {
            c = (char)(c - 32);
        }
        for (int i = 0; i < VALID_CHARS.length(); ++i) {
            if (c != VALID_CHARS.charAt(i)) continue;
            return c;
        }
        return this.defaultChar;
    }

    public void paint(MagmicGraphics magmicGraphics, int n, int n2, int n3) {
        int n4 = this.font.line_height + 2;
        boolean bl = this.selected && this.length > 0 && System.currentTimeMillis() <= this.lastChangeTime + this.selectionTimeThreshold;
        magmicGraphics.setColor(this.selected ? this.selectedColor : this.unselectedColor);
        magmicGraphics.fillRect(n, n2, n3, n4);
        magmicGraphics.setColor(this.borderColor);
        magmicGraphics.drawRect(n, n2, n3, n4);
        int n5 = 1;
        int n6 = n + n5;
        int n7 = n2 + n5;
        int n8 = n3 - n5 - n5;
        if (this.isPassword) {
            int n9 = Math.min(n8 / (this.font.get_char_width(this.passwordHideCharacter) + this.font.data.spacer_x), this.length);
            if (bl) {
                --n9;
            }
            for (int i = 0; i < n9; ++i) {
                n6 += this.font.paint_char(magmicGraphics, this.passwordHideCharacter, n6, n7);
            }
            if (bl) {
                n6 += this.font.paint_char(magmicGraphics, this.value[this.length - 1], n6, n7);
            }
        } else {
            int n10;
            for (n10 = 0; n10 < this.length && this.font.get_chars_width(this.value, n10, this.length - n10) > n8; ++n10) {
            }
            n6 += this.font.paint_chars(magmicGraphics, this.value, n10, this.length - n10, n6, n7);
        }
        if (this.selected && this.length < this.capacity && !bl) {
            n6 += this.font.paint_char(magmicGraphics, this.cursorCharacter, n6, n7);
        }
    }

    public boolean keyDown(int n, int n2) {
        int n3;
        boolean bl = this.selected && this.length > 0 && System.currentTimeMillis() <= this.lastChangeTime + this.selectionTimeThreshold;
        int n4 = n3 = bl ? this.length - 1 : this.length;
        if (n3 == this.capacity) {
            bl = true;
            --n3;
        }
        if (!this.selected) {
            return false;
        }
        char[] cArray = MagmicStringBuffer.global_buffer.chars;
        int n5 = MagmicGame.get_key_letters(n2, cArray, true);
        if ((n5 = this.validateKeys(cArray, n5)) > 0) {
            this.lastChangeTime = n5 == 1 ? 0L : System.currentTimeMillis();
            if (bl) {
                int n6 = -1;
                for (int i = 0; i < n5; ++i) {
                    if (this.getValidChar(cArray[i]) != this.value[n3]) continue;
                    n6 = i;
                }
                if (n6 != -1) {
                    this.value[n3] = this.getValidChar(cArray[(n6 + 1) % n5]);
                    return true;
                }
            }
            if (bl) {
                if (n3 + 1 < this.capacity) {
                    this.value[n3 + 1] = this.getValidChar(cArray[0]);
                    ++this.length;
                }
            } else {
                this.value[n3] = this.getValidChar(cArray[0]);
                ++this.length;
            }
            return true;
        }
        switch (n) {
            case 4: {
                this.lastChangeTime = System.currentTimeMillis();
                if (bl) {
                    this.cycleChar(n3, 1);
                } else {
                    this.value[n3] = VALID_CHARS.charAt(0);
                    ++this.length;
                }
                return true;
            }
            case 5: {
                this.lastChangeTime = System.currentTimeMillis();
                if (bl) {
                    this.cycleChar(n3, -1);
                } else {
                    this.value[n3] = VALID_CHARS.charAt(VALID_CHARS.length() - 1);
                    ++this.length;
                }
                return true;
            }
            case 2: {
                if (this.length > 0) {
                    --this.length;
                }
                this.lastChangeTime = 0L;
                return true;
            }
            case 3: {
                this.lastChangeTime = 0L;
                return true;
            }
        }
        return false;
    }

    public boolean keyUp(int n, int n2) {
        if (n == 6) {
            this.showTextDialog();
            return true;
        }
        return false;
    }

    public void cycleChar(int n, int n2) {
        char c = this.value[n];
        for (int i = 0; i < VALID_CHARS.length(); ++i) {
            if (c != VALID_CHARS.charAt(i)) continue;
            n2 = i + n2;
            break;
        }
        while (n2 < 0) {
            n2 += VALID_CHARS.length();
        }
        this.value[n] = VALID_CHARS.charAt(n2 %= VALID_CHARS.length());
    }

    public int validateKeys(char[] cArray, int n) {
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            char c2 = this.getValidChar(c);
            if (c >= 'a' && c <= 'z' || c == c2) continue;
            cArray[i] = cArray[n - 1];
            --i;
            --n;
        }
        return n;
    }

    public void showTextDialog() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = Application.getEventLock();
                synchronized (object) {
                    byte by = 0;
                    if (TextField.this.self.isPassword) {
                        by = 1;
                    }
                    AutoTextDialog autoTextDialog = new AutoTextDialog(null, TextField.this.capacity, new String(TextField.this.value, 0, TextField.this.length), TextField.this.self, by);
                    autoTextDialog.show();
                }
            }
        }.start();
    }
}

