/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.ui.game;

import net.rim.device.api.system.Application;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.ui.Graphics;
import net.rim.device.api.ui.Keypad;
import net.rim.device.api.ui.XYRect;
import net.rim.device.api.ui.container.FullScreen;

public class GameCanvas
extends FullScreen {
    public static final int SCREEN_WIDTH = Graphics.getScreenWidth();
    public static final int SCREEN_HEIGHT = Graphics.getScreenHeight();
    public Bitmap buffer;
    protected int keyStates;
    private int hardwareKeyStates;
    public static final int SOFTKEY_LEFT = 30;
    public static final int SOFTKEY_RIGHT = 31;
    private String leftSoftKeyLabel = " ";
    private String rightSoftKeyLabel = " ";
    private boolean stopRightSoftKey = false;
    public static final int SOFTKEY_BACK = 29;
    public static final int ACTION_ESCAPE = 29;
    public static final int BACKSPACE = 666;
    public static final int ACTION_END = -34;
    public static final int ACTION_SEND = -35;
    public static final int ACTION_DONE = -36;
    public static final int ACTION_MENU = -37;
    public static final int DOWN = 6;
    public static final int FIRE = 8;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int UP = 1;
    public static final int GAME_A = 9;
    public static final int GAME_B = 10;
    public static final int GAME_C = 11;
    public static final int GAME_D = 12;
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    public static final int KEY_STAR = 42;
    public static final int KEY_POUND = 35;
    public static final int UP_PRESSED = 2;
    public static final int DOWN_PRESSED = 64;
    public static final int LEFT_PRESSED = 4;
    public static final int RIGHT_PRESSED = 32;
    public static final int FIRE_PRESSED = 256;
    public static final int GAME_A_PRESSED = 512;
    public static final int GAME_B_PRESSED = 1024;
    public static final int GAME_C_PRESSED = 2048;
    public static final int GAME_D_PRESSED = 4096;
    public static final int KEY_0_PRESSED = 8192;
    public static final int KEY_1_PRESSED = 16384;
    public static final int KEY_2_PRESSED = 32768;
    public static final int KEY_3_PRESSED = 65536;
    public static final int KEY_4_PRESSED = 131072;
    public static final int KEY_5_PRESSED = 262144;
    public static final int KEY_6_PRESSED = 524288;
    public static final int KEY_7_PRESSED = 0x100000;
    public static final int KEY_8_PRESSED = 0x200000;
    public static final int KEY_9_PRESSED = 0x400000;
    public static final int ESCAPE_PRESSED = 0x20000000;
    public static final int SOFTKEY_LEFT_PRESSED = 0x40000000;
    public static final int SOFTKEY_RIGHT_PRESSED = Integer.MIN_VALUE;
    public static final int DONE_PRESSED = 0x10000000;
    public static final int MENU_PRESSED = 0x8000000;
    private boolean keyDPadEnabled = true;

    public Graphics getGraphics() {
        if (this.buffer == null) {
            this.buffer = new Bitmap(Graphics.getScreenWidth(), Graphics.getScreenHeight());
            Graphics graphics = new Graphics(this.buffer);
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
            return graphics;
        }
        return new Graphics(this.buffer);
    }

    public void setDKeypadEnabled(boolean bl) {
        this.keyDPadEnabled = bl;
    }

    public int getGameAction(int n) {
        switch (Keypad.key((int)n)) {
            case 10: 
            case 32: {
                return 8;
            }
            case 27: {
                return 29;
            }
        }
        switch (this.getScreenHeight()) {
            case 160: 
            case 240: {
                switch (Character.toUpperCase(Keypad.map((int)n))) {
                    case 'E': 
                    case 'U': {
                        return 1;
                    }
                    case 'N': 
                    case 'X': {
                        return 6;
                    }
                    case 'H': 
                    case 'S': {
                        return 2;
                    }
                    case 'F': 
                    case 'K': {
                        return 5;
                    }
                    case 'D': 
                    case 'J': {
                        return 8;
                    }
                    case 'W': 
                    case 'Y': {
                        return 9;
                    }
                    case 'I': 
                    case 'R': {
                        return 10;
                    }
                    case 'B': 
                    case 'Z': {
                        return 11;
                    }
                    case 'C': 
                    case 'M': {
                        return 12;
                    }
                }
                break;
            }
            case 260: {
                switch (Keypad.key((int)n)) {
                    case 68: 
                    case 81: {
                        return 2;
                    }
                    case 74: 
                    case 79: {
                        return 5;
                    }
                    case 84: {
                        return 1;
                    }
                    case 66: {
                        return 6;
                    }
                    case 10: 
                    case 32: 
                    case 71: {
                        return 8;
                    }
                    case 69: {
                        return 9;
                    }
                    case 85: {
                        return 10;
                    }
                    case 67: {
                        return 11;
                    }
                    case 77: {
                        return 12;
                    }
                }
                break;
            }
            case 320: 
            case 360: {
                if (this.getScreenWidth() == 480) {
                    switch (Character.toUpperCase(Keypad.map((int)n))) {
                        case 'E': 
                        case 'U': {
                            return 1;
                        }
                        case 'N': 
                        case 'X': {
                            return 6;
                        }
                        case 'H': 
                        case 'S': {
                            return 2;
                        }
                        case 'F': 
                        case 'K': {
                            return 5;
                        }
                        case 'D': 
                        case 'J': {
                            return 8;
                        }
                        case 'W': 
                        case 'Y': {
                            return 9;
                        }
                        case 'I': 
                        case 'R': {
                            return 10;
                        }
                        case 'B': 
                        case 'Z': {
                            return 11;
                        }
                        case 'C': 
                        case 'M': {
                            return 12;
                        }
                    }
                }
                switch (Keypad.key((int)n)) {
                    case 68: {
                        return 2;
                    }
                    case 74: {
                        return 5;
                    }
                    case 84: {
                        return 1;
                    }
                    case 66: {
                        return 6;
                    }
                    case 10: 
                    case 32: 
                    case 71: {
                        return 8;
                    }
                    case 69: {
                        return 9;
                    }
                    case 85: {
                        return 10;
                    }
                    case 67: {
                        return 11;
                    }
                    case 77: {
                        return 12;
                    }
                }
            }
        }
        return 0;
    }

    public String gameActionToString(int n) {
        switch (n) {
            case 8: {
                return "FIRE";
            }
            case 1: {
                return "UP";
            }
            case 6: {
                return "DOWN";
            }
            case 2: {
                return "LEFT";
            }
            case 5: {
                return "RIGHT";
            }
            case 9: {
                return "GAME_A";
            }
            case 10: {
                return "GAME_B";
            }
            case 11: {
                return "GAME_C";
            }
            case 12: {
                return "GAME_D";
            }
            case 30: {
                return "SOFTKEY_LEFT";
            }
            case 31: {
                return "SOFTKEY_RIGHT";
            }
            case 29: {
                return "SOFTKEY_BACK";
            }
        }
        return "(none)";
    }

    public static int getKeyCode(int n) {
        switch (Graphics.getScreenHeight()) {
            case 160: 
            case 240: {
                switch (n) {
                    case 8: {
                        return Keypad.keycode((char)'f', (int)0);
                    }
                    case 1: {
                        return Keypad.keycode((char)'u', (int)0);
                    }
                    case 6: {
                        return Keypad.keycode((char)'n', (int)0);
                    }
                    case 2: {
                        return Keypad.keycode((char)'h', (int)0);
                    }
                    case 5: {
                        return Keypad.keycode((char)'k', (int)0);
                    }
                }
                break;
            }
            case 260: {
                switch (n) {
                    case 8: {
                        return Keypad.keycode((char)'g', (int)0);
                    }
                    case 1: {
                        return Keypad.keycode((char)'t', (int)0);
                    }
                    case 6: {
                        return Keypad.keycode((char)'b', (int)0);
                    }
                    case 2: {
                        return Keypad.keycode((char)'d', (int)0);
                    }
                    case 5: {
                        return Keypad.keycode((char)'j', (int)0);
                    }
                }
            }
        }
        return -1;
    }

    public void flush() {
        this.flush(0, 0, this.getWidth(), this.getHeight());
    }

    public void flush(XYRect xYRect) {
        this.flush(xYRect.x, xYRect.y, xYRect.width, xYRect.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(int n, int n2, int n3, int n4) {
        Object object = Application.getEventLock();
        synchronized (object) {
            this.invalidate(n, n2, n3, n4);
            this.doPaint();
        }
    }

    public void paint(Graphics graphics) {
        if (this.buffer != null) {
            graphics.drawBitmap(0, 0, this.buffer.getWidth(), this.buffer.getHeight(), this.buffer, 0, 0);
        }
    }

    public void sizeChanged(int n, int n2) {
    }

    public int getKeyStates() {
        int n = this.keyStates;
        this.keyStates = this.hardwareKeyStates;
        return n;
    }

    public boolean keyDown(int n, int n2) {
        return this.keyDown(this.getGameAction(n));
    }

    public boolean keyDown(int n) {
        if (n != 0) {
            this.keyStates |= 1 << n;
            this.hardwareKeyStates = this.keyStates;
            return true;
        }
        return false;
    }

    public boolean keyUp(int n, int n2) {
        return this.keyUp(this.getGameAction(n));
    }

    public boolean keyUp(int n) {
        if (n != 0) {
            this.hardwareKeyStates &= ~(1 << n);
            return true;
        }
        return false;
    }

    public boolean keyChar(char c, int n, int n2) {
        return false;
    }

    public boolean keyRepeat(int n, int n2) {
        return false;
    }

    public boolean keyStatus(int n, int n2) {
        return false;
    }

    public boolean trackwheelClick(int n, int n2) {
        this.keyStates |= 0x100;
        return true;
    }

    public boolean trackwheelUnclick(int n, int n2) {
        this.keyStates &= 0xFFFFFEFF;
        return true;
    }

    public int getScreenWidth() {
        return Graphics.getScreenWidth();
    }

    public int getScreenHeight() {
        return Graphics.getScreenHeight();
    }

    public void removeLeftCommand() {
    }

    public void reAddCommands() {
    }

    public void removeCommands() {
    }

    public void addCommands(String string, String string2) {
    }

    public void removeRightSoftKey() {
    }
}

