/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.maglet;

import com.magmic.maglet.Maglet;
import com.magmic.ui.MagmicGraphics;
import com.magmic.ui.game.GameCanvas;
import net.rim.device.api.ui.Graphics;
import net.rim.device.api.ui.Keypad;

public class MagletGameCanvas
extends GameCanvas {
    public static final int DOWN = 6;
    public static final int FIRE = 8;
    public static final int GAME_A = 9;
    public static final int GAME_B = 10;
    public static final int GAME_C = 11;
    public static final int GAME_D = 12;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int UP = 1;
    private Maglet theMaglet = Maglet.getInstance();
    private Object processEventMutex = Maglet.processEventMutex;
    private boolean firstPaint = true;
    private MagmicGraphics mg = new MagmicGraphics(null);
    private boolean previousKeyDown = false;
    private boolean keyDPadEnabled = true;
    private boolean separateTrackwheelEvents = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        if (this.firstPaint) {
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.theMaglet.getWidth(), this.theMaglet.getHeight());
            this.firstPaint = false;
            return;
        }
        this.mg = this.mg.setGraphics(graphics);
        if (this.theMaglet.initEventProcessed) {
            Object object = this.processEventMutex;
            synchronized (object) {
                this.theMaglet.processEventState(1, -1, -1, this.mg);
            }
        }
        this.mg.resetClip();
    }

    protected void paintBackground(Graphics graphics) {
    }

    public Graphics getGraphics() {
        return super.getGraphics();
    }

    public void sublayout(int n, int n2) {
        super.sublayout(n, n2);
    }

    public void setDKeypadEnabled(boolean bl) {
        this.keyDPadEnabled = bl;
    }

    public int getGameAction(int n) {
        switch (Keypad.key((int)n)) {
            case 10: 
            case 32: {
                return 8;
            }
            case 27: {
                return 29;
            }
        }
        if (this.keyDPadEnabled) {
            switch (Keypad.key((int)n)) {
                case 68: 
                case 81: {
                    return 2;
                }
                case 74: 
                case 79: {
                    return 5;
                }
                case 84: {
                    return 1;
                }
                case 66: {
                    return 6;
                }
                case 10: 
                case 32: 
                case 71: {
                    return 8;
                }
                case 69: {
                    return 9;
                }
                case 85: {
                    return 10;
                }
                case 67: {
                    return 11;
                }
                case 77: {
                    return 12;
                }
            }
        }
        return 0;
    }

    public void enableSeparateTrackwheelEvents(boolean bl) {
        this.separateTrackwheelEvents = bl;
    }

    public boolean trackwheelClick(int n, int n2) {
        super.trackwheelClick(n, n2);
        this.theMaglet.postEvent(21, -1, -1, new int[]{n, n2}, 8);
        return true;
    }

    protected boolean trackwheelRoll(int n, int n2, int n3) {
        int n4 = (n2 & 1) != 0 ? n : 0;
        int n5 = (n2 & 1) == 0 ? n : 0;
        this.theMaglet.postEvent(23, n4, n5, new int[]{n4, n5, n2, n3}, 8);
        return super.trackwheelRoll(n, n2, n3);
    }

    public boolean trackwheelUnclick(int n, int n2) {
        super.trackwheelUnclick(n, n2);
        this.theMaglet.postEvent(22, -1, -1, new int[]{n, n2}, 8);
        return true;
    }

    public boolean keyDown(int n, int n2) {
        boolean bl = super.keyDown(n, n2);
        this.theMaglet.postEvent(9, n, -1, null, 8);
        return bl;
    }

    public boolean keyUp(int n, int n2) {
        boolean bl = super.keyUp(n, n2);
        this.theMaglet.postEvent(8, n, -1, null, 8);
        return bl;
    }

    protected void onDisplay() {
        this.theMaglet.invalidateScreen();
    }

    protected void onUndisplay() {
    }

    protected void onExposed() {
        if (this.theMaglet.initEventProcessed) {
            this.theMaglet.postEvent(6, 1, -1, null, 15);
        }
        this.theMaglet.invalidateScreen();
    }

    protected void onObscured() {
        if (this.theMaglet.initEventProcessed) {
            this.theMaglet.postEvent(5, 1, -1, null, 15);
        }
    }
}

