/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.kahuna;

import com.magmic.Font;
import com.magmic.MagmicGame;
import com.magmic.MagmicStringBuffer;
import com.magmic.Window;
import com.magmic.kahuna.MainMenuLayer;
import com.magmic.net.NetClient;
import com.magmic.pykegame.MagmicLayer;
import com.magmic.ui.MagmicGraphics;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class OnlineScoreLayer
extends Window {
    public static final int NUMBER_OF_SCORES = 2;
    public static final int NUMBER_OF_SCORE_TYPES = 2;
    public static final int MAX_NUMBER_OF_TOP_SCORES = 10;
    public Font font;
    public boolean requestedScores;
    public boolean receivedAllData;
    public int pageIndex;
    public int topIndex;
    public int visibleTops;
    public int[] scores;
    public int[] rankings;
    public String[][] topUsernames;
    public int[][] topScores;
    public int[] topN;
    public boolean receivedKeyDown;
    public MagmicLayer layer;

    public OnlineScoreLayer(MagmicGame magmicGame, Font font) {
        super(magmicGame);
        this.font = font;
        int n = 4;
        this.scores = new int[n];
        this.rankings = new int[n];
        this.topUsernames = new String[n][10];
        this.topScores = new int[n][10];
        this.topN = new int[n];
    }

    public void open(MagmicLayer magmicLayer) {
        super.open(magmicLayer);
        this.layer = magmicLayer;
        this.receivedKeyDown = false;
        this.pageIndex = 0;
        this.topIndex = 0;
        this.receivedAllData = false;
        this.requestedScores = false;
        this.submitScore();
    }

    public void close() {
        super.close();
        ((MainMenuLayer)this.layer).showMenu(3);
    }

    public void paint(MagmicGraphics magmicGraphics) {
        super.paint(magmicGraphics);
        if (this.isTransiting()) {
            return;
        }
        if (this.receivedAllData) {
            int n;
            MagmicStringBuffer magmicStringBuffer = MagmicStringBuffer.global_buffer;
            int n2 = this.center_x;
            int n3 = this.center_y;
            int n4 = this.pageIndex / 2 == 0 ? 103 : 104;
            int n5 = this.pageIndex % 2 == 0 ? 139 : 140;
            magmicStringBuffer.clear();
            this.maglet.strings.append_string(n4, magmicStringBuffer);
            int n6 = this.font.get_chars_width(magmicStringBuffer.chars, 0, magmicStringBuffer.length);
            int n7 = n2 + (this.center_w - n6) / 2;
            int n8 = n3;
            this.font.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n7, n3);
            magmicStringBuffer.clear();
            this.maglet.strings.append_string(n5, magmicStringBuffer);
            n6 = this.font.get_chars_width(magmicStringBuffer.chars, 0, magmicStringBuffer.length);
            n7 = n2 + (this.center_w - n6) / 2;
            this.font.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n7, n3 += this.font.line_height);
            n3 += this.font.line_height;
            magmicStringBuffer.clear();
            this.maglet.strings.append_string(141, magmicStringBuffer);
            magmicStringBuffer.append(' ');
            magmicStringBuffer.append(this.rankings[this.pageIndex]);
            this.font.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n2, n3 += this.font.line_height);
            magmicStringBuffer.clear();
            this.maglet.strings.append_string(142, magmicStringBuffer);
            this.font.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n2, n3 += this.font.line_height);
            n3 += this.font.line_height;
            magmicStringBuffer.clear();
            magmicStringBuffer.append(' ');
            if (n5 == 140) {
                magmicStringBuffer.append(this.scores[this.pageIndex] / 10);
                magmicStringBuffer.append('.');
                magmicStringBuffer.append(this.scores[this.pageIndex] % 10);
            } else {
                magmicStringBuffer.append(this.scores[this.pageIndex]);
            }
            this.font.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n2, n3);
            n3 += this.font.line_height;
            n3 += this.font.line_height;
            magmicStringBuffer.clear();
            this.maglet.strings.append_string(143, magmicStringBuffer);
            magmicStringBuffer.append(' ');
            magmicStringBuffer.append(this.topN[this.pageIndex]);
            magmicStringBuffer.append(':');
            this.font.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n2, n3);
            int n9 = n3 += this.font.line_height;
            for (n = this.topIndex; n < this.topN[this.pageIndex] && n3 + this.font.line_height * 2 < this.center_y + this.center_h; ++n) {
                magmicStringBuffer.clear();
                magmicStringBuffer.append('#');
                magmicStringBuffer.append(n + 1);
                magmicStringBuffer.append(' ');
                magmicStringBuffer.append(this.topUsernames[this.pageIndex][n]);
                this.font.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n2, n3);
                n3 += this.font.line_height;
                magmicStringBuffer.clear();
                magmicStringBuffer.append(' ');
                if (n5 == 140) {
                    magmicStringBuffer.append(this.topScores[this.pageIndex][n] / 10);
                    magmicStringBuffer.append('.');
                    magmicStringBuffer.append(this.topScores[this.pageIndex][n] % 10);
                } else {
                    magmicStringBuffer.append(this.topScores[this.pageIndex][n]);
                }
                this.font.paint_chars(magmicGraphics, magmicStringBuffer.chars, 0, magmicStringBuffer.length, n2, n3);
                n3 += this.font.line_height;
            }
            int n10 = this.x + this.w - (this.center_x + this.center_w);
            int n11 = this.center_x + this.center_w + (n10 - this.maglet.arrowUp.getWidth()) / 2;
            if (this.topIndex > 0) {
                this.maglet.arrowUp.draw(magmicGraphics, n11, n9);
            }
            if (n < this.topN[this.pageIndex]) {
                this.maglet.arrowDown.draw(magmicGraphics, n11, n3 - this.maglet.arrowDown.getHeight());
            }
            int n12 = this.x + (this.center_x - this.x - this.maglet.arrowLeft.getWidth()) / 2;
            n11 = this.center_x + this.center_w + (n10 - this.maglet.arrowRight.getWidth()) / 2;
            int n13 = n8 + (this.font.line_height - this.maglet.arrowLeft.getHeight()) / 2;
            this.maglet.arrowLeft.draw(magmicGraphics, n12, n13);
            this.maglet.arrowRight.draw(magmicGraphics, n11, n13);
        }
    }

    public boolean tick(int n) {
        super.tick(n);
        if (this.isTransiting()) {
            return true;
        }
        if (this.maglet.netHasMessage) {
            switch (this.maglet.netMessageCode) {
                case 100: {
                    if (!this.requestedScores) {
                        this.readSubmitScoreResponse();
                        this.requestedScores = true;
                        this.maglet.netClearStates();
                        this.requestScores();
                        break;
                    }
                    this.readRequestScoresResponse();
                    this.maglet.netClearStates();
                    break;
                }
                default: {
                    this.maglet.showSystemMessage(NetClient.respToString(this.maglet.netMessageCode), (MagmicLayer)this, -1);
                    this.maglet.netClearStates();
                    this.close();
                }
            }
        }
        return true;
    }

    public boolean key_down(int n, int n2) {
        if (this.isTransiting()) {
            return false;
        }
        this.receivedKeyDown = true;
        switch (n) {
            case 2: {
                this.setPage(this.pageIndex - 1);
                break;
            }
            case 3: {
                this.setPage(this.pageIndex + 1);
                break;
            }
            case 4: {
                --this.topIndex;
                if (this.topIndex >= 0) break;
                this.topIndex = 0;
                break;
            }
            case 5: {
                ++this.topIndex;
                if (this.topIndex <= this.topN[this.pageIndex] - this.visibleTops) break;
                this.topIndex = this.topN[this.pageIndex] - this.visibleTops;
            }
        }
        return true;
    }

    public void setPage(int n) {
        int n2;
        this.pageIndex = n;
        this.topIndex = 0;
        if (this.pageIndex < 0) {
            this.pageIndex = 3;
        }
        if (this.pageIndex >= 4) {
            this.pageIndex = 0;
        }
        int n3 = this.center_x;
        int n4 = this.center_y;
        n4 += this.font.line_height * 8;
        for (n2 = 0; n2 < this.topN[this.pageIndex] && n4 + this.font.line_height * 2 < this.center_y + this.center_h; ++n2) {
            n4 += this.font.line_height * 2;
        }
        this.visibleTops = n2;
    }

    public boolean key_up(int n, int n2) {
        if (this.isTransiting()) {
            return false;
        }
        if (this.maglet.netWaitingForReply) {
            return false;
        }
        if (!this.receivedKeyDown) {
            return false;
        }
        switch (n) {
            case 1: {
                this.close();
            }
        }
        return true;
    }

    public void submitScore() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF("2.0");
            dataOutputStream.writeByte(16);
            dataOutputStream.writeInt(4);
            this.scores[0] = this.maglet.score.getTotalScore(0);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeInt(this.scores[0]);
            this.scores[1] = this.maglet.score.getTotalAvg(0);
            dataOutputStream.writeInt(2);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeInt(this.scores[1]);
            this.scores[2] = this.maglet.score.getTotalScore(1);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeInt(this.scores[2]);
            this.scores[3] = this.maglet.score.getTotalAvg(1);
            dataOutputStream.writeInt(2);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeInt(this.scores[3]);
            dataOutputStream.flush();
            dataOutputStream.close();
            this.maglet.netClearStates();
            this.maglet.netWaitingForReply = true;
            this.maglet.net.setData(byteArrayOutputStream.toByteArray());
            this.maglet.net.request((byte)3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void requestScores() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF("2.0");
            dataOutputStream.writeByte(15);
            dataOutputStream.writeInt(4);
            dataOutputStream.writeByte(13);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeInt(10);
            dataOutputStream.writeByte(13);
            dataOutputStream.writeInt(2);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeInt(10);
            dataOutputStream.writeByte(13);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeInt(10);
            dataOutputStream.writeByte(13);
            dataOutputStream.writeInt(2);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeInt(10);
            dataOutputStream.flush();
            dataOutputStream.close();
            this.maglet.netClearStates();
            this.maglet.netWaitingForReply = true;
            this.maglet.net.setData(byteArrayOutputStream.toByteArray());
            this.maglet.net.request((byte)3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void readRequestScoresResponse() {
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.maglet.netMessageData));
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            for (int i = 0; i < n2; ++i) {
                int n3 = dataInputStream.readInt();
                int n4 = dataInputStream.readInt();
                short s = dataInputStream.readShort();
                int n5 = dataInputStream.readInt();
                int n6 = n4 - 1 + s * 2;
                this.topN[n6] = n5;
                for (int j = 0; j < n5; ++j) {
                    int n7 = dataInputStream.readInt();
                    String string = dataInputStream.readUTF();
                    int n8 = dataInputStream.readInt();
                    int n9 = (int)dataInputStream.readLong();
                    this.topUsernames[n6][j] = string;
                    this.topScores[n6][j] = n8;
                }
            }
            this.receivedAllData = true;
            this.setPage(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void readSubmitScoreResponse() {
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.maglet.netMessageData));
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            for (int i = 0; i < n2; ++i) {
                int n3;
                n = dataInputStream.readInt();
                int n4 = dataInputStream.readInt();
                short s = dataInputStream.readShort();
                this.rankings[n4 - 1 + s * 2] = n3 = (int)dataInputStream.readLong();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

