/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.ICircularBuffer;
import game.ILayer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import tinbrain.GCanvas;
import tinbrain.RM;
import tinbrain.midp20.MIDP20Proxy;

public class CircularBuffer
implements ICircularBuffer {
    private int bufferWidth;
    private int bufferHeight;
    private int bufferGridWidth;
    private int bufferGridHeight;
    private int worldGridX;
    private int worldGridY;
    private int pixelOffsetX;
    private int pixelOffsetY;
    private Image backbuffer;
    private Graphics og;
    private int backgroundColor;
    private int worldX;
    private int worldY;
    private ILayer[] layers = new ILayer[4];
    private final int[] viewRect = new int[4];
    private int[] rgbBufferHorizontal;
    private int[] rgbBufferVertical;
    private int clipLeft;
    private int clipTop;
    private int clipRight;
    private int clipBottom;
    private int[] stride = new int[1];

    public void setLayer(int n, ILayer iLayer) {
        this.layers[n] = iLayer;
        this.invalidate();
    }

    public void setMapPosition(int n, int n2) {
        this.worldX = n;
        this.worldY = n2;
    }

    public void setViewWindow(int n, int n2, int n3, int n4) {
        RM.setRect(this.viewRect, n, n2, n3, n4);
        this.bufferGridWidth = (n3 + 15 >> 4) + 1;
        this.bufferGridHeight = (n4 + 15 >> 4) + 1;
        int n5 = this.bufferGridWidth << 4;
        int n6 = this.bufferGridHeight << 4;
        if (this.og == null || n5 != this.bufferWidth || n6 != this.bufferHeight) {
            this.bufferWidth = n5;
            this.bufferHeight = n6;
            this.backbuffer = RM.createImage(this.bufferWidth, this.bufferHeight);
            this.og = this.backbuffer.getGraphics();
            this.rgbBufferHorizontal = new int[this.bufferWidth * 16];
            this.rgbBufferVertical = new int[this.bufferHeight * 16];
        }
        this.invalidate();
    }

    public void invalidate() {
        this.worldGridX = -1073741824;
        this.worldGridY = -1073741824;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2 = this.worldX;
        int n3 = this.worldY;
        int n4 = n2 >> 4;
        int n5 = n3 >> 4;
        int n6 = n2 % 16;
        if (n6 < 0) {
            n6 += 16;
        }
        if ((n = n3 % 16) < 0) {
            n += 16;
        }
        this.pixelOffsetX = n6;
        this.pixelOffsetY = n;
        if (n4 != this.worldGridX || n5 != this.worldGridY) {
            int n7;
            int n8;
            int n9;
            int n10 = n4 - this.worldGridX;
            int n11 = n10 = n10 < 0 ? -n10 : n10;
            if (n10 > this.bufferGridWidth) {
                this.worldGridX = n4 - this.bufferGridWidth;
            }
            int n12 = n9 = (n9 = n5 - this.worldGridY) < 0 ? -n9 : n9;
            if (n9 > this.bufferGridHeight) {
                this.worldGridY = n5 - this.bufferGridHeight;
            }
            if ((n8 = this.worldGridX % this.bufferGridWidth) < 0) {
                n8 += this.bufferGridWidth;
            }
            if ((n7 = this.worldGridY % this.bufferGridHeight) < 0) {
                n7 += this.bufferGridHeight;
            }
            if (this.worldGridX < n4) {
                n8 = this.updateRight(n4, n8, n7);
            } else if (this.worldGridX > n4) {
                n8 = this.updateLeft(n4, n8, n7);
            }
            if (this.worldGridY < n5) {
                this.updateBottom(n5, n8, n7);
            } else if (this.worldGridY > n5) {
                this.updateTop(n5, n8, n7);
            }
        }
        this.displayBuffer(graphics);
    }

    private int updateLeft(int n, int n2, int n3) {
        int n4;
        for (int i = this.worldGridX - n; i > 0; i -= n4) {
            int n5 = n2 == 0 ? 1 : n2;
            int n6 = n4 = i < n5 ? i : n5;
            if ((n2 -= n4) < 0) {
                n2 += this.bufferGridWidth;
            }
            this.worldGridX -= n4;
            int n7 = n2;
            int n8 = this.worldGridX;
            int n9 = n4;
            int n10 = n3;
            int n11 = this.worldGridY;
            int n12 = this.bufferGridHeight - n3;
            this.updateGrid(n7, n10, n8, n11, n9, n12);
            if (n12 >= this.bufferGridHeight) continue;
            this.updateGrid(n7, 0, n8, n11 + n12, n9, n3);
        }
        return n2;
    }

    private int updateRight(int n, int n2, int n3) {
        int n4;
        for (int i = n - this.worldGridX; i > 0; i -= n4) {
            int n5 = this.bufferGridWidth - n2;
            n4 = i < n5 ? i : n5;
            int n6 = n2;
            int n7 = this.worldGridX + this.bufferGridWidth;
            int n8 = n4;
            int n9 = n3;
            int n10 = this.worldGridY;
            int n11 = this.bufferGridHeight - n3;
            this.updateGrid(n6, n9, n7, n10, n8, n11);
            if (n11 < this.bufferGridHeight) {
                this.updateGrid(n6, 0, n7, n10 + n11, n8, n3);
            }
            if ((n2 += n4) >= this.bufferGridWidth) {
                n2 -= this.bufferGridWidth;
            }
            this.worldGridX += n4;
        }
        return n2;
    }

    private void updateTop(int n, int n2, int n3) {
        int n4;
        for (int i = this.worldGridY - n; i > 0; i -= n4) {
            int n5 = n3 == 0 ? 1 : n3;
            int n6 = n4 = i < n5 ? i : n5;
            if ((n3 -= n4) < 0) {
                n3 += this.bufferGridHeight;
            }
            this.worldGridY -= n4;
            int n7 = n3;
            int n8 = this.worldGridY;
            int n9 = n4;
            int n10 = n2;
            int n11 = this.worldGridX;
            int n12 = this.bufferGridWidth - n2;
            this.updateGrid(n10, n7, n11, n8, n12, n9);
            if (n12 >= this.bufferGridWidth) continue;
            this.updateGrid(0, n7, n11 + n12, n8, n2, n9);
        }
    }

    private void updateBottom(int n, int n2, int n3) {
        int n4;
        for (int i = n - this.worldGridY; i > 0; i -= n4) {
            int n5 = this.bufferGridHeight - n3;
            n4 = i < n5 ? i : n5;
            int n6 = n3;
            int n7 = this.worldGridY + this.bufferGridHeight;
            int n8 = n4;
            int n9 = n2;
            int n10 = this.worldGridX;
            int n11 = this.bufferGridWidth - n2;
            this.updateGrid(n9, n6, n10, n7, n11, n8);
            if (n11 < this.bufferGridWidth) {
                this.updateGrid(0, n6, n10 + n11, n7, n2, n8);
            }
            if ((n3 += n4) >= this.bufferGridHeight) {
                n3 -= this.bufferGridHeight;
            }
            this.worldGridY += n4;
        }
    }

    private void updateGrid(int n, int n2, int n3, int n4, int n5, int n6) {
        this.update(n <<= 4, n2 <<= 4, n3 <<= 4, n4 <<= 4, n5 <<= 4, n6 <<= 4);
    }

    public void fillRect(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int[] nArray = this.getRGBStrip(this.stride);
        if (nArray != null) {
            int n8 = this.stride[0];
            if (n4 < this.clipRight && n5 < this.clipBottom) {
                if (n4 < this.clipLeft) {
                    n6 += n4 - this.clipLeft;
                    n4 = this.clipLeft;
                }
                if (n5 < this.clipTop) {
                    n7 += n5 - this.clipTop;
                    n5 = this.clipTop;
                }
                int n9 = n4 + n6;
                int n10 = n5 + n7;
                if (n9 >= this.clipRight) {
                    n6 = this.clipRight - n4;
                }
                if (n10 >= this.clipBottom) {
                    n7 = this.clipBottom - n5;
                }
                if (n6 > 0 && n7 > 0) {
                    int n11 = 0xFF000000 | n << 16 | n2 << 8 | n3;
                    int n12 = (n4 -= this.clipLeft) + (n5 -= this.clipTop) * n8;
                    for (int i = 0; i < n7; ++i) {
                        int n13 = n12;
                        for (int j = 0; j < n6; ++j) {
                            nArray[n13++] = n11;
                        }
                        n12 += n8;
                    }
                }
            }
            return;
        }
        this.og.setColor(n, n2, n3);
        this.og.fillRect(n4, n5, n6, n7);
    }

    private void update(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.backgroundColor != 0) {
            this.og.setColor(this.backgroundColor);
            this.og.fillRect(n, n2, n5, n6);
        }
        this.clipLeft = n;
        this.clipTop = n2;
        this.clipRight = n + n5;
        this.clipBottom = n2 + n6;
        GCanvas.pushClip(this.og);
        if (GCanvas.clipRect(this.og, n, n2, n5, n6)) {
            int n7 = this.layers.length;
            for (int i = 0; i < n7; ++i) {
                int[] nArray;
                ILayer iLayer = this.layers[i];
                if (iLayer == null) continue;
                iLayer.update(this, n, n2, n3, n4, n5, n6);
                if (i != 0 || (nArray = this.getRGBStrip(this.stride)) == null) continue;
                MIDP20Proxy.drawImage(this.og, nArray, n, n2, 0, 0, n5, n6, this.stride[0], false);
            }
        }
        GCanvas.popClip(this.og);
    }

    private int[] getRGBStrip(int[] nArray) {
        int n = this.clipRight - this.clipLeft;
        int n2 = this.clipBottom - this.clipTop;
        if (n <= 16 && n2 <= this.bufferHeight) {
            nArray[0] = 16;
            return this.rgbBufferVertical;
        }
        if (n2 <= 16 && n <= this.bufferWidth) {
            nArray[0] = this.bufferWidth;
            return this.rgbBufferHorizontal;
        }
        return null;
    }

    private void displayBuffer(Graphics graphics) {
        int n = this.worldGridX % this.bufferGridWidth;
        if (n < 0) {
            n += this.bufferGridWidth;
        }
        int n2 = this.bufferGridWidth - n;
        int n3 = this.worldGridY % this.bufferGridHeight;
        if (n3 < 0) {
            n3 += this.bufferGridHeight;
        }
        int n4 = this.bufferGridHeight - n3;
        this.og.setColor(-1);
        GCanvas.pushClip(graphics);
        if (GCanvas.clipRect(graphics, this.viewRect)) {
            GCanvas.pushClip(graphics);
            this.blit(graphics, n, n3, 0, 0, n2, n4);
            this.blit(graphics, n, 0, 0, n4, n2, n3);
            this.blit(graphics, 0, 0, n2, n4, n, n3);
            this.blit(graphics, 0, n3, n2, 0, n, n4);
            GCanvas.popClip(graphics);
        }
        GCanvas.popClip(graphics);
    }

    private void blit(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 == 0 || n6 == 0) {
            return;
        }
        int n7 = (n3 << 4) - this.pixelOffsetX + this.viewRect[0];
        int n8 = (n4 << 4) - this.pixelOffsetY + this.viewRect[1];
        int n9 = n5 << 4;
        int n10 = n6 << 4;
        int n11 = n << 4;
        int n12 = n2 << 4;
        if (GCanvas.clipRect(n7, n8, n9, n10)) {
            graphics.drawImage(this.backbuffer, n7 - n11, n8 - n12, 20);
        }
    }
}

