/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.ICircularBuffer;
import game.ILayer;
import game.Interpolants;
import tinbrain.GCanvas;
import tinbrain.RM;

public class RaycastTerrain
implements ILayer {
    private int posX;
    private int posY;
    private byte[] heightMap;
    private int heightMapWidth;
    private int heightMapHeight;
    private byte[] textureTileMap;
    private int textureTilemapWidth;
    private int textureTilemapWidthMod;
    private int textureTilemapHeightMod;
    private int textureTileShift;
    private int textureTileMod;
    private int[] texturePalette;
    private byte[] texture;
    private int minHeight;
    private int maxHeight;
    private static final int PATCH_SHIFT_WORLD = GCanvas.log2(32);
    public static final int PATCH_SHIFT_SCREEN = GCanvas.log2(32);
    public static final int STEPS_PER_PATCH_SHIFT = PATCH_SHIFT_SCREEN - 1;
    public static final int STEPS_PER_PATCH = 1 << STEPS_PER_PATCH_SHIFT;
    private static final int[] clip = new int[4];
    private int minScreenY;
    private int maxScreenY;
    private int minWorldY;
    private int maxWorldY;
    private Interpolants interpolants = new Interpolants();

    public void update(ICircularBuffer iCircularBuffer, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n - (n3 -= this.posX);
        int n8 = n2 - (n4 -= this.posY);
        RM.setRect(clip, n3, n4, n5, n6);
        RM.intersectRect(clip, 0, 0, this.getWidth() - 32, this.getHeight() - 32);
        int n9 = clip[0];
        int n10 = clip[1];
        int n11 = clip[2];
        int n12 = clip[3];
        int n13 = (n10 + this.minHeight) * 2;
        int n14 = (n12 + this.maxHeight) * 2;
        boolean bl = false;
        int n15 = this.getHeight() - 2;
        if (n13 >= n15) {
            return;
        }
        if (n14 <= 0) {
            return;
        }
        if (n13 < 0) {
            n13 = 0;
        }
        if (n14 > n15) {
            n14 = n15;
        }
        int n16 = n2 + n6;
        block0: for (int i = n9; i < n11; i += 2) {
            this.interpolants.setupInterpolantsX(i, n13);
            int n17 = n7 + i;
            int n18 = Integer.MIN_VALUE;
            boolean bl2 = false;
            for (int j = n13; j <= n14 && n18 < n16; j += 2) {
                int n19 = this.interpolants.height;
                int n20 = n19 * 320 >> 20;
                int n21 = n8 + (j >> 1) - n20;
                if (n21 >= n2 && n18 > Integer.MIN_VALUE) {
                    int n22;
                    int n23;
                    int n24;
                    if (!bl2) {
                        this.interpolants.setupInterpolantsY();
                        bl2 = true;
                    }
                    if ((n24 = ((n23 = this.interpolants.heightLeft - n19) + (n22 = this.interpolants.heightBottom - n19) >> 10) * 5 + 250) < 140) {
                        n24 = 140;
                    }
                    this.drawTexel(iCircularBuffer, bl, i, n17, n18, j, n21, n24);
                }
                n18 = n21;
                if (!this.interpolants.stepY()) continue block0;
            }
        }
    }

    private void drawTexel(ICircularBuffer iCircularBuffer, boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n >> 1;
        int n8 = n4 >> 1;
        int n9 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n10 = n7 & this.textureTileMod;
        int n11 = n8 & this.textureTileMod;
        n7 >>= this.textureTileShift;
        n8 >>= this.textureTileShift;
        int n12 = this.textureTileMap[(n7 &= this.textureTilemapWidthMod) + (n8 &= this.textureTilemapHeightMod) * this.textureTilemapWidth] - 1;
        int n13 = n12 << (this.textureTileShift << 1);
        int n14 = n13 + n10 + (n11 << this.textureTileShift);
        n9 = this.texturePalette[this.texture[n14] & 0xFF];
        n10 = (n9 & 0xFF0000) >> 16;
        n11 = (n9 & 0xFF00) >> 8;
        n12 = n9 & 0xFF;
        n13 = n10 * n6 >> 8;
        n10 = n13 < 0 ? 0 : (n13 > 255 ? 255 : n13);
        n13 = n11 * n6 >> 8;
        n11 = n13 < 0 ? 0 : (n13 > 255 ? 255 : n13);
        n13 = n12 * n6 >> 8;
        n12 = n13 < 0 ? 0 : (n13 > 255 ? 255 : n13);
        iCircularBuffer.fillRect(n10, n11, n12, n2, n3, 2, n5 - n3);
    }

    public void setHeightMap(int n) {
        this.heightMap = RM.getBytes(n);
        this.heightMapWidth = RM.getWidth(n);
        this.heightMapHeight = RM.getHeight(n);
        this.interpolants.setMap(this.heightMap, this.heightMapWidth, this.heightMapHeight);
    }

    public void cleanUp() {
        this.interpolants.hm = null;
        this.heightMap = null;
        this.texture = null;
        this.texturePalette = null;
    }

    public void setTexture(int n, int n2) {
        this.textureTileMap = RM.getBytes(n);
        this.textureTilemapWidth = RM.getWidth(n);
        this.textureTilemapWidthMod = RM.getWidth(n) - 1;
        this.textureTilemapHeightMod = RM.getHeight(n) - 1;
        this.texture = RM.getPixels(n2);
        this.texturePalette = RM.getPaletteInt(n2);
        this.textureTileShift = GCanvas.log2(RM.getWidth(n2));
        this.textureTileMod = (1 << this.textureTileShift) - 1;
    }

    public void setScaling() {
        int n;
        int n2;
        this.minHeight = Integer.MAX_VALUE;
        this.maxHeight = Integer.MIN_VALUE;
        int n3 = this.heightMap.length;
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.heightMap[n2];
            if (n < this.minHeight) {
                this.minHeight = n;
            }
            if (n <= this.maxHeight) continue;
            this.maxHeight = n;
        }
        this.minHeight -= 4;
        this.maxHeight += 4;
        this.minHeight *= 320;
        this.minHeight >>= 10;
        this.maxHeight *= 320;
        this.maxHeight >>= 10;
        n2 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MIN_VALUE;
        int n7 = (this.heightMapHeight - 2) * this.heightMapWidth;
        for (int i = 0; i < this.heightMapWidth; ++i) {
            n = this.heightMap[i];
            if (n < n2) {
                n2 = n;
            }
            if (n > n4) {
                n4 = n;
            }
            if ((n = this.heightMap[i + n7]) > n6) {
                n6 = n;
            }
            if (n >= n5) continue;
            n5 = n;
        }
        n2 *= 320;
        n4 *= 320;
        n6 *= 320;
        n5 *= 320;
        this.minScreenY = (this.posY >> 1) - (n2 >>= 10);
        this.maxScreenY = (this.posY + (this.heightMapHeight - 2 << PATCH_SHIFT_WORLD) >> 1) - (n6 >>= 10);
        this.minWorldY = this.minScreenY + (n4 >>= 10) << 1 << 10;
        this.maxWorldY = this.maxScreenY + (n5 >>= 10) << 1 << 10;
        this.minScreenY >>= 0;
        this.maxScreenY >>= 0;
    }

    public int getMinScreenY() {
        return this.minScreenY;
    }

    public int getMaxScreenY() {
        return this.maxScreenY;
    }

    public int getMinWorldY() {
        return this.minWorldY;
    }

    public int getMaxWorldY() {
        return this.maxWorldY;
    }

    public int getHeight() {
        return this.heightMapHeight << PATCH_SHIFT_WORLD;
    }

    public int getWidth() {
        return this.heightMapWidth - 1 << PATCH_SHIFT_WORLD;
    }

    public final int getHeight(int n, int n2) {
        byte[] byArray = this.heightMap;
        int n3 = this.heightMapWidth;
        int n4 = this.heightMapHeight;
        int n5 = n >> PATCH_SHIFT_WORLD;
        int n6 = n2 >> PATCH_SHIFT_WORLD;
        int n7 = n & 0x1F;
        int n8 = n2 & 0x1F;
        if (n5 < 0) {
            n5 = 0;
            n7 = 0;
        }
        if (n5 > n3 - 2) {
            n5 = n3 - 2;
            n7 = 31;
        }
        if (n6 < 0) {
            n6 = 0;
            n8 = 0;
        }
        if (n6 > n4 - 2) {
            n6 = n4 - 2;
            n8 = 31;
        }
        int n9 = 32 - n7;
        int n10 = 32 - n8;
        int n11 = n5 + n6 * n3;
        byte by = byArray[n11];
        byte by2 = byArray[n11 + 1];
        byte by3 = byArray[n11 + 1 + n3];
        byte by4 = byArray[n11 + n3];
        int n12 = by * n9 * n10 + by2 * n7 * n10 + by4 * n9 * n8 + by3 * n7 * n8 >> 2 * PATCH_SHIFT_WORLD;
        return (n12 *= 320) >> 10;
    }
}

