/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Bee;
import game.CircularBuffer;
import game.ICircularBuffer;
import game.RandomGenerator;
import game.RaycastTerrain;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.ISound;
import tinbrain.Menu;
import tinbrain.RM;
import tinbrain.math3D.M3D;
import tinbrain.math3D.Point2D;
import tinbrain.util.GL;

public class Game {
    private static Bee playerCar;
    private static int currentViewX;
    private static int currentViewY;
    private static int targetViewX;
    private static int targetViewY;
    private static int windowX;
    private static int windowY;
    private static final int[] mapBounds;
    public static final int[] carBounds;
    private static int halfWidth;
    private static int halfHeight;
    private static ICircularBuffer backbuffer;
    private static RaycastTerrain terrain;
    private static int gameMessageText;
    private static int gameMessageTime;
    private static int gameMessageTargetY;
    private static int gameMessageY;
    private static boolean gameMessageWaitOneFrame;
    private static int frameCount;
    private static boolean waitForPlayer;
    private static int currentTrack;
    private static int currentMission;
    private static int preparedMission;
    public static int currentLocation;
    private static int sScore;
    private static final int[] hudCounterValuesNew;
    private static final int[] hudCounterValues;
    private static final int[] hudCounterFrames;
    private static int hudRedrawInfo;
    private static boolean setSoftkeysDelayed;
    private static boolean firstFrameDrawn;
    private static int gameStartCountdown;
    private static int gameFinishedCountdown;
    private static int sPlayerEnergy;
    private static int sDesiredPlayerEnergy;
    private static int sMaxEnergy;
    private static int sEnergyStart;
    private static int sEnergyDelta;
    private static int sEnergyDeltaPercentage;
    private static int sNumCombosNormal;
    private static int sNumCombosSuper;
    private static int[] HUD_FLOWER_ICON_COLORS;
    static int[] sPreparedSoundId;
    private static int[] sEndScreenZZZ;
    private static String[] sEndScreenText;
    private static int sHighscorePos;
    private static int sLastDrawnFrame;
    private static int sSteeringAngle;
    private static int ENERGY_WARNING_START_VAL;
    private static boolean sHudEnergyBarFlashOn;
    private static boolean sHudBackgroundDirty;
    private static int sHudScoreDigitWidth;
    private static int sHudScoreDigitHeight;
    private static int[] hudTabsType;
    private static int[] hudTabsY;
    private static int[] hudTabsLastRenderPos;
    private static int[] hudTabsDY;
    private static int hudTabDirty;
    private static int hudTabsWidth;
    private static int hudTabsHeight;
    private static int hudTabsLeft;
    private static int hudTabsBottom;
    private static int hudSparksIntensity;
    private static int[] hudSparks;
    private static int hudSparksNumFrames;
    private static int hudSparksNumSpawnFP;
    private static int hudSparksY;
    private static int hudSparksDY;
    private static boolean hudSparksComboAward;
    private static boolean hudSparksKillAll;
    private static int sHudScoreEffectDelta;
    private static int sHudScoreEffectTimer;
    private static int sHudScoreEffectPosY;
    private static int sHudScoreEffectVY;
    private static int sHudScoreEffectChainLength;
    private static boolean sHudScoreEffectComboIsSuper;
    private static boolean sHudScoreEffectIsCombo;
    private static byte[] sHighscoreNameCharacters;
    private static byte[] sHighscoreNameBytes;
    private static byte[] sHighscoreNameIndices;
    private static int sHighscoreNameCursorPos;
    private static boolean sHighscoreNeedsInit;
    private static boolean sHelpMenuTextIsPrepared;
    private static int sOutroTimer;
    private static int sSwitchToOutroTimer;
    private static int[][] sFlowers;
    private static short[][] sFlowerGrid;
    private static int[][] FLOWER_TYPE_ATTRIBUTES;
    private static int FLOWER_NUM_TYPES;
    private static int FLOWER_NUM_ATTRIBUTES;
    private static int[] sFlowerClosestOfType;
    private static long[] sFlowerCurrentClosestOfTypeDistSq;
    private static int sFlowerGridSquareSizeX;
    private static int sFlowerGridSquareSizeY;
    private static int sFlowerWorldMinX;
    private static int sFlowerWorldMaxX;
    private static int sFlowerWorldMinY;
    private static int sFlowerWorldMaxY;
    private static int sFlowerGridSqCountX;
    private static int sFlowerGridSqCountY;
    private static int sFlowerCountLevelFull;
    private static short sFlowersCount;
    private static int sFlowerNumTypesAvailable;
    private static boolean sFlowerFirstTimeInit;
    private static Point2D sFlowerDrawScreenExtentsX;
    private static Point2D sFlowerDrawScreenExtentsY;
    private static int[] sComboFlowersSinceLast;
    private static int[][] sComboFlowers;
    private static int sComboCount;
    private static int sComboKnown;
    private static int sComboFlowerCount;
    private static int sCombo;
    private static boolean sComboCompleted;
    private static int sComboChainLength;
    private static int sComboTimeToContinueCombo;
    private static int sComboTimeToContinueComboMax;
    private static int sComboTimeBetweenFlowers;
    private static int[][] sObstacles;
    private static short[][] sObstacleGrid;
    private static int sCandyTimer;
    private static int sCandyLifeTime;
    private static int sCandyAnimFrame;
    private static int sCandySpawnDelay;
    private static int sCandySpriteIdx;
    private static short sCandyFlowerIdx;
    private static boolean sCandyPresent;
    private static boolean sCandyHarvested;
    private static boolean sCandyFlashOn;
    private static int sCandyFlashTime;
    private static int sCandySpawnDelayMin;
    private static int sCandySpawnDelayMax;
    private static int[][] sTutorialMessagesToDisplay;
    private static int sTutorialNumMessagesToDisplay;
    private static int sDemoNumHarvestedFlowers;

    private Game() {
    }

    private static void showMessage(int n) {
        Menu.setSelectedItem(0);
        Menu.showMessage(14, n, 24, -1, false);
    }

    protected static final int getTerrainHeight(int n, int n2) {
        return terrain.getHeight(n, n2);
    }

    public static final boolean isInGame() {
        return !waitForPlayer;
    }

    private static final void calculateView(Bee bee, boolean bl) {
        int n = halfWidth << 10;
        int n2 = halfHeight << 10;
        int n3 = n >> 2;
        int n4 = n2 >> 2;
        int n5 = bee.getWorldPositionOldX();
        int n6 = (bee.getWorldPositionOldY() >> 1) - bee.getWorldPositionOldZ();
        int n7 = 0;
        int n8 = 0;
        if (bee.isOrbitting()) {
            n7 = bee.getOrbittingCenterX();
            n8 = bee.getOrbittingCenterY() >> 1;
        } else {
            n7 = bee.getWorldPositionX();
            n8 = (bee.getWorldPositionY() >> 1) - bee.getWorldPositionZ();
            n7 -= bee.getVelocityVector().x << 1;
            n8 += bee.getVelocityVector().y;
        }
        int n9 = ((n7 >>= 0) - (n5 >>= 0) << 10) / 146 << 2;
        int n10 = ((n8 >>= 0) - (n6 >>= 0) << 10) / 146 << 2;
        int n11 = n7;
        int n12 = n8;
        targetViewX = n11 - n;
        targetViewY = n12 - n2;
        n9 = GCanvas.clamp(n9, -n3, n3);
        n10 = GCanvas.clamp(n10, -n4, n4);
        int n13 = (targetViewX += n9) - currentViewX;
        int n14 = (targetViewY += n10) - currentViewY;
        if (bl) {
            currentViewX += n13 * 146 >> 10;
            currentViewY += n14 * 146 >> 10;
        } else {
            currentViewX += n13;
            currentViewY += n14;
        }
    }

    public static final void onDraw(Graphics graphics) {
        int n;
        if (GCanvas.getGlobalFrameCount() - sLastDrawnFrame > 1) {
            sHudBackgroundDirty = true;
            hudTabDirty = -1;
        }
        sLastDrawnFrame = GCanvas.getGlobalFrameCount();
        int n2 = GCanvas.getWidth();
        int n3 = GCanvas.getHeight();
        graphics.setClip(0, 0, n2, n3);
        windowX = currentViewX >> 10;
        windowY = currentViewY >> 10;
        if (windowX < mapBounds[0]) {
            windowX = mapBounds[0];
        }
        if (windowX + n2 > mapBounds[2]) {
            windowX = mapBounds[2] - n2;
        }
        if (windowY < mapBounds[1]) {
            windowY = mapBounds[1];
        }
        if (windowY + n3 > mapBounds[3]) {
            windowY = mapBounds[3] - n3;
        }
        backbuffer.setMapPosition(windowX, windowY);
        backbuffer.paint(graphics);
        graphics.translate(-windowX, -windowY);
        playerCar.castShadow(graphics);
        Game.flowerDrawAll(graphics);
        Game.hudDrawFlowerFocus();
        if (RM.intersects(playerCar.getEstimatedScreenBounds(), windowX, windowY, GCanvas.getWidth(), GCanvas.getHeight())) {
            playerCar.onDraw(graphics);
        }
        graphics.translate(windowX, windowY);
        if (--gameMessageTime > 0) {
            n = gameMessageTargetY - gameMessageY >> 2;
            gameMessageY += n;
            if (gameMessageTime <= 30 && gameMessageTargetY > 0) {
                gameMessageTargetY = -GCanvas.FONT_SMALL_HEIGHT << 1;
            }
            Menu.drawMenuItem(graphics, GCanvas.FONT_SMALL, -16777216, RM.t(gameMessageText), halfWidth + 1, gameMessageY + 1, 17);
            Menu.drawMenuItem(graphics, GCanvas.FONT_SMALL, -6226166, RM.t(gameMessageText), halfWidth, gameMessageY, 17);
        }
        graphics.setClip(0, 0, GCanvas.getWidth(), GCanvas.getHeight());
        Game.drawHud(graphics, playerCar);
        if (GCanvas.cheatEnabled(8)) {
            n = playerCar.getWorldPositionX() >> 10;
            int n4 = playerCar.getWorldPositionY() >> 10;
            String string = n + ", " + n4;
            int n5 = RM.getStringWidth(string, GCanvas.FONT_SMALL) + 2;
            graphics.setFont(GCanvas.FONT_SMALL);
            graphics.setColor(0);
            graphics.fillRect(0, 0, n5, GCanvas.FONT_SMALL_HEIGHT);
            graphics.setColor(-1);
            graphics.drawString(string, 1, 0, 0);
        }
        if (GCanvas.cheatEnabled(3)) {
            graphics.setFont(GCanvas.FONT_SMALL);
            graphics.setColor(0);
            n = RM.getStringWidth("Hands-On_20071008", GCanvas.FONT_SMALL) + 2;
            graphics.fillRect(0, 0, n, GCanvas.FONT_SMALL_HEIGHT);
            graphics.setColor(-1);
            graphics.drawString("Hands-On_20071008", 1, 0, 0);
        }
        firstFrameDrawn = true;
    }

    private static final void setHudDirty(int n) {
        hudRedrawInfo |= n;
    }

    public static int getWorldXToScreenXShift() {
        return 10;
    }

    public static int getScreenXFromWorldPosX(int n) {
        return n >>= Game.getWorldXToScreenXShift();
    }

    private static void getScreenExtentsX(Point2D point2D) {
        point2D.x = 0;
        point2D.x = windowX;
        point2D.y = point2D.x + GCanvas.getWidth();
    }

    private static void getScreenExtentsY(Point2D point2D) {
        point2D.x = 0;
        point2D.x = windowY;
        point2D.y = point2D.x + GCanvas.getHeight();
    }

    public static int getScreenYFromWorldYAndTerrainHeight(int n, int n2) {
        n >>= 10;
        n = (n >> 1) - n2 >> 0;
        return n;
    }

    public static int getScreenYFromWorldPos(int n, int n2) {
        int n3 = Game.getTerrainHeight(n, n2);
        n2 >>= 10;
        n2 = (n2 >> 1) - n3 >> 0;
        return n2;
    }

    private static boolean cullOrDrawSpriteOnGround(Graphics graphics, int n, int n2, int n3, int n4) {
        return Game.cullOrDrawSpriteOnGround(graphics, n, n2, n3, n4, 0, 0);
    }

    private static boolean cullOrDrawSpriteOnGround(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = GCanvas.getSpriteFrames(n) - 1;
        if (n2 > n7) {
            n2 = n7;
        }
        int n8 = Game.getTerrainHeight(n3, n4);
        int n9 = n3 >> 10;
        int n10 = n4 >> 10;
        int n11 = n9 >> 0;
        int n12 = (n10 >> 1) - n8 >> 0;
        return Game.cullOrDrawSprite(graphics, n, n11, n12, n5, n6, n2);
    }

    private static boolean overlapsRange(int n, int n2, Point2D point2D) {
        return n < point2D.y && n2 > point2D.x;
    }

    private static boolean rectIsOnScreen(int n, int n2, int n3, int n4) {
        return Game.overlapsRange(n, n2, sFlowerDrawScreenExtentsX) && Game.overlapsRange(n3, n4, sFlowerDrawScreenExtentsY);
    }

    private static boolean cullOrDrawSprite(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        boolean bl;
        int n9;
        int n10;
        int n11 = n10 = n2 + n4;
        int n12 = n9 = n3 + n5;
        boolean bl2 = bl = n == 5 || n == 8 || n == 9 || n == 6 || n == 7;
        if (bl) {
            // empty if block
        }
        if (Game.rectIsOnScreen(n10 -= (n8 = GCanvas.getSpriteWidth(n)) >> 1, n11 += n8 >> 1, n9, n12 += (n7 = GCanvas.getSpriteHeight(n)))) {
            GCanvas.drawSprite(n, n2, n3, n6);
            return true;
        }
        return false;
    }

    private static final void hudDrawClosestFlowersIcons(Graphics graphics) {
        Point2D point2D = M3D.locPoint2D();
        Point2D point2D2 = M3D.locPoint2D();
        int n = windowX + 5;
        int n2 = windowY + 5;
        int n3 = windowX + GCanvas.getWidth() - 5;
        int n4 = windowY + GCanvas.getHeight() - 5;
        int n5 = windowX + (GCanvas.getWidth() >> 1) << 10;
        int n6 = windowY + (GCanvas.getHeight() >> 1) << 10;
        int n7 = n << 10;
        int n8 = n2 << 10;
        int n9 = n3 << 10;
        int n10 = n4 << 10;
        for (int i = 0; i < FLOWER_NUM_TYPES; ++i) {
            int n11;
            int n12;
            int n13;
            int n14 = Game.flowerQueryClosestOfType(i);
            if (n14 == -1) continue;
            point2D.set(Game.flowerGetWorldPosX(n14), Game.flowerGetWorldPosY(n14));
            int n15 = Game.getScreenXFromWorldPosX(point2D.x);
            int n16 = Game.getScreenYFromWorldPos(point2D.x, point2D.y);
            if (n15 >= n && n15 <= n3 && n16 >= n2 && n16 <= n4) continue;
            point2D.set(n15 << 10, n16 << 10);
            point2D2.set(n5, n6);
            point2D2.sub(point2D);
            if (Math.abs(point2D2.x) > 600000 || Math.abs(point2D2.y) > 600000) {
                point2D2.shiftR(1);
                point2D.set(n5, n6);
                point2D.sub(point2D2);
            }
            if (Math.abs(point2D2.x) >= 1000000 || Math.abs(point2D2.y) >= 1000000) continue;
            int n17 = 0;
            if (point2D.x < n7) {
                n13 = n7 - point2D.x;
                n12 = n5 - point2D.x;
                if (n12 != 0) {
                    n11 = (int)((long)n13 << 10) / n12;
                    point2D.addScaled(point2D2, n11);
                    n17 |= 1;
                }
            }
            if (point2D.y < n8) {
                n13 = n8 - point2D.y;
                n12 = n6 - point2D.y;
                if (n12 != 0) {
                    n11 = (int)((long)n13 << 10) / n12;
                    point2D.addScaled(point2D2, n11);
                    n17 |= 8;
                }
            }
            if (point2D.x > n9) {
                n13 = point2D.x - n9;
                n12 = point2D.x - n5;
                if (n12 != 0) {
                    n11 = (int)((long)n13 << 10) / n12;
                    point2D.addScaled(point2D2, n11);
                    n17 |= 2;
                }
            }
            if (point2D.y > n10) {
                n13 = point2D.y - n10;
                n12 = point2D.y - n6;
                if (n12 != 0) {
                    n11 = (int)((long)n13 << 10) / n12;
                    point2D.addScaled(point2D2, n11);
                    n17 |= 4;
                }
            }
            if ((n17 & 1) > 0) {
                point2D.x = n7;
            }
            if ((n17 & 2) > 0) {
                point2D.x = n9;
            }
            if ((n17 & 8) > 0) {
                point2D.y = n8;
            }
            if ((n17 & 4) > 0) {
                point2D.y = n10;
            }
            n13 = point2D.x >> 10;
            n12 = point2D.y >> 10;
            GCanvas.drawSprite(graphics, 18, n13 -= windowX, n12 -= windowY, RM.getValue(59, i, 3));
        }
        M3D.locFree(point2D2);
        M3D.locFree(point2D);
    }

    private static final void hudDrawFlowerFocus() {
        int n = -1;
        Bee bee = playerCar;
        n = bee.isOrbitting() ? bee.getPollinationTarget() : Game.flowerQueryClosestOnOrOffScreen(playerCar.getWorldPositionX(), playerCar.getWorldPositionY(), true);
        Point2D point2D = Point2D.tmp0;
        Game.flowerCalcScreenPos(n, point2D);
        GCanvas.drawSprite(26, point2D.x, point2D.y - GCanvas.getSpriteHeight(26) / 6, 0);
    }

    private static final void hudDrawEnergyBar(Graphics graphics) {
        int n;
        int n2 = GCanvas.getSpriteWidth(27);
        int n3 = GCanvas.getHeight();
        sHudBackgroundDirty = false;
        GCanvas.drawSprite(27, GCanvas.getWidth() - n2 >> 1, n3 -= 8, 0);
        n2 = GCanvas.getSpriteWidth(28);
        n3 = GCanvas.getSpriteHeight(28);
        int n4 = n2;
        int n5 = GCanvas.getHeight() - 8 - 2;
        int n6 = n4 * sDesiredPlayerEnergy >> 10;
        int n7 = GCanvas.getWidth() - n4 >> 1;
        GCanvas.pushClip(graphics);
        GCanvas.setClip(graphics, n7, n5 - n3, n6, n3);
        GCanvas.drawSprite(29, n7, n5, 0);
        GCanvas.popClip();
        int n8 = GCanvas.getGlobalFrameCount();
        if (sPlayerEnergy < ENERGY_WARNING_START_VAL) {
            int n9 = n = sPlayerEnergy < ENERGY_WARNING_START_VAL >> 1 ? 2 : 4;
            if (n8 % n == 0) {
                sHudEnergyBarFlashOn = !sHudEnergyBarFlashOn;
            }
        } else {
            sHudEnergyBarFlashOn = true;
        }
        if (sHudEnergyBarFlashOn) {
            n = n4 * sPlayerEnergy >> 10;
            GCanvas.pushClip(graphics);
            GCanvas.setClip(graphics, n7, n5 - n3, n, n3);
            GCanvas.drawSprite(28, n7, n5, 0);
            GCanvas.popClip();
        }
    }

    private static final void hudDrawScore(Graphics graphics) {
        int n = 0;
        int n2 = RM.getHeight(28);
        for (int i = 0; i < n2; ++i) {
            if (i != 3) continue;
            int n3 = RM.getValue(28, i, 4);
            int n4 = i == 3 ? GCanvas.getWidth() - sHudScoreDigitWidth * n3 >> 1 : RM.getValue(28, i, 0);
            int n5 = RM.getValue(28, i, 1);
            n = RM.getValue(28, i, 3);
            for (int j = 0; j < n3; ++j) {
                int n6 = hudCounterFrames[n++];
                GCanvas.drawSprite(16, n4, n5, n6);
                n4 += sHudScoreDigitWidth;
            }
        }
    }

    private static final void hudInit() {
        sHudBackgroundDirty = true;
        sHudScoreDigitWidth = GCanvas.getSpriteWidth(16) + 1;
        sHudScoreDigitHeight = GCanvas.getSpriteHeight(16) + 1;
        Game.hudTabsInit();
        Game.hudSparksInit();
        sEndScreenZZZ = new int[10];
        sEndScreenText = new String[3];
    }

    private static final void hudTabsUp(int n) {
        Game.hudTabsDY[n] = -4;
    }

    private static final void hudTabsDown(int n) {
        Game.hudTabsDY[n] = 4;
    }

    private static final void hudTabsAllDown() {
        for (int i = 0; i < 4; ++i) {
            Game.hudTabsDown(i);
        }
    }

    private static final void hudTabsReset() {
        if (hudTabsType != null) {
            for (int i = 0; i < 4; ++i) {
                Game.hudTabsType[i] = 0;
                Game.hudTabsY[i] = hudTabsHeight - 3;
                Game.hudTabsDY[i] = 4;
                hudTabDirty |= 1 << i;
            }
        }
    }

    private static final void hudTabsInit() {
        hudTabsWidth = GCanvas.getSpriteWidth(14);
        hudTabsHeight = GCanvas.getSpriteHeight(14);
        hudTabsLeft = GCanvas.getWidth() - 4 * hudTabsWidth >> 1;
        hudTabsBottom = GCanvas.getHeight() - 8 - 21;
        hudTabsType = new int[4];
        hudTabsY = new int[4];
        hudTabsDY = new int[4];
        Game.hudTabsReset();
    }

    private static final void hudTabsSetPosYFromComboPercentage() {
        int n = (sComboTimeToContinueCombo << 10) / sComboTimeToContinueComboMax;
        for (int i = 0; i < 4; ++i) {
            int n2;
            int n3 = hudTabsHeight - 3;
            int n4 = hudTabsY[i] - n3;
            Game.hudTabsY[i] = n2 = (n4 * n >> 10) + n3;
        }
    }

    private static final void hudDrawTabs(Graphics graphics, Bee bee) {
        int n;
        int n2 = 0;
        for (n = 0; n < 4; ++n) {
            n2 = hudTabsY[n];
            int n3 = n;
            hudTabsY[n3] = hudTabsY[n3] + hudTabsDY[n];
            Game.hudTabsY[n] = GCanvas.clamp(hudTabsY[n], 0, hudTabsHeight - 3);
        }
        n = hudTabsLeft;
        int n4 = hudTabsBottom;
        int n5 = 1024;
        if (sComboTimeToContinueCombo > 0) {
            n5 = (sComboTimeToContinueCombo << 10) / sComboTimeToContinueComboMax;
        }
        GCanvas.pushClip(graphics);
        GCanvas.setClip(graphics, 0, n4 - hudTabsHeight, GCanvas.getWidth(), hudTabsHeight);
        graphics.setColor(0x214242);
        for (int i = 0; i < 4; ++i) {
            int n6 = hudTabsHeight - 3;
            int n7 = hudTabsY[i] - n6;
            int n8 = (n7 * n5 >> 10) + n6;
            GCanvas.drawSprite(14, n, n4 + n8, RM.getValue(59, hudTabsType[i], 3));
            n += hudTabsWidth;
        }
        GCanvas.popClip();
    }

    private static final void hudSparksInit() {
        hudSparks = new int[800];
        for (int i = 0; i < 200; ++i) {
            Game.hudSparks[i * 4 + 2] = -1;
        }
        hudSparksNumFrames = GCanvas.getSpriteFrames(15);
    }

    private static final void hudSparksStartDrop() {
        if (hudSparksDY == 0) {
            hudSparksY = 0;
            hudSparksDY = 2;
        }
    }

    private static final void hudSparksAdd(int n, int n2, int n3, int n4) {
        int n5 = Game.hudSparksFindEmptyOffset();
        if (n5 != -1) {
            Game.hudSparksSet(n5, n, n2, n3, n4);
        }
    }

    private static final void hudSparksAdd() {
        int n = Game.hudSparksFindEmptyOffset();
        if (n != -1) {
            int n2 = hudTabsBottom - hudTabsHeight - 4;
            int n3 = hudTabsBottom + 4;
            int n4 = hudTabsLeft - 4;
            int n5 = hudTabsLeft + Game.comboGetFlowerCount() * hudTabsWidth + 4;
            Game.hudSparksSet(n, n4, n5, n2, n3);
        }
    }

    private static final int hudSparksFindEmptyOffset() {
        if (hudSparksKillAll) {
            return -1;
        }
        int n = 0;
        for (int i = 0; i < 200; ++i) {
            if (hudSparks[n + 2] == -1) {
                return n;
            }
            n += 4;
        }
        return -1;
    }

    private static final void hudSparksSet(int n, int n2, int n3, int n4, int n5) {
        Game.hudSparks[n + 0] = GCanvas.getRandom(n2, n3);
        Game.hudSparks[n + 1] = GCanvas.getRandom(n4, n5);
        Game.hudSparks[n + 2] = 0;
        Game.hudSparks[n + 3] = 1;
    }

    private static final void hudDrawSparks(Graphics graphics, Bee bee) {
        int n;
        if (hudSparksComboAward) {
            for (n = 0; n < 3; ++n) {
                Game.hudSparksAdd();
            }
            if ((hudSparksY += hudSparksDY) > hudTabsHeight) {
                hudSparksY = hudTabsHeight;
                hudSparksDY = 0;
                hudSparksComboAward = false;
                hudSparksKillAll = true;
            }
        } else if (Game.comboGetFlowerCount() > 1 && Game.comboGetFlowerCount() < 4) {
            hudSparksNumSpawnFP += hudSparksIntensity * 20;
            while (hudSparksNumSpawnFP > 1024) {
                hudSparksNumSpawnFP -= 1024;
                Game.hudSparksAdd();
            }
        }
        if (hudSparks == null) {
            return;
        }
        n = 0;
        int n2 = 0;
        for (int i = 0; i < 200; ++i) {
            if (hudSparks[n + 2] != -1) {
                ++n2;
                GCanvas.drawSprite(15, hudSparks[n + 0], hudSparks[n + 1] + hudSparksY, hudSparks[n + 2]);
                int n3 = n + 2;
                hudSparks[n3] = hudSparks[n3] + hudSparks[n + 3];
                if (hudSparks[n + 2] >= hudSparksNumFrames) {
                    Game.hudSparks[n + 2] = hudSparksNumFrames - 1;
                    Game.hudSparks[n + 3] = -1;
                }
            }
            n += 4;
        }
        if (hudSparksKillAll && n2 == 0) {
            hudSparksKillAll = false;
            hudSparksY = 0;
            hudSparksDY = 0;
        }
    }

    private static final void hudScoreEffectStart(int n) {
        GCanvas.dbgLog("SCORE_EFFECT started with scoreDelta " + n);
        sHudScoreEffectDelta = n;
        sHudScoreEffectTimer = 20;
        if (sComboChainLength == 6) {
            sHudScoreEffectTimer += 20;
        }
        sHudScoreEffectPosY = GCanvas.getHeight() - 8 - 21 - hudTabsHeight - 3 - sHudScoreDigitHeight;
        sHudScoreEffectVY = 0;
        sHudScoreEffectIsCombo = Game.comboGetFlowerCount() == 4;
        sHudScoreEffectChainLength = sComboChainLength;
        sHudScoreEffectComboIsSuper = sComboChainLength == 6;
    }

    private static final void hudDrawScoreEffect(Graphics graphics) {
        if (sHudScoreEffectDelta != 0) {
            int n;
            int n2;
            if (sHudScoreEffectTimer > 0) {
                if (--sHudScoreEffectTimer == 0) {
                    Game.hudSparksStartDrop();
                }
            } else if ((sHudScoreEffectPosY -= (sHudScoreEffectVY += 2)) <= RM.getValue(28, 3, 1)) {
                sHudScoreEffectDelta = 0;
                return;
            }
            int n3 = 0;
            n3 = sHudScoreEffectIsCombo ? GCanvas.getSpriteWidth(23) + 2 : 0;
            int n4 = 0;
            int n5 = sHudScoreEffectDelta;
            int n6 = 1;
            int n7 = 10;
            while (n7 - 1 < n5) {
                n7 *= 10;
                ++n6;
            }
            if (sHudScoreEffectIsCombo && sHudScoreEffectChainLength > 1) {
                n6 += 2;
            }
            n4 = GCanvas.getWidth() + n6 * sHudScoreDigitWidth + n3 >> 1;
            if (sHudScoreEffectIsCombo && sHudScoreEffectChainLength > 1) {
                if (sHudScoreEffectComboIsSuper && (GCanvas.getGlobalFrameCount() >> 3 & 1) != 0) {
                    n2 = n4 - 2 * sHudScoreDigitWidth + (2 * sHudScoreDigitWidth - GCanvas.getSpriteWidth(17) >> 1);
                    n = sHudScoreEffectPosY + (sHudScoreDigitHeight - GCanvas.getSpriteHeight(17) >> 1);
                    GCanvas.drawSprite(17, n2, n, 0);
                    n4 -= 2 * sHudScoreDigitWidth;
                } else {
                    GCanvas.drawSprite(16, n4 -= sHudScoreDigitWidth, sHudScoreEffectPosY, sHudScoreEffectChainLength);
                    GCanvas.drawSprite(16, n4 -= sHudScoreDigitWidth, sHudScoreEffectPosY, 10);
                }
                n6 -= 2;
            }
            n2 = 0;
            n5 = sHudScoreEffectDelta;
            for (n = 0; n < n6; ++n) {
                n2 = n5 % 10;
                n5 /= 10;
                GCanvas.drawSprite(16, n4 -= sHudScoreDigitWidth, sHudScoreEffectPosY, n2);
            }
            if (sHudScoreEffectIsCombo) {
                n5 = sHudScoreEffectComboIsSuper ? 24 : 23;
                GCanvas.drawSprite(n5, n4 -= GCanvas.getSpriteWidth(23) + 2, sHudScoreEffectPosY - (GCanvas.getSpriteHeight(23) - sHudScoreDigitHeight >> 1), 0);
                if (sHudScoreEffectPosY > GCanvas.getHeight() >> 1) {
                    sHudBackgroundDirty = true;
                    hudTabDirty = -1;
                }
            }
        }
    }

    private static final void hudDrawComboPreview(Graphics graphics) {
        if (Game.comboGetFlowerCount() > 0 && Game.comboGetFlowerCount() < 4) {
            int n = GCanvas.getSpriteWidth(18) + 1;
            int n2 = GCanvas.getSpriteHeight(18) + 1;
            int n3 = 0;
            n3 = hudTabsBottom - hudTabsHeight - 2;
            for (int i = 0; i < 19; ++i) {
                int n4;
                int n5;
                boolean bl = true;
                for (n5 = 0; n5 < Game.comboGetFlowerCount(); ++n5) {
                    n4 = RM.getValue(60, i, n5);
                    if (n4 == Game.comboGetFlower(n5)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                n5 = hudTabsLeft;
                for (n4 = 0; n4 < 4; ++n4) {
                    GCanvas.drawSprite(graphics, 18, n5, n3, RM.getValue(59, RM.getValue(60, i, n4), 3));
                    n5 += n;
                }
                n3 -= n2;
            }
        }
    }

    private static final void hudDrawSoftkeyLabels(Graphics graphics) {
        int n = GCanvas.getSpriteWidth(3);
        int n2 = GCanvas.getSpriteHeight(3);
        GCanvas.drawSprite(3, GCanvas.getWidth() - n, GCanvas.getHeight() - n2, 0);
    }

    private static final void drawHud(Graphics graphics, Bee bee) {
        Game.hudDrawEnergyBar(graphics);
        Game.hudDrawTabs(graphics, bee);
        Game.hudDrawSparks(graphics, bee);
        Game.updateHudCounter(playerCar);
        Game.hudDrawScore(graphics);
        Game.hudDrawScoreEffect(graphics);
        Game.hudDrawComboPreview(graphics);
        Game.hudDrawSoftkeyLabels(graphics);
        Game.hudDrawClosestFlowersIcons(graphics);
    }

    private static final void doStart() {
        waitForPlayer = false;
        Game.sfxPlayLogicSound(0);
        Game.showGameMessage(105);
    }

    public static final void menuOnInput() {
        if (Menu.getCurrentMenu() == 1) {
            Game.highscoreNameUpdate();
        }
    }

    public static final void onInput() {
        Game.tutorialUpdate();
        if (gameFinishedCountdown >= 0) {
            if (gameFinishedCountdown == 0) {
                Game.onGameFinish();
            }
            --gameFinishedCountdown;
            return;
        }
        if (setSoftkeysDelayed && firstFrameDrawn) {
            setSoftkeysDelayed = false;
        }
        if (gameStartCountdown >= 0) {
            if (gameStartCountdown == 0) {
                Game.doStart();
            }
            --gameStartCountdown;
        }
        if (waitForPlayer) {
            return;
        }
        if (GCanvas.cheatEnabled(4) || GCanvas.cheatEnabled(7)) {
            Game.playerFinished();
            return;
        }
        if (GCanvas.cheatEnabled(1)) {
            playerCar.setScore(50000);
            Game.playerFinished();
            return;
        }
        ++frameCount;
        Bee bee = playerCar;
        int n = 0;
        int n2 = 0;
        bee.setFirePressed(GCanvas.isFIRE());
        boolean bl = false;
        boolean bl2 = false;
        if (GCanvas.isUP()) {
            bl = true;
            bl2 = true;
            n2 = 1;
        } else if (GCanvas.isDOWN()) {
            bl2 = true;
            bl = true;
            n2 = -1;
        }
        if (GCanvas.isLEFT()) {
            bl2 = true;
            bl = true;
            sSteeringAngle -= 50;
            n = -1;
        } else if (GCanvas.isRIGHT()) {
            bl2 = true;
            bl = true;
            sSteeringAngle += 50;
            n = 1;
        }
        if (GCanvas.isUPRIGHT()) {
            bl2 = true;
            bl = true;
            sSteeringAngle += 50;
            n2 = 1;
            n = 1;
        }
        if (GCanvas.isUPLEFT()) {
            bl2 = true;
            bl = true;
            sSteeringAngle -= 50;
            n2 = 1;
            n = -1;
        }
        if (GCanvas.isDOWNRIGHT()) {
            bl2 = true;
            bl = true;
            sSteeringAngle += 50;
            n2 = -1;
            n = 1;
        }
        if (GCanvas.isDOWNLEFT()) {
            bl2 = true;
            bl = true;
            sSteeringAngle -= 50;
            n2 = -1;
            n = -1;
        }
        Game.updateEnergy(bl);
        if (bl2) {
            // empty if block
        }
        bee.steer(n, n2);
        Game.doGameLogic();
        if (sPlayerEnergy < 0) {
            Game.playerFinished();
        }
    }

    private static final void updateEnergy(boolean bl) {
        if ((sEnergyDelta += 1024 + (4096 * sEnergyDeltaPercentage >> 10)) >= 1024) {
            sDesiredPlayerEnergy -= sEnergyDelta >> 10;
            if (bl) {
                sDesiredPlayerEnergy -= 2;
            }
            sEnergyDelta &= 0x3FF;
        }
        if (GCanvas.cheatEnabled(2)) {
            sDesiredPlayerEnergy = 1024;
        }
    }

    private static final void doGameLogic() {
        playerCar.step();
        playerCar.satisfy(false);
        playerCar.postStep(frameCount);
        Game.flowerUpdate(playerCar);
        Game.candyUpdate();
        Game.comboUpdateTimers();
        Game.calculateView(playerCar, true);
    }

    private static final void playerFinished() {
        gameFinishedCountdown = 30;
        Game.showGameMessage(106);
    }

    private static final void onGameFinish() {
        Game.highscorePrepare();
        if (sNumCombosNormal == 0 && sNumCombosSuper == 0 && Game.tutorialAllMessagesDisplayed()) {
            Menu.changeMenu(8, false);
        } else {
            Menu.changeMenu(4, false);
        }
    }

    private static final void updateHudCounter(Bee bee) {
        int n;
        if (sScore < bee.getScore() && sHudScoreEffectDelta == 0) {
            n = GL.mathMax(1, bee.getScore() - sScore >> 3);
            sScore += n;
        }
        Game.hudCounterValuesNew[3] = sScore;
        int n2 = 0;
        for (int i = 0; i < 7; ++i) {
            int n3 = RM.getValue(28, i, 4);
            n = hudCounterValuesNew[i];
            if (n != hudCounterValues[i]) {
                Game.hudCounterValues[i] = n;
                Game.setHudDirty(RM.getValue(28, i, 2));
                int n4 = RM.getValue(28, i, 5);
                n = n < n4 ? n : n4;
                int n5 = (n4 + 1) / 10;
                int n6 = n2;
                for (int j = 0; j < n3; ++j) {
                    int n7 = n / n5;
                    n -= n7 * n5;
                    n5 /= 10;
                    Game.hudCounterFrames[n6++] = n7;
                }
            }
            n2 += n3;
        }
    }

    public static final void init() {
        M3D.locInit();
        GL.guiInit();
        Game.initBackbuffer(GCanvas.getWidth(), GCanvas.getHeight());
        terrain = new RaycastTerrain();
        backbuffer.setLayer(0, terrain);
        playerCar = new Bee();
        Game.hudInit();
    }

    public static final void screenSizeChanged() {
        if (backbuffer != null) {
            backbuffer.setViewWindow(0, 0, GCanvas.getWidth(), GCanvas.getHeight());
        }
        halfWidth = GCanvas.getWidth() >> 1;
        halfHeight = GCanvas.getHeight() >> 1;
    }

    public static final void initGame(boolean bl) {
        if (bl) {
            Menu.startLoading(98);
        }
        currentMission = preparedMission;
        currentTrack = RM.getValue(55, currentMission, 1);
        currentLocation = RM.getValue(54, currentTrack, 0);
        int n = RM.getValue(54, currentTrack, 1);
        int n2 = RM.getValue(54, currentTrack, 3);
        int n3 = RM.getValue(53, currentLocation, 0);
        terrain.cleanUp();
        terrain.setHeightMap(n);
        RM.forget(n);
        terrain.setTexture(n2, n3);
        terrain.setScaling();
        int n4 = terrain.getMinWorldY();
        int n5 = terrain.getMaxWorldY();
        int n6 = terrain.getWidth() - 32 << 10;
        RM.setRect(carBounds, 0, n4, n6, n5);
        int n7 = terrain.getMinScreenY();
        int n8 = terrain.getMaxScreenY();
        RM.setRect(mapBounds, 0, n7, n6 >> Game.getWorldXToScreenXShift(), n8 - n7);
        System.gc();
        Thread.yield();
        carBounds[0] = carBounds[0] + 20000;
        carBounds[2] = carBounds[2] - 20000;
        carBounds[1] = carBounds[1] + 40000;
        carBounds[3] = carBounds[3] - 40000;
        Game.restart(false);
        if (bl) {
            Menu.stopLoading();
        }
    }

    private static final void showGameMessage(int n) {
        gameMessageText = n;
        gameMessageTime = 30;
        gameMessageTargetY = halfHeight - (halfHeight >> 1);
        gameMessageTime <<= 1;
        gameMessageY = -GCanvas.FONT_SMALL_HEIGHT << 1;
    }

    public static final void restart(boolean bl) {
        if (bl) {
            Menu.startLoading(98);
        }
        gameStartCountdown = 0;
        gameFinishedCountdown = -1;
        waitForPlayer = true;
        gameMessageTime = -1;
        Game.flowerInitAll();
        playerCar.reset();
        playerCar.initSystem();
        Game.calculateView(playerCar, false);
        backbuffer.invalidate();
        frameCount = 0;
        firstFrameDrawn = false;
        for (int i = 0; i < hudCounterValues.length; ++i) {
            Game.hudCounterValues[i] = -1;
        }
        Game.setHudDirty(65535);
        if (bl) {
            Menu.stopLoading();
        }
        Game.comboInit();
        Game.candyInit();
        Game.tutorialInit();
        sPlayerEnergy = sEnergyStart = sMaxEnergy;
        sDesiredPlayerEnergy = sEnergyStart;
        sEnergyDeltaPercentage = 0;
        sEnergyDelta = 0;
        Game.hudTabsReset();
        sScore = 0;
        sComboChainLength = 0;
        sComboTimeToContinueCombo = 0;
        sComboTimeToContinueComboMax = 300;
        sComboTimeBetweenFlowers = 300;
        sNumCombosNormal = 0;
        sNumCombosSuper = 0;
    }

    public static final void notify(boolean bl) {
        if (bl) {
            // empty if block
        }
        Game.setHudDirty(65535);
    }

    public static final void setOptionDefaults() {
        Game.highscoreSetDefault();
    }

    public static final void performMenuAction(int n, int n2) {
        switch (n) {
            case 44: {
                Game.prepareMission(n2);
                Menu.performMenuAction(7);
                break;
            }
            case 62: {
                Game.prepareMission(0);
                Menu.performMenuAction(7);
                break;
            }
            case 63: {
                Menu.performMenuAction(4);
                break;
            }
            case 9: {
                if (preparedMission != currentMission) {
                    Game.prepareMission(currentMission);
                }
            }
            case 8: {
                Menu.performMenuAction(7);
                break;
            }
            case 65: {
                Menu.setOption(5, 0);
                Game.prepareOptionsScreen();
                Menu.saveOptions();
                Menu.changeMenu(4, false);
                break;
            }
            case 66: {
                Menu.changeMenu(4, false);
                break;
            }
            case 64: {
                Menu.setOption(5, Game.tutorialAllMessagesDisplayed() ? 0 : -1);
                Game.prepareOptionsScreen();
                Menu.refreshMenu();
                Menu.saveOptions();
                break;
            }
            case 67: {
                Menu.changeMenu(17, false);
                break;
            }
            case 68: {
                Menu.setOption(17 + sHighscorePos, Game.highscoreNameToInt(RM.t(13)));
                Menu.setOption(6, sHighscorePos);
                Menu.saveOptions();
                Menu.changeMenu(3, false);
                break;
            }
            case 18: {
                if (GL.handsonDemoIsActive()) {
                    Menu.changeMenu(26, false);
                    break;
                }
                Menu.changeMenu(17, false);
                break;
            }
            case 17: {
                if (GL.handsonDemoIsActive()) {
                    Menu.changeMenu(26, false);
                    break;
                }
                Menu.performMenuAction(16);
                break;
            }
        }
    }

    private static final void highscoreNameUpdate() {
        boolean bl = false;
        if (GCanvas.consumeRIGHT()) {
            ++sHighscoreNameCursorPos;
            bl = true;
        } else if (GCanvas.consumeLEFT()) {
            --sHighscoreNameCursorPos;
            bl = true;
        }
        sHighscoreNameCursorPos = GL.mathModWrap(sHighscoreNameCursorPos, 0, 3);
        if (GCanvas.consumeUP()) {
            int n = sHighscoreNameCursorPos;
            sHighscoreNameIndices[n] = (byte)(sHighscoreNameIndices[n] + 1);
            bl = true;
        } else if (GCanvas.consumeDOWN()) {
            int n = sHighscoreNameCursorPos;
            sHighscoreNameIndices[n] = (byte)(sHighscoreNameIndices[n] - 1);
            bl = true;
        }
        Game.sHighscoreNameIndices[Game.sHighscoreNameCursorPos] = (byte)GL.mathModWrap(sHighscoreNameIndices[sHighscoreNameCursorPos], 0, sHighscoreNameCharacters.length);
        if (bl) {
            for (int i = 0; i < 3; ++i) {
                Game.sHighscoreNameBytes[i] = sHighscoreNameCharacters[sHighscoreNameIndices[i]];
            }
            RM.prepareVarText(13, new String(sHighscoreNameBytes));
            Menu.refreshMenu();
        }
    }

    private static final int highscoreNameToInt(String string) {
        if (string == null) {
            return 0;
        }
        byte[] byArray = string.getBytes();
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            n |= (byArray[i] & 0xFF) << i * 8;
        }
        return n;
    }

    public static final void highscoreSetDefault() {
        Menu.setOption(7, 105000);
        Menu.setOption(8, 95000);
        Menu.setOption(9, 85000);
        Menu.setOption(10, 75000);
        Menu.setOption(11, 65000);
        Menu.setOption(12, 55000);
        Menu.setOption(13, 45000);
        Menu.setOption(14, 35000);
        Menu.setOption(15, 25000);
        Menu.setOption(16, 15000);
        Menu.setOption(6, -1);
        if (RM.t(109) != null) {
            for (int i = 0; i < 10; ++i) {
                Menu.setOption(17 + i, Game.highscoreNameToInt(RM.t(109 + i)));
            }
        } else {
            sHighscoreNeedsInit = true;
        }
    }

    private static final String highscoreIntToName(int n) {
        for (int i = 0; i < 3; ++i) {
            byte by;
            Game.sHighscoreNameBytes[i] = by = (byte)(n >> i * 8 & 0xFF);
        }
        return new String(sHighscoreNameBytes);
    }

    private static final void highscorePrepareNameEntry(int n) {
        for (int i = 0; i < 3; ++i) {
            byte by;
            Game.sHighscoreNameBytes[i] = by = (byte)(n >> i * 8 & 0xFF);
            boolean bl = false;
            for (int j = 0; j < sHighscoreNameCharacters.length && !bl; ++j) {
                if (sHighscoreNameCharacters[j] != by) continue;
                Game.sHighscoreNameIndices[i] = (byte)j;
                bl = true;
            }
        }
    }

    private static void highscorePrepare() {
        int n = Menu.getOption(6);
        if (n != -1) {
            Game.highscorePrepareNameEntry(Menu.getOption(17 + n));
        }
        if ((sHighscorePos = Game.highscoreCheck(playerCar.getScore())) != -1) {
            sHighscoreNameCursorPos = 0;
            if (n == -1) {
                for (int i = 0; i < 3; ++i) {
                    Game.sHighscoreNameIndices[i] = 1;
                    Game.sHighscoreNameBytes[i] = sHighscoreNameCharacters[sHighscoreNameIndices[i]];
                }
            }
            RM.prepareVarText(13, new String(sHighscoreNameBytes));
            Menu.setMenuItemTarget(4, 0, 1);
        } else {
            Menu.setMenuItemTarget(4, 0, 0);
        }
    }

    private static int highscoreCheck(int n) {
        for (int i = 0; i < 10; ++i) {
            if (n <= Menu.getOption(7 + i)) continue;
            for (int j = 9; j >= i + 1; --j) {
                Menu.setOption(7 + j, Menu.getOption(7 + j - 1));
                Menu.setOption(17 + j, Menu.getOption(17 + j - 1));
            }
            Menu.setOption(7 + i, n);
            return i;
        }
        return -1;
    }

    private static final void prepareEndScreen() {
        int n = RM.getValue(29, 0, 0);
        int n2 = playerCar.getScore();
        for (int i = 0; i < 15; ++i) {
            if (n2 <= RM.getValue(29, i, 1)) continue;
            n = RM.getValue(29, i, 0);
        }
        Game.sEndScreenText[0] = RM.t(n);
        Game.sEndScreenText[1] = RM.t(87);
        Game.sEndScreenText[2] = "" + playerCar.getScore();
        if (sHighscorePos != -1) {
            Game.sEndScreenText[1] = RM.t(107);
        }
        RM.prepareVarText(11, sEndScreenText);
        Menu.setItemBottom(GCanvas.getHeight() - RM.getHeight(4) - GCanvas.FONT_MEDIUM_HEIGHT);
        Menu.setMenuCaptionImage(-1);
    }

    private static final void prepareAboutScreen() {
        RM.prepareVarText(10, new String[]{Menu.getMidletInfo(0), Menu.getMidletInfo(1), Menu.getMidletInfo(0)});
    }

    private static final void prepareHelpMenuText(boolean bl) {
        if (sHelpMenuTextIsPrepared && !bl) {
            return;
        }
        sHelpMenuTextIsPrepared = true;
        if (GL.handsonDemoIsActive()) {
            RM.prepareVarText(7, RM.t(12));
            RM.prepareVarText(9, RM.t(89), RM.t(7));
        } else if (GL.handsonMoreGamesIsMenu()) {
            RM.prepareVarText(8, RM.t(12));
            RM.prepareVarText(9, RM.t(89), RM.t(8));
        } else {
            RM.setString(9, RM.t(89));
        }
    }

    private static final void prepareMenuExpiredScreen() {
        RM.prepareVarText(6, Menu.getMidletInfo(0));
    }

    private static final void prepareOptionsScreen() {
        RM.prepareVarText(14, Game.tutorialAllMessagesDisplayed() ? RM.t(59) : RM.t(58));
    }

    public static final void onPrepareMenuChange(int n, int n2) {
        Menu.resetItemBottom();
        Menu.setMenuCaptionImage(27, true);
        boolean bl = n != 17;
        Menu.showUpDownArrows(bl);
        switch (n) {
            case 8: 
            case 21: {
                Menu.setItemBottom(GCanvas.getHeight() - GCanvas.getSpriteHeight(22) * 7 / 8);
                Menu.setMenuCaptionImage(-1);
                break;
            }
            case 17: {
                Menu.stopMusic();
                sOutroTimer = 5000;
                if (GL.handsonDemoIsActive()) {
                    Menu.setMenuOption(17, 3, (byte)-1);
                    Menu.setMenuOption(17, 4, (byte)-1);
                    sOutroTimer = 2000;
                } else if (GL.handsonMoreGamesIsExit()) {
                    Menu.setMenuOption(17, 3, (byte)17);
                }
                Menu.setMenuCaptionImage(-1);
                break;
            }
            case 14: {
                Game.prepareAboutScreen();
                break;
            }
            case 4: {
                Game.prepareEndScreen();
                break;
            }
            case 6: {
                Game.prepareOptionsScreen();
                break;
            }
            case 26: {
                sSwitchToOutroTimer = 5000;
                Game.prepareMenuExpiredScreen();
                break;
            }
            case 27: {
                Game.prepareMenuExpiredScreen();
                break;
            }
            case 0: 
            case 2: 
            case 3: {
                if (!sHighscoreNeedsInit) break;
                sHighscoreNeedsInit = false;
                Game.highscoreSetDefault();
                Menu.saveOptions();
                break;
            }
            case 9: {
                Game.prepareHelpMenuText(false);
                break;
            }
            case 1: {
                Menu.setMenuCaptionImage(-1);
                break;
            }
        }
    }

    private static final void prepareMission(int n) {
        preparedMission = n;
    }

    public static final boolean evaluateCondition(int n, int n2) {
        switch (n) {
            case 15: {
                return GL.handsonDemoIsActive();
            }
            case 16: {
                return !GL.handsonDemoIsActive();
            }
            case 13: {
                if (GL.handsonDemoIsActive()) {
                    return false;
                }
                return GL.handsonMoreGamesIsMenu();
            }
            case 14: {
                if (GL.handsonDemoIsActive()) {
                    GL.handsonMoreGamesReadBuySetup();
                    return GL.handsonMoreGamesIsMenu();
                }
                return false;
            }
            case 11: {
                return Game.isInGame();
            }
            case 17: {
                return !Menu.sUserPaused;
            }
            case 18: {
                return GL.handsonLanguageIsAvailable(0);
            }
            case 19: {
                return GL.handsonLanguageIsAvailable(1);
            }
            case 20: {
                return GL.handsonLanguageIsAvailable(2);
            }
            case 21: {
                return GL.handsonLanguageIsAvailable(3);
            }
            case 22: {
                return GL.handsonLanguageIsAvailable(4);
            }
            case 23: {
                return GL.handsonLanguageIsAvailable(5);
            }
        }
        return true;
    }

    public static final void onLanguageChanged() {
        GL.handsonDemoInit("P3TG0TJ0H");
        GL.handsonMoreGamesReadLabel();
        if (GL.sHandsonMoreGamesLabel == null || GL.sHandsonMoreGamesLabel.length() == 0) {
            GL.sHandsonMoreGamesLabel = GL.handsonDemoIsActive() ? new String(RM.t(84)) : new String(RM.t(102));
        }
        RM.prepareVarText(12, GL.sHandsonMoreGamesLabel);
        Game.prepareHelpMenuText(true);
    }

    public static final void menuDrawItem(Graphics graphics, Font font, int n, String string, int n2, int n3, int n4) {
        if (string == RM.t(13)) {
            graphics.setFont(font);
            n2 += 0;
            n3 += 2;
            int n5 = GCanvas.getCharWidth('O') + 3 & 0xFFFFFFFE;
            n2 -= n5 * 2 >> 1;
            for (int i = 0; i < 3; ++i) {
                if (i == sHighscoreNameCursorPos && (GCanvas.getGlobalFrameCount() >> 2 & 1) != 0) {
                    graphics.setColor(-3402);
                    graphics.fillRect(n2 - (n5 >> 1), n3, n5, GCanvas.getFontHeight());
                }
                graphics.setColor(n);
                graphics.drawChar(string.charAt(i), n2, n3, n4);
                n2 += n5;
            }
        } else {
            Menu.drawMenuItem(graphics, font, n, string, n2, n3, n4);
        }
    }

    public static final void menuDrawHighscoreEntry(Graphics graphics, int n) {
        int n2 = n;
        Font font = GCanvas.FONT_MEDIUM;
        for (int i = 0; i < 10; ++i) {
            int n3 = Menu.getCurrentMenu() == 3 && i == sHighscorePos ? -3407872 : -10872824;
            Menu.drawMenuItem(graphics, font, n3, Game.highscoreIntToName(Menu.getOption(17 + i)), 8, n2, 20);
            Menu.drawMenuItem(graphics, font, n3, "" + Menu.getOption(7 + i), GCanvas.getWidth() - 4, n2, 24);
            n2 += GCanvas.FONT_MEDIUM_HEIGHT;
            n2 += 0;
        }
    }

    public static final int menuDrawSelectionBar(Graphics graphics, int n, int n2, int n3) {
        if (Menu.getCurrentMenu() == 17) {
            return n;
        }
        if (n == -3402) {
            graphics.setColor(n);
            graphics.fillRect(0, n2, GCanvas.getWidth(), GCanvas.FONT_MEDIUM_HEIGHT);
            return n3 == 12 ? -3407872 : -10872824;
        }
        return n3 == 12 ? -3407872 : n;
    }

    private static final void menuDrawSpeechBubble(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = 0;
        int n7 = 0;
        n6 = GCanvas.getSpriteWidth(20);
        n7 = GCanvas.getSpriteHeight(20);
        graphics.setColor(-1);
        graphics.fillRect(n + n6, n2 + n7, n3 - n - n6, n4 - n2 - n7);
        int n8 = n2;
        for (n5 = n + n6; n5 < n3 - n6; n5 += n6) {
            GCanvas.drawSprite(20, n5, n8, 4);
        }
        GCanvas.drawSprite(20, n3 - n6, n8, 4);
        n8 = n4;
        for (n5 = n + n6; n5 < n3 - n6; n5 += n6) {
            GCanvas.drawSprite(20, n5, n8, 5);
        }
        GCanvas.drawSprite(20, n3 - n6, n8, 5);
        n5 = n;
        for (n8 = n2 + n7; n8 < n4 - n7; n8 += n7) {
            GCanvas.drawSprite(20, n5, n8, 6);
        }
        GCanvas.drawSprite(20, n5, n4 - n7, 6);
        n5 = n3;
        for (n8 = n2 + n7; n8 < n4 - n7; n8 += n7) {
            GCanvas.drawSprite(20, n5, n8, 7);
        }
        GCanvas.drawSprite(20, n5, n4 - n7, 7);
        GCanvas.drawSprite(20, n, n2, 0);
        GCanvas.drawSprite(20, n3, n2, 1);
        GCanvas.drawSprite(20, n, n4, 2);
        GCanvas.drawSprite(20, n3, n4, 3);
        GCanvas.drawSprite(21, GCanvas.getWidth() / 3, n4 + n7 - 2, 0);
    }

    private static final void menuDrawTutorialBackground(int n, int n2, int n3, int n4) {
        Graphics graphics = GCanvas.getTargetGraphics();
        int n5 = 1;
        int n6 = GCanvas.getSpriteWidth(19);
        int n7 = GCanvas.getSpriteHeight(19);
        int n8 = (GCanvas.getGlobalFrameCount() >> 1) % n6 - n6;
        int n9 = -((GCanvas.getGlobalFrameCount() >> 1) % n7) - n7;
        int n10 = n8;
        for (int i = n9; i < GCanvas.getHeight(); i += n7) {
            while (n10 < GCanvas.getWidth()) {
                GCanvas.drawSprite(19, n10, i, n5);
                n10 += n6;
            }
            n10 = n8;
        }
        n5 = GCanvas.getSpriteWidth(20);
        n6 = GCanvas.getSpriteHeight(20);
        n7 = n3;
        n8 = Menu.getMenuSeperatorTop();
        n9 = GCanvas.getWidth() - n3 - n5;
        n10 = n4 + GCanvas.getFontHeight();
        Game.menuDrawSpeechBubble(graphics, n7, n8, n9, n10);
        GCanvas.drawSprite(22, GCanvas.getWidth(), GCanvas.getHeight(), 0);
    }

    private static final void menuDrawOutroScreen(int n, int n2, int n3, int n4) {
        Graphics graphics = GCanvas.getTargetGraphics();
        graphics.setColor(-1);
        graphics.fillRect(0, 0, GCanvas.getWidth(), GCanvas.getHeight());
        GCanvas.drawImage(1, GCanvas.getWidth() >> 1, GCanvas.getHeight() >> 1, 3);
        graphics.setColor(0);
        graphics.setFont(GCanvas.FONT_SMALL);
        GCanvas.drawString(RM.t(85), GCanvas.getWidth() >> 1, 0, 17);
        int n5 = 0;
        n5 = GCanvas.FONT_SMALL_HEIGHT + 1;
        GCanvas.drawString(RM.t(86), GCanvas.getWidth() >> 1, n5, 17);
    }

    private static final void menuDrawEndscreenBackground(int n, int n2, int n3, int n4) {
        int n5;
        Graphics graphics = GCanvas.getTargetGraphics();
        graphics.setColor(0);
        graphics.fillRect(0, 0, GCanvas.getWidth(), GCanvas.getHeight());
        GCanvas.drawImage(4, GCanvas.getWidth() >> 1, GCanvas.getHeight() - 2, 33);
        int n6 = RM.getHeight(4);
        int n7 = GCanvas.getSpriteWidth(20);
        int n8 = GCanvas.getSpriteHeight(20);
        Game.menuDrawSpeechBubble(graphics, n3, Menu.getMenuSeperatorTop(), GCanvas.getWidth() - n3 - n7, GCanvas.getHeight() - n6 - n8 - 4);
        n7 = GCanvas.getWidth() - 4;
        n8 = 120;
        n7 = RM.getWidth(4);
        n8 = RM.getHeight(4);
        int n9 = GCanvas.getSpriteWidth(23);
        int n10 = GCanvas.getSpriteHeight(23);
        int n11 = n7 / 20;
        int n12 = n5 = GCanvas.getHeight() - 2 - n8 * 3 / 4 - (n10 >> 1);
        GCanvas.drawSprite(24, n11, n12, 0);
        graphics.setColor(-1);
        GCanvas.drawString("x" + sNumCombosSuper, n11 += n9 * 5 / 4, n12 += n10 >> 1, 20);
        n11 = n7 / 20;
        n12 = n5 + n10 + 2;
        GCanvas.drawSprite(23, n11, n12, 0);
        GCanvas.drawString("x" + sNumCombosNormal, n11 += n9 * 5 / 4, n12 += n10 >> 1, 20);
        for (n9 = 0; n9 < 2; ++n9) {
            n10 = n9 * 5;
            if (sEndScreenZZZ[n10 + 4] <= 0) {
                Game.sEndScreenZZZ[n10 + 0] = GCanvas.getWidth() - 2 - 36 << 10;
                Game.sEndScreenZZZ[n10 + 1] = GCanvas.getHeight() - 2 - 35 << 10;
                Game.sEndScreenZZZ[n10 + 2] = GCanvas.getRandom(-512, 512);
                Game.sEndScreenZZZ[n10 + 3] = GCanvas.getRandom(-2048, -1024);
                Game.sEndScreenZZZ[n10 + 4] = GCanvas.getRandom(20, 30);
            } else {
                int n13 = n10 + 0;
                sEndScreenZZZ[n13] = sEndScreenZZZ[n13] + sEndScreenZZZ[n10 + 2];
                int n14 = n10 + 1;
                sEndScreenZZZ[n14] = sEndScreenZZZ[n14] + sEndScreenZZZ[n10 + 3];
                int n15 = n10 + 4;
                sEndScreenZZZ[n15] = sEndScreenZZZ[n15] - 1;
            }
            GCanvas.drawSprite(25, sEndScreenZZZ[n10 + 0] >> 10, sEndScreenZZZ[n10 + 1] >> 10, 0);
        }
    }

    private static final void menuDrawStandardBackground(int n, int n2, int n3, int n4) {
        int n5;
        Graphics graphics = GCanvas.getTargetGraphics();
        int n6 = 0;
        n6 = Menu.getMenuSeperatorTop();
        graphics.setColor(-9830358);
        graphics.fillRect(0, 0, GCanvas.getWidth(), n6);
        int n7 = GCanvas.getSpriteWidth(19);
        int n8 = GCanvas.getSpriteHeight(19);
        int n9 = n5 = 0;
        int n10 = 0;
        for (int i = n6; i < GCanvas.getHeight(); i += n8) {
            while (n9 < GCanvas.getWidth()) {
                GCanvas.drawSprite(19, n9, i, n10);
                n9 += n7;
            }
            n9 = n5;
            n10 = 1;
        }
    }

    public static final boolean menuProcessActions() {
        switch (Menu.getCurrentMenu()) {
            case 26: {
                if ((sSwitchToOutroTimer -= 50) >= 0) break;
                Menu.performMenuAction(67);
                return true;
            }
            case 17: {
                if ((sOutroTimer -= 50) >= 0) break;
                Menu.performMenuAction(16);
                return true;
            }
        }
        return false;
    }

    public static final void drawCustomMenuBackground(int n, int n2, int n3, int n4) {
        switch (n) {
            case 8: 
            case 21: {
                Game.menuDrawTutorialBackground(n, n2, n3, n4);
                break;
            }
            case 17: {
                Game.menuDrawOutroScreen(n, n2, n3, n4);
                break;
            }
            case 4: {
                Game.menuDrawEndscreenBackground(n, n2, n3, n4);
                break;
            }
            default: {
                Game.menuDrawStandardBackground(n, n2, n3, n4);
            }
        }
    }

    private static int sfxGetIntenalSoundID(int n) {
        return RM.getValue(37, n, 0);
    }

    public static void resetSoundInitTable() {
        for (int i = 0; i < sPreparedSoundId.length; ++i) {
            Game.sPreparedSoundId[i] = 0;
        }
    }

    private static void initSoundPreparationTable() {
        sPreparedSoundId = new int[5];
        Game.resetSoundInitTable();
    }

    private static void prepareSound(ISound iSound, int n) {
        int n2 = Game.sfxGetIntenalSoundID(n);
        int n3 = -1;
        for (int i = 0; i < sPreparedSoundId.length; ++i) {
            if (sPreparedSoundId[i] == 0 && n3 == -1) {
                n3 = i;
            }
            if (sPreparedSoundId[i] != n2) continue;
            return;
        }
        Game.sPreparedSoundId[n3] = n2;
        iSound.prepare(n2, false);
    }

    public static final void prepareSounds(ISound iSound) {
        if (sPreparedSoundId == null) {
            Game.initSoundPreparationTable();
        }
        Game.prepareSound(iSound, 0);
        Game.prepareSound(iSound, 1);
        Game.prepareSound(iSound, 2);
        Game.prepareSound(iSound, 3);
    }

    public static final void initBackbuffer(int n, int n2) {
        if (backbuffer == null) {
            backbuffer = Game.createBackbuffer();
        }
        Game.screenSizeChanged();
    }

    private static final ICircularBuffer createBackbuffer() {
        return new CircularBuffer();
    }

    private static void flowerInitFirstTime() {
        if (sFlowerFirstTimeInit) {
            int n;
            sFlowerDrawScreenExtentsX = new Point2D(0, 0);
            sFlowerDrawScreenExtentsY = new Point2D(0, 0);
            sFlowerNumTypesAvailable = FLOWER_NUM_TYPES = RM.getHeight(59);
            FLOWER_NUM_ATTRIBUTES = RM.getWidth(59);
            sFlowerWorldMinX = carBounds[0];
            sFlowerWorldMaxX = carBounds[2];
            sFlowerWorldMinY = carBounds[1];
            sFlowerWorldMaxY = carBounds[3];
            sFlowerGridSqCountX = (sFlowerWorldMaxX - sFlowerWorldMinX) / sFlowerGridSquareSizeX;
            sFlowerGridSqCountY = (sFlowerWorldMaxY - sFlowerWorldMinY) / sFlowerGridSquareSizeY;
            sFlowerGridSquareSizeX = (sFlowerWorldMaxX - sFlowerWorldMinX) / sFlowerGridSqCountX;
            sFlowerGridSquareSizeY = (sFlowerWorldMaxY - sFlowerWorldMinY) / sFlowerGridSqCountY;
            sFlowerCountLevelFull = 591 * sFlowerGridSqCountX * sFlowerGridSqCountY >> 10;
            sFlowers = new int[sFlowerCountLevelFull + 2][];
            for (n = 0; n < sFlowerCountLevelFull + 2; ++n) {
                Game.sFlowers[n] = new int[7];
            }
            sFlowerGrid = new short[sFlowerGridSqCountX][];
            for (n = 0; n < sFlowerGridSqCountX; ++n) {
                Game.sFlowerGrid[n] = new short[sFlowerGridSqCountY];
            }
            FLOWER_TYPE_ATTRIBUTES = new int[FLOWER_NUM_TYPES][];
            for (n = 0; n < FLOWER_NUM_TYPES; ++n) {
                Game.FLOWER_TYPE_ATTRIBUTES[n] = new int[FLOWER_NUM_ATTRIBUTES];
            }
            sFlowerClosestOfType = new int[FLOWER_NUM_TYPES];
            sFlowerCurrentClosestOfTypeDistSq = new long[FLOWER_NUM_TYPES];
            Game.obstaclesFirstTimeInit();
            RandomGenerator.setSeed(31384454);
            Game.comboFirstTimeInit();
            Game.tutorialFirstTimeInit();
            sFlowerFirstTimeInit = false;
        }
    }

    private static void flowerInitAll() {
        int n;
        int n2;
        Game.flowerInitFirstTime();
        sFlowersCount = 0;
        for (n2 = 0; n2 < sFlowerGridSqCountY; ++n2) {
            for (n = 0; n < sFlowerGridSqCountX; ++n) {
                Game.sFlowerGrid[n][n2] = -1;
            }
        }
        for (n2 = 0; n2 < FLOWER_NUM_TYPES; ++n2) {
            for (n = 0; n < FLOWER_NUM_ATTRIBUTES; ++n) {
                Game.FLOWER_TYPE_ATTRIBUTES[n2][n] = RM.getValue(59, n2, n);
            }
        }
        for (n2 = 0; n2 < sFlowerCountLevelFull; ++n2) {
            Game.flowerGenerate(null);
        }
    }

    private static int flowerGetNumUnharvested() {
        int n = 0;
        for (int i = 0; i < sFlowersCount; ++i) {
            if (Game.flowerAlreadyHarvested(sFlowers[i])) continue;
            ++n;
        }
        return n;
    }

    private static void flowerConvertPercentageToViolas() {
        int n = Game.flowerGetNumUnharvested();
        int n2 = n / 10;
        while (n2 > 0) {
            int n3 = RandomGenerator.nextIntInRange(0, sFlowersCount);
            if (sFlowers[n3][0] == -2 || Game.flowerAlreadyHarvested(sFlowers[n3])) continue;
            Game.sFlowers[n3][0] = 0;
            --n2;
        }
        Game.flowerUpdateClosestOfTypes(playerCar);
    }

    private static boolean flowerOkToGenerateHere(Point2D point2D, Point2D point2D2, Bee bee, int n) {
        int n2 = Game.flowerGetWorldPosX(point2D.x, point2D2.x);
        int n3 = Game.flowerGetWorldPosY(point2D.y, point2D2.y);
        if (!Game.flowerGetGridSquareAvailable(point2D.x, point2D.y)) {
            return false;
        }
        if (Game.flowerTooCloseToObstacle(n2, n3, 204800)) {
            return false;
        }
        if (bee == null) {
            return true;
        }
        int n4 = bee.getWorldPositionX();
        int n5 = bee.getWorldPositionY();
        if (Game.flowerWouldBeOnScreen(n2, n3)) {
            return false;
        }
        return !Game.flowerCloserThanClosestFlowerOfSameType(n2, n3, n4, n5, n);
    }

    private static int flowerGenerateType() {
        int n = -1;
        block0: while (FLOWER_NUM_TYPES - n > sFlowerNumTypesAvailable) {
            int n2 = 100 - RandomGenerator.nextIntInRange(0, 100);
            for (int i = 0; i < FLOWER_NUM_TYPES; ++i) {
                if (n2 > FLOWER_TYPE_ATTRIBUTES[i][1]) continue;
                n = i;
                continue block0;
            }
        }
        if (n == -1) {
            return 0;
        }
        return n;
    }

    private static void flowerGenerate(Bee bee) {
        int n = Game.flowerGenerateType();
        Game.flowerGenerate(bee, n);
    }

    private static boolean flowerGenerateGridSqXY(Point2D point2D, int n, short[][] sArray, int n2, int n3, int n4) {
        try {
            int n5 = n3 * n4;
            int n6 = n5 - n;
            int n7 = 0;
            int n8 = RandomGenerator.nextIntInRange(1, Math.max(2, n6 - 1));
            int n9 = -1;
            int n10 = -1;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    if (sArray[i][j] != n2) continue;
                    n9 = i;
                    n10 = j;
                    if (++n7 != n8) continue;
                    point2D.set(i, j);
                    return true;
                }
            }
            if (n9 != -1 && n10 != -1) {
                point2D.set(n9, n10);
                return true;
            }
            GCanvas.dbgLog("E>No free gr sq, reduce number of flowers");
        }
        catch (Exception exception) {
            GCanvas.dbgLog("ER> Problem generating gridXY for flower. Possibly no space left. gridX = " + point2D.x + "gridY = " + point2D.y);
        }
        return false;
    }

    private static void flowerGenerateGridOffset(Point2D point2D, Point2D point2D2) {
        int n = 30720;
        int n2 = sFlowerGridSquareSizeX - 30720;
        int n3 = 0;
        int n4 = sFlowerGridSquareSizeY - 71680;
        if (point2D2.y == 0) {
            n3 = 30720;
        } else if (point2D2.y == sFlowerGridSqCountY - 1) {
            // empty if block
        }
        point2D.set(RandomGenerator.nextIntInRange(n, n2), RandomGenerator.nextIntInRange(n3, n4));
    }

    private static void flowerGenerate(Bee bee, int n) {
        Point2D point2D = Point2D.tmp0;
        point2D.set(0, 0);
        Point2D point2D2 = Point2D.tmp1;
        point2D2.set(0, 0);
        for (int i = 0; i < 20; ++i) {
            if (!Game.flowerGenerateGridSqXY(point2D, sFlowersCount, sFlowerGrid, -1, sFlowerGridSqCountX, sFlowerGridSqCountY)) continue;
            Game.flowerGenerateGridOffset(point2D2, point2D);
            if (!Game.flowerOkToGenerateHere(point2D, point2D2, bee, n)) continue;
            Game.flowerAdd(n, point2D.x, point2D.y, point2D2.x, point2D2.y);
            break;
        }
    }

    private static void flowerAdd(int n, int n2, int n3, int n4, int n5) {
        if (n == -2) {
            sCandyFlowerIdx = sFlowersCount;
        }
        Game.sFlowerGrid[n2][n3] = sFlowersCount;
        int[] nArray = sFlowers[sFlowersCount];
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = n3;
        nArray[3] = n4;
        nArray[4] = n5;
        nArray[5] = 0;
        nArray[6] = Game.flowerGetAnimFrame(nArray[5], n2 + n2);
        sFlowersCount = (short)(sFlowersCount + 1);
    }

    private static void flowerRemove(short s) {
        int n;
        int[] nArray;
        int n2;
        if (Game.flowerIsCandy(s)) {
            // empty if block
        }
        if (sFlowerGrid[n2 = (nArray = sFlowers[s])[1]][n = nArray[2]] != -1) {
            Game.sFlowerGrid[n2][n] = -1;
            if (sFlowersCount > 1) {
                if (Game.flowerIsCandy(s)) {
                    sCandyFlowerIdx = (short)-1;
                }
                int[] nArray2 = sFlowers[sFlowersCount - 1];
                Game.sFlowers[s] = nArray2;
                Game.sFlowerGrid[nArray2[1]][nArray2[2]] = s;
                Game.sFlowers[Game.sFlowersCount - 1] = nArray;
                if (nArray2[0] == -2) {
                    sCandyFlowerIdx = s;
                }
            }
            sFlowersCount = (short)(sFlowersCount - 1);
        }
    }

    private static boolean flowerGetGridSquareAvailable(int n, int n2) {
        return sFlowerGrid[n][n2] == -1;
    }

    private static boolean flowerTooCloseToObstacle(int n, int n2, int n3) {
        return Game.obstacleQueryClosest(n, n2, n3) != -1;
    }

    private static boolean flowerCloserThanClosestFlowerOfSameType(int n, int n2, int n3, int n4, int n5) {
        long l = Game.flowerGetDistSq(n, n2, n3, n4, false);
        if (n5 == -2) {
            return false;
        }
        if (sFlowerClosestOfType[n5] == -1) {
            return false;
        }
        return l < Game.flowerGetDistSq(sFlowers[sFlowerClosestOfType[n5]], n3, n4, false);
    }

    private static long flowerGetDistSq(int n, int n2, int n3, int n4, boolean bl) {
        long l = n - n3;
        l *= l;
        long l2 = n2 - n4;
        if (bl) {
            l2 >>= 1;
        }
        l2 *= l2;
        return l + l2 >> 10;
    }

    private static long flowerGetDistSq(int[] nArray, int n, int n2, boolean bl) {
        return Game.flowerGetDistSq(Game.flowerGetWorldPosX(nArray), Game.flowerGetWorldPosY(nArray), n, n2, bl);
    }

    public static void flowerUpdate(Bee bee) {
        int n = sFlowerCountLevelFull - sFlowersCount;
        for (int i = 0; i < n; ++i) {
            Game.flowerGenerate(bee);
        }
        Game.flowerUpdateClosestOfTypes(bee);
        if (Math.abs(sPlayerEnergy - sDesiredPlayerEnergy) < 10) {
            sPlayerEnergy = sDesiredPlayerEnergy;
        } else if (sPlayerEnergy < sDesiredPlayerEnergy) {
            sPlayerEnergy += 10;
        } else if (sPlayerEnergy > sDesiredPlayerEnergy) {
            sPlayerEnergy = sDesiredPlayerEnergy;
        }
    }

    private static void flowerUpdateClosestOfTypes(Bee bee) {
        try {
            if (sFlowerFirstTimeInit) {
                return;
            }
            for (int i = 0; i < FLOWER_NUM_TYPES; ++i) {
                Game.sFlowerClosestOfType[i] = -1;
                Game.sFlowerCurrentClosestOfTypeDistSq[i] = Integer.MAX_VALUE;
            }
            int[] nArray = null;
            int n = 0;
            int n2 = 0;
            if (bee.isOrbitting()) {
                n = bee.getOrbittingCenterX();
                n2 = bee.getOrbittingCenterY();
            } else {
                n = bee.getWorldPositionX();
                n2 = bee.getWorldPositionY();
            }
            for (short s = 0; s < sFlowersCount; s = (short)(s + 1)) {
                long l;
                nArray = sFlowers[s];
                if (Game.flowerAlreadyHarvested(nArray)) {
                    Game.flowerTryToRemove(s, n, n2);
                    continue;
                }
                if (nArray[0] == -2 || (l = Game.flowerGetDistSq(nArray, n, n2, false)) >= sFlowerCurrentClosestOfTypeDistSq[nArray[0]]) continue;
                Game.sFlowerClosestOfType[nArray[0]] = s;
                Game.sFlowerCurrentClosestOfTypeDistSq[nArray[0]] = l;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean flowerAlreadyHarvested(int[] nArray) {
        return nArray[5] == 1;
    }

    private static void flowerTryToRemove(short s, int n, int n2) {
        if (!Game.flowerWouldBeOnScreen(s)) {
            Game.flowerRemove(s);
        }
    }

    public static int flowerQueryClosestOfType(int n) {
        return sFlowerClosestOfType[n];
    }

    public static int flowerQueryClosestOnOrOffScreen(int n, int n2, boolean bl) {
        int n3 = -1;
        int n4 = -1;
        short s = sFlowersCount;
        try {
            long l = Long.MAX_VALUE;
            int n5 = -1;
            for (int i = 0; i < sFlowerNumTypesAvailable; ++i) {
                int n6;
                int n7;
                n3 = n7 = FLOWER_NUM_TYPES - i - 1;
                if (sFlowerClosestOfType[n7] == -1) continue;
                n4 = n6 = sFlowerClosestOfType[n7];
                long l2 = Game.flowerGetDistSq(sFlowers[n6], n, n2, false);
                if (sFlowers[n6][0] == -1 || l2 >= l) continue;
                n5 = sFlowerClosestOfType[n7];
                l = l2;
            }
            if (bl && sCandyPresent && !sCandyHarvested && Game.flowerGetDistSq(Game.flowerGetWorldPosX(sCandyFlowerIdx), Game.flowerGetWorldPosY(sCandyFlowerIdx), n, n2, false) < l) {
                n5 = sCandyFlowerIdx;
            }
            return n5;
        }
        catch (Exception exception) {
            GCanvas.dbgLog("ER> Problem finding nearest flower index = " + n4 + " type = " + n3 + "flowerCount" + s);
            throw new IllegalArgumentException("Game: flowerQueryClosestOnOrOffScreen: bad closest flower found.");
        }
    }

    public static int flowerQueryClosestInRange(int n, int n2, int n3) {
        int n4 = Game.flowerQueryClosestOnOrOffScreen(n, n2, true);
        int n5 = windowX + 5 - 48;
        int n6 = windowY + 5 - 24;
        int n7 = windowX + GCanvas.getWidth() - 5 + 48;
        int n8 = windowY + GCanvas.getHeight() - 5 + 24;
        Point2D point2D = Point2D.tmp0;
        Game.flowerCalcScreenPos(n4, point2D);
        if (point2D.x > n7 || point2D.x < n5 || point2D.y > n8 || point2D.y < n6) {
            return -1;
        }
        return n4;
    }

    private static boolean flowerIsCandy(int n) {
        return sFlowers[n][0] == -2;
    }

    public static void flowerOnHarvest(int n, Bee bee) {
        if (Game.flowerIsCandy(n)) {
            Game.candyHarvest();
            return;
        }
        int[] nArray = sFlowers[n];
        if (bee == playerCar) {
            Game.flowerAward(nArray);
            Game.comboUpdate(nArray);
            Game.flowerSetAnimType(n, 1);
            ++sDemoNumHarvestedFlowers;
            if (sEnergyDeltaPercentage < 1024 && (sEnergyDeltaPercentage += 2) > 1024) {
                sEnergyDeltaPercentage = 1024;
            }
        }
    }

    private static int flowerGetAnimFrame(int n, int n2) {
        int n3 = RM.getValue(62, n, 0);
        int n4 = RM.getValue(62, n, 1);
        int n5 = RM.getValue(62, n, 2);
        int n6 = 0;
        switch (n5) {
            case 0: {
                n6 = GL.mathModWrap(n2, n3, n4 + 1);
                break;
            }
            case 1: {
                n6 = GL.mathClamp(n2, n3, n4);
            }
        }
        return n6;
    }

    private static void flowerSetAnimType(int n, int n2) {
        int[] nArray = sFlowers[n];
        nArray[5] = n2;
    }

    private static void flowerCalcScreenPos(int n, Point2D point2D) {
        Game.flowerCalcScreenPosFromWorldOnGround(Game.flowerGetWorldPosX(n), Game.flowerGetWorldPosY(n), point2D);
    }

    private static void flowerCalcScreenPosFromWorldOnGround(int n, int n2, Point2D point2D) {
        int n3 = n >> 10;
        int n4 = n2 >> 10;
        int n5 = Game.getTerrainHeight(n, n2);
        point2D.x = n3 >> 0;
        point2D.y = (n4 >> 1) - n5 >> 0;
    }

    private static int flowerGetWorldPosX(int[] nArray) {
        return Game.flowerGetWorldPosX(nArray[1], nArray[3]);
    }

    private static int flowerGetWorldPosX(int n, int n2) {
        return sFlowerWorldMinX + n2 + n * sFlowerGridSquareSizeX;
    }

    private static int flowerGetWorldPosY(int[] nArray) {
        return Game.flowerGetWorldPosY(nArray[2], nArray[4]);
    }

    private static int flowerGetWorldPosY(int n, int n2) {
        return sFlowerWorldMinY + n2 + n * sFlowerGridSquareSizeY;
    }

    private static void flowerDrawAll(Graphics graphics) {
        Game.getScreenExtentsX(sFlowerDrawScreenExtentsX);
        Game.getScreenExtentsY(sFlowerDrawScreenExtentsY);
        Point2D point2D = Point2D.tmp3;
        Game.getScreenExtentsX(point2D);
        point2D.x <<= Game.getWorldXToScreenXShift();
        point2D.y <<= Game.getWorldXToScreenXShift();
        int n = (point2D.x - sFlowerWorldMinX) / sFlowerGridSquareSizeX;
        int n2 = (point2D.y - sFlowerWorldMinX) / sFlowerGridSquareSizeX + 1;
        n = GCanvas.clamp(n, 0, sFlowerGridSqCountX);
        n2 = GCanvas.clamp(n2, 0, sFlowerGridSqCountX);
        Game.getScreenExtentsY(point2D);
        point2D.x <<= 11;
        point2D.y <<= 11;
        int n3 = (point2D.x - sFlowerWorldMinY) / sFlowerGridSquareSizeY;
        int n4 = (point2D.y - sFlowerWorldMinY) / sFlowerGridSquareSizeY + 1;
        n3 = GCanvas.clamp(n3, 0, sFlowerGridSqCountY);
        n4 = GCanvas.clamp(n4, 0, sFlowerGridSqCountY);
        int[] nArray = null;
        int n5 = 0;
        int n6 = 0;
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                short s = sFlowerGrid[i][j];
                if (s == -1) continue;
                nArray = sFlowers[s];
                n5 = Game.flowerGetWorldPosX(nArray);
                n6 = Game.flowerGetWorldPosY(nArray);
                if (nArray[0] != -2) {
                    int n7;
                    if (!Game.cullOrDrawSpriteOnGround(graphics, FLOWER_TYPE_ATTRIBUTES[nArray[0]][0], nArray[6], n5, n6) || (n7 = GCanvas.getGlobalFrameCount() + s) % 4 != 0) continue;
                    nArray[6] = Game.flowerGetAnimFrame(nArray[5], nArray[6] + 1);
                    continue;
                }
                if (!sCandyPresent || !sCandyFlashOn) continue;
                Game.cullOrDrawSpriteOnGround(graphics, sCandySpriteIdx, sCandyAnimFrame, n5, n6);
            }
        }
        Game.obstaclesDrawAll(graphics);
    }

    private static void obstaclesDrawAll(Graphics graphics) {
        int[] nArray = null;
        for (int i = 0; i < 5; ++i) {
            int n;
            int n2;
            nArray = sObstacles[i];
            int n3 = Game.obstacleGetWorldPosX(nArray);
            if (!Game.cullOrDrawSpriteOnGround(graphics, nArray[0], nArray[5], n3, n2 = Game.obstacleGetWorldPosY(nArray), 0, 6) || (n = GCanvas.getGlobalFrameCount() + i) % 4 != 0) continue;
            nArray[5] = Game.obstacleGetAnimFrame(nArray[6], nArray[5] + 1);
        }
    }

    public static int flowerGetWorldPosX(int n) {
        return Game.flowerGetWorldPosX(sFlowers[n]);
    }

    public static int flowerGetWorldPosY(int n) {
        return Game.flowerGetWorldPosY(sFlowers[n]);
    }

    private static void flowerAward(int[] nArray) {
        int n = RM.getValue(59, nArray[0], 2);
        int n2 = RM.getValue(58, n, 0);
        Game.beeAwardCalcAndGive(n, n2);
    }

    private static boolean flowerWouldBeOnScreen(int n) {
        int n2 = Game.flowerGetWorldPosX(n);
        int n3 = Game.flowerGetWorldPosY(n);
        if (n == -2) {
            return Game.flowerWouldBeOnScreen(n2, n3, 11) != Integer.MIN_VALUE;
        }
        return Game.flowerWouldBeOnScreen(n2, n3, 8) != Integer.MIN_VALUE;
    }

    private static boolean flowerWouldBeOnScreen(int n, int n2) {
        return Game.flowerWouldBeOnScreen(n, n2, 8) != Integer.MIN_VALUE;
    }

    private static int flowerWouldBeOnScreen(int n, int n2, int n3) {
        int n4 = GCanvas.getSpriteWidth(8);
        int n5 = Game.getScreenXFromWorldPosX(n);
        int n6 = n5 + n4 + (n4 >> 1) + 1;
        Point2D point2D = Point2D.tmp4;
        Game.getScreenExtentsX(point2D);
        if (n5 > point2D.y || n6 < point2D.x) {
            return Integer.MIN_VALUE;
        }
        int n7 = GCanvas.getSpriteHeight(8);
        int n8 = Game.getTerrainHeight(n, n2);
        int n9 = Game.getScreenYFromWorldYAndTerrainHeight(n2, n8);
        int n10 = n9 + n7 + 1;
        Game.getScreenExtentsY(point2D);
        if (n9 > point2D.y || n10 < point2D.x) {
            return Integer.MIN_VALUE;
        }
        return n8;
    }

    private static void comboFirstTimeInit() {
        sComboCount = RM.getHeight(60);
        sComboFlowersSinceLast = new int[4];
        sComboFlowers = new int[sComboCount][];
        for (int i = 0; i < sComboCount; ++i) {
            Game.sComboFlowers[i] = new int[4];
            for (int j = 0; j < 4; ++j) {
                Game.sComboFlowers[i][j] = RM.getValue(60, i, j);
            }
        }
    }

    private static void comboInit() {
        sComboFlowerCount = 0;
        sComboCompleted = false;
        sCombo = -1;
        sComboKnown = 0;
    }

    private static void comboReset() {
        sComboFlowerCount = 0;
        sCombo = -1;
        sComboCompleted = false;
        Game.hudTabsAllDown();
    }

    private static void comboUpdateTimers() {
        if (Game.comboGetFlowerCount() > 0 && sComboTimeToContinueCombo > 0 && --sComboTimeToContinueCombo <= 0) {
            Game.comboAbort();
        }
    }

    private static void comboSetTimeToContinueCombo(int n) {
        sComboTimeToContinueCombo = n;
        sComboTimeToContinueComboMax = n;
    }

    private static void comboConsumeFlower(int[] nArray) {
        Game.sComboFlowersSinceLast[Game.sComboFlowerCount] = nArray[0];
        Game.hudTabsType[Game.sComboFlowerCount] = nArray[0];
        hudTabDirty |= 1 << sComboFlowerCount;
        Game.hudTabsUp(sComboFlowerCount);
        if (++sComboFlowerCount == 1) {
            Game.tutorialAddDisplayMessage(2, 5);
        }
        Game.comboEstablish();
        Game.comboSetTimeToContinueCombo(sComboTimeBetweenFlowers);
    }

    private static void comboUpdate(int[] nArray) {
        if (sComboFlowerCount == 4) {
            Game.comboReset();
        }
        Game.comboConsumeFlower(nArray);
        if (sCombo == -1) {
            Game.comboAbort();
            Game.comboConsumeFlower(nArray);
        } else if (Game.comboJustCompleted()) {
            Game.comboOnComplete();
        } else {
            Game.sfxPlayLogicSound(1);
        }
        hudSparksIntensity = Game.comboGetSparkle();
    }

    private static boolean comboJustCompleted() {
        return !sComboCompleted && sComboFlowerCount == 4;
    }

    private static void comboOnComplete() {
        if (!Game.tutorialMessageDisplayed(3)) {
            Game.tutorialAddDisplayMessage(3, 5);
        }
        Game.sfxPlayLogicSound(2);
        if (sCombo != -1) {
            sComboKnown |= 1 << sCombo;
        }
        sComboCompleted = true;
        if (++sComboChainLength > 6) {
            sComboChainLength = 6;
        }
        Game.comboAward();
        int n = (sComboChainLength << 10) / 6;
        sComboTimeBetweenFlowers = n * 80 + (1024 - n) * 300 >> 10;
        GCanvas.dbgLog("Time to contine combo " + sComboTimeBetweenFlowers);
        Game.comboSetTimeToContinueCombo(sComboTimeBetweenFlowers);
        if (sComboChainLength == 6) {
            ++sNumCombosSuper;
        } else {
            ++sNumCombosNormal;
        }
    }

    public static void comboAbort() {
        Game.sfxPlayLogicSound(3);
        sComboChainLength = 0;
        Game.hudTabsSetPosYFromComboPercentage();
        sComboTimeToContinueCombo = 0;
        sComboTimeBetweenFlowers = 300;
        Game.comboReset();
    }

    private static void beeAwardCalcAndGive(int n, int n2) {
        int n3 = RM.getValue(58, n, 1);
        Game.beeAwardGive(n3, n2);
    }

    private static void beeAwardGive(int n, int n2) {
        playerCar.setScore(playerCar.getScore() + n2);
        if (n > 100) {
            int n3 = (n << 10) / 100;
            if ((sMaxEnergy = sMaxEnergy * n3 >> 10) > 1024) {
                sMaxEnergy = 1024;
            }
        } else if (n == 100) {
            sDesiredPlayerEnergy = sMaxEnergy;
        } else {
            int n4 = (n << 10) / 100;
            if ((sDesiredPlayerEnergy += sMaxEnergy * n4 >> 10) > sMaxEnergy) {
                sDesiredPlayerEnergy = sMaxEnergy;
            }
        }
    }

    private static void comboAward() {
        if (sCombo == -1) {
            return;
        }
        int n = RM.getValue(60, sCombo, 4);
        int n2 = RM.getValue(58, n, 0);
        if (RM.getValue(58, n, 2) > 0) {
            Game.flowerConvertPercentageToViolas();
        }
        Game.beeAwardCalcAndGive(n, n2 * sComboChainLength);
        Game.hudScoreEffectStart(n2);
        hudSparksComboAward = true;
    }

    private static void comboEstablish() {
        sCombo = -1;
        for (int i = 0; i < sComboCount; ++i) {
            boolean bl = false;
            for (int j = 0; j < sComboFlowerCount; ++j) {
                if (sComboFlowersSinceLast[j] != sComboFlowers[i][j]) {
                    bl = false;
                    break;
                }
                bl = true;
            }
            if (!bl) continue;
            sCombo = i;
        }
    }

    public static int comboGetFlower(int n) {
        return sComboFlowersSinceLast[n];
    }

    public static int comboGetFlowerCount() {
        return sComboFlowerCount;
    }

    public static int comboGetSparkle() {
        if (sCombo == -1 || sComboFlowerCount == 0) {
            return 0;
        }
        int n = RM.getValue(60, sCombo, 5);
        int n2 = sComboFlowerCount * 25;
        if (sComboFlowerCount == 1) {
            n2 = 0;
        }
        return n2 * n / 10;
    }

    private static void obstaclesInit() {
        short s;
        int[][] nArray = new int[5][2];
        nArray[0][0] = 2;
        nArray[0][1] = 2;
        nArray[1][0] = 1;
        nArray[1][1] = 9;
        nArray[2][0] = 7;
        nArray[2][1] = 4;
        nArray[3][0] = 7;
        nArray[3][1] = 9;
        nArray[4][0] = 4;
        nArray[4][1] = 15;
        RandomGenerator.setSeed(3138471);
        int n = Game.obstacleGetGridSquareCountX();
        short s2 = Game.obstacleGetGridSquareCountY();
        for (int i = 0; i < n; ++i) {
            for (s = 0; s < s2; ++s) {
                Game.sObstacleGrid[i][s] = -1;
            }
        }
        Point2D point2D = Point2D.tmp0;
        for (s = 0; s < 5; s = (short)(s + 1)) {
            int[] nArray2 = nArray[s];
            nArray2[0] = nArray2[0] / (9 / n);
            nArray[s][0] = GCanvas.clamp(nArray[s][0], 1, n - 2);
            int[] nArray3 = nArray[s];
            nArray3[1] = nArray3[1] / (19 / s2);
            nArray[s][1] = GCanvas.clamp(nArray[s][1], 1, s2 - 2);
            if (nArray[s][0] >= n || nArray[s][1] >= s2) {
                GCanvas.dbgLog("Reduce OBSTACLE_COUNT to 2 or disable");
            }
            point2D.set(nArray[s][0], nArray[s][1]);
            Game.obstacleGenerate(s, point2D);
        }
    }

    private static void obstaclesFirstTimeInit() {
        int n;
        sObstacles = new int[5][];
        for (n = 0; n < 5; ++n) {
            Game.sObstacles[n] = new int[7];
        }
        n = Game.obstacleGetGridSquareCountX();
        int n2 = Game.obstacleGetGridSquareCountY();
        sObstacleGrid = new short[n][];
        for (int i = 0; i < n; ++i) {
            Game.sObstacleGrid[i] = new short[n2];
        }
        Game.obstaclesInit();
    }

    private static void obstacleGenerate(short s, Point2D point2D) {
        int n = Game.obstacleGetGridSquareCountX();
        int n2 = Game.obstacleGetGridSquareCountY();
        boolean bl = false;
        if (point2D == null) {
            point2D = Point2D.tmp0;
            Game.flowerGenerateGridSqXY(point2D, s, sObstacleGrid, -1, n, n2);
        } else {
            bl = true;
        }
        Point2D point2D2 = Point2D.tmp1;
        Game.flowerGenerateGridOffset(point2D2, point2D);
        while (!Game.obstacleOkToGenerateHere(point2D, point2D2, n, n2)) {
            if (!bl) {
                Game.flowerGenerateGridSqXY(point2D, s, sObstacleGrid, -1, n, n2);
            }
            Game.flowerGenerateGridOffset(point2D2, point2D);
        }
        Game.obstacleAdd(10, point2D.x, point2D.y, point2D2.x, point2D2.y, s);
    }

    private static void obstacleAdd(int n, int n2, int n3, int n4, int n5, short s) {
        Game.sObstacleGrid[n2][n3] = s;
        int[] nArray = sObstacles[s];
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = n3;
        nArray[3] = n4;
        nArray[4] = n5;
        nArray[6] = 0;
        nArray[5] = Game.obstacleGetAnimFrame(nArray[6], n2 + n2);
    }

    private static boolean obstacleOkToGenerateHere(Point2D point2D, Point2D point2D2, int n, int n2) {
        if (point2D.y == 0 || point2D.x == n || point2D.y == 0 || point2D.y == n2) {
            return false;
        }
        return sObstacleGrid[point2D.x][point2D.y] == -1;
    }

    private static int obstacleGetGridSquareCountX() {
        return (sFlowerWorldMaxX - sFlowerWorldMinX) / 204800;
    }

    private static int obstacleGetGridSquareCountY() {
        return (sFlowerWorldMaxY - sFlowerWorldMinY) / 204800;
    }

    private static boolean pointInEllipse(int n, int n2, int n3, int n4, int n5, int n6) {
        Point2D point2D = Point2D.tmp1;
        point2D.set(n - n3, n2 - n4);
        if (n5 > n6) {
            int n7 = n5 / n6;
            point2D.y *= n7;
            if (point2D.x * point2D.x + point2D.y * point2D.y < n5 * n5) {
                return true;
            }
        } else {
            int n8 = n6 / n5;
            point2D.x *= n8;
            if (point2D.x * point2D.x + point2D.y * point2D.y < n6 * n6) {
                return true;
            }
        }
        return false;
    }

    public static boolean obstacleToPlayerCollide(Bee bee) {
        int n = Game.obstacleQueryClosest(bee.getWorldPositionX(), bee.getWorldPositionY(), 307200L);
        if (n != -1) {
            int[] nArray = sObstacles[n];
            int n2 = Game.getScreenXFromWorldPosX(bee.getWorldPositionX());
            int n3 = Game.getScreenYFromWorldPos(bee.getWorldPositionX(), bee.getWorldPositionY());
            Point2D point2D = Point2D.tmp2;
            Game.obstacleGetScreenCollisionCentre(nArray, point2D);
            if (Game.pointInEllipse(n2, n3, point2D.x, point2D.y, 28, 16)) {
                bee.negateMoveBack();
                Point2D point2D2 = Point2D.tmp4;
                point2D2.set(n2 - point2D.x, n3 - point2D.y);
                bee.deflectVel(point2D2);
                nArray[6] = 1;
                nArray[5] = Game.obstacleGetAnimStart(nArray[6]);
                return true;
            }
        }
        return false;
    }

    private static int obstacleQueryClosest(int n, int n2, long l) {
        int n3 = Game.obstacleGetGridX(n);
        int n4 = Game.obstacleGetGridY(n2);
        int n5 = (int)(l / 204800L + 1L);
        int n6 = Game.obstacleGetGridSquareCountX();
        int n7 = Game.obstacleGetGridSquareCountY();
        int n8 = GCanvas.clamp(n3 - n5, 0, n6);
        int n9 = GCanvas.clamp(n3 + n5, 0, n6);
        int n10 = GCanvas.clamp(n4 - n5, 0, n7);
        int n11 = GCanvas.clamp(n4 + n5, 0, n7);
        int[] nArray = null;
        int n12 = -1;
        long l2 = l * l >> 10;
        long l3 = Long.MAX_VALUE;
        for (int i = n8; i < n9; ++i) {
            for (int j = n10; j < n11; ++j) {
                int n13 = sObstacleGrid[i][j];
                if (n13 == -1 || (l3 = Game.obstacleGetDistSq(nArray = sObstacles[n13], n, n2)) >= l2) continue;
                n12 = n13;
                l2 = l3;
            }
        }
        return n12;
    }

    private static int obstacleGetWorldPosX(int[] nArray) {
        return Game.obstacleGetWorldPosX(nArray[1], nArray[3]);
    }

    private static int obstacleGetWorldPosX(int n, int n2) {
        return sFlowerWorldMinX + n2 + n * 204800;
    }

    private static int obstacleGetWorldPosY(int[] nArray) {
        return Game.obstacleGetWorldPosY(nArray[2], nArray[4]);
    }

    private static int obstacleGetWorldPosY(int n, int n2) {
        return sFlowerWorldMinY + n2 + n * 204800;
    }

    private static int obstacleGetGridX(int n) {
        return (n - sFlowerWorldMinX) / 204800;
    }

    private static int obstacleGetGridY(int n) {
        return (n - sFlowerWorldMinY) / 204800;
    }

    private static long obstacleGetDistSq(int[] nArray, int n, int n2) {
        return Game.obstacleGetDistSq(Game.obstacleGetWorldPosX(nArray), Game.obstacleGetWorldPosY(nArray), n, n2);
    }

    private static long obstacleGetDistSq(int n, int n2, int n3, int n4) {
        long l = n - n3;
        l *= l;
        long l2 = n2 - n4;
        l2 <<= 1;
        l2 *= l2;
        return l + l2 >> 10;
    }

    private static int obstacleGetAnimStart(int n) {
        return RM.getValue(63, n, 0);
    }

    private static int obstacleGetAnimFrame(int n, int n2) {
        int n3 = RM.getValue(63, n, 0);
        int n4 = RM.getValue(63, n, 1);
        int n5 = RM.getValue(63, n, 2);
        int n6 = 0;
        switch (n5) {
            case 0: {
                n6 = GL.mathModWrap(n2, n3, n4);
                break;
            }
            case 1: {
                n6 = GL.mathClamp(n2, n3, n4);
            }
        }
        return n6;
    }

    private static void obstacleGetScreenCollisionCentre(int[] nArray, Point2D point2D) {
        Game.flowerCalcScreenPosFromWorldOnGround(Game.obstacleGetWorldPosX(nArray), Game.obstacleGetWorldPosY(nArray), point2D);
        point2D.x += -3;
        point2D.y += 13;
    }

    private static void candyInit() {
        sCandySpriteIdx = 11;
        sCandySpawnDelayMin = 100;
        sCandySpawnDelayMax = 200;
        sCandyFlashTime = 40;
        Game.candyReset();
    }

    private static void candyReset() {
        sCandyTimer = 0;
        sCandyAnimFrame = 0;
        sCandyLifeTime = 0;
        sCandyPresent = false;
        sCandyHarvested = false;
        sCandySpawnDelay = RandomGenerator.nextIntInRange(sCandySpawnDelayMin, sCandySpawnDelayMax);
        sCandyFlashOn = true;
    }

    private static boolean candyInitialGenerationDone() {
        return sFlowersCount != 0;
    }

    private static void candyCreate() {
        if (Game.candyInitialGenerationDone()) {
            // empty if block
        }
        Game.flowerGenerate(playerCar, -2);
        sCandyPresent = true;
        sCandyLifeTime = RandomGenerator.nextIntInRange(300, 400);
        sCandyTimer = 0;
        sCandySpawnDelay = 0;
        sCandyHarvested = false;
    }

    private static void candyDestroy() {
        Game.candyReset();
    }

    private static void candyStartFlash() {
        sCandyTimer = sCandyLifeTime - sCandyFlashTime;
    }

    private static void candyHarvest() {
        Point2D point2D = Point2D.tmp1;
        Game.flowerCalcScreenPos(sCandyFlowerIdx, point2D);
        int n = GCanvas.getWidth();
        int n2 = GCanvas.getHeight();
        for (int i = 0; i < 25; ++i) {
            Game.hudSparksAdd(0, n, 0, n2);
        }
        Game.beeAwardGive(100, 20000);
        sCandyHarvested = true;
        Game.comboAbort();
        Game.flowerRemove(sCandyFlowerIdx);
        Game.hudScoreEffectStart(20000);
        Game.candyStartFlash();
    }

    private static void candyUpdate() {
        if (sCandyPresent) {
            int n = GCanvas.getGlobalFrameCount();
            if (sCandyTimer >= sCandyLifeTime - sCandyFlashTime && n % 4 == 0) {
                boolean bl = sCandyFlashOn = !sCandyFlashOn;
            }
            if (n % 4 == 0) {
                sCandyAnimFrame = GL.mathModWrap(sCandyAnimFrame + 1, 0, 3);
            }
            if (sCandyTimer > sCandyLifeTime) {
                Game.candyDestroy();
            }
            if (sCandyHarvested) {
                ++sCandyTimer;
            }
        } else {
            if (sCandyTimer > sCandySpawnDelay) {
                Game.candyCreate();
            }
            ++sCandyTimer;
        }
    }

    private static final void tutorialFirstTimeInit() {
        sTutorialMessagesToDisplay = new int[32][2];
        Game.tutorialInit();
    }

    private static final void tutorialInit() {
        sTutorialNumMessagesToDisplay = 0;
    }

    private static boolean tutorialAllMessagesDisplayed() {
        for (int i = 0; i < 5; ++i) {
            if (Game.tutorialMessageDisplayed(i)) continue;
            return false;
        }
        return true;
    }

    public static final boolean tutorialMessageDisplayed(int n) {
        return Menu.isOptionBitSet(5, n);
    }

    private static final void tutorialDisplayMessage(int n) {
        try {
            if (n > 32) {
                GCanvas.dbgLog("Game: tutorialDisplayMessage: more than max num messages...can't use 32 bit int now.");
                GL.dbgBreak();
                throw new IllegalArgumentException();
            }
            Game.showMessage(RM.getValue(61, n, 0));
            Menu.setOptionBit(5, n);
            if (Game.tutorialAllMessagesDisplayed()) {
                Menu.saveOptions();
            }
        }
        catch (Exception exception) {
            GCanvas.dbgLog("Game: tutorialDisplayMessage: message ID = ." + n);
            GL.dbgBreak();
            throw new IllegalArgumentException();
        }
    }

    public static final void tutorialUpdate() {
        try {
            if (!Game.tutorialMessageDisplayed(0)) {
                Game.tutorialDisplayMessage(0);
            } else if (Game.tutorialMessageDisplayed(0) && !Game.tutorialMessageDisplayed(1)) {
                Game.tutorialDisplayMessage(1);
            } else if (Game.tutorialMessageDisplayed(3) && !Game.tutorialMessageDisplayed(4)) {
                Game.tutorialDisplayMessage(4);
            }
            for (int i = 0; i < sTutorialNumMessagesToDisplay; ++i) {
                if (sTutorialMessagesToDisplay[i][1] <= 0) {
                    int n = sTutorialMessagesToDisplay[i][0];
                    if (!Game.tutorialMessageDisplayed(n)) {
                        Game.tutorialDisplayMessage(n);
                    }
                    Game.tutorialRemoveDisplayMessage(i);
                    continue;
                }
                int[] nArray = sTutorialMessagesToDisplay[i];
                nArray[1] = nArray[1] - 1;
            }
        }
        catch (Exception exception) {
            GCanvas.dbgLog("Game: tutorialUpdate: sTutor55ialNumMessagesToDisplay = " + sTutorialNumMessagesToDisplay);
            GL.dbgBreak();
            throw new IllegalArgumentException();
        }
    }

    public static final void tutorialAddDisplayMessage(int n, int n2) {
        try {
            Game.sTutorialMessagesToDisplay[Game.sTutorialNumMessagesToDisplay][0] = n;
            Game.sTutorialMessagesToDisplay[Game.sTutorialNumMessagesToDisplay][1] = n2;
            ++sTutorialNumMessagesToDisplay;
        }
        catch (Exception exception) {
            GCanvas.dbgLog("Game: tutorialAddDisplayMessage: sTutorialNumMessagesToDisplay = " + sTutorialNumMessagesToDisplay);
            GL.dbgBreak();
            throw new IllegalArgumentException();
        }
    }

    private static final void tutorialRemoveDisplayMessage(int n) {
        try {
            if (sTutorialNumMessagesToDisplay > 1) {
                Game.sTutorialMessagesToDisplay[n][0] = sTutorialMessagesToDisplay[sTutorialNumMessagesToDisplay - 1][0];
                Game.sTutorialMessagesToDisplay[n][1] = sTutorialMessagesToDisplay[sTutorialNumMessagesToDisplay - 1][1];
            }
            --sTutorialNumMessagesToDisplay;
        }
        catch (Exception exception) {
            GCanvas.dbgLog("Game: tutorialRemoveDisplayMessage: sTutorialNumMessagesToDisplay = " + sTutorialNumMessagesToDisplay);
            GL.dbgBreak();
            throw new IllegalArgumentException();
        }
    }

    public static void sfxPlayLogicSound(int n) {
        int n2 = RM.getValue(37, n, 0);
        int n3 = RM.getValue(37, n, 1);
        if (n2 != -1) {
            Menu.playSound(n2);
        }
        if (n3 != 0) {
            int n4 = RM.getValue(36, n3);
        }
    }

    public static String readMoreGamesUrl() {
        return GL.handsonMoreGamesReadUrl();
    }

    private static boolean demoIsDemoExpired() {
        return sDemoNumHarvestedFlowers >= 15;
    }

    private static void demoPrintIngameDemoMode(Graphics graphics) {
        if (Menu.getCurrentMenu() == 17) {
            return;
        }
        if (GCanvas.getGlobalFrameCount() % 20 > 10) {
            graphics.setFont(GCanvas.FONT_SMALL);
            int n = 1;
            int n2 = 1;
            graphics.setColor(-16777216);
            graphics.drawString(RM.t(82), n - 1, n2 - 1, 20);
            graphics.drawString(RM.t(82), n + 1, n2 - 1, 20);
            graphics.drawString(RM.t(82), n - 1, n2 + 1, 20);
            graphics.drawString(RM.t(82), n + 1, n2 + 1, 20);
            graphics.setColor(-256);
            graphics.drawString(RM.t(82), n, n2, 20);
        }
    }

    private static void demoPrintMenuDemoMode(Graphics graphics) {
        Game.demoPrintIngameDemoMode(graphics);
    }

    public static void demoHandleDemoMode(Graphics graphics) {
        if (!GL.handsonDemoIsActive()) {
            return;
        }
        if (Menu.getMode() == 2) {
            Game.demoPrintIngameDemoMode(graphics);
            if (Game.demoIsDemoExpired()) {
                Menu.changeMenu(26, false);
            }
        } else {
            Game.demoPrintMenuDemoMode(graphics);
        }
    }

    public static final void drawSoftkeyLabels(Graphics graphics, int n, int n2, String string, boolean bl) {
        if (Menu.getCurrentMenu() == 4) {
            graphics.setColor(-3402);
            graphics.drawString(string, n + 1, n2, bl ? 36 : 40);
            graphics.drawString(string, n - 1, n2, bl ? 36 : 40);
            graphics.drawString(string, n, n2 + 1, bl ? 36 : 40);
            graphics.drawString(string, n, n2 - 1, bl ? 36 : 40);
            graphics.setColor(-16777216);
            graphics.drawString(string, n, n2, bl ? 36 : 40);
        } else if (!(Menu.getCurrentMenu() != 8 && Menu.getCurrentMenu() != 21 || bl)) {
            graphics.setColor(-3402);
            graphics.fillRoundRect(n - 1 - GCanvas.getStringWidth(string), n2 - GCanvas.getFontHeight(), GCanvas.getStringWidth(string) + 1, GCanvas.getFontHeight(), 3, 3);
            graphics.setColor(-16777216);
            graphics.drawString(string, n, n2, bl ? 36 : 40);
        } else {
            graphics.setColor(-16777216);
            graphics.drawString(string, n, n2, bl ? 36 : 40);
        }
    }

    static {
        mapBounds = new int[4];
        carBounds = new int[4];
        gameMessageWaitOneFrame = false;
        waitForPlayer = true;
        hudCounterValuesNew = new int[7];
        hudCounterValues = new int[7];
        hudCounterFrames = new int[19];
        sEnergyStart = sMaxEnergy = 1024;
        HUD_FLOWER_ICON_COLORS = new int[]{-15722315, -6540825, -4359416, -4904704, -5373977};
        sPreparedSoundId = null;
        sHighscorePos = 0;
        sLastDrawnFrame = 0;
        sSteeringAngle = 0;
        ENERGY_WARNING_START_VAL = 204;
        sHudScoreDigitWidth = 0;
        sHudScoreDigitHeight = 0;
        hudTabsType = null;
        hudTabsY = null;
        hudTabsLastRenderPos = null;
        hudTabsDY = null;
        hudTabDirty = 0;
        hudTabsWidth = 0;
        hudTabsHeight = 0;
        hudTabsLeft = 0;
        hudTabsBottom = 0;
        hudSparksIntensity = 0;
        hudSparks = null;
        hudSparksNumFrames = 0;
        hudSparksNumSpawnFP = 0;
        hudSparksY = 0;
        hudSparksDY = 0;
        hudSparksComboAward = false;
        hudSparksKillAll = false;
        sHudScoreEffectDelta = 0;
        sHudScoreEffectTimer = 0;
        sHudScoreEffectPosY = 0;
        sHudScoreEffectVY = 0;
        sHudScoreEffectChainLength = 0;
        sHighscoreNameCharacters = "_ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".getBytes();
        sHighscoreNameBytes = new byte[3];
        sHighscoreNameIndices = new byte[3];
        sHighscoreNameCursorPos = 0;
        sHighscoreNeedsInit = false;
        sHelpMenuTextIsPrepared = false;
        sOutroTimer = 0;
        sSwitchToOutroTimer = 0;
        sFlowers = null;
        sFlowerGrid = null;
        FLOWER_TYPE_ATTRIBUTES = null;
        sFlowerClosestOfType = null;
        sFlowerCurrentClosestOfTypeDistSq = null;
        sFlowerGridSquareSizeY = sFlowerGridSquareSizeX = 153600;
        sFlowerWorldMinX = 0;
        sFlowerWorldMaxX = 0;
        sFlowerWorldMinY = 0;
        sFlowerWorldMaxY = 0;
        sFlowerCountLevelFull = 0;
        sFlowersCount = 0;
        sFlowerNumTypesAvailable = 2;
        sFlowerFirstTimeInit = true;
        sComboFlowersSinceLast = null;
        sComboFlowers = null;
        sComboCount = 0;
        sComboKnown = 0;
        sComboFlowerCount = 0;
        sObstacles = null;
        sObstacleGrid = null;
        sCandyTimer = 0;
        sCandyLifeTime = 0;
        sCandyAnimFrame = 0;
        sCandySpawnDelay = 0;
        sCandySpriteIdx = 0;
        sCandyFlowerIdx = 0;
        sCandyPresent = false;
        sCandyHarvested = false;
        sCandyFlashOn = true;
        sCandyFlashTime = 0;
        sCandySpawnDelayMin = 0;
        sCandySpawnDelayMax = 0;
        sTutorialMessagesToDisplay = null;
        sTutorialNumMessagesToDisplay = 0;
        sDemoNumHarvestedFlowers = 0;
    }
}

