/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.L2CAPConnectionNotifier;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;

final class Bluetooth
implements Runnable,
DiscoveryListener {
    public LocalDevice m_LocalDevice;
    public DeviceClass m_LocalDeviceClass;
    public RemoteDevice[] m_RemoteDevices = new RemoteDevice[32];
    public RemoteDevice[] m_RemoteUsefulDevices = new RemoteDevice[32];
    public ServiceRecord[][] m_RemoteServiceRecords = new ServiceRecord[32][];
    public int m_ServiceSearchTransID = -1;
    public int m_ServiceSearchDeviceID;
    public int m_nNumRemoteDevices;
    public int m_nNumRemoteUsefulDevices;
    public L2CAPConnection m_BluetoothConnection;
    public L2CAPConnectionNotifier m_Server;
    public byte[] m_BluetoothMessage = new byte[100];
    public String UUID_STRING = "05e46f4f160d4640bcba0a5aa0b4359a";
    public String SERVICE_NAME = "NBCO";
    public String SERVER_URL = "btl2cap://localhost:" + this.UUID_STRING + ";authenticate=false" + ";authorize=false" + ";encrypt=false" + ";name=" + this.SERVICE_NAME;
    public boolean m_bSearchingNetwork = false;
    public boolean m_bCanSearchingServices = false;
    public boolean m_bWaitingForConnectionACK = false;
    public boolean m_ErrorOccured = false;
    public int m_ErrorType;
    public boolean m_RemotePlayerHasPaused = false;
    public boolean isCloseConnection;

    public Bluetooth() throws BluetoothStateException {
        this.m_LocalDevice = LocalDevice.getLocalDevice();
        this.m_LocalDeviceClass = this.m_LocalDevice.getDeviceClass();
        this.btCloseConnection();
        this.isCloseConnection = false;
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        if (this.isCloseConnection) {
            return;
        }
        System.out.println("deivece discoverd ........");
        if (deviceClass.getMajorDeviceClass() == this.m_LocalDeviceClass.getMajorDeviceClass() && deviceClass.getMinorDeviceClass() == this.m_LocalDeviceClass.getMinorDeviceClass()) {
            this.m_RemoteDevices[this.m_nNumRemoteDevices++] = remoteDevice;
        }
    }

    public void inquiryCompleted(int n) {
        if (this.isCloseConnection) {
            return;
        }
        System.out.println("inquiryCompleted : " + this.m_nNumRemoteDevices + " discovered");
        if (this.m_nNumRemoteDevices == 0) {
            this.btStopResearch();
            Game.RefreshRemoteDevices();
        } else {
            this.m_ServiceSearchDeviceID = -1;
            this.m_bCanSearchingServices = true;
        }
    }

    public void StartSearchServices(int n) {
        if (this.isCloseConnection) {
            return;
        }
        System.out.println("start searching devices");
        try {
            this.m_bCanSearchingServices = false;
            UUID[] uUIDArray = new UUID[]{new UUID(this.UUID_STRING, false)};
            int[] nArray = null;
            this.m_ServiceSearchDeviceID = n;
            this.m_ServiceSearchTransID = this.m_LocalDevice.getDiscoveryAgent().searchServices(nArray, uUIDArray, this.m_RemoteDevices[n], (DiscoveryListener)this);
        }
        catch (Exception exception) {
            this.btConnectionErrorOccured();
        }
    }

    public int GetDeviceIdFromTransID(int n) {
        if (this.isCloseConnection) {
            return -1;
        }
        if (n == this.m_ServiceSearchTransID) {
            return this.m_ServiceSearchDeviceID;
        }
        return -1;
    }

    public void servicesDiscovered(int n, ServiceRecord[] serviceRecordArray) {
        if (this.isCloseConnection) {
            return;
        }
        System.out.println("services discoverd......");
        int n2 = this.GetDeviceIdFromTransID(n);
        if (n2 == -1) {
            return;
        }
        try {
            this.m_RemoteServiceRecords[this.m_nNumRemoteUsefulDevices] = serviceRecordArray;
            this.m_RemoteUsefulDevices[this.m_nNumRemoteUsefulDevices] = this.m_RemoteDevices[n2];
            ++this.m_nNumRemoteUsefulDevices;
            Game.RefreshRemoteDevices();
        }
        catch (Exception exception) {
            this.btConnectionErrorOccured();
        }
    }

    public void serviceSearchCompleted(int n, int n2) {
        if (this.isCloseConnection) {
            return;
        }
        System.out.println("serviceSearchCompleted");
        int n3 = this.GetDeviceIdFromTransID(n);
        if (n3 == -1) {
            return;
        }
        this.m_bCanSearchingServices = true;
    }

    public void btSendRandomSync(int n) {
        if (this.isCloseConnection) {
            return;
        }
        System.out.println("btSendRandomSync");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.m_BluetoothMessage.length);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(0);
            dataOutputStream.writeInt(n);
            this.m_BluetoothConnection.send(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            this.btConnectionErrorOccured();
        }
    }

    public void btSendCursorUpdate(int n, int n2) {
        if (this.isCloseConnection) {
            return;
        }
        System.out.println("btSendCursorUpdate");
        if ((Game.m_sm_stack[Game.m_sm_depth] & Integer.MAX_VALUE) != 2) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.m_BluetoothMessage.length);
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeByte(1);
                dataOutputStream.writeInt(n);
                dataOutputStream.writeInt(n2);
                this.m_BluetoothConnection.send(byteArrayOutputStream.toByteArray());
            }
            catch (Exception exception) {
                this.btConnectionErrorOccured();
            }
        }
    }

    public void btSendCursorSelect() {
        if (this.isCloseConnection) {
            return;
        }
        System.out.println("btSendCursorSelect");
        if ((Game.m_sm_stack[Game.m_sm_depth] & Integer.MAX_VALUE) != 2) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.m_BluetoothMessage.length);
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeByte(2);
                this.m_BluetoothConnection.send(byteArrayOutputStream.toByteArray());
            }
            catch (Exception exception) {
                this.btConnectionErrorOccured();
            }
        }
    }

    public void btUpdateResearch() {
        if (this.isCloseConnection) {
            return;
        }
        if (this.m_bSearchingNetwork && this.m_nNumRemoteDevices > 0 && this.m_bCanSearchingServices) {
            if (this.m_ServiceSearchDeviceID < this.m_nNumRemoteDevices - 1) {
                this.StartSearchServices(this.m_ServiceSearchDeviceID + 1);
            } else {
                this.btStopResearch();
                Game.RefreshRemoteDevices();
            }
        }
    }

    public boolean btHandleReceivedMessages() {
        if (this.isCloseConnection) {
            return false;
        }
        System.out.println("handdleReceivedMessages = " + (this.m_BluetoothConnection != null));
        if (this.m_BluetoothConnection == null) {
            return false;
        }
        boolean bl = false;
        try {
            bl = this.m_BluetoothConnection.ready();
            if (bl) {
                int n = this.m_BluetoothConnection.receive(this.m_BluetoothMessage);
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.m_BluetoothMessage, 0, n));
                while (dataInputStream.available() > 0) {
                    byte by = dataInputStream.readByte();
                    this.btReceiveMessage(by, dataInputStream);
                }
            }
        }
        catch (Exception exception) {
            this.btConnectionErrorOccured();
        }
        return bl;
    }

    public void btReceiveMessage(byte by, DataInputStream dataInputStream) {
        if (this.isCloseConnection) {
            return;
        }
        System.out.println("receiveMessage .........");
        try {
            switch (by) {
                case 15: {
                    dataInputStream.readByte();
                    this.btConnectionErrorOccured();
                    break;
                }
                case 0: {
                    Game.m_SyncRandomSeed = dataInputStream.readInt();
                    break;
                }
                case 1: {
                    Game.m_MultiCursorPositionX = dataInputStream.readInt();
                    Game.m_MultiCursorPositionY = dataInputStream.readInt();
                    break;
                }
                case 2: {
                    Game.m_MultiHasSelected = true;
                    break;
                }
                case 3: {
                    byte by2 = dataInputStream.readByte();
                    byte[] byArray = Game.m_Fleets[Game.m_OpponentTerritory][by2];
                    byArray[2] = dataInputStream.readByte();
                    byArray[3] = dataInputStream.readByte();
                    byArray[4] = dataInputStream.readByte();
                    if (Game.m_BoatSprites[Game.m_OpponentTerritory][byArray[1]] != null) {
                        Game.AddObjectToOrder(Game.m_OpponentTerritory, byArray);
                        Game.SortObjects(Game.m_OpponentTerritory);
                    }
                    Game.ConfirmBoatPlacement(Game.m_OpponentTerritory, by2, byArray);
                    break;
                }
                case 4: {
                    byte by3 = dataInputStream.readByte();
                    byte[] byArray = null;
                    if (by3 != -1) {
                        byArray = Game.m_Fleets[Game.m_PlayingTerritory][by3];
                    }
                    Game.SelectSpecialMove(byArray);
                    break;
                }
                case 5: {
                    dataInputStream.readByte();
                    this.btSendByte((byte)6, (byte)0);
                    break;
                }
                case 6: {
                    dataInputStream.readByte();
                    this.m_bWaitingForConnectionACK = false;
                    break;
                }
                case 7: {
                    byte by4 = dataInputStream.readByte();
                    this.m_RemotePlayerHasPaused = by4 != 0;
                    break;
                }
                case 8: {
                    this.btConnectionErrorOccured(1, true);
                    break;
                }
                case -125: {
                    byte by5 = dataInputStream.readByte();
                    Game.m_HasRequestedLoadGameState = false;
                    Game.LoadGameMode(by5);
                    Game.m_GameFlags |= 6;
                    Game.m_LocalTerritory = this.m_Server != null ? 0 : 1;
                    Game.m_OpponentTerritory = 1 - Game.m_LocalTerritory;
                    break;
                }
                case 21: {
                    byte by6 = dataInputStream.readByte();
                    Game.m_OpponentFaction = by6;
                    Game.m_LocalFaction = 1 - Game.m_OpponentFaction;
                    break;
                }
                case 22: {
                    byte by7 = dataInputStream.readByte();
                    Game.m_OpponentAvatar = by7;
                    if (this.m_Server != null) break;
                    if (Game.m_OpponentFaction == 1) {
                        Game.EmilyPopMenu(false);
                        Game.EmilyPushMenu(889);
                        break;
                    }
                    Game.EmilyPopMenu(false);
                    Game.EmilyPushMenu(872);
                    break;
                }
                case 9: {
                    dataInputStream.readByte();
                    Game.RequestStartGameplay();
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.btConnectionErrorOccured();
        }
    }

    public void btSendByte(byte by, byte by2) {
        if (this.isCloseConnection) {
            return;
        }
        System.out.println("btSendByte (type=" + by + ", byte=" + by2 + ")");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(by);
            dataOutputStream.writeByte(by2);
            this.m_BluetoothConnection.send(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            this.btConnectionErrorOccured();
        }
    }

    public void btSendBoat(byte by, byte[] byArray) {
        if (this.isCloseConnection) {
            return;
        }
        System.out.println(" sendboat .......");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(5);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(3);
            dataOutputStream.writeByte(by);
            dataOutputStream.writeByte(byArray[2]);
            dataOutputStream.writeByte(byArray[3]);
            dataOutputStream.writeByte(byArray[4]);
            this.m_BluetoothConnection.send(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            this.btConnectionErrorOccured();
        }
    }

    public void btCreateServer() {
        try {
            Game.RefreshLocalDeviceName();
            this.m_ErrorOccured = false;
            this.btCloseConnection();
            this.m_LocalDevice.setDiscoverable(10390323);
            Thread thread = new Thread(this);
            thread.start();
        }
        catch (Exception exception) {
            this.btConnectionErrorOccured();
        }
    }

    public void btLookForServers() {
        if (this.isCloseConnection) {
            return;
        }
        try {
            this.m_ErrorOccured = false;
            this.btCloseConnection();
            this.m_bSearchingNetwork = true;
            this.m_bCanSearchingServices = false;
            this.m_LocalDevice.setDiscoverable(0);
            this.m_LocalDevice.getDiscoveryAgent().startInquiry(10390323, (DiscoveryListener)this);
            Game.RefreshRemoteDevices();
        }
        catch (Exception exception) {
            this.btConnectionErrorOccured();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void btConnectToServer(int n) {
        System.out.println("connect to server .......");
        try {
            this.btStopResearch();
            String string = this.m_RemoteServiceRecords[n][0].getConnectionURL(0, false);
            this.m_BluetoothConnection = (L2CAPConnection)Connector.open((String)string);
            if (this.m_BluetoothConnection == null) return;
        }
        catch (Exception exception) {
            this.btConnectionErrorOccured();
        }
    }

    public void btStopResearch() {
        if (this.isCloseConnection) {
            return;
        }
        System.out.println("stop searching devices........");
        if (this.m_bSearchingNetwork) {
            this.m_bSearchingNetwork = false;
            this.m_bCanSearchingServices = false;
            this.m_LocalDevice.getDiscoveryAgent().cancelInquiry((DiscoveryListener)this);
            this.m_ServiceSearchDeviceID = -1;
            int n = this.m_ServiceSearchTransID;
            if (n != -1) {
                this.m_ServiceSearchTransID = -1;
                this.m_LocalDevice.getDiscoveryAgent().cancelServiceSearch(n);
            }
        }
    }

    public void uyCloseConnection() {
        try {
            if (this.m_BluetoothConnection != null) {
                this.m_BluetoothConnection = null;
            }
            if (this.m_Server != null) {
                this.m_Server.close();
                this.m_Server = null;
            }
            this.isCloseConnection = false;
        }
        catch (Exception exception) {
            System.out.println("error when close connection.................");
        }
    }

    public void btCloseConnection() {
        System.out.println("btStopResearch");
        try {
            this.m_LocalDevice.setDiscoverable(0);
            this.m_nNumRemoteDevices = 0;
            this.m_nNumRemoteUsefulDevices = 0;
            this.m_bWaitingForConnectionACK = false;
            this.m_RemotePlayerHasPaused = false;
            if (this.m_BluetoothConnection != null) {
                byte by = 15;
                System.out.println("Bluetooth.......................................flag disconnect");
                this.btSendByte(by, by);
            }
            this.btStopResearch();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void btConnectionErrorOccured() {
        this.btConnectionErrorOccured(0, true);
    }

    public void btConnectionErrorOccured(int n, boolean bl) {
        if (this.isCloseConnection) {
            return;
        }
        System.out.println("btConnectionErrorOccured");
        if (bl) {
            this.btCloseConnection();
            this.isCloseConnection = true;
        }
        if (!this.m_ErrorOccured) {
            this.m_ErrorOccured = true;
            this.m_ErrorType = n;
        }
    }

    public void run() {
        System.out.println("run...........");
        try {
            if (this.m_Server == null) {
                this.m_Server = (L2CAPConnectionNotifier)Connector.open((String)this.SERVER_URL);
            }
            this.m_BluetoothConnection = this.m_Server.acceptAndOpen();
            if (this.m_BluetoothConnection != null) {
                this.btSendRandomSync(Game.m_SyncRandomSeed);
                Game.EmilyPopMenu(false);
                Game.EmilyPushMenu(757);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

