/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class GameWorld
implements Constants {
    public int state;
    public static boolean debugScript;
    public int viewY;
    public static int viewHeight;
    public static int[] mapView;
    public boolean lockScrollingX;
    public boolean lockScrollingY;
    public int scrollSpeed = -1;
    public static int level;
    public static int unlockLevelRecord;
    public static int tileSheetGround;
    public int tileSheetMiddle;
    public static short[] map;
    public static int mapRows;
    public static int mapCols;
    public static int mapWidth;
    public static int mapHeight;
    public static GameObject player;
    public GameObject player_ele;
    public GameObject player_tiger;
    public GameObject player_sid;
    public static GameObject observeObject;
    public GameObject preFocusedObject;
    public Vector objects;
    public Vector objectsToAdd;
    public Vector objectsToRemove;
    public Vector objectsOnScreen;
    public Vector objectsOnScreenBottom;
    public GameObject focusedObject;
    public GameObject conversationObject;
    public GameObject hintObject;
    public static GameObject interfaceObject;
    public static Vector bonusObjects;
    public Vector objectsInRange;
    public Vector interactObjects = new Vector();
    public int[] interactTile;
    public int[] interactArea;
    public static Hashtable assignedMappings;
    public Hashtable areas;
    public Vector tickableScripts;
    public int[][][] loadedScripts;
    public Hashtable levelObjects;
    public Hashtable quests;
    public static int tileSize;
    public static SGSprite[][] tiles;
    public static SGSprite tileGroundBaseSprite;
    public static SGSprite tileMiddleBaseSprite;
    public static SGSprite tileSharedBaseSprite;
    public static DeviceImage[] speechBubbleArrowImages;
    public static SGSprite[] sprites;
    public SGSprite actionIconSprite;
    public static SGSprite interfaceSprite;
    public int[] cameraScriptHeader;
    public int[] fadeScriptHeader;
    public static boolean drawHud;
    public static boolean bIsPlayerChanged;
    public int playerChangeTick = -1;
    public int bonusTick = -1;
    public int savedAnimals = 0;
    public int savingAnimals = 0;
    public int ateBonusCount = 0;
    public int currentLevelTotalBonusCount = 0;
    public static boolean isTigerOnEle;
    public static boolean isPlayerDie;
    public static boolean isSidOnStage;
    public static boolean isTigerOnStage;
    public static int tigerJumpTile;
    public static boolean isPlayerOnIce;
    public static boolean isObserveStyle;
    public static boolean isPlayerMoveStone;
    public static int swampTick;
    public static int swampHeight;
    public static int[] swampClipRect;
    public static boolean isPlayerOnSwamp;
    public static GameObject swampRipple;
    public static GameObject swampRippleUp;
    public static GameObject swampRippleDown;
    public boolean dialogTicked;
    public GameObject dialogSpeechBubble;
    public GameObject dialogSpeaker;
    public int dialogTick = -1;
    public static boolean playerLocked;
    public AStarNode currentNode;
    public String enteringLevelName;
    public String caption;
    public GameObject scriptTextBubble;
    public static int endLevelTick;
    public static boolean bWin;
    public static int currentLevelTimeLimit;
    public static int levelTimeTick;
    public static int restTime;
    public boolean bIsFreezeTime;
    public static boolean isIGM;
    public static final String[] TILESHEET_GROUND_NAMES;
    public static final String[] TILESHEET_MIDDLE_NAMES;
    public static final String[] SPRITE_NAMES;
    public static final int[] SPRITE_LOADED;
    private static boolean bStatistics;
    private static int statTick;
    public static int retriesNum;

    public GameWorld() {
        GameObject.gameWorld = this;
    }

    public void init() {
        switch (Engine.loadingProgressDisplay) {
            case 0: {
                tileSize = 16;
                DataManager.initFile("arrays.bin");
                Engine.loadingProgressDisplay = 1;
                break;
            }
            case 1: {
                this.loadGfx();
                Engine.loadingProgressDisplay = 2;
                break;
            }
            case 2: {
                this.initUIValues();
                Engine.loadingProgressDisplay = 3;
                break;
            }
            case 3: {
                this.loadSprites();
                Engine.loadingProgressDisplay = 4;
                break;
            }
            case 4: {
                this.objects = new Vector();
                this.objectsToAdd = new Vector();
                this.objectsToRemove = new Vector();
                this.objectsOnScreen = new Vector();
                this.objectsOnScreenBottom = new Vector();
                this.objectsInRange = new Vector();
                this.levelObjects = new Hashtable();
                Engine.loadingProgressDisplay = 5;
                break;
            }
            case 5: {
                Engine.loadingProgressDisplay = 6;
                break;
            }
            case 6: {
                assignedMappings = new Hashtable();
                this.areas = new Hashtable();
                this.tickableScripts = new Vector();
                Engine.loadingProgressDisplay = 7;
                break;
            }
            case 7: {
                this.loadScripts("level" + level + ".script");
                this.tickScripts();
                Engine.loadingProgressDisplay = 8;
                break;
            }
            case 8: {
                levelTimeTick = Engine.tick;
                currentLevelTimeLimit = 0;
                if (9 == DataManager.LEVEL_TIME_LIMIT.length && level < 9) {
                    currentLevelTimeLimit = 600 * DataManager.LEVEL_TIME_LIMIT[level];
                }
                restTime = currentLevelTimeLimit;
                Engine.loadingProgressDisplay = 9;
                break;
            }
            case 9: {
                ResourceMaster.closeResource();
                Engine.fadeIn(false);
                Engine.loadingProgressDisplay = 10;
                break;
            }
        }
    }

    public void release() {
        int n;
        int n2;
        DataManager.closeFile("arrays.bin");
        this.objects.removeAllElements();
        this.objectsToAdd.removeAllElements();
        this.objectsToRemove.removeAllElements();
        this.objectsOnScreen.removeAllElements();
        this.objectsOnScreenBottom.removeAllElements();
        this.objectsInRange.removeAllElements();
        bonusObjects.removeAllElements();
        map = null;
        SGSprite.releaseAllCaches();
        for (n2 = 0; n2 < this.loadedScripts.length; ++n2) {
            for (n = 0; n < this.loadedScripts[n2].length; ++n) {
                this.loadedScripts[n2][n] = null;
            }
        }
        this.loadedScripts = null;
        for (n2 = 0; n2 < tiles.length; ++n2) {
            for (n = 0; n < tiles[n2].length; ++n) {
                GameWorld.tiles[n2][n] = null;
            }
        }
        tiles = null;
        tileGroundBaseSprite = null;
        tileMiddleBaseSprite = null;
        tileSharedBaseSprite = null;
        for (n2 = 0; n2 < speechBubbleArrowImages.length; ++n2) {
            GameWorld.speechBubbleArrowImages[n2] = null;
        }
        speechBubbleArrowImages = null;
        for (n2 = 0; n2 < sprites.length; ++n2) {
            GameWorld.sprites[n2] = null;
        }
        sprites = null;
        player = null;
        this.player_ele = null;
        this.player_tiger = null;
        this.player_sid = null;
        observeObject = null;
        this.preFocusedObject = null;
        this.focusedObject = null;
        this.conversationObject = null;
        this.hintObject = null;
        swampRipple = null;
        swampRippleUp = null;
        swampRippleDown = null;
        interfaceSprite = null;
        interfaceObject = null;
        assignedMappings = null;
        GameObject.gameWorld = null;
        Engine.loadingProgressDisplay = 8;
        isTigerOnEle = false;
        isSidOnStage = false;
        isTigerOnStage = false;
        tigerJumpTile = -1;
        isPlayerOnIce = false;
        isObserveStyle = false;
        isPlayerMoveStone = false;
        System.gc();
    }

    public void initUIValues() {
        this.viewY = 22;
        viewHeight = Device.HEIGHT - this.viewY;
    }

    public void loadGfx() {
        DeviceImage deviceImage = new DeviceImage(65596);
        speechBubbleArrowImages = new DeviceImage[4];
        GameWorld.speechBubbleArrowImages[0] = deviceImage;
        GameWorld.speechBubbleArrowImages[1] = new DeviceImage(deviceImage, 1);
        GameWorld.speechBubbleArrowImages[2] = new DeviceImage(deviceImage, 5);
        GameWorld.speechBubbleArrowImages[3] = new DeviceImage(deviceImage, 6);
    }

    public void loadSprites() {
        sprites = new SGSprite[41];
        for (int i = 0; i < 41; ++i) {
            if ((SPRITE_LOADED[i] == -1 || (SPRITE_LOADED[i] & 1 << level) != 1 << level) && SPRITE_LOADED[i] != 0) continue;
            GameWorld.sprites[i] = new SGSprite(SPRITE_NAMES[i]);
        }
        interfaceSprite = sprites[0];
    }

    public void loadTileSheets(String string, String string2) {
        int n;
        int n2;
        if (tiles == null) {
            tiles = new SGSprite[3][];
        }
        if (tileGroundBaseSprite == null || !GameWorld.tileGroundBaseSprite.spriteKey.equals(string)) {
            if (tileGroundBaseSprite != null) {
                GameWorld.tiles[0] = null;
                tileGroundBaseSprite.releaseBaseSprite();
                tileGroundBaseSprite = null;
            }
            tileGroundBaseSprite = new SGSprite(string);
            n2 = GameWorld.tileGroundBaseSprite.animationSequences.length;
            GameWorld.tiles[0] = new SGSprite[n2];
            for (n = 0; n < n2; ++n) {
                GameWorld.tiles[0][n] = new SGSprite(tileGroundBaseSprite);
                tiles[0][n].startAnimation(n, 0);
            }
        }
        if (tileMiddleBaseSprite == null || !GameWorld.tileMiddleBaseSprite.spriteKey.equals(string2)) {
            if (tileMiddleBaseSprite != null && !GameWorld.tileMiddleBaseSprite.spriteKey.equals(string2)) {
                GameWorld.tiles[1] = null;
                tileMiddleBaseSprite.releaseBaseSprite();
                tileMiddleBaseSprite = null;
            }
            tileMiddleBaseSprite = new SGSprite(string2);
            n2 = GameWorld.tileMiddleBaseSprite.animationSequences.length;
            GameWorld.tiles[1] = new SGSprite[n2];
            for (n = 0; n < n2; ++n) {
                GameWorld.tiles[1][n] = new SGSprite(tileMiddleBaseSprite);
                tiles[1][n].startAnimation(n, 0);
            }
        }
        if (tileSharedBaseSprite == null) {
            tileSharedBaseSprite = new SGSprite("Shared");
            n2 = GameWorld.tileSharedBaseSprite.animationSequences.length;
            GameWorld.tiles[2] = new SGSprite[n2];
            for (n = 0; n < n2; ++n) {
                GameWorld.tiles[2][n] = new SGSprite(tileSharedBaseSprite);
                tiles[2][n].startAnimation(n, 0);
            }
        }
    }

    public void loadScripts(String string) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(ResourceMaster.getResource(string)));
            int n = dataInputStream.readByte();
            this.loadedScripts = new int[n][][];
            for (int i = 0; i < n; ++i) {
                int n2;
                short s = dataInputStream.readShort();
                boolean bl = dataInputStream.readBoolean();
                int n3 = dataInputStream.readInt();
                boolean bl2 = dataInputStream.readBoolean();
                byte by = dataInputStream.readByte();
                Vector<Integer> vector = new Vector<Integer>();
                vector.addElement(new Integer(s));
                vector.addElement(new Integer(bl ? 1 : 0));
                vector.addElement(new Integer(n3));
                vector.addElement(new Integer(bl2 ? 1 : 0));
                vector.addElement(new Integer(0));
                vector.addElement(new Integer(-1));
                vector.addElement(new Integer(0));
                vector.addElement(new Integer(by));
                int n4 = dataInputStream.readByte();
                for (n2 = 0; n2 < n4; ++n2) {
                    vector.addElement(new Integer(dataInputStream.readShort()));
                }
                n2 = dataInputStream.readByte();
                int[][] nArrayArray = new int[n2 + 1][];
                nArrayArray[0] = Engine.vectorToIntArray(vector);
                for (int j = 0; j < n2; ++j) {
                    nArrayArray[j + 1] = GameWorld.readScriptStep(dataInputStream);
                }
                this.loadedScripts[i] = nArrayArray;
                if (!bl) continue;
                this.tickableScripts.addElement(nArrayArray);
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int[] readScriptStep(DataInputStream dataInputStream) throws Exception {
        byte by = dataInputStream.readByte();
        int[] nArray = new int[DataManager.SCRIPT_STEP_LENGTHS[by] + 1];
        nArray[0] = by;
        for (int i = 1; i < nArray.length; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        return nArray;
    }

    public void tick() {
        int n;
        if (Engine.isPressedRepeat(64) && !bStatistics) {
            isIGM = true;
            Engine.doRepaint();
            Device.soundFunction(1);
            Engine.setMenu(Engine.menuInGame);
            Engine.state = 110;
            Engine.menuCurrent.setCursor(0);
            return;
        }
        if (bStatistics) {
            return;
        }
        if (swampTick != -1) {
            ++swampTick;
        }
        if (this.bonusTick != -1) {
            ++this.bonusTick;
        }
        for (n = 0; n < this.objectsOnScreenBottom.size(); ++n) {
            ((GameObject)this.objectsOnScreenBottom.elementAt(n)).tick();
        }
        for (n = 0; n < this.objectsOnScreen.size(); ++n) {
            ((GameObject)this.objectsOnScreen.elementAt(n)).tick();
        }
        this.removeObjects();
        this.addObjects();
        this.tickScripts();
        this.checkCloseObjects();
        this.enteringLevelName = null;
        for (n = 0; n < tiles.length; ++n) {
            for (int i = 0; i < tiles[n].length; ++i) {
                tiles[n][i].tickAnimation(50);
            }
        }
        if (this.dialogSpeechBubble != null) {
            this.dialogSpeechBubble.tick();
        }
        if (this.scriptTextBubble != null) {
            this.scriptTextBubble.tick();
        }
        if (this.hintObject.sprite.visible) {
            this.hintObject.tick();
        }
        this.scrollView(false);
        this.sortObjects();
        if (isObserveStyle && Engine.key(8192) && this.focusedObject == observeObject) {
            this.focusedObject = player = this.preFocusedObject;
            player.setMovementAnimation();
            observeObject.setRow(0);
            observeObject.setCol(-5);
            isObserveStyle = false;
            GameWorld.observeObject.sprite.visible = false;
            this.bIsFreezeTime = false;
            levelTimeTick = Engine.tick + restTime - currentLevelTimeLimit;
        }
        if (!this.bIsFreezeTime) {
            this.checkEndLevel();
        }
    }

    public void tickScripts() {
        this.dialogTicked = false;
        Enumeration enumeration = this.tickableScripts.elements();
        block0: while (enumeration.hasMoreElements()) {
            int[] nArray;
            int[][] nArray2 = (int[][])enumeration.nextElement();
            int[] nArray3 = nArray2[0];
            int[] nArray4 = nArray3[4] > 0 ? nArray2[nArray3[4]] : null;
            int[] nArray5 = nArray2[nArray3[4] + 1];
            int[] nArray6 = nArray = nArray3[4] + 2 < nArray2.length ? nArray2[nArray3[4] + 2] : null;
            if (nArray3[5] != -1) {
                this.tickScript(nArray2, nArray4, nArray5, nArray);
                continue;
            }
            while (nArray3[5] == -1) {
                if (nArray3[6] == 1) {
                    nArray4 = nArray5;
                    nArray5 = nArray;
                    nArray3[4] = nArray3[4] + 1;
                    nArray = nArray3[4] + 2 < nArray2.length ? nArray2[nArray3[4] + 2] : null;
                    nArray3[6] = 0;
                }
                if (nArray5 != null) {
                    if (nArray3[6] != 0) continue;
                    this.handleEvent(nArray2, nArray5);
                    nArray3[6] = 1;
                    continue;
                }
                if (this.conversationObject != null) {
                    this.endConversation();
                }
                if (nArray4[0] == 6) {
                    this.focusedObject = player;
                }
                if (this.tickableScripts.contains(nArray2) && nArray3[3] != 1 && nArray3[2] == -1) {
                    this.tickableScripts.removeElement(nArray2);
                }
                if (nArray3[3] == 1) {
                    nArray3[4] = 0;
                    nArray3[5] = -1;
                } else {
                    int n;
                    if (nArray3[2] != -1) {
                        ((GameObject)GameWorld.assignedMappings.get((Object)new Integer((int)nArray3[2]))).ints3[0] = null;
                    }
                    if ((n = nArray3.length - 7) > 0) {
                        for (int i = 8; i < nArray3.length; ++i) {
                            int[][] nArray7 = this.getScript(nArray3[i]);
                            if (nArray7[0][2] != -1) {
                                GameObject gameObject = (GameObject)assignedMappings.get(new Integer(nArray7[0][2]));
                                gameObject.ints3[0] = nArray7;
                                continue;
                            }
                            this.tickableScripts.addElement(nArray7);
                        }
                    }
                }
                this.bIsFreezeTime = false;
                levelTimeTick = Engine.tick + restTime - currentLevelTimeLimit;
                continue block0;
            }
        }
        if (this.dialogSpeechBubble != null && !this.dialogTicked) {
            this.tickDialog(null);
        }
    }

    public void tickScript(int[][] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = nArray[0];
        if (nArray5[5] > 0) {
            nArray5[5] = nArray5[5] - 1;
            if (nArray5[5] == 0) {
                nArray5[5] = -1;
            }
            return;
        }
        switch (nArray3[0]) {
            case 6: {
                this.tickDialog(nArray);
                this.dialogTicked = true;
                break;
            }
            case 7: {
                this.checkTaskChain(nArray);
                break;
            }
            case 15: {
                if (Engine.key(16) || this.scriptTextBubble.bytes[9] <= 0) {
                    this.scriptTextBubble = null;
                    nArray[0][5] = -1;
                    break;
                }
                if (Engine.isPressedRepeat(1)) {
                    if (this.scriptTextBubble.bytes[6] <= 0) break;
                    this.scriptTextBubble.bytes[6] = (byte)(this.scriptTextBubble.bytes[6] - 1);
                    break;
                }
                if (!Engine.isPressedRepeat(2) || this.scriptTextBubble.bytes[6] >= this.scriptTextBubble.strings2[0].length - this.scriptTextBubble.bytes[7]) break;
                this.scriptTextBubble.bytes[6] = (byte)(this.scriptTextBubble.bytes[6] + 1);
            }
        }
    }

    public void checkTaskChain(int[][] nArray) {
        int[] nArray2;
        boolean bl = true;
        int n = -1;
        int[] nArray3 = nArray[0];
        int n2 = -1;
        for (int i = nArray3[4]; i < nArray.length - 1 && (nArray2 = nArray[i + 1])[0] == 7; ++i) {
            GameObject gameObject;
            if (nArray2[1] == 3) {
                gameObject = (GameObject)assignedMappings.get(new Integer(nArray2[2]));
                if (gameObject.sprite.firstTimeDone || gameObject.sprite.animationDone) {
                    bl = true;
                    n2 = i;
                    continue;
                }
                bl = false;
                continue;
            }
            n = nArray2[6];
            if (this.isTaskComplete(nArray2)) {
                if (nArray2[1] == 1 || nArray2[1] == 2) {
                    if (nArray2[1] == 1 && nArray2[4] == 1) {
                        Engine.releaseAllKeys();
                        player.setX(GameWorld.player.ints[2]);
                        player.setY(GameWorld.player.ints[3]);
                        player.stop();
                        playerLocked = true;
                        this.bIsFreezeTime = true;
                    }
                } else {
                    gameObject = (GameObject)assignedMappings.get(new Integer(nArray3[2]));
                    if (gameObject != null) {
                        gameObject.booleans[1] = false;
                    }
                }
                n2 = i;
                continue;
            }
            if (nArray3[2] != -1 && this.conversationObject != null) {
                this.endConversation();
            }
            if (this.dialogSpeechBubble == null && n != -1) {
                if (nArray3[2] != -1) {
                    gameObject = (GameObject)assignedMappings.get(new Integer(nArray3[2]));
                    if ((gameObject.booleans[1] || nArray2[7] == 1) && n != -1) {
                        this.showDialog(n, nArray3[2], 0, false);
                    }
                    if (!gameObject.booleans[1]) {
                        gameObject.booleans[1] = true;
                    }
                } else {
                    this.showDialog(n, "player".hashCode(), 0, false);
                }
            }
            bl = false;
            break;
        }
        if (bl) {
            nArray3[4] = n2;
            nArray3[5] = -1;
        } else {
            nArray3[5] = 0;
        }
    }

    public boolean isTaskComplete(int[] nArray) {
        if (nArray[1] == 0) {
            int n = nArray[4];
            boolean bl = nArray[5] == 1;
        } else {
            if (nArray[1] == 1) {
                int[] nArray2 = (int[])this.areas.get(new Integer(nArray[2]));
                if (nArray2 == null) {
                    return false;
                }
                GameObject gameObject = null;
                if (nArray[3] != -1) {
                    gameObject = (GameObject)assignedMappings.get(new Integer(nArray[3]));
                }
                return this.isObjectInArea(gameObject, nArray2[0], nArray2[1], nArray2[2], nArray2[3]);
            }
            if (nArray[1] == 2) {
                int[] nArray3 = (int[])this.areas.get(new Integer(nArray[2]));
                if (nArray3 == null) {
                    return false;
                }
                return this.interactArea == nArray3;
            }
        }
        return true;
    }

    public boolean isPlayerInArea(int n, int n2, int n3, int n4) {
        if (player == null) {
            return false;
        }
        int n5 = n2 * 16 << 8;
        int n6 = n * 16 << 8;
        int n7 = (n4 + 1) * 16 << 8;
        int n8 = (n3 + 1) * 16 << 8;
        return Engine.isRectInRect(player.getCollisionX(), player.getCollisionY(), GameWorld.player.collisionWidth, GameWorld.player.collisionHeight, n5, n6, n7 - n5, n8 - n6);
    }

    public boolean isObjectInArea(GameObject gameObject, int n, int n2, int n3, int n4) {
        if (gameObject == null) {
            return this.isPlayerInArea(n, n2, n3, n4);
        }
        int n5 = n2 * 16 << 8;
        int n6 = n * 16 << 8;
        int n7 = (n4 + 1) * 16 << 8;
        int n8 = (n3 + 1) * 16 << 8;
        return Engine.isRectInRect(gameObject.getCollisionX(), gameObject.getCollisionY(), gameObject.collisionWidth, gameObject.collisionHeight, n5, n6, n7 - n5, n8 - n6);
    }

    public boolean isPlayerInInteractionRange(int n, int n2, int n3, int n4) {
        int[] nArray = player.getTileInFront(false);
        return nArray[0] >= n && nArray[0] <= n3 && nArray[1] >= n2 && nArray[1] <= n4;
    }

    public void tickDialog(int[][] nArray) {
        if (Engine.key(16) || this.dialogTick != -1 && Engine.tick > this.dialogTick + 18) {
            if (this.dialogSpeechBubble.bytes[6] + this.dialogSpeechBubble.bytes[7] < this.dialogSpeechBubble.strings2[0].length) {
                this.dialogSpeechBubble.bytes[6] = (byte)(this.dialogSpeechBubble.bytes[6] + this.dialogSpeechBubble.bytes[7]);
            } else {
                this.closeDialog();
                if (nArray != null) {
                    nArray[0][5] = -1;
                } else {
                    this.focusedObject = player;
                }
            }
            this.dialogTick = -1;
        }
    }

    public int[][] getScript(int n) {
        for (int i = 0; i < this.loadedScripts.length; ++i) {
            if (this.loadedScripts[i] == null || this.loadedScripts[i][0][0] != n) continue;
            return this.loadedScripts[i];
        }
        return null;
    }

    public int checkPlayer(int n) {
        if ("player".hashCode() == n) {
            if (GameWorld.player.spriteId == 1) {
                n = "player_elephant".hashCode();
            } else if (GameWorld.player.spriteId == 2) {
                n = "player_tiger".hashCode();
            } else if (GameWorld.player.spriteId == 3) {
                n = "player_sid".hashCode();
            }
        }
        return n;
    }

    public void handleEvent(int[][] nArray, int[] nArray2) {
        int[] nArray3 = nArray[0];
        block0 : switch (nArray2[0]) {
            case 0: {
                this.loadLevel(nArray2[1]);
                ResourceMaster.closeResource();
                break;
            }
            case 1: {
                GameObject gameObject = null;
                if (nArray2[2] == -1) {
                    nArray2[3] = this.checkPlayer(nArray2[3]);
                    gameObject = (GameObject)assignedMappings.get(new Integer(nArray2[3]));
                } else {
                    gameObject = this.getObjectAt(nArray2[2], nArray2[3]);
                }
                if (gameObject != null) {
                    this.focusedObject = gameObject;
                    if (gameObject.spriteId == 1 || gameObject.spriteId == 2 || gameObject.spriteId == 3) {
                        playerLocked = false;
                    }
                } else {
                    this.focusedObject = GameObject.createFromTile(nArray2[2], nArray2[3]);
                }
                if (nArray2[1] == 1) {
                    this.scrollView(true);
                }
                if (nArray2[4] == 1) {
                    this.cameraScriptHeader = nArray3;
                    this.cameraScriptHeader[5] = 0;
                }
                if (nArray2[5] == 1) {
                    this.scrollSpeed = 1;
                    break;
                }
                if (nArray2[5] == 2) {
                    this.scrollSpeed = 3;
                    break;
                }
                if (nArray2[5] != 3) break;
                this.scrollSpeed = 5;
                break;
            }
            case 2: {
                Object object;
                nArray2[2] = this.checkPlayer(nArray2[2]);
                GameObject gameObject = (GameObject)assignedMappings.get(new Integer(nArray2[2]));
                int n = nArray2[3];
                if (n == -1) {
                    n = level;
                }
                if (gameObject.bytes[0] != n) {
                    if (gameObject.bytes[0] == level) {
                        this.removeObject(gameObject, true);
                    } else if (n == level) {
                        this.addObject(gameObject, true);
                    }
                    object = (Vector)this.levelObjects.get(new Integer(gameObject.bytes[0]));
                    ((Vector)object).removeElement(gameObject);
                    object = (Vector)this.levelObjects.get(new Integer(n));
                    if (object == null) {
                        object = new Vector();
                        this.levelObjects.put(new Integer(n), object);
                    }
                    ((Vector)object).addElement(gameObject);
                    gameObject.bytes[0] = (byte)n;
                }
                if (nArray2[1] == 1) {
                    gameObject.setTile(nArray2[4], nArray2[5]);
                } else {
                    object = this.getPathToTile(gameObject, gameObject.getRow(), gameObject.getCol(), nArray2[4], nArray2[5]);
                    gameObject.ints2[0] = object;
                    gameObject.bytes[3] = 0;
                    if (nArray2[6] == 1) {
                        gameObject.ints2[2] = nArray3;
                    }
                }
                gameObject.sprite.visible = nArray2[7] != 1;
                int n2 = nArray3[5] = nArray2[6] == 1 ? 0 : -1;
                if (gameObject.spriteId != 4 && gameObject.spriteId != 38 && gameObject.spriteId != 37) break;
                ++this.savedAnimals;
                drawHud = true;
                break;
            }
            case 3: {
                nArray3[5] = nArray2[1] / 50;
                break;
            }
            case 4: {
                Vector vector;
                GameObject gameObject;
                int n;
                int n3 = n = nArray2[5] == -1 ? level : nArray2[5];
                if (nArray2[2] == 4 || nArray2[2] == 38 || nArray2[2] == 37) {
                    ++this.savingAnimals;
                }
                if (nArray2[2] == 40) {
                    this.currentLevelTotalBonusCount += 10;
                }
                if (nArray2[2] == 17) {
                    gameObject = GameWorld.createCharacter(nArray2[2], 0, n, nArray2[6], nArray2[7]);
                    if (nArray2[3] == 0) {
                        gameObject.bytes[1] = 0;
                    } else if (nArray2[3] == 1) {
                        gameObject.bytes[1] = 2;
                    } else if (nArray2[3] == 2) {
                        gameObject.bytes[1] = 4;
                    } else if (nArray2[3] == 3) {
                        gameObject.bytes[1] = 6;
                    } else if (nArray2[3] == -1) {
                        gameObject.bytes[1] = -1;
                    }
                } else {
                    gameObject = GameWorld.createCharacter(nArray2[2], nArray2[3], n, nArray2[6], nArray2[7]);
                }
                gameObject.sprite.visible = nArray2[4] == 1;
                assignedMappings.put(new Integer(nArray2[1]), gameObject);
                if (level == n) {
                    this.addObject(gameObject, true);
                }
                if (this.levelObjects.containsKey(new Integer(n))) {
                    vector = (Vector)this.levelObjects.get(new Integer(n));
                } else {
                    vector = new Vector();
                    this.levelObjects.put(new Integer(n), vector);
                }
                vector.addElement(gameObject);
                gameObject.bytes[0] = (byte)n;
                break;
            }
            case 17: {
                Vector vector;
                int n = nArray2[2] == -1 ? level : nArray2[2];
                GameObject gameObject = GameWorld.createCharacter(10, 6, n, nArray2[3] + (nArray2[5] - nArray2[3]) / 2, nArray2[4] + (nArray2[6] - nArray2[4]) / 2);
                gameObject.ints[4] = (short)((nArray2[6] - nArray2[4] + 1) * 16);
                gameObject.ints[5] = (short)((nArray2[5] - nArray2[3] + 1) * 16);
                gameObject.ints[6] = nArray2[7];
                gameObject.bytes[1] = nArray2[8] >= 0 ? (int)(nArray2[8] * 2) : -1;
                assignedMappings.put(new Integer(nArray2[1]), gameObject);
                if (level == n) {
                    this.addObject(gameObject, true);
                }
                if (this.levelObjects.containsKey(new Integer(n))) {
                    vector = (Vector)this.levelObjects.get(new Integer(n));
                } else {
                    vector = new Vector();
                    this.levelObjects.put(new Integer(n), vector);
                }
                vector.addElement(gameObject);
                gameObject.bytes[0] = (byte)n;
                break;
            }
            case 5: {
                GameObject gameObject = (GameObject)assignedMappings.get(new Integer(nArray2[1]));
                assignedMappings.remove(new Integer(nArray2[1]));
                this.removeObject(gameObject, true);
                Enumeration enumeration = this.levelObjects.elements();
                while (enumeration.hasMoreElements()) {
                    Vector vector = (Vector)enumeration.nextElement();
                    if (!vector.contains(gameObject)) continue;
                    vector.removeElement(gameObject);
                    break block0;
                }
                break;
            }
            case 6: {
                nArray2[2] = this.checkPlayer(nArray2[2]);
                this.showDialog(nArray2[1], nArray2[2], nArray2[3], false);
                nArray3[5] = 0;
                break;
            }
            case 7: {
                nArray3[5] = 0;
                break;
            }
            case 18: {
                GameObject gameObject = (GameObject)assignedMappings.get(new Integer(nArray2[1]));
                gameObject.sprite.startAnimation(nArray2[2], nArray2[3]);
                if (gameObject.spriteId == 39 && nArray2[2] == 1) {
                    DeviceSound.play(131081);
                }
                if (gameObject.spriteId == 40 && nArray2[2] == 2) {
                    GameObject gameObject2 = GameObject.createFromPosition((gameObject.x >> 8) + 3 * tileSize, gameObject.y >> 8);
                    gameObject2.bytes[0] = (byte)level;
                    gameObject2.type = 1;
                    gameObject2.setSprite(14);
                    gameObject2.sprite.startAnimation(2, 0);
                    gameObject2.ints[5] = nArray2[1];
                    this.addObject(gameObject2, true);
                    break;
                }
                this.focusedObject = gameObject;
                playerLocked = true;
                break;
            }
            case 11: {
                if (nArray2[1] == 0) {
                    int[] nArray4 = new int[]{nArray2[3], nArray2[4], nArray2[5], nArray2[6]};
                    this.areas.put(new Integer(nArray2[2]), nArray4);
                    break;
                }
                this.areas.remove(new Integer(nArray2[2]));
                this.removeScriptWithReferences(nArray2[2], true);
                break;
            }
            case 12: {
                if (nArray2[1] == 2) {
                    Engine.fadeOut(nArray2[2] == 1, -1);
                } else if (nArray2[1] == 1) {
                    Engine.fadeIn(nArray2[2] == 1);
                }
                nArray3[5] = 0;
                this.fadeScriptHeader = nArray3;
                break;
            }
            case 15: {
                Engine.releaseAllKeys();
                this.scriptTextBubble = GameWorld.createSpeechBubble(Engine.getText(nArray2[1]), Device.WIDTH / 2 << 8, Device.HEIGHT / 2 << 8, -1, -1, 3, true, true);
                this.bIsFreezeTime = true;
                nArray3[5] = 0;
                this.scriptTextBubble.bytes[9] = 90;
                break;
            }
            case 16: {
                if (nArray2[1] != 0 || nArray2[2] != "player_tiger".hashCode()) break;
                isTigerOnStage = !isTigerOnStage;
            }
        }
    }

    public void removeScriptWithReferences(int n, boolean bl) {
        Object object;
        Enumeration<Object> enumeration = this.tickableScripts.elements();
        while (enumeration.hasMoreElements()) {
            object = (int[][])enumeration.nextElement();
            for (int i = 1; i < ((int[][])object).length; ++i) {
                boolean bl2;
                int[] nArray = object[i];
                if (bl) {
                    bl2 = nArray[0] == 7 && (nArray[1] == 1 || nArray[1] == 2) && nArray[2] == n;
                } else {
                    boolean bl3 = bl2 = nArray[0] == 13 && nArray[2] == n;
                }
                if (!bl2) continue;
                this.tickableScripts.removeElement(object);
            }
        }
        enumeration = assignedMappings.elements();
        while (enumeration.hasMoreElements()) {
            object = (GameObject)enumeration.nextElement();
            int[][] nArray = object.ints3[0];
            if (nArray == null) continue;
            for (int i = 1; i < nArray.length; ++i) {
                boolean bl4;
                int[] nArray2 = nArray[i];
                if (bl) {
                    bl4 = nArray2[0] == 7 && (nArray2[1] == 1 || nArray2[1] == 2) && nArray2[2] == n;
                } else {
                    boolean bl5 = bl4 = nArray2[0] == 13 && nArray2[2] == n;
                }
                if (!bl4) continue;
                this.tickableScripts.removeElement(object.ints3[0]);
                object.ints3[0] = null;
            }
        }
    }

    public void fadeComplete() {
        if (this.fadeScriptHeader != null) {
            this.fadeScriptHeader[5] = -1;
            this.fadeScriptHeader = null;
        }
    }

    public void startConversation(GameObject gameObject) {
        this.conversationObject = gameObject;
        this.focusedObject = gameObject;
        if (!this.tickableScripts.contains(this.conversationObject.ints3[0])) {
            this.tickableScripts.addElement(this.conversationObject.ints3[0]);
        }
    }

    public void endConversation() {
        if (this.conversationObject != null) {
            this.tickableScripts.removeElement(this.conversationObject.ints3[0]);
        }
        this.conversationObject = null;
        this.focusedObject = player;
    }

    public void showDialog(int n, int n2, int n3, boolean bl) {
        if (!bl) {
            Engine.releaseAllKeys();
            player.stop();
        } else {
            this.dialogTick = Engine.tick;
        }
        this.dialogSpeaker = (GameObject)assignedMappings.get(new Integer(n2));
        int n4 = this.dialogSpeaker.x;
        int n5 = n >= 58 && n <= 71 ? this.dialogSpeaker.y - 6144 - (n3 << 8) : this.dialogSpeaker.y - 11776 - (n3 << 8);
        if (n5 < 7680) {
            n5 = 7680;
        }
        this.dialogSpeechBubble = GameWorld.createSpeechBubble(Engine.getText(n), n4, n5, this.dialogSpeaker.x, this.dialogSpeaker.y - 2560, 1, false, false);
        this.focusedObject = this.dialogSpeaker;
    }

    public void closeDialog() {
        if (this.dialogSpeaker.spriteId == 4 || this.dialogSpeaker.spriteId == 37 || this.dialogSpeaker.spriteId == 38) {
            DeviceSound.play(131072);
        }
        this.dialogSpeechBubble = null;
        this.dialogSpeaker = null;
    }

    public void tickPlayer() {
        boolean bl;
        if (this.player_ele != null && this.player_ele.hp <= 0 || this.player_tiger != null && this.player_tiger.hp <= 0 || this.player_sid != null && this.player_sid.hp <= 0) {
            GameWorld.playerDie(0);
        }
        if (this.dialogSpeechBubble != null || this.scriptTextBubble != null || GameWorld.player.ints2[0] != null || this.cameraScriptHeader != null) {
            return;
        }
        int n = GameWorld.getTile(player.getRow(), player.getCol());
        int n2 = GameWorld.getTileSprite(n).getAnimationSequenceDuration(n % 200);
        if (!(Engine.isCheatMode || GameWorld.player.spriteId == 3 || n == -1 || n2 != 100 && n2 != 260 && n2 != 240 && n2 != 270 && n2 != 250 && n2 != 610 && n2 != 590 && n2 != 600 || GameWorld.player.spriteId == 2 && GameWorld.player.sprite.currentAnimation >= 8 && GameWorld.player.sprite.currentAnimation <= 11)) {
            player.setRow(GameWorld.player.ints[4]);
            player.setCol(GameWorld.player.ints[5]);
        }
        if (!(n == -1 || n2 != 10 && n2 != 350 || GameWorld.player.spriteId == 2 && GameWorld.player.sprite.currentAnimation >= 8 && GameWorld.player.sprite.currentAnimation <= 11 || GameWorld.player.bIsPlayerOnLavaPlatform)) {
            GameWorld.player.ints[4] = player.getRow();
            GameWorld.player.ints[5] = player.getCol();
        }
        boolean bl2 = Engine.key(16);
        boolean bl3 = GameWorld.player.spriteId == 3 ? GameWorld.player.sprite.currentAnimation < 8 || GameWorld.player.sprite.currentAnimation > 17 : (GameWorld.player.spriteId == 2 ? !(GameWorld.player.sprite.currentAnimation >= 8 && GameWorld.player.sprite.currentAnimation <= 11 || GameWorld.player.sprite.currentAnimation >= 17 && GameWorld.player.sprite.currentAnimation <= 20) : (bl = true));
        if (bl && bl2 && !playerLocked) {
            player.stop();
            if (GameWorld.player.spriteId == 3 && GameWorld.player.sprite.currentAnimation != 19) {
                GameWorld.player.sprite.startAnimation(19, 1);
                return;
            }
            if (GameWorld.player.spriteId == 1 && (GameWorld.player.sprite.currentAnimation < 11 || GameWorld.player.sprite.currentAnimation > 14)) {
                GameWorld.player.sprite.startAnimation(11 + GameWorld.player.bytes[1] / 2, 1);
                GameWorld.player.velX = 0;
                GameWorld.player.velY = 0;
            } else if (GameWorld.player.spriteId == 2 && (GameWorld.player.sprite.currentAnimation < 23 || GameWorld.player.sprite.currentAnimation > 26)) {
                GameWorld.player.sprite.startAnimation(23 + GameWorld.player.bytes[1] / 2, 1);
                if (GameWorld.player.bytes[1] == 0) {
                    GameWorld.player.attackArea.setX(GameWorld.player.x);
                    GameWorld.player.attackArea.setY(GameWorld.player.y - GameWorld.player.collisionHeight * 4 / 5);
                } else if (GameWorld.player.bytes[1] == 2) {
                    GameWorld.player.attackArea.setX(GameWorld.player.x + GameWorld.player.collisionWidth * 4 / 5);
                    GameWorld.player.attackArea.setY(GameWorld.player.y);
                } else if (GameWorld.player.bytes[1] == 4) {
                    GameWorld.player.attackArea.setX(GameWorld.player.x);
                    GameWorld.player.attackArea.setY(GameWorld.player.y + GameWorld.player.collisionHeight * 4 / 5);
                } else if (GameWorld.player.bytes[1] == 6) {
                    GameWorld.player.attackArea.setX(GameWorld.player.x - GameWorld.player.collisionWidth * 4 / 5);
                    GameWorld.player.attackArea.setY(GameWorld.player.y);
                }
                return;
            }
        } else if (GameWorld.player.spriteId == 2 && GameWorld.player.attackArea != null && (GameWorld.player.sprite.currentAnimation < 23 || GameWorld.player.sprite.currentAnimation > 26)) {
            GameWorld.player.attackArea.setRow(0);
            GameWorld.player.attackArea.setCol(-5);
        }
        if (playerLocked) {
            Engine.releaseAllKeys();
            return;
        }
        if (!(GameWorld.player.spriteId != 2 || (GameWorld.player.sprite.currentAnimation < 8 || GameWorld.player.sprite.currentAnimation > 11 || !GameWorld.player.sprite.animationDone) && (GameWorld.player.sprite.currentAnimation >= 8 && GameWorld.player.sprite.currentAnimation <= 11 || Math.abs(GameWorld.player.velX) != 1280 && Math.abs(GameWorld.player.velY) != 1280 || GameWorld.player.sprite.currentAnimation >= 17 && GameWorld.player.sprite.currentAnimation <= 20))) {
            GameWorld.player.velX /= 2;
            GameWorld.player.velY /= 2;
            player.setMovementAnimation();
            isTigerOnEle = false;
            tigerJumpTile = -1;
        }
        int n3 = this.interactTile == null ? 1 : 0;
        int n4 = this.interactObjects.isEmpty();
        this.interactObjects = this.getInteractObject(player);
        this.interactTile = null;
        this.interactArea = null;
        this.interactTile = player.getTileInFront(true);
        int[] nArray = player.getTile(true);
        if (nArray != null && GameWorld.player.spriteId == 3 && ((nArray[2] == 401 || nArray[2] == 406 || nArray[2] == 403 || nArray[2] == 404 || nArray[2] == 402 || nArray[2] == 405 || nArray[2] == 400) && tileSheetGround == 1 || (nArray[2] == 408 || nArray[2] == 412 || nArray[2] == 410 || nArray[2] == 409 || nArray[2] == 411 || nArray[2] == 407) && tileSheetGround == 0 || (nArray[2] == 414 || nArray[2] == 415 || nArray[2] == 420 || nArray[2] == 421 || nArray[2] == 417 || nArray[2] == 418 || nArray[2] == 416 || nArray[2] == 419 || nArray[2] == 413) && tileSheetGround == 2)) {
            this.interactTile = nArray;
        }
        if (this.interactTile == null) {
            if (GameWorld.player.spriteId == 3 && GameWorld.player.sprite.currentAnimation >= 8 && GameWorld.player.sprite.currentAnimation <= 11) {
                player.setMovementAnimation();
                if (Engine.isPressed(4) || Engine.isPressed(8)) {
                    GameWorld.player.velX = 640;
                } else if (Engine.isPressed(1) || Engine.isPressed(2)) {
                    GameWorld.player.velY = 640;
                } else {
                    GameWorld.player.velY = 0;
                    GameWorld.player.velX = 0;
                }
            }
        } else if (this.interactTile != null) {
            if ((this.interactTile[2] == 43 || this.interactTile[2] == 42 || this.interactTile[2] == 45 || this.interactTile[2] == 37 || this.interactTile[2] == 40 || this.interactTile[2] == 72) && GameWorld.player.spriteId == 2 && tileSheetGround == 1 || (this.interactTile[2] == 23 || this.interactTile[2] == 13 || this.interactTile[2] == 101 || this.interactTile[2] == 105 || this.interactTile[2] == 58 || this.interactTile[2] == 21 || this.interactTile[2] == 12 || this.interactTile[2] == 57 || this.interactTile[2] == 102 || this.interactTile[2] == 104 || this.interactTile[2] == 57 || this.interactTile[2] == 24 || this.interactTile[2] == 107 || this.interactTile[2] == 109 || this.interactTile[2] == 110 || this.interactTile[2] == 26 || this.interactTile[2] == 19) && GameWorld.player.spriteId == 2 && tileSheetGround == 0 || (this.interactTile[2] == 98 || this.interactTile[2] == 45 || this.interactTile[2] == 90 || this.interactTile[2] == 10 || this.interactTile[2] == 27 || this.interactTile[2] == 28 || this.interactTile[2] == 29 || this.interactTile[2] == 8 || this.interactTile[2] == 104) && GameWorld.player.spriteId == 2 && tileSheetGround == 2) {
                if (GameWorld.player.sprite.currentAnimation < 8 || GameWorld.player.sprite.currentAnimation > 11) {
                    GameWorld.player.sprite.startAnimation(8 + GameWorld.player.bytes[1] / 2, 1);
                    if (GameWorld.player.bytes[1] == 2 && (this.interactTile[2] == 43 || this.interactTile[2] == 42 || this.interactTile[2] == 23 || this.interactTile[2] == 13 || this.interactTile[2] == 101 || this.interactTile[2] == 105 || this.interactTile[2] == 58 || this.interactTile[2] == 98 || this.interactTile[2] == 45)) {
                        GameWorld.player.velX = 1280;
                        GameWorld.player.velY = 0;
                        GameWorld.player.ints[5] = GameWorld.player.ints[5] - 1;
                    } else if (GameWorld.player.bytes[1] == 6 && (this.interactTile[2] == 45 || this.interactTile[2] == 37 || this.interactTile[2] == 21 || this.interactTile[2] == 12 || this.interactTile[2] == 57 || this.interactTile[2] == 102 || this.interactTile[2] == 104 || this.interactTile[2] == 57 || this.interactTile[2] == 90 || this.interactTile[2] == 10)) {
                        GameWorld.player.velX = -1280;
                        GameWorld.player.velY = 0;
                        GameWorld.player.ints[5] = GameWorld.player.ints[5] + 1;
                    } else if (GameWorld.player.bytes[1] == 0 && (this.interactTile[2] == 72 || this.interactTile[2] == 26 || this.interactTile[2] == 19 || this.interactTile[2] == 8 || this.interactTile[2] == 104)) {
                        GameWorld.player.velY = -1280;
                        GameWorld.player.velX = 0;
                        GameWorld.player.ints[4] = GameWorld.player.ints[4] + 1;
                    } else if (GameWorld.player.bytes[1] == 4 && (this.interactTile[2] == 40 || this.interactTile[2] == 24 || this.interactTile[2] == 107 || this.interactTile[2] == 109 || this.interactTile[2] == 110 || this.interactTile[2] == 27 || this.interactTile[2] == 28 || this.interactTile[2] == 29)) {
                        GameWorld.player.velY = 1280;
                        GameWorld.player.velX = 0;
                        GameWorld.player.ints[4] = GameWorld.player.ints[4] - 1;
                    }
                }
                if (tigerJumpTile != this.interactTile[2]) {
                    isTigerOnStage = false;
                    tigerJumpTile = this.interactTile[2];
                }
            } else if (!((this.interactTile[2] != 403 && this.interactTile[2] != 404 && this.interactTile[2] != 401 && this.interactTile[2] != 406 && this.interactTile[2] != 402 && this.interactTile[2] != 400 && this.interactTile[2] != 405 || GameWorld.player.spriteId != 3 || nArray == null || tileSheetGround != 1) && (this.interactTile[2] != 410 && this.interactTile[2] != 408 && this.interactTile[2] != 412 && this.interactTile[2] != 409 && this.interactTile[2] != 407 && this.interactTile[2] != 411 || GameWorld.player.spriteId != 3 || nArray == null || tileSheetGround != 0) && (this.interactTile[2] != 417 && this.interactTile[2] != 418 && this.interactTile[2] != 414 && this.interactTile[2] != 415 && this.interactTile[2] != 420 && this.interactTile[2] != 421 && this.interactTile[2] != 416 && this.interactTile[2] != 413 && this.interactTile[2] != 419 || GameWorld.player.spriteId != 3 || nArray == null || tileSheetGround != 2) || GameWorld.player.sprite.currentAnimation >= 8 && GameWorld.player.sprite.currentAnimation <= 11)) {
                if ((this.interactTile[2] == 400 || this.interactTile[2] == 401) && tileSheetGround == 1 || (this.interactTile[2] == 407 || this.interactTile[2] == 408) && tileSheetGround == 0 || (this.interactTile[2] == 413 || this.interactTile[2] == 414 || this.interactTile[2] == 415) && tileSheetGround == 2) {
                    GameWorld.player.sprite.startAnimation(11, 0);
                    if (GameWorld.player.bytes[1] == 2) {
                        GameWorld.player.velX = 512;
                    } else if (GameWorld.player.bytes[1] == 6) {
                        GameWorld.player.velX = -512;
                    }
                    GameWorld.player.velY = 0;
                } else if ((this.interactTile[2] == 405 || this.interactTile[2] == 406) && tileSheetGround == 1 || (this.interactTile[2] == 411 || this.interactTile[2] == 412) && tileSheetGround == 0 || (this.interactTile[2] == 419 || this.interactTile[2] == 420 || this.interactTile[2] == 421) && tileSheetGround == 2) {
                    GameWorld.player.sprite.startAnimation(9, 0);
                    if (GameWorld.player.bytes[1] == 6) {
                        GameWorld.player.velX = -512;
                    } else if (GameWorld.player.bytes[1] == 2) {
                        GameWorld.player.velX = 512;
                    }
                    GameWorld.player.velY = 0;
                } else if ((this.interactTile[2] == 402 || this.interactTile[2] == 403 || this.interactTile[2] == 404) && tileSheetGround == 1 || (this.interactTile[2] == 409 || this.interactTile[2] == 410) && tileSheetGround == 0 || (this.interactTile[2] == 416 || this.interactTile[2] == 417 || this.interactTile[2] == 418) && tileSheetGround == 2) {
                    GameWorld.player.sprite.startAnimation(8, 0);
                    if (GameWorld.player.bytes[1] == 0) {
                        GameWorld.player.velY = -512;
                    } else if (GameWorld.player.bytes[1] == 4) {
                        GameWorld.player.velY = 512;
                    }
                    GameWorld.player.velX = 0;
                }
                isSidOnStage = false;
            }
            this.interactTile = null;
        }
        if (!this.interactObjects.isEmpty()) {
            if (n4 != 0) {
                // empty if block
            }
            for (int i = 0; i < this.interactObjects.size(); ++i) {
                GameObject gameObject = (GameObject)this.interactObjects.elementAt(i);
                this.playerAction(gameObject);
            }
        } else if (this.hintObject.sprite.visible) {
            this.hintObject.sprite.visible = false;
        }
        this.tickPlayerSpeed();
        n3 = this.getFrontTile(player);
        n4 = this.getBackTile(player);
        int n5 = GameWorld.getTile(player.getRow(), player.getCol());
        if (n5 != -1 && GameWorld.getTileSprite(n5).getAnimationSequenceDuration(n5 % 200) == 350) {
            isPlayerOnIce = true;
        } else if (n3 != -1 && GameWorld.getTileSprite(n3).getAnimationSequenceDuration(n3 % 200) != 350 && n4 != -1 && GameWorld.getTileSprite(n4).getAnimationSequenceDuration(n4 % 200) != 350) {
            isPlayerOnIce = false;
            if (GameWorld.player.spriteId == 3) {
                player.setMovementAnimation();
            }
        }
        if (n5 != -1 && GameWorld.getTileSprite(n5).getAnimationSequenceDuration(n5 % 200) == 360) {
            player.drown();
            return;
        }
        if (n4 != -1 && GameWorld.getTileSprite(n4).getAnimationSequenceDuration(n4 % 200) == 300) {
            if (GameWorld.player.spriteId == 2 && GameWorld.player.sprite.currentAnimation >= 12 && GameWorld.player.sprite.currentAnimation <= 15) {
                isPlayerOnSwamp = false;
                swampHeight = 0;
                swampTick = -1;
                GameWorld.swampRipple.sprite.visible = false;
                GameWorld.swampRippleUp.sprite.visible = false;
                GameWorld.swampRippleDown.sprite.visible = false;
                swampRipple.stop();
                swampRippleUp.stop();
                swampRippleDown.stop();
                swampRipple.setX(0);
                swampRipple.setY(0);
                swampRippleUp.setX(0);
                swampRippleUp.setY(0);
                swampRippleDown.setX(0);
                swampRippleDown.setY(0);
            } else if (!(isPlayerOnSwamp || GameWorld.player.spriteId == 2 && GameWorld.player.sprite.currentAnimation >= 8 && GameWorld.player.sprite.currentAnimation <= 11)) {
                isPlayerOnSwamp = true;
                swampRipple.setX(GameWorld.player.x);
                swampRipple.setY(GameWorld.player.y);
                swampRippleUp.setX(GameWorld.player.x);
                swampRippleUp.setY(GameWorld.player.y);
                swampRippleDown.setX(GameWorld.player.x);
                swampRippleDown.setY(GameWorld.player.y);
                if (GameWorld.player.spriteId == 1) {
                    GameWorld.swampRipple.sprite.startAnimation(0, 1);
                    GameWorld.swampRippleUp.sprite.startAnimation(2, 0);
                    GameWorld.swampRippleDown.sprite.startAnimation(3, 0);
                } else if (GameWorld.player.spriteId == 2) {
                    GameWorld.swampRipple.sprite.startAnimation(1, 1);
                    GameWorld.swampRippleUp.sprite.startAnimation(4, 0);
                    GameWorld.swampRippleDown.sprite.startAnimation(5, 0);
                } else if (GameWorld.player.spriteId == 3) {
                    GameWorld.swampRipple.sprite.startAnimation(1, 1);
                    GameWorld.swampRippleUp.sprite.startAnimation(6, 0);
                    GameWorld.swampRippleDown.sprite.startAnimation(7, 0);
                }
                if (GameWorld.player.spriteId == 3) {
                    GameWorld.swampRipple.sprite.visible = false;
                    GameWorld.swampRippleUp.sprite.visible = true;
                    GameWorld.swampRippleDown.sprite.visible = true;
                } else if (GameWorld.player.bytes[1] == 0 || GameWorld.player.bytes[1] == 4) {
                    GameWorld.swampRipple.sprite.visible = true;
                    GameWorld.swampRippleUp.sprite.visible = false;
                    GameWorld.swampRippleDown.sprite.visible = false;
                } else {
                    GameWorld.swampRipple.sprite.visible = false;
                    GameWorld.swampRippleUp.sprite.visible = true;
                    GameWorld.swampRippleDown.sprite.visible = true;
                }
                if (swampTick == -1) {
                    swampTick = 0;
                }
            }
        }
        if (n3 != -1 && (GameWorld.getTileSprite(n3).getAnimationSequenceDuration(n3 % 200) == 320 || GameWorld.getTileSprite(n3).getAnimationSequenceDuration(n3 % 200) == 10) && isPlayerOnSwamp) {
            isPlayerOnSwamp = false;
            isPlayerDie = false;
            GameWorld.swampRipple.sprite.visible = false;
            swampRipple.setX(0);
            swampRipple.setY(0);
            swampRipple.stop();
            GameWorld.swampRippleUp.sprite.visible = false;
            swampRippleUp.setX(0);
            swampRippleUp.setY(0);
            swampRippleUp.stop();
            GameWorld.swampRippleDown.sprite.visible = false;
            swampRippleDown.setX(0);
            swampRippleDown.setY(0);
            swampRippleDown.stop();
            swampTick = -1;
            swampHeight = 0;
        }
        if (!(GameWorld.player.spriteId == 3 && isSidOnStage || GameWorld.player.bIsPlayerOnLavaPlatform || n5 == -1 || GameWorld.getTileSprite(n5).getAnimationSequenceDuration(n5 % 200) != 450)) {
            GameWorld.player.sprite.visible = true;
            playerLocked = true;
            player.stop();
            if (player != null) {
                if (GameWorld.player.spriteId == 1) {
                    GameWorld.player.sprite.startAnimation(10, 1);
                } else if (GameWorld.player.spriteId == 2) {
                    GameWorld.player.sprite.startAnimation(22, 1);
                } else if (GameWorld.player.spriteId == 3) {
                    GameWorld.player.sprite.startAnimation(21, 1);
                }
            }
        }
        if (player != null && GameWorld.player.spriteId == 2 && GameWorld.player.sprite.currentAnimation >= 17 && GameWorld.player.sprite.currentAnimation <= 20 && GameWorld.player.sprite.animationDone) {
            GameWorld.player.sprite.startAnimation(GameWorld.player.sprite.currentAnimation - 9, 1);
        }
        if (!isObserveStyle && Engine.key(8192) && this.focusedObject == player) {
            GameWorld.player.velX = 0;
            GameWorld.player.velY = 0;
            GameWorld.player.accX = 0;
            GameWorld.player.accY = 0;
            player.setMovementAnimation();
            observeObject.setRow(player.getRow());
            observeObject.setCol(player.getCol());
            this.preFocusedObject = player;
            player = null;
            this.bIsFreezeTime = true;
            this.focusedObject = observeObject;
            GameWorld.observeObject.sprite.visible = true;
            isObserveStyle = true;
        }
    }

    public void tickPlayerSpeed() {
        if (!playerLocked && Math.abs(GameWorld.player.velX) != 1280 && Math.abs(GameWorld.player.velY) != 1280 && (GameWorld.player.spriteId != 1 || GameWorld.player.sprite.currentAnimation < 11 || GameWorld.player.sprite.currentAnimation > 14 || GameWorld.player.sprite.animationDone)) {
            int n;
            int n2 = -1;
            if (GameWorld.player.spriteId == 2 && Engine.isDoublePressed(4) && GameWorld.player.bytes[1] == 6) {
                if (isPlayerOnIce && GameWorld.player.velX > -1024) {
                    GameWorld.player.accX = -32;
                    if (!Engine.isPressed(1) && !Engine.isPressed(2)) {
                        n2 = 6;
                    }
                } else {
                    GameWorld.player.velX = -1024;
                }
                if (GameWorld.player.sprite.currentAnimation != 15) {
                    GameWorld.player.sprite.startAnimation(15, 0);
                }
            } else if (GameWorld.player.spriteId == 2 && Engine.isDoublePressed(8) && GameWorld.player.bytes[1] == 2) {
                if (isPlayerOnIce && GameWorld.player.velX < 1024) {
                    GameWorld.player.accX = 32;
                    if (!Engine.isPressed(1) && !Engine.isPressed(2)) {
                        n2 = 2;
                    }
                } else {
                    GameWorld.player.velX = 1024;
                }
                if (GameWorld.player.sprite.currentAnimation != 13) {
                    GameWorld.player.sprite.startAnimation(13, 0);
                }
            } else if (GameWorld.player.spriteId == 2 && Engine.isDoublePressed(1) && GameWorld.player.bytes[1] == 0) {
                if (isPlayerOnIce && GameWorld.player.velY > -1024) {
                    GameWorld.player.accY = -32;
                    if (!Engine.isPressed(4) && !Engine.isPressed(8)) {
                        n2 = 0;
                    }
                } else {
                    GameWorld.player.velY = -1024;
                }
                if (GameWorld.player.sprite.currentAnimation != 12) {
                    GameWorld.player.sprite.startAnimation(12, 0);
                }
            } else if (GameWorld.player.spriteId == 2 && Engine.isDoublePressed(2) && GameWorld.player.bytes[1] == 4) {
                if (isPlayerOnIce && GameWorld.player.velY < 1024) {
                    GameWorld.player.accY = 32;
                    if (!Engine.isPressed(4) && !Engine.isPressed(8)) {
                        n2 = 4;
                    }
                } else {
                    GameWorld.player.velY = 1024;
                }
                if (GameWorld.player.sprite.currentAnimation != 14) {
                    GameWorld.player.sprite.startAnimation(14, 0);
                }
            } else {
                if (Engine.isPressed(4) && !isPlayerMoveStone && (GameWorld.player.velX != -1024 || GameWorld.player.spriteId != 2) && (GameWorld.player.velX != -512 || GameWorld.player.spriteId != 3 || GameWorld.player.spriteId == 3 && isPlayerOnIce)) {
                    if (isPlayerOnIce && GameWorld.player.velX > -640) {
                        GameWorld.player.accX = -20;
                        if (!Engine.isPressed(1) && !Engine.isPressed(2)) {
                            n2 = 6;
                        }
                    } else {
                        GameWorld.player.velX = -640;
                    }
                } else if (Engine.isPressed(8) && !isPlayerMoveStone && (GameWorld.player.velX != 1024 || GameWorld.player.spriteId != 2) && (GameWorld.player.velX != 512 || GameWorld.player.spriteId != 3 || GameWorld.player.spriteId == 3 && isPlayerOnIce)) {
                    if (isPlayerOnIce && GameWorld.player.velX < 640) {
                        GameWorld.player.accX = 20;
                        if (!Engine.isPressed(1) && !Engine.isPressed(2)) {
                            n2 = 2;
                        }
                    } else {
                        GameWorld.player.velX = 640;
                    }
                } else if (!Engine.isPressed(4) && !Engine.isPressed(8)) {
                    if (isPlayerOnIce && GameWorld.player.velX != 0) {
                        if (GameWorld.player.velX < 0) {
                            GameWorld.player.accX = 20;
                        } else if (GameWorld.player.velX > 0) {
                            GameWorld.player.accX = -20;
                        }
                    } else {
                        GameWorld.player.velX = 0;
                    }
                }
                n = 640;
                int n3 = 20;
                int n4 = GameWorld.getTile(player.getRow(), player.getCol());
                if (n4 != -1 && GameWorld.getTileSprite(n4).getAnimationSequenceDuration(n4 % 200) == 30) {
                    n /= 2;
                    n3 /= 2;
                } else if (Engine.isPressed(1) && !isPlayerMoveStone && (GameWorld.player.velY != -1024 || GameWorld.player.spriteId != 2) && (GameWorld.player.velY != -512 || GameWorld.player.spriteId != 3 || GameWorld.player.spriteId == 3 && isPlayerOnIce)) {
                    if (isPlayerOnIce && GameWorld.player.velY > -640) {
                        GameWorld.player.accY = -n3;
                        if (!Engine.isPressed(4) && !Engine.isPressed(8)) {
                            n2 = 0;
                        }
                    } else {
                        GameWorld.player.velY = -n;
                    }
                } else if (Engine.isPressed(2) && !isPlayerMoveStone && (GameWorld.player.velY != 1024 || GameWorld.player.spriteId != 2) && (GameWorld.player.velY != 512 || GameWorld.player.spriteId != 3 || GameWorld.player.spriteId == 3 && isPlayerOnIce)) {
                    if (isPlayerOnIce && GameWorld.player.velY < 640) {
                        GameWorld.player.accY = n3;
                        if (!Engine.isPressed(4) && !Engine.isPressed(8)) {
                            n2 = 4;
                        }
                    } else {
                        GameWorld.player.velY = n;
                    }
                } else if (!Engine.isPressed(1) && !Engine.isPressed(2)) {
                    if (isPlayerOnIce && GameWorld.player.velY != 0) {
                        if (GameWorld.player.velY < 0) {
                            GameWorld.player.accY = 20;
                        } else if (GameWorld.player.velY > 0) {
                            GameWorld.player.accY = -20;
                        }
                    } else {
                        GameWorld.player.velY = 0;
                    }
                }
            }
            if (isPlayerOnIce && GameWorld.player.bytes[2] != n2) {
                if (n2 != -1) {
                    GameWorld.player.bytes[1] = (byte)n2;
                }
                player.setMovementAnimation();
                GameWorld.player.bytes[2] = (byte)n2;
            }
            if (!(!isPlayerOnIce || Engine.isPressed(1) || Engine.isPressed(2) || Engine.isPressed(4) || Engine.isPressed(8))) {
                GameWorld.player.bytes[2] = -1;
                player.setMovementAnimation();
            }
            if (Engine.key(4096) && level >= 3) {
                n = -1;
                GameWorld.player.velX = 0;
                GameWorld.player.velY = 0;
                GameWorld.player.accX = 0;
                GameWorld.player.accY = 0;
                player.setMovementAnimation();
                if (player == this.player_ele) {
                    player = this.player_tiger;
                    n = 46;
                } else if (player == this.player_tiger) {
                    player = this.player_sid;
                    n = 47;
                } else {
                    player = this.player_ele;
                    n = 45;
                }
                this.focusedObject = player;
                player.setMovementAnimation();
                drawHud = true;
                this.showDialog(n, this.checkPlayer("player".hashCode()), 0, true);
                bIsPlayerChanged = true;
                this.playerChangeTick = Engine.tick;
            }
        }
    }

    public int getFrontTile(GameObject gameObject) {
        int n = (gameObject.y >> 8) / 16;
        int n2 = (gameObject.x >> 8) / 16;
        switch (gameObject.bytes[1]) {
            case 0: {
                --n;
                break;
            }
            case 2: {
                ++n2;
                break;
            }
            case 4: {
                ++n;
                break;
            }
            case 6: {
                --n2;
            }
        }
        return GameWorld.getTile(n, n2);
    }

    public int getBackTile(GameObject gameObject) {
        int n = (gameObject.y >> 8) / 16;
        int n2 = (gameObject.x >> 8) / 16;
        switch (gameObject.bytes[1]) {
            case 0: {
                ++n;
                break;
            }
            case 2: {
                --n2;
                break;
            }
            case 4: {
                --n;
                break;
            }
            case 6: {
                ++n2;
            }
        }
        return GameWorld.getTile(n, n2);
    }

    public static void playerDie(int n) {
        if (endLevelTick == -1) {
            endLevelTick = Engine.tick;
        }
        GameWorld.player.velX = 0;
        GameWorld.player.velY = 0;
        GameWorld.player.hp = 0;
        drawHud = true;
        isPlayerDie = true;
    }

    public int getOppositeDirection(int n) {
        return (n + 4) % 8;
    }

    public void checkCloseObjects() {
        GameObject gameObject;
        int n;
        if (player == null) {
            return;
        }
        int n2 = GameWorld.player.x - 6400;
        int n3 = GameWorld.player.y - 6400;
        int n4 = 12800;
        this.objectsInRange.removeAllElements();
        for (n = 0; n < this.objectsOnScreen.size(); ++n) {
            gameObject = (GameObject)this.objectsOnScreen.elementAt(n);
            if (gameObject == player || !Engine.isRectInRect(n2, n3, n4, n4, gameObject.x + gameObject.collisionOffsetX, gameObject.y + gameObject.collisionOffsetY, gameObject.collisionWidth, gameObject.collisionHeight)) continue;
            this.objectsInRange.addElement(gameObject);
        }
        for (n = 0; n < this.objectsOnScreenBottom.size(); ++n) {
            gameObject = (GameObject)this.objectsOnScreenBottom.elementAt(n);
            if (gameObject == player || !Engine.isRectInRect(n2, n3, n4, n4, gameObject.x + gameObject.collisionOffsetX, gameObject.y + gameObject.collisionOffsetY, gameObject.collisionWidth, gameObject.collisionHeight)) continue;
            this.objectsInRange.addElement(gameObject);
        }
    }

    public Vector getInteractObject(GameObject gameObject) {
        Vector<GameObject> vector = new Vector<GameObject>();
        block6: for (int i = 0; i < this.objectsInRange.size(); ++i) {
            GameObject gameObject2 = (GameObject)this.objectsInRange.elementAt(i);
            if (gameObject2.type != 1) continue;
            if (gameObject2.spriteId == 10 && gameObject2.sprite.currentAnimation == 6) {
                vector.addElement(gameObject2);
            }
            switch (gameObject.bytes[1]) {
                case 0: {
                    if (gameObject2.y >= gameObject.y) continue block6;
                    vector.addElement(gameObject2);
                    continue block6;
                }
                case 2: {
                    if (gameObject2.x <= gameObject.x) continue block6;
                    vector.addElement(gameObject2);
                    continue block6;
                }
                case 4: {
                    if (gameObject2.y <= gameObject.y) continue block6;
                    vector.addElement(gameObject2);
                    continue block6;
                }
                case 6: {
                    if (gameObject2.x >= gameObject.x) continue block6;
                    vector.addElement(gameObject2);
                }
            }
        }
        return vector;
    }

    public void sortObjects() {
        this.objectsOnScreen.removeAllElements();
        this.objectsOnScreenBottom.removeAllElements();
        for (int i = 0; i < this.objects.size(); ++i) {
            GameObject gameObject;
            int n;
            boolean bl;
            GameObject gameObject2 = (GameObject)this.objects.elementAt(i);
            if (!gameObject2.isOnScreen() && gameObject2.spriteId != 15 && (gameObject2.spriteId != 10 || gameObject2.sprite.currentAnimation != 6) && gameObject2.spriteId != 22) continue;
            if (Engine.getIndexInArray(DataManager.SPRITES_ON_BOTTOM, gameObject2.spriteId) != -1 || gameObject2.spriteId == 5 && gameObject2.sprite.currentAnimation == 6) {
                if (this.objectsOnScreenBottom.size() == 0) {
                    this.objectsOnScreenBottom.addElement(gameObject2);
                    continue;
                }
                bl = false;
                for (n = 0; n < this.objectsOnScreenBottom.size(); ++n) {
                    gameObject = (GameObject)this.objectsOnScreenBottom.elementAt(n);
                    if (gameObject2.y >= gameObject.y) continue;
                    this.objectsOnScreenBottom.insertElementAt(gameObject2, n);
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.objectsOnScreenBottom.addElement(gameObject2);
                continue;
            }
            if (this.objectsOnScreen.size() == 0) {
                this.objectsOnScreen.addElement(gameObject2);
                continue;
            }
            bl = false;
            for (n = 0; n < this.objectsOnScreen.size(); ++n) {
                gameObject = (GameObject)this.objectsOnScreen.elementAt(n);
                if (isTigerOnEle && gameObject2.spriteId == 2 && gameObject.spriteId == 1) continue;
                if (isPlayerOnSwamp) {
                    if (gameObject == player && (gameObject2 == swampRippleDown || gameObject2 == swampRipple)) continue;
                    if (gameObject == player && gameObject2 == swampRippleUp) {
                        this.objectsOnScreen.insertElementAt(gameObject2, n);
                        bl = true;
                        break;
                    }
                } else {
                    if (isTigerOnStage && gameObject2.spriteId == 2 && (gameObject.spriteId == 13 || gameObject.spriteId == 10 || gameObject.spriteId == 1 || gameObject.spriteId == 5 || !isTigerOnStage && gameObject.spriteId == 3)) continue;
                    if (!isTigerOnStage && gameObject2.spriteId == 2 && gameObject.spriteId == 13) {
                        this.objectsOnScreen.insertElementAt(gameObject2, n);
                        bl = true;
                        break;
                    }
                    if (isSidOnStage && gameObject2.spriteId == 3 && (gameObject.spriteId == 13 || gameObject.spriteId == 10 || gameObject.spriteId == 1 || gameObject.spriteId == 5 || !isTigerOnStage && gameObject.spriteId == 2)) continue;
                    if (!isSidOnStage && gameObject2.spriteId == 3 && gameObject.spriteId == 13) {
                        this.objectsOnScreen.insertElementAt(gameObject2, n);
                        bl = true;
                        break;
                    }
                    if (gameObject2.spriteId == 1 && gameObject.spriteId == 13) {
                        this.objectsOnScreen.insertElementAt(gameObject2, n);
                        bl = true;
                        break;
                    }
                }
                if (gameObject2.y >= gameObject.y) continue;
                this.objectsOnScreen.insertElementAt(gameObject2, n);
                bl = true;
                break;
            }
            if (bl) continue;
            this.objectsOnScreen.addElement(gameObject2);
        }
    }

    public void scrollView(boolean bl) {
        if (this.focusedObject != null) {
            int n;
            int n2;
            if (this.focusedObject.sprite != null) {
                n2 = this.focusedObject.sprite.x - Device.WIDTH / 2;
                n = this.focusedObject.sprite.y - Device.HEIGHT / 2;
            } else {
                n2 = GameWorld.scaleGame(this.focusedObject.x >> 8) - Device.WIDTH / 2;
                n = GameWorld.scaleGame(this.focusedObject.y >> 8) - Device.HEIGHT / 2;
            }
            if (mapView[0] == n2 && mapView[1] == n) {
                if (this.cameraScriptHeader != null) {
                    this.cameraScriptHeader[5] = -1;
                    this.cameraScriptHeader = null;
                } else {
                    this.scrollSpeed = -1;
                }
            } else {
                Engine.scroll(mapView, Device.WIDTH, viewHeight, 0, 0, n2, n, mapWidth, mapHeight, bl, this.lockScrollingX, this.lockScrollingY, this.scrollSpeed);
            }
        }
    }

    public void addObject(GameObject gameObject, boolean bl) {
        this.objectsToAdd.addElement(gameObject);
        if (bl) {
            this.addObjects();
        }
    }

    public void addObjects() {
        if (this.objectsToAdd.size() == 0) {
            return;
        }
        for (int i = 0; i < this.objectsToAdd.size(); ++i) {
            GameObject gameObject = (GameObject)this.objectsToAdd.elementAt(i);
            gameObject.refreshPosition();
            this.objects.addElement(gameObject);
        }
        this.objectsToAdd.removeAllElements();
    }

    public void removeObject(GameObject gameObject, boolean bl) {
        this.objectsToRemove.addElement(gameObject);
        if (bl) {
            this.removeObjects();
        }
    }

    public void removeObjects() {
        if (this.objectsToRemove.size() == 0) {
            return;
        }
        for (int i = 0; i < this.objectsToRemove.size(); ++i) {
            this.objects.removeElement(this.objectsToRemove.elementAt(i));
        }
        this.objectsToRemove.removeAllElements();
    }

    public GameObject getObjectAt(int n, int n2) {
        for (int i = 0; i < this.objects.size(); ++i) {
            GameObject gameObject = (GameObject)this.objects.elementAt(i);
            if (gameObject.getRow() != n || gameObject.getCol() != n2) continue;
            return gameObject;
        }
        return null;
    }

    public int getTileFromPosition(int n, boolean bl) {
        if (bl) {
            n >>= 8;
        }
        return n / 16 - (n < 0 ? 1 : 0);
    }

    public void loadLevel(int n) {
        try {
            int n2;
            short s;
            int n3;
            int n4;
            int n5;
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(ResourceMaster.getResource("level" + n + "_1.rms")));
            level = n;
            if (n > unlockLevelRecord) {
                unlockLevelRecord = n;
            }
            Engine.saveSlotInfoBytes[0] = (byte)unlockLevelRecord;
            Engine.saveRMS(1);
            this.objects.removeAllElements();
            this.objectsToAdd.removeAllElements();
            this.objectsToRemove.removeAllElements();
            this.objectsOnScreen.removeAllElements();
            this.objectsOnScreenBottom.removeAllElements();
            this.objectsInRange.removeAllElements();
            bWin = false;
            isIGM = false;
            endLevelTick = -1;
            isObserveStyle = false;
            tileSheetGround = dataInputStream.readByte();
            this.tileSheetMiddle = dataInputStream.readByte();
            this.loadTileSheets(TILESHEET_GROUND_NAMES[tileSheetGround], TILESHEET_MIDDLE_NAMES[this.tileSheetMiddle]);
            mapRows = dataInputStream.readByte();
            mapCols = dataInputStream.readByte();
            mapWidth = mapCols * tileSize;
            mapHeight = mapRows * tileSize;
            this.lockScrollingX = mapWidth <= Device.WIDTH;
            this.lockScrollingY = mapHeight <= viewHeight;
            map = new short[mapRows * mapCols];
            for (n5 = 0; n5 < map.length; ++n5) {
                GameWorld.map[n5] = dataInputStream.readShort();
            }
            n5 = dataInputStream.readShort();
            for (n4 = 0; n4 < n5; ++n4) {
                n3 = dataInputStream.readShort();
                short s2 = dataInputStream.readShort();
                s = dataInputStream.readShort();
                n2 = dataInputStream.readByte();
                GameObject gameObject = GameObject.createFromPosition(s2, s);
                gameObject.bytes[0] = (byte)n;
                if (n3 == 0) continue;
                if (n3 == 1) {
                    gameObject.setSprite(6);
                    gameObject.sprite.startAnimation(n2, 0);
                } else if (n3 == 2) {
                    gameObject.setSprite(7);
                    gameObject.sprite.startAnimation(n2, 0);
                } else if (n3 == 3) {
                    gameObject.setSprite(8);
                    gameObject.sprite.startAnimation(n2, 0);
                } else if (n3 == 4) {
                    gameObject.setSprite(9);
                    gameObject.sprite.startAnimation(n2, 0);
                } else if (n3 == 5 || n3 == 6 || n3 == 7 || n3 == 15 || n3 == 16 || n3 == 17) {
                    gameObject.setSprite(13);
                    gameObject.sprite.startAnimation(n2, 0);
                } else if (n3 == 8 || n3 == 9 || n3 == 10 || n3 == 11) {
                    gameObject.setSprite(10);
                    gameObject.sprite.startAnimation(n2, 0);
                    gameObject.type = 1;
                } else if (n3 == 12) {
                    gameObject.setSprite(14);
                    gameObject.sprite.startAnimation(n2, 0);
                    gameObject.type = 1;
                    ++this.currentLevelTotalBonusCount;
                } else if (n3 == 13) {
                    gameObject.setSprite(16);
                    gameObject.sprite.startAnimation(n2, 0);
                    gameObject.type = 1;
                } else if (n3 == 14) {
                    gameObject.setSprite(18);
                    gameObject.sprite.startAnimation(n2, 0);
                    gameObject.type = 1;
                } else if (n3 == 18 || n3 == 19) {
                    gameObject.setSprite(19);
                    gameObject.sprite.startAnimation(n2, 0);
                    gameObject.type = 1;
                } else if (n3 == 20 || n3 == 21 || n3 == 29 || n3 == 30 || n3 == 31 || n3 == 32) {
                    gameObject.setSprite(20);
                    gameObject.sprite.startAnimation(n2, 0);
                    gameObject.type = 1;
                } else if (n3 == 22) {
                    gameObject.setSprite(21);
                    gameObject.sprite.startAnimation(n2, 1);
                    gameObject.type = 1;
                    GameObject gameObject2 = GameObject.createFromPosition(s2, s - 8);
                    gameObject2.setSprite(28);
                    gameObject2.sprite.startAnimation(1, 1);
                    gameObject2.type = 1;
                    gameObject.object_link = gameObject2;
                    this.addObject(gameObject2, false);
                } else if (n3 == 23) {
                    gameObject.setSprite(22);
                    gameObject.sprite.startAnimation(n2, 0);
                    gameObject.type = 1;
                    gameObject.bytes[6] = 1;
                    gameObject.ints[4] = gameObject.getRow();
                    gameObject.ints[5] = gameObject.getCol();
                    gameObject.attackArea = GameWorld.createCharacter(25, 0, n, 0, -5);
                    gameObject.attackArea.bytes[6] = 1;
                    this.addObject(gameObject.attackArea, false);
                    gameObject.hp = 3;
                } else if (n3 == 24) {
                    gameObject.setSprite(23);
                    gameObject.sprite.startAnimation(n2, 0);
                } else if (n3 == 25) {
                    gameObject.setSprite(24);
                    gameObject.sprite.startAnimation(n2, 0);
                    gameObject.type = 1;
                } else if (n3 == 26) {
                    gameObject.setSprite(26);
                    gameObject.sprite.startAnimation(n2, 0);
                    gameObject.type = 1;
                } else if (n3 == 27) {
                    gameObject.setSprite(29);
                    gameObject.sprite.startAnimation(0, 1);
                    gameObject.type = 1;
                } else if (n3 == 28) {
                    gameObject.setSprite(30);
                    gameObject.sprite.startAnimation(n2, 0);
                    gameObject.type = 1;
                } else if (n3 == 33) {
                    gameObject.setSprite(5);
                    gameObject.sprite.startAnimation(n2, 0);
                    gameObject.type = 1;
                } else if (n3 == 34) {
                    gameObject.setSprite(32);
                    gameObject.sprite.startAnimation(n2, 0);
                } else if (n3 == 35) {
                    gameObject.setSprite(33);
                    gameObject.sprite.startAnimation(n2, 0);
                } else if (n3 == 36) {
                    gameObject.setSprite(34);
                    gameObject.sprite.startAnimation(n2, 0);
                } else if (n3 == 37) {
                    gameObject.setSprite(35);
                    gameObject.sprite.startAnimation(n2, 0);
                    gameObject.type = 1;
                } else if (n3 == 38) {
                    gameObject.setSprite(36);
                    gameObject.sprite.startAnimation(n2, 0);
                    gameObject.type = 1;
                }
                this.addObject(gameObject, false);
            }
            if (this.levelObjects.containsKey(new Integer(n))) {
                Vector vector = (Vector)this.levelObjects.get(new Integer(n));
                for (n3 = 0; n3 < vector.size(); ++n3) {
                    GameObject gameObject = (GameObject)vector.elementAt(n3);
                    this.addObject(gameObject, false);
                }
            }
            dataInputStream.readByte();
            n4 = dataInputStream.readByte();
            if (n4 == 0) {
                Object var5_8 = null;
                Vector vector = new Vector();
                s = 0;
                n2 = dataInputStream.readByte();
                boolean bl = false;
                boolean bl2 = false;
                byte by = 0;
                byte by2 = 0;
                for (int i = 0; i < n2; ++i) {
                    byte by3 = dataInputStream.readByte();
                    byte by4 = dataInputStream.readByte();
                    if (i == 0) {
                        // empty if block
                    }
                    by = by3;
                    by2 = by4;
                }
                if (n2 > 0) {
                    // empty if block
                }
            }
            playerLocked = false;
            if (n != 1 && n != 2) {
                this.player_ele = GameObject.createFromPrecisePosition(0, 0);
                this.player_ele.type = 1;
                this.player_ele.setSprite(1);
                this.player_ele.setMovementAnimation();
                this.player_ele.bytes[1] = 2;
                this.player_ele.bytes[0] = (byte)n;
                this.player_ele.hp = 8;
                this.addObject(this.player_ele, false);
                assignedMappings.put(new Integer("player_elephant".hashCode()), this.player_ele);
                player = this.player_ele;
            }
            if (n != 0 && n != 2) {
                this.player_tiger = GameObject.createFromPrecisePosition(50, 0);
                this.player_tiger.type = 1;
                this.player_tiger.setSprite(2);
                this.player_tiger.setMovementAnimation();
                this.player_tiger.bytes[1] = 2;
                this.player_tiger.bytes[0] = (byte)n;
                this.player_tiger.attackArea = GameWorld.createCharacter(25, 0, n, 0, -5);
                this.player_tiger.attackArea.bytes[6] = 0;
                this.addObject(this.player_tiger.attackArea, false);
                this.player_tiger.hp = 8;
                this.addObject(this.player_tiger, false);
                assignedMappings.put(new Integer("player_tiger".hashCode()), this.player_tiger);
                if (n == 1 || n == 3) {
                    player = this.player_tiger;
                }
                isTigerOnStage = false;
                isTigerOnEle = false;
            }
            if (n != 0 && n != 1) {
                this.player_sid = GameObject.createFromPrecisePosition(100, 0);
                this.player_sid.type = 1;
                this.player_sid.setSprite(3);
                this.player_sid.setMovementAnimation();
                this.player_sid.bytes[1] = 2;
                this.player_sid.bytes[0] = (byte)n;
                this.player_sid.hp = 8;
                this.addObject(this.player_sid, false);
                assignedMappings.put(new Integer("player_sid".hashCode()), this.player_sid);
                if (n == 2) {
                    player = this.player_sid;
                }
                isSidOnStage = false;
            }
            this.focusedObject = player;
            if (n == 4 || n == 5 || n == 8) {
                this.player_ele.bytes[1] = 0;
            } else if (n == 3) {
                this.player_ele.bytes[1] = 2;
            } else if (n == 7 || n == 0) {
                this.player_ele.bytes[1] = 4;
            } else if (n == 6) {
                this.player_ele.bytes[1] = 6;
            }
            if (n == 1 || n == 4 || n == 5) {
                this.player_tiger.bytes[1] = 0;
            } else if (n == 3) {
                this.player_tiger.bytes[1] = 2;
            } else if (n == 6 || n == 7 || n == 8) {
                this.player_tiger.bytes[1] = 6;
            }
            if (n == 4 || n == 5 || n == 8 || n == 2) {
                this.player_sid.bytes[1] = 0;
            } else if (n == 7) {
                this.player_sid.bytes[1] = 4;
            } else if (n == 6) {
                this.player_sid.bytes[1] = 6;
            }
            observeObject = GameObject.createFromPrecisePosition(0, 0);
            GameWorld.observeObject.type = 1;
            observeObject.setSprite(31);
            GameWorld.observeObject.sprite.visible = false;
            GameWorld.observeObject.bytes[1] = 2;
            GameWorld.observeObject.bytes[0] = (byte)n;
            this.addObject(observeObject, false);
            interfaceObject = GameObject.createFromPrecisePosition(145, 205);
            interfaceObject.setSprite(0);
            GameWorld.interfaceObject.sprite.visible = true;
            GameWorld.interfaceObject.sprite.startAnimation(6, 0);
            GameWorld.interfaceObject.bytes[0] = (byte)n;
            this.hintObject = GameObject.createFromPrecisePosition(0, 0);
            this.hintObject.type = 2;
            this.hintObject.setSprite(11);
            this.hintObject.sprite.visible = false;
            this.hintObject.bytes[0] = (byte)n;
            if (tileSheetGround == 1) {
                swampRipple = GameObject.createFromPrecisePosition(0, -5);
                GameWorld.swampRipple.type = 1;
                swampRipple.setSprite(12);
                GameWorld.swampRipple.sprite.visible = false;
                GameWorld.swampRipple.bytes[0] = (byte)n;
                swampRippleUp = GameObject.createFromPrecisePosition(0, -5);
                GameWorld.swampRippleUp.type = 1;
                swampRippleUp.setSprite(12);
                GameWorld.swampRippleUp.sprite.visible = false;
                GameWorld.swampRippleUp.bytes[0] = (byte)n;
                swampRippleDown = GameObject.createFromPrecisePosition(0, -5);
                GameWorld.swampRippleDown.type = 1;
                swampRippleDown.setSprite(12);
                GameWorld.swampRippleDown.sprite.visible = false;
                GameWorld.swampRippleDown.bytes[0] = (byte)n;
                this.addObject(swampRipple, false);
                this.addObject(swampRippleUp, false);
                this.addObject(swampRippleDown, false);
            }
            this.addObjects();
            this.sortObjects();
            if (dataInputStream != null) {
                dataInputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.scrollView(true);
    }

    private void checkEndLevel() {
        if (this.savedAnimals == this.savingAnimals && this.savedAnimals != 0 || Engine.isCheatMode && Engine.isPressed(16384)) {
            if (endLevelTick == -1) {
                endLevelTick = Engine.tick;
                bWin = true;
                Engine.releaseAllKeys();
            }
        } else if (currentLevelTimeLimit - (Engine.tick - levelTimeTick) < 0 && currentLevelTimeLimit != 0) {
            DeviceSound.play(131073);
            if (endLevelTick == -1) {
                endLevelTick = Engine.tick;
            }
        }
        if (endLevelTick != -1) {
            playerLocked = true;
            if (Engine.tick > endLevelTick + 20 && !bStatistics) {
                if (bWin) {
                    endLevelTick = -1;
                    bStatistics = true;
                    statTick = Engine.tick;
                    DeviceSound.play(131078);
                } else {
                    ++retriesNum;
                    endLevelTick = -1;
                    Engine.destroyGameWorld();
                    Engine.fadeIn(false);
                    Menu.engine.initGameWorld(false);
                }
            }
        }
    }

    private void drawStatistics(Graphics graphics) {
        if (Engine.menuSnowUp == null) {
            Engine.menuSnowUp = new DeviceImage(65594);
            Engine.menuSnowRight = new DeviceImage(65593);
            Engine.menuSnowDown = new DeviceImage(65592);
        }
        graphics.setClip(0, 0, Device.WIDTH, Device.HEIGHT);
        Menu.paintFigurinesBG(graphics, 60, 70);
        if (!Engine.hasAnyKeyPressed()) {
            FontMgr.drawStringAutoChangeLine(2, graphics, Engine.text[50], Device.WIDTH / 2, Device.HEIGHT / 12, 18, 17);
            FontMgr.drawString(2, graphics, Engine.text[51], Device.WIDTH / 20, Device.HEIGHT * 3 / 10, 20);
            int n = (currentLevelTimeLimit - restTime) / 10;
            if (n < 0) {
                n = 0;
            }
            FontMgr.drawString(2, graphics, "" + n / 600, Device.WIDTH * 3 / 4 - 24, Device.HEIGHT * 3 / 10, 17);
            FontMgr.drawString(2, graphics, "" + n / 60 % 10, Device.WIDTH * 3 / 4 - 12, Device.HEIGHT * 3 / 10, 17);
            FontMgr.drawString(2, graphics, ":", Device.WIDTH * 3 / 4, Device.HEIGHT * 3 / 10, 17);
            FontMgr.drawString(2, graphics, "" + n % 60 / 10, Device.WIDTH * 3 / 4 + 12, Device.HEIGHT * 3 / 10, 17);
            FontMgr.drawString(2, graphics, "" + n % 60 % 10, Device.WIDTH * 3 / 4 + 24, Device.HEIGHT * 3 / 10, 17);
            FontMgr.drawString(2, graphics, Engine.text[52], Device.WIDTH / 20, Device.HEIGHT * 4 / 10, 20);
            FontMgr.drawString(2, graphics, "" + this.ateBonusCount, Device.WIDTH * 3 / 4 - 20, Device.HEIGHT * 4 / 10, 17);
            FontMgr.drawString(2, graphics, "/", Device.WIDTH * 3 / 4, Device.HEIGHT * 4 / 10, 17);
            FontMgr.drawString(2, graphics, "" + this.currentLevelTotalBonusCount, Device.WIDTH * 3 / 4 + 20, Device.HEIGHT * 4 / 10, 17);
            FontMgr.drawString(2, graphics, Engine.text[53], Device.WIDTH / 20, Device.HEIGHT * 5 / 10, 20);
            FontMgr.drawString(2, graphics, "" + retriesNum, Device.WIDTH * 3 / 4, Device.HEIGHT * 5 / 10, 17);
            String string = "D";
            int n2 = 100 - (n * 100 / (60 * currentLevelTimeLimit) + (this.currentLevelTotalBonusCount - this.ateBonusCount) * 2 + retriesNum * 15) / 3;
            if (n2 >= 75) {
                string = "A";
            } else if (n2 >= 50) {
                string = "B";
            } else if (n2 >= 25) {
                string = "C";
            }
            FontMgr.drawString(2, graphics, Engine.text[54], Device.WIDTH / 20, Device.HEIGHT * 7 / 11, 20);
            FontMgr.drawString(2, graphics, "" + string, Device.WIDTH * 3 / 4, Device.HEIGHT * 7 / 11, 17);
            if (Engine.tick % 30 < 15) {
                FontMgr.drawString(1, graphics, Engine.text[39], Device.WIDTH / 2, Device.HEIGHT * 8 / 10, 17);
            }
        } else {
            if (Engine.saveSlotInfoBytes[1] + this.ateBonusCount >= 100) {
                if (Engine.saveSlotInfoBytes[2] >= 9) {
                    Engine.saveSlotInfoBytes[1] = 99;
                } else {
                    Engine.saveSlotInfoBytes[1] = (byte)((Engine.saveSlotInfoBytes[1] + this.ateBonusCount) % 100);
                    Engine.saveSlotInfoBytes[2] = (byte)(Engine.saveSlotInfoBytes[2] + 1);
                }
            } else {
                Engine.saveSlotInfoBytes[1] = (byte)(Engine.saveSlotInfoBytes[1] + (byte)this.ateBonusCount);
            }
            Engine.saveRMS(1);
            statTick = -1;
            bStatistics = false;
            retriesNum = 0;
            restTime = 0;
            this.currentLevelTotalBonusCount = 0;
            Engine.destroyGameWorld();
            if (Engine.bIsDemoMode) {
                if (level < 2) {
                    ++level;
                    Menu.engine.initGameWorld(true);
                } else {
                    Engine.loadMenuRes();
                    Engine.setMenu(Engine.menuDemoEnd);
                    Menu.bPaintScrollWords = true;
                    Engine.fadeOut(false, 0);
                }
            } else if (level < 8) {
                ++level;
                Menu.engine.initGameWorld(true);
            } else {
                Engine.endingScreenState = 0;
                Engine.state = 6;
            }
        }
    }

    public static boolean isOnMap(int n, int n2) {
        return n >= 0 && n <= mapRows - 1 && n2 >= 0 && n2 <= mapCols - 1;
    }

    public static int getTile(int n, int n2) {
        if (!GameWorld.isOnMap(n, n2)) {
            return -1;
        }
        return map[n * mapCols + n2];
    }

    public void setTile(int n, int n2, int n3) {
        GameWorld.map[n * GameWorld.mapCols + n2] = (short)n3;
    }

    public static SGSprite getTileSprite(int n) {
        int n2 = n / 200;
        SGSprite sGSprite = null;
        if (n2 < tiles.length && n % 200 < tiles[n2].length) {
            sGSprite = tiles[n2][n % 200];
        }
        return sGSprite;
    }

    public boolean isTileWalkable(GameObject gameObject, int n, int n2) {
        if (!GameWorld.isOnMap(n, n2)) {
            return false;
        }
        short s = map[n * mapCols + n2];
        if (s != -1) {
            int n3 = GameWorld.getTileSprite(s).getAnimationSequenceDuration(s % 200);
            if (n3 == 320 && gameObject.spriteId == 5 || gameObject.spriteId == 22 && gameObject.bytes[6] != 0 && n3 == 360) {
                return false;
            }
            if (n3 == 10 || n3 == 30 || n3 == 300 || n3 == 550 || n3 == 320 || n3 == 350 || n3 == 360 || player != null && GameWorld.player.spriteId == 2 && isTigerOnStage && n3 == 290 || player != null && GameWorld.player.spriteId == 3 && isSidOnStage && n3 == 290 || n3 == 450) {
                return true;
            }
            if (player != null && GameWorld.player.spriteId == 2) {
                if (GameWorld.player.sprite.currentAnimation >= 8 && GameWorld.player.sprite.currentAnimation <= 11) {
                    return true;
                }
                if (GameWorld.player.bytes[1] == 2 && n3 == 240 && GameWorld.player.velX >= 0 || GameWorld.player.bytes[1] == 6 && n3 == 260 && GameWorld.player.velX <= 0 || GameWorld.player.bytes[1] == 4 && n3 == 270 && GameWorld.player.velY >= 0 || GameWorld.player.bytes[1] == 0 && n3 == 250 && GameWorld.player.velY <= 0) {
                    return true;
                }
            } else if (player != null && GameWorld.player.spriteId == 3 && n3 >= 580 && n3 <= 630) {
                return true;
            }
        }
        return false;
    }

    public boolean isTileInteractable(int n) {
        for (int i = 0; i < DataManager.INTERACTABLE_TILES.length; ++i) {
            if (n != DataManager.INTERACTABLE_TILES[i]) continue;
            return true;
        }
        return false;
    }

    public static int scaleGame(int n) {
        if (tileSize == 16) {
            return n;
        }
        return n * tileSize / 16;
    }

    public static int scaleToBase(int n) {
        if (tileSize == 16) {
            return n;
        }
        return n * 16 / tileSize;
    }

    public static String getLevelName(int n) {
        return n == -1 ? null : null;
    }

    public void hideNotify() {
    }

    public void playerAction(GameObject gameObject) {
        if ((gameObject.spriteId == 5 || gameObject.spriteId == 36) && GameWorld.player.spriteId == 1) {
            boolean bl = (GameWorld.player.bytes[1] == 0 || GameWorld.player.bytes[1] == 4) && GameWorld.player.sprite.x > gameObject.sprite.x + (gameObject.collisionOffsetX >> 8) && GameWorld.player.sprite.x < gameObject.sprite.x + (gameObject.collisionOffsetX >> 8) + (gameObject.collisionWidth >> 8);
            boolean bl2 = bl = bl || (GameWorld.player.bytes[1] == 6 || GameWorld.player.bytes[1] == 2) && GameWorld.player.sprite.y > gameObject.sprite.y + (gameObject.collisionOffsetY >> 8) && GameWorld.player.sprite.y < gameObject.sprite.y + (gameObject.collisionOffsetY >> 8) + (gameObject.collisionHeight >> 8);
            if (gameObject.spriteId == 5 && bl && player.isMoving() && (GameWorld.player.velX == 0 || GameWorld.player.velY == 0) && !gameObject.isMoving()) {
                gameObject.bytes[1] = GameWorld.player.bytes[1];
                if (GameWorld.player.velX != 0) {
                    int n = GameWorld.player.velX = GameWorld.player.velX < 0 ? -512 : 512;
                }
                if (GameWorld.player.velY != 0) {
                    GameWorld.player.velY = GameWorld.player.velY < 0 ? -512 : 512;
                }
                gameObject.velX = GameWorld.player.velX;
                gameObject.velY = GameWorld.player.velY;
                gameObject.setMovementAnimation();
                isPlayerMoveStone = true;
            } else if (gameObject.spriteId == 36 && bl && GameWorld.player.sprite.currentAnimation >= 11 && GameWorld.player.sprite.currentAnimation <= 14) {
                if (GameWorld.player.sprite.currentAnimation == 11) {
                    GameWorld.player.velX = 0;
                    GameWorld.player.velY = 256;
                    gameObject.sprite.startAnimation(1, 0);
                } else if (GameWorld.player.sprite.currentAnimation == 12) {
                    GameWorld.player.velX = -256;
                    GameWorld.player.velY = 0;
                    gameObject.sprite.startAnimation(2, 0);
                } else if (GameWorld.player.sprite.currentAnimation == 13) {
                    GameWorld.player.velX = 0;
                    GameWorld.player.velY = -256;
                    gameObject.sprite.startAnimation(3, 0);
                } else if (GameWorld.player.sprite.currentAnimation == 14) {
                    GameWorld.player.velX = 256;
                    GameWorld.player.velY = 0;
                    gameObject.sprite.startAnimation(4, 0);
                }
                gameObject.velX = GameWorld.player.velX;
                gameObject.velY = GameWorld.player.velY;
            }
            return;
        }
        if (gameObject.spriteId == 10) {
            if (!this.hintObject.sprite.visible && (GameWorld.player.spriteId == 1 && gameObject.sprite.currentAnimation == 0 || GameWorld.player.spriteId == 3 && gameObject.sprite.currentAnimation == 1)) {
                this.hintObject.sprite.startAnimation(0, 0);
                this.hintObject.tickHint();
                this.hintObject.sprite.visible = true;
            }
            if (GameWorld.player.spriteId == 3 && (gameObject.sprite.currentAnimation == 2 || gameObject.sprite.currentAnimation == 3)) {
                isSidOnStage = true;
            } else if (GameWorld.player.spriteId == 2 && gameObject.sprite.currentAnimation == 4) {
                isTigerOnStage = false;
            }
            return;
        }
        if (gameObject.spriteId == 1 && GameWorld.player.spriteId == 2 && GameWorld.player.sprite.currentAnimation >= 8 && GameWorld.player.sprite.currentAnimation <= 11 && gameObject.sprite.currentAnimation != 8) {
            int n;
            int n2 = n = gameObject.bytes[1] == 2 || gameObject.bytes[1] == 6 ? 3 : 1;
            if (Math.abs(GameWorld.player.x - gameObject.x) >> 8 <= 16 / n && Math.abs(GameWorld.player.y - gameObject.y) >> 8 <= 16 / n) {
                isTigerOnEle = true;
                GameWorld.player.sprite.startAnimation(GameWorld.player.sprite.currentAnimation + 9, 1);
            }
            return;
        }
        if (gameObject.spriteId == 14 && (gameObject.sprite.currentAnimation == 0 || gameObject.sprite.currentAnimation == 2)) {
            if (gameObject.sprite.currentAnimation == 2) {
                GameObject gameObject2 = (GameObject)assignedMappings.get(new Integer(gameObject.ints[5]));
                gameObject2.sprite.startAnimation(3, 1);
                gameObject.ints[4] = 40;
            }
            gameObject.sprite.startAnimation(1, 1);
            gameObject.ints[0] = gameObject.ints[2] = (gameObject.x >> 8) - mapView[0];
            gameObject.ints[1] = gameObject.ints[3] = (gameObject.y >> 8) - mapView[1];
            DeviceSound.play(131083);
            return;
        }
        if (gameObject.spriteId == 16 && GameWorld.player.spriteId == 3 && GameWorld.player.sprite.currentAnimation == 19 && GameWorld.player.sprite.animationDone) {
            if (gameObject.sprite.currentAnimation != 1) {
                gameObject.sprite.startAnimation(1, 1);
            }
            return;
        }
        if (gameObject.spriteId == 30 && GameWorld.player.spriteId == 3 && GameWorld.player.sprite.currentAnimation == 19 && GameWorld.player.sprite.animationDone) {
            if (gameObject.sprite.currentAnimation != 1) {
                gameObject.sprite.startAnimation(1, 1);
            }
            return;
        }
        if (gameObject.spriteId == 17) {
            if (gameObject.sprite.currentAnimation == 0 && (GameWorld.player.spriteId != 2 || GameWorld.player.sprite.currentAnimation < 8 || GameWorld.player.sprite.currentAnimation > 11)) {
                GameWorld.player.bIsHurt = false;
                GameWorld.player.sprite.visible = false;
                playerLocked = true;
                GameWorld.player.velX = 0;
                GameWorld.player.velY = 0;
                if (gameObject.bytes[1] == 0) {
                    gameObject.sprite.startAnimation(GameWorld.player.spriteId == 2 ? 1 : (GameWorld.player.spriteId == 3 ? 5 : 9), 1);
                    player.setTile(gameObject.getRow() - 4, gameObject.getCol());
                } else if (gameObject.bytes[1] == 2) {
                    gameObject.sprite.startAnimation(GameWorld.player.spriteId == 2 ? 2 : (GameWorld.player.spriteId == 3 ? 6 : 10), 1);
                    player.setTile(gameObject.getRow(), gameObject.getCol() + 4);
                } else if (gameObject.bytes[1] == 4) {
                    gameObject.sprite.startAnimation(GameWorld.player.spriteId == 2 ? 3 : (GameWorld.player.spriteId == 3 ? 7 : 11), 1);
                    player.setTile(gameObject.getRow() + 4, gameObject.getCol());
                } else if (gameObject.bytes[1] == 6) {
                    gameObject.sprite.startAnimation(GameWorld.player.spriteId == 2 ? 4 : (GameWorld.player.spriteId == 3 ? 8 : 12), 1);
                    player.setTile(gameObject.getRow(), gameObject.getCol() - 4);
                }
            }
            return;
        }
    }

    public void playerActionScript(GameObject gameObject) {
    }

    public void playerActionScript(int[] nArray) {
    }

    public int[] getPathToTile(GameObject gameObject, int n, int n2, int n3, int n4) {
        if (n == n3 && n2 == n4) {
            return new int[]{n, n2};
        }
        try {
            int n5 = n;
            int n6 = n2;
            this.currentNode = new AStarNode(null, n, n2, 0, 0, 0, 1);
            Hashtable<Short, AStarNode> hashtable = new Hashtable<Short, AStarNode>();
            hashtable.put(new Short((short)(n * mapCols + n2)), this.currentNode);
            Vector<AStarNode> vector = new Vector<AStarNode>();
            for (int i = 0; i < 100; ++i) {
                if (this.currentNode == null) {
                    return null;
                }
                this.currentNode.list = 2;
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        AStarNode aStarNode;
                        int n7 = this.currentNode.row + j;
                        int n8 = this.currentNode.col + k;
                        if (n7 == n3 && n8 == n4) {
                            return this.constructPath(n5, n6, n7, n8);
                        }
                        if (n7 < 0 || n7 >= mapRows || n8 < 0 || n8 >= mapCols || (aStarNode = (AStarNode)hashtable.get(new Short((short)(n7 * mapCols + n8)))) != null && aStarNode.list == 2) continue;
                        int n9 = gameObject.x;
                        int n10 = gameObject.y;
                        gameObject.setTile(n7, n8);
                        if (this.isTileWalkable(gameObject, n7, n8)) {
                            int n11 = Math.abs(k) + Math.abs(j) == 2 ? this.currentNode.g + 361 : this.currentNode.g + 256;
                            int n12 = Math.abs(n7 - n3) + Math.abs(n8 - n4) << 8;
                            int n13 = n11 + n12;
                            if (aStarNode != null && aStarNode.list == 1) {
                                if (n11 < aStarNode.g) {
                                    aStarNode.parent = this.currentNode;
                                    aStarNode.g = n11;
                                    aStarNode.f = n13;
                                }
                            } else {
                                AStarNode aStarNode2 = new AStarNode(this.currentNode, n7, n8, n11, n12, n13, 1);
                                hashtable.put(new Short((short)(n7 * mapCols + n8)), aStarNode2);
                                boolean bl = false;
                                for (int i2 = 0; i2 < vector.size(); ++i2) {
                                    AStarNode aStarNode3 = (AStarNode)vector.elementAt(i2);
                                    if (aStarNode2.f >= aStarNode3.f) continue;
                                    vector.insertElementAt(aStarNode2, i2);
                                    bl = true;
                                    break;
                                }
                                if (!bl) {
                                    vector.addElement(aStarNode2);
                                }
                            }
                        } else if (n7 == n3 && n8 == n4) {
                            return this.constructPath(n5, n6, n7, n8);
                        }
                        gameObject.setX(n9);
                        gameObject.setY(n10);
                    }
                }
                if (vector.size() == 0) {
                    this.currentNode = null;
                    continue;
                }
                this.currentNode = (AStarNode)vector.elementAt(0);
                vector.removeElementAt(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currentNode = null;
        return null;
    }

    public int[] constructPath(int n, int n2, int n3, int n4) {
        Vector<int[]> vector = new Vector<int[]>();
        vector.addElement(new int[]{n3, n4});
        while (this.currentNode != null && (this.currentNode.row != n || this.currentNode.col != n2)) {
            vector.addElement(new int[]{this.currentNode.row, this.currentNode.col});
            this.currentNode = this.currentNode.parent;
        }
        this.currentNode = null;
        int[] nArray = new int[vector.size() << 1];
        int n5 = vector.size() - 1;
        int n6 = 0;
        while (n5 >= 0) {
            int[] nArray2 = (int[])vector.elementAt(n5);
            nArray[n6] = (short)nArray2[0];
            nArray[n6 + 1] = (short)nArray2[1];
            --n5;
            n6 += 2;
        }
        return nArray;
    }

    public static GameObject createSpeechBubble(String string, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        GameObject gameObject = GameObject.createFromPrecisePosition(n, n2);
        gameObject.type = 5;
        gameObject.booleans[2] = bl2;
        if (n5 == 3) {
            gameObject.setSpeechBubbleText(string, n5);
        } else {
            gameObject.setSpeechBubbleText(string, 1);
        }
        if (n3 == -1) {
            gameObject.ints[4] = -1;
            gameObject.ints[5] = -1;
            gameObject.bytes[5] = -1;
        } else {
            if (n4 < n2) {
                gameObject.bytes[5] = 0;
            } else if (n4 > n2) {
                gameObject.bytes[5] = 4;
            } else if (n3 < n) {
                gameObject.bytes[5] = 6;
            } else if (n3 > n) {
                gameObject.bytes[5] = 2;
            }
            gameObject.ints[4] = n3 >> 8;
            gameObject.ints[5] = n4 >> 8;
        }
        gameObject.booleans[0] = true;
        gameObject.booleans[1] = bl;
        return gameObject;
    }

    public static GameObject createCharacter(int n, int n2, int n3, int n4, int n5) {
        GameObject gameObject = GameObject.createFromTile(n4, n5);
        gameObject.type = 1;
        gameObject.bytes[2] = -1;
        gameObject.bytes[5] = (byte)n2;
        gameObject.bytes[0] = (byte)n3;
        gameObject.setSprite(n);
        if (n == 15 && n2 == 1) {
            gameObject.sprite.startAnimation(n2, 1);
        } else {
            gameObject.sprite.startAnimation(n2, 0);
        }
        return gameObject;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2 = -mapView[0];
        int n3 = -mapView[1];
        graphics.setClip(0, 0, Device.WIDTH, viewHeight);
        int n4 = Math.max(0, mapView[1] / tileSize);
        int n5 = Math.max(0, mapView[0] / tileSize);
        int n6 = Math.min(mapRows - 1, (mapView[1] + viewHeight) / tileSize);
        int n7 = Math.min(mapCols - 1, (mapView[0] + Device.WIDTH) / tileSize + 1);
        for (n = n4; n <= n6; ++n) {
            for (int i = n5; i <= n7; ++i) {
                int n8;
                int n9 = map[n * mapCols + i];
                if (n9 == -1) continue;
                int n10 = -1;
                int n11 = n9;
                if ((n9 %= 200) >= tiles[n8 = n9 / 200].length) continue;
                tiles[n8][n9].paint(graphics, i * tileSize + tileSize / 2 + n2 - 1, n * tileSize + tileSize + n3 - 1);
            }
        }
        for (n = 0; n < this.objectsOnScreenBottom.size(); ++n) {
            ((GameObject)this.objectsOnScreenBottom.elementAt(n)).paint(graphics, n2, n3);
        }
        for (n = 0; n < this.objectsOnScreen.size(); ++n) {
            ((GameObject)this.objectsOnScreen.elementAt(n)).paint(graphics, n2, n3);
        }
        if (isObserveStyle) {
            GameWorld.observeObject.sprite.spriteImages[0].drawImage(graphics, Device.WIDTH / 2 + GameWorld.observeObject.sprite.layerImageX[0][0], (Device.HEIGHT - 22) / 12 + GameWorld.observeObject.sprite.layerImageY[0][0] + (Engine.tick % 9 < 4 ? 0 : 3));
            GameWorld.observeObject.sprite.spriteImages[1].drawImage(graphics, Device.WIDTH * 11 / 12 + GameWorld.observeObject.sprite.layerImageX[1][0] + (Engine.tick % 9 < 4 ? 0 : 3), (Device.HEIGHT - 22) / 2 + GameWorld.observeObject.sprite.layerImageY[1][0]);
            GameWorld.observeObject.sprite.spriteImages[2].drawImage(graphics, Device.WIDTH / 2 + GameWorld.observeObject.sprite.layerImageX[2][0], (Device.HEIGHT - 22) * 11 / 12 + GameWorld.observeObject.sprite.layerImageY[2][0] + (Engine.tick % 9 < 4 ? 0 : -3));
            GameWorld.observeObject.sprite.spriteImages[3].drawImage(graphics, Device.WIDTH / 12 + GameWorld.observeObject.sprite.layerImageX[3][0] + (Engine.tick % 9 < 4 ? 0 : -3), (Device.HEIGHT - 22) / 2 + GameWorld.observeObject.sprite.layerImageY[3][0]);
        }
        if (currentLevelTimeLimit != 0) {
            if (!(bStatistics || Engine.state == 110 || this.bIsFreezeTime || bWin)) {
                restTime = currentLevelTimeLimit - (Engine.tick - levelTimeTick);
            }
            if (restTime >= 0) {
                n = restTime / 10;
                FontMgr.drawString(2, graphics, "" + n / 600, 118, 10, 17);
                FontMgr.drawString(2, graphics, "" + n / 60 % 10, 130, 10, 17);
                FontMgr.drawString(2, graphics, ":", 142, 10, 17);
                FontMgr.drawString(2, graphics, "" + n % 60 / 10, 153, 10, 17);
                FontMgr.drawString(2, graphics, "" + n % 60 % 10, 165, 10, 17);
            }
        }
        if (this.hintObject.sprite.visible) {
            this.hintObject.paint(graphics, n2, n3);
        }
        if (this.dialogSpeechBubble != null) {
            this.dialogSpeechBubble.paint(graphics, n2, n3);
        }
        if (!(MapEditor.enabled || bStatistics || isIGM)) {
            this.drawHud(graphics);
            Engine.paintTooltips(graphics, 4);
        }
        if (this.enteringLevelName != null) {
            // empty if block
        }
        if (this.scriptTextBubble != null) {
            this.scriptTextBubble.paint(graphics, n2, n3);
        }
        if (endLevelTick != -1) {
            if (bWin) {
                graphics.setClip(0, 0, Device.WIDTH, viewHeight);
                Menu.paintHighLightBG(graphics, Device.INGAME_WIN_BG_Y, 60);
                FontMgr.drawStringAutoChangeLine(2, graphics, Engine.getText(48), Device.WIDTH / 2, 90, 150, 18, 17);
            } else {
                graphics.setClip(0, 0, Device.WIDTH, viewHeight);
                Menu.paintHighLightBG(graphics, Device.INGAME_WIN_BG_Y, 60);
                FontMgr.drawStringAutoChangeLine(2, graphics, Engine.getText(49), Device.WIDTH / 2, 100, 150, 18, 17);
            }
        }
        if (bStatistics) {
            this.drawStatistics(graphics);
        }
        if (Engine.isCheatMode) {
            graphics.setColor(0xFF0000);
            graphics.drawString("GOD", 5, 5, 0);
        }
    }

    public static void drawSpeechBubble(Graphics graphics, int n, int n2, int n3, int n4, String[] stringArray, int n5, int n6, int n7, int n8, int n9, boolean bl, int n10) {
        int n11;
        int n12;
        if (n3 == -1) {
            n3 = FontMgr.stringWidth(0, stringArray[0]) + 8;
        }
        if (n4 == -1) {
            n4 = Math.min(stringArray.length, n5) * FontMgr.charHeight[0] + 8;
        }
        if ((n7 & 8) > 0) {
            n -= n3;
        } else if ((n7 & 1) > 0) {
            n -= n3 / 2;
        }
        if ((n7 & 0x20) > 0) {
            n2 -= n4;
        } else if ((n7 & 2) > 0) {
            n2 -= n4 / 2;
        }
        if (n < 0) {
            n = 3;
        } else if (n + n3 > Device.WIDTH) {
            n = Device.WIDTH - 3 - n3;
        }
        if (n10 == 3) {
            n = Device.WIDTH - 160 >> 1;
            n12 = n2 - 35;
            n11 = n4 + 35;
            Menu.paintHighLightBG(graphics, 12375776, n12, n11);
            FontMgr.drawString(2, graphics, Engine.levelName[level], n + n3 / 2, n12 + 5, 17);
            GameWorld.interfaceObject.sprite.startAnimation(7, 0);
            GameWorld.interfaceObject.sprite.paint(graphics, 0, n12 - 4);
        } else {
            graphics.setColor(0);
            graphics.fillRect(n, n2, n3, n4);
            graphics.setColor(0xE6E6E6);
            graphics.fillRect(n + 2, n2 + 2, n3 - 4, n4 - 4);
        }
        if (bl) {
            n12 = n2 + 5;
            n11 = n6;
            for (int i = 0; i < n5 && n11 < stringArray.length; ++n11, ++i) {
                graphics.setColor(0);
                FontMgr.drawString(0, graphics, stringArray[n11], n + n3 / 2, n12, 17);
                n12 += FontMgr.charHeight[0];
            }
        }
        if (bl && n8 != -1) {
            if (n9 == 4) {
                n8 = Math.max(n + 3, n8);
                speechBubbleArrowImages[0].drawImage(graphics, n8 + GameWorld.speechBubbleArrowImages[0].width / 2, n2 + n4 - 2, 17);
            } else if (n9 == 0) {
                n8 = Math.max(n + 3, n8);
                speechBubbleArrowImages[1].drawImage(graphics, n8 + GameWorld.speechBubbleArrowImages[0].width / 2, n2 + 2, 33);
            } else if (n9 == 6) {
                n8 = Math.max(n2 + 3, n8);
                speechBubbleArrowImages[2].drawImage(graphics, n + 2, n8 + GameWorld.speechBubbleArrowImages[0].height / 2, 10);
            } else if (n9 == 2) {
                n8 = Math.max(n2 + 3, n8);
                speechBubbleArrowImages[3].drawImage(graphics, n + n3 - 2, n8 + GameWorld.speechBubbleArrowImages[0].height / 2, 6);
            }
        }
    }

    public void drawHud(Graphics graphics) {
        if (interfaceSprite != null) {
            int n;
            graphics.setClip(0, viewHeight - 10, Device.WIDTH, 32);
            if (drawHud) {
                GameWorld.interfaceSprite.spriteImages[0].drawImage(graphics, 0, viewHeight);
                GameWorld.interfaceSprite.spriteImages[4 + this.savedAnimals].drawImage(graphics, 110, 204);
                GameWorld.interfaceSprite.spriteImages[4 + this.savingAnimals].drawImage(graphics, 124, 204);
                if (player == null) {
                    for (n = 1; n <= this.preFocusedObject.hp; ++n) {
                        GameWorld.interfaceSprite.spriteImages[17 + (n % 2 == 1 ? 0 : 5)].drawImage(graphics, 42 + (n - 1) / 2 * 12, 204);
                    }
                } else {
                    for (n = 1; n <= GameWorld.player.hp; ++n) {
                        GameWorld.interfaceSprite.spriteImages[17 + (n % 2 == 1 ? 0 : 5)].drawImage(graphics, 42 + (n - 1) / 2 * 12, 204);
                    }
                }
                if (this.ateBonusCount < 10) {
                    GameWorld.interfaceSprite.spriteImages[4 + this.ateBonusCount].drawImage(graphics, 163, 204);
                } else {
                    GameWorld.interfaceSprite.spriteImages[4 + this.ateBonusCount / 10].drawImage(graphics, 160, 204);
                    GameWorld.interfaceSprite.spriteImages[4 + this.ateBonusCount % 10].drawImage(graphics, 168, 204);
                }
                drawHud = false;
            }
            if (player == null) {
                GameWorld.interfaceSprite.spriteImages[this.preFocusedObject.spriteId].drawImage(graphics, 0, viewHeight - 10);
            } else if (bIsPlayerChanged) {
                n = 0;
                n = player == this.player_ele ? 19 : (player == this.player_tiger ? 20 : 21);
                graphics.setClip(0, 0, Device.WIDTH, Device.HEIGHT);
                GameWorld.interfaceSprite.spriteImages[n].drawImage(graphics, 0, viewHeight - 21);
                if (Engine.tick - this.playerChangeTick > 35) {
                    bIsPlayerChanged = false;
                    drawHud = true;
                }
            } else {
                GameWorld.interfaceSprite.spriteImages[GameWorld.player.spriteId].drawImage(graphics, 0, viewHeight - 10);
            }
            if (!bonusObjects.isEmpty()) {
                for (n = 0; n < bonusObjects.size(); ++n) {
                    GameObject gameObject = (GameObject)bonusObjects.elementAt(n);
                    if (gameObject.booleans[1]) {
                        Engine.saveAndSetClip(graphics, 0, 0, Device.WIDTH, Device.HEIGHT);
                        gameObject.sprite.spriteImages[0].drawImage(graphics, gameObject.ints[0], gameObject.ints[1]);
                        Engine.restoreClip(graphics);
                        continue;
                    }
                    this.bonusTick = 0;
                    bonusObjects.removeElement(gameObject);
                    if (gameObject.ints[4] == 40) {
                        this.ateBonusCount += 10;
                        continue;
                    }
                    ++this.ateBonusCount;
                }
            } else if (this.bonusTick > -1 && this.bonusTick < 12) {
                GameWorld.interfaceSprite.spriteImages[14 + this.bonusTick % 3].drawImage(graphics, 141, 200);
                if (this.bonusTick == 11) {
                    this.bonusTick = -1;
                    drawHud = true;
                }
            }
        }
    }

    public static void drawNumbers(Graphics graphics, DeviceImage[] deviceImageArray, String string, int n, int n2, int n3) {
        if ((n3 & 1) > 0) {
            n -= GameWorld.numberWidth(deviceImageArray, string) / 2;
        }
        if ((n3 & 2) > 0) {
            n2 -= deviceImageArray[0].height / 2;
        }
        int n4 = n;
        for (int i = 0; i < string.length(); ++i) {
            int n5 = string.charAt(i) - 48;
            deviceImageArray[n5].drawImage(graphics, n4, n2);
            if (n5 == 1) {
                n4 += deviceImageArray[n5].width / 2;
                continue;
            }
            n4 += deviceImageArray[n5].width;
        }
    }

    public static int numberWidth(DeviceImage[] deviceImageArray, String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            int n2 = string.charAt(i) - 48;
            n += n2 == 1 ? deviceImageArray[n2].width / 2 : deviceImageArray[n2].width;
        }
        return n;
    }

    static {
        mapView = new int[2];
        bonusObjects = new Vector();
        tiles = new SGSprite[3][];
        isTigerOnEle = false;
        isPlayerDie = false;
        isSidOnStage = false;
        isTigerOnStage = false;
        tigerJumpTile = -1;
        isPlayerOnIce = false;
        isObserveStyle = false;
        isPlayerMoveStone = false;
        swampTick = -1;
        swampHeight = 0;
        swampClipRect = new int[4];
        isPlayerOnSwamp = false;
        endLevelTick = -1;
        TILESHEET_GROUND_NAMES = new String[]{"level2", "level1", "level3"};
        TILESHEET_MIDDLE_NAMES = new String[]{"COLOURED_green", "COLOURED_blue", "COLOURED_red"};
        SPRITE_NAMES = new String[]{"UI_ingame", "player_elephant", "player_tiger", "player_sid", "help_pig", "stone_move", "tree1", "tree2", "tree3", "hill", "discovery", "hint", "swamp", "bridge", "bonus", "falling_stone", "snowhill_melt", "spring", "fell_snow_platform", "small_block", "wall_fire", "ice_hole_fish", "rhinoceros", "tree6", "lava_platform", "attack_area", "flower_lick", "tree7", "fish", "ice_broke", "wild_grass", "observe", "tree8", "tree9", "mound", "spineball", "pull_stone", "sea_otter", "chinemys", "twins", "squirrel"};
        SPRITE_LOADED = new int[]{0, 0, 0, 0, 0, 0, 73, 365, 73, -1, 0, 0, 73, 192, 0, 438, 292, 146, 292, 292, 146, 292, 290, 292, 146, 0, 290, 292, 292, 438, 210, 0, 146, 146, 146, 73, 0, 0, 0, 0, 0};
        bStatistics = false;
        statTick = -1;
        retriesNum = 0;
    }
}

