/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DeviceImage
implements Constants {
    public static final int MANIPULATION_NONE = 0;
    public static final int MANIPULATION_FLIP_HORIZONTAL = 2;
    public static final int MANIPULATION_FLIP_VERTICAL = 1;
    public static final int MANIPULATION_ROTATE_90 = 5;
    public static final int MANIPULATION_ROTATE_180 = 3;
    public static final int MANIPULATION_ROTATE_270 = 6;
    public static final boolean USE_CLIPPING = false;
    private Image image;
    private int manipulation = 0;
    private int clip_x;
    private int clip_y;
    public short width;
    public short height;
    public boolean requireClipping;

    public DeviceImage(byte[] byArray) {
        this.createImage(byArray);
    }

    public DeviceImage(int n) {
        this.createImage(ResourceMaster.getResource(n));
    }

    public DeviceImage(String string) {
        this.createImage(ResourceMaster.getResource(string));
    }

    public DeviceImage(String string, int n) {
        byte[] byArray = ResourceMaster.getResource(string);
        this.createImage(byArray);
    }

    public DeviceImage(DeviceImage deviceImage, int n) {
        this.image = deviceImage.image;
        this.manipulation = n;
        this.clip_x = deviceImage.clip_x;
        this.clip_y = deviceImage.clip_y;
        this.requireClipping = deviceImage.requireClipping;
        if (n >= 4) {
            this.width = deviceImage.height;
            this.height = deviceImage.width;
        } else {
            this.width = deviceImage.width;
            this.height = deviceImage.height;
        }
    }

    private void createImage(byte[] byArray) {
        try {
            this.image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
            this.width = (short)this.image.getWidth();
            this.height = (short)this.image.getHeight();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DeviceImage(DeviceImage deviceImage, int n, int n2, int n3, int n4) {
        this.width = (short)n3;
        this.height = (short)n4;
        this.image = deviceImage.image;
        this.clip_x = n;
        this.clip_y = n2;
        if (this.clip_x != 0 || this.clip_y != 0 || this.width != deviceImage.width || this.height != deviceImage.height) {
            this.requireClipping = true;
        }
    }

    public DeviceImage[] divide(int n) {
        int n2 = this.width / n;
        short s = this.height;
        return this.divide(n2, s);
    }

    public DeviceImage[] divide(int n, int n2) {
        int n3 = this.width / n;
        int n4 = this.height / n2;
        DeviceImage[] deviceImageArray = new DeviceImage[n4 * n3];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                deviceImageArray[n5++] = new DeviceImage(this, j * n, i * n2, n, n2);
            }
        }
        return deviceImageArray;
    }

    public void drawImage(Graphics graphics, int n, int n2, int n3) {
        if (this.requireClipping || this.manipulation != 0) {
            if (this.manipulation >= 4) {
                graphics.drawRegion(this.image, this.clip_x, this.clip_y, (int)this.height, (int)this.width, this.manipulation, n, n2, n3);
            } else {
                graphics.drawRegion(this.image, this.clip_x, this.clip_y, (int)this.width, (int)this.height, this.manipulation, n, n2, n3);
            }
        } else {
            graphics.drawImage(this.image, n, n2, n3);
        }
    }

    public void drawImage(Graphics graphics, int n, int n2) {
        if (this.requireClipping || this.manipulation != 0) {
            if (this.manipulation >= 4) {
                graphics.drawRegion(this.image, this.clip_x, this.clip_y, (int)this.height, (int)this.width, this.manipulation, n, n2, 20);
            } else {
                graphics.drawRegion(this.image, this.clip_x, this.clip_y, (int)this.width, (int)this.height, this.manipulation, n, n2, 20);
            }
        } else {
            graphics.drawImage(this.image, n, n2, 0);
        }
    }

    public void drawImageNoClipping(Graphics graphics, int n, int n2) {
        graphics.drawImage(this.image, n - this.clip_x, n2 - this.clip_y, 20);
    }
}

