/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;

public class MapEditor
implements Constants {
    public static int state;
    public static final int STATE_EDIT = 0;
    public static final int STATE_MENU = 1;
    public static boolean enabled;
    public static int tool;
    public static final int TOOL_BRUSH = 0;
    public static final int TOOL_FILL = 1;
    public static final int TOOL_MARK = 2;
    public static final int TOOL_COPY = 3;
    public static final int TOOL_PASTE = 4;
    public static final int TOOL_VIEW = 5;
    public static final int TOOL_EYEDROP = 6;
    public static final String[] TOOL_NAMES;
    public static int palette;
    public static final int PALETTE_TILES_GROUND = 0;
    public static final int PALETTE_TILES_MIDDLE = 1;
    public static final int PALETTE_TILES_SHARED = 2;
    public static final int PALETTE_OBJECTS = 3;
    public static final int PALETTE_TAGS = 4;
    public static int paletteTopY;
    public static boolean marking;
    public static int markStartRow;
    public static int markEndRow;
    public static int markStartCol;
    public static int markEndCol;
    public static int copyRows;
    public static int copyCols;
    public static short[] copyTiles;
    public static int levelIndex;
    public static Vector levels;
    public static Vector levelDimensions;
    public static Vector saved;
    public static SGSprite[] tagsTilesSheet;
    public static Vector tags;
    public static int tagsTileIndex;
    public static SGSprite[][] tileSheetsGround;
    public static SGSprite[][] tileSheetsMiddle;
    public static SGSprite[] tileSheetShared;
    public static String[] tileSheetNamesGround;
    public static String[] tileSheetNamesMiddle;
    public static Vector tileSheetGroundIndex;
    public static Vector tileSheetMiddleIndex;
    public static int tileIndex;
    public static int nTileRows;
    public static SGSprite[] objectSprites;
    public static int objectIndex;
    public static int objectWidth;
    public static Vector gameObjects;
    public static GameObject selectedObject;
    public static boolean draggingObject;
    public static int draggingObjectOffsetX;
    public static int draggingObjectOffsetY;
    public static boolean dragBlock;
    public static GameWorld gameWorld;
    public static int levelDimensionsCountdown;
    public static int cursorRow;
    public static int cursorCol;
    public static Vector undoSteps;
    public static boolean showObjects;
    public static boolean showTags;
    public static boolean showRowCol;
    public static boolean tileSheetSelectionGround;
    public static boolean tileSheetSelectionMiddle;
    public static boolean movingView;
    public static int movingViewOffsetX;
    public static int movingViewOffsetY;
    public static int movingStartMapViewOffsetX;
    public static int movingStartMapViewOffsetY;
    public static boolean showSameTile;
    public static final int TAG_WAITRESS_1 = 0;
    public static final int TAG_WAITRESS_2 = 1;
    public static final int TAG_WAITRESS_3 = 2;
    public static final int TAG_WAITRESS_4 = 3;
    public static final int TAG_WAITRESS_5 = 4;

    public static void init(GameWorld gameWorld) {
        int n;
        MapEditor.gameWorld = gameWorld;
        MapEditor.gameWorld.addObject(GameWorld.player, false);
        MapEditor.gameWorld.focusedObject = GameWorld.player;
        ResourceMaster.initPak(1);
        MapEditor.loadGroundTileSheets(new String[]{"level2", "level1", "level3"});
        MapEditor.loadMiddleTileSheets(new String[]{"COLOURED_green", "COLOURED_blue", "COLOURED_red"});
        MapEditor.loadSharedTileSheet();
        tagsTilesSheet = MapEditor.loadTileSheet("waypoints");
        MapEditor.loadObjectSprites(new String[]{"help_pig", "tree1", "tree2", "tree3", "hill", "bridge", "bridge", "bridge", "discovery", "discovery", "discovery", "discovery", "bonus", "snowhill_melt", "fell_snow_platform", "bridge", "bridge", "bridge", "small_block", "small_block", "wall_fire", "wall_fire", "ice_hole_fish", "rhinoceros", "tree6", "lava_platform", "flower_lick", "ice_broke", "wild_grass", "wall_fire", "wall_fire", "wall_fire", "wall_fire", "stone_move", "tree8", "tree9", "mound", "spineball", "pull_stone", "bridge", "bridge", "bridge", "bridge", "bridge", "bridge"}, new byte[]{0, 0, 0, 0, 0, 0, 1, 2, 2, 3, 4, 5, 0, 0, 0, 3, 4, 5, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 5, 0, 0, 0, 0, 0, 0, 6, 7, 8, 9, 10, 11});
        int n2 = 0;
        for (n = 0; n < tileSheetsGround.length; ++n) {
            n2 = Math.max(n2, tileSheetsGround[n].length);
        }
        for (n = 0; n < tileSheetsMiddle.length; ++n) {
            n2 = Math.max(n2, tileSheetsMiddle[n].length);
        }
        n2 = Math.max(n2, tileSheetShared.length);
        nTileRows = 1 + n2 / (Device.WIDTH / GameWorld.tileSize);
        paletteTopY = Device.HEIGHT - 2 * nTileRows * GameWorld.tileSize;
        for (n = 0; n < objectSprites.length; ++n) {
            DeviceImage[] deviceImageArray = MapEditor.objectSprites[n].spriteImages;
            if (deviceImageArray.length <= 0) continue;
            paletteTopY = Math.min(paletteTopY, Device.HEIGHT - deviceImageArray[0].height);
            objectWidth = Math.min(50, Math.max(objectWidth, deviceImageArray[0].width));
        }
        ResourceMaster.closeResource();
        MapEditor.loadAllLevels();
        MapEditor.setLevel(0);
        MapEditor.setPalette(0);
        showSameTile = true;
    }

    public static void loadGroundTileSheets(String[] stringArray) {
        tileSheetNamesGround = stringArray;
        tileSheetsGround = new SGSprite[tileSheetNamesGround.length][];
        for (int i = 0; i < tileSheetNamesGround.length; ++i) {
            MapEditor.tileSheetsGround[i] = MapEditor.loadTileSheet(tileSheetNamesGround[i]);
        }
    }

    public static void loadMiddleTileSheets(String[] stringArray) {
        tileSheetNamesMiddle = stringArray;
        tileSheetsMiddle = new SGSprite[tileSheetNamesMiddle.length][];
        for (int i = 0; i < tileSheetNamesMiddle.length; ++i) {
            MapEditor.tileSheetsMiddle[i] = MapEditor.loadTileSheet(tileSheetNamesMiddle[i]);
        }
    }

    public static void loadSharedTileSheet() {
        tileSheetShared = MapEditor.loadTileSheet("Shared");
    }

    public static SGSprite[] loadTileSheet(String string) {
        SGSprite sGSprite = new SGSprite(string);
        int n = sGSprite.animationSequences.length + 1;
        SGSprite[] sGSpriteArray = new SGSprite[n];
        for (int i = 1; i < n; ++i) {
            sGSpriteArray[i] = new SGSprite(sGSprite);
            sGSpriteArray[i].startAnimation(i - 1, 0);
        }
        return sGSpriteArray;
    }

    public static void loadObjectSprites(String[] stringArray, byte[] byArray) {
        objectSprites = new SGSprite[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            MapEditor.objectSprites[i] = new SGSprite(stringArray[i]);
            objectSprites[i].startAnimation(byArray[i], 0);
        }
    }

    public static void enable() {
        cursorRow = GameWorld.player.getRow();
        cursorCol = GameWorld.player.getCol();
        MapEditor.gameWorld.focusedObject = null;
        showObjects = true;
        enabled = true;
    }

    public static void disable() {
        if (!showObjects) {
            MapEditor.showObjects();
        }
        MapEditor.gameWorld.focusedObject = GameWorld.player;
        enabled = false;
    }

    public static void tick() {
        int n;
        if (Engine.isPressedRepeat(1)) {
            if (selectedObject != null) {
                selectedObject.moveY(-256);
                MapEditor.mapChanged();
            } else if (cursorRow > 0) {
                --cursorRow;
            }
        }
        if (Engine.isPressedRepeat(8)) {
            if (selectedObject != null) {
                selectedObject.moveX(256);
                MapEditor.mapChanged();
            } else if (cursorCol < GameWorld.mapCols - 1) {
                ++cursorCol;
            }
        }
        if (Engine.isPressedRepeat(2)) {
            if (selectedObject != null) {
                selectedObject.moveY(256);
                MapEditor.mapChanged();
            } else if (cursorRow < GameWorld.mapRows - 1) {
                ++cursorRow;
            }
        }
        if (Engine.isPressedRepeat(4)) {
            if (selectedObject != null) {
                selectedObject.moveX(-256);
                MapEditor.mapChanged();
            } else if (cursorCol > 0) {
                --cursorCol;
            }
        }
        if (Engine.isPressedRepeat(256) && palette == 3 && --objectIndex < 0) {
            objectIndex = objectSprites.length - 1;
        }
        if (Engine.isPressedRepeat(512) && palette == 3 && ++objectIndex > objectSprites.length - 1) {
            objectIndex = 0;
        }
        boolean bl = false;
        if (Engine.isPressed(1024) && MapEditor.getTool() != 5) {
            bl = true;
            MapEditor.setTool(5);
            marking = false;
        }
        if (Engine.isPressed(262144) && MapEditor.getTool() != 0) {
            bl = true;
            MapEditor.setTool(0);
            marking = false;
        }
        if (Engine.isPressed(2048) && MapEditor.getTool() != 2) {
            bl = true;
            MapEditor.setTool(2);
            marking = false;
        }
        if (Engine.isPressed(65536)) {
            bl = true;
            MapEditor.setTool(3);
            marking = false;
        }
        if (Engine.isPressed(16)) {
            bl = true;
            MapEditor.setTool(4);
            marking = false;
        }
        if (bl && MapEditor.getTool() == 5) {
            movingView = false;
        }
        if (Engine.isPressed(16384)) {
            showSameTile = !showSameTile;
        }
        byte by = (Byte)tileSheetGroundIndex.elementAt(levelIndex);
        for (n = 0; n < tileSheetsGround[by].length; ++n) {
            if (tileSheetsGround[by][n] == null) continue;
            tileSheetsGround[by][n].tickAnimation(50);
        }
        by = (Byte)tileSheetMiddleIndex.elementAt(levelIndex);
        for (n = 0; n < tileSheetsMiddle[by].length; ++n) {
            if (tileSheetsMiddle[by][n] == null) continue;
            tileSheetsMiddle[by][n].tickAnimation(50);
        }
        for (n = 0; n < objectSprites.length; ++n) {
            if (objectSprites[n] == null || MapEditor.objectSprites[n].spriteKey.equals("hill")) continue;
            objectSprites[n].tickAnimation(50);
        }
        if (levelDimensionsCountdown > 0) {
            --levelDimensionsCountdown;
        }
    }

    public static void showMenu() {
        state = 1;
    }

    public static void pointerPressed(int n, int n2) {
        dragBlock = true;
        if (n2 < FontMgr.charHeight[Engine.font]) {
            if (n > Device.WIDTH - 40) {
                MapEditor.addLevel();
            } else {
                int n3 = n / 40;
                if (n3 < levels.size()) {
                    MapEditor.setLevel(n3);
                }
            }
        } else if (n > Device.WIDTH - 40 && n2 < 2 * FontMgr.charHeight[Engine.font]) {
            MapEditor.saveLevel(levelIndex);
        } else if (n > Device.WIDTH - 40 && n2 > 3 * FontMgr.charHeight[Engine.font] && n2 < 7 * FontMgr.charHeight[Engine.font]) {
            int n4 = n2 - 3 * FontMgr.charHeight[Engine.font];
            int n5 = n4 / FontMgr.charHeight[Engine.font];
            byte[] byArray = (byte[])levelDimensions.elementAt(levelIndex);
            switch (n5) {
                case 0: {
                    MapEditor.setMapDimensions((short[])levels.elementAt(levelIndex), byArray[0] + 1, byArray[1]);
                    MapEditor.setMapDimensions((short[])tags.elementAt(levelIndex), byArray[0] + 1, byArray[1]);
                    break;
                }
                case 1: {
                    MapEditor.setMapDimensions((short[])levels.elementAt(levelIndex), byArray[0] - 1, byArray[1]);
                    MapEditor.setMapDimensions((short[])tags.elementAt(levelIndex), byArray[0] - 1, byArray[1]);
                    break;
                }
                case 2: {
                    MapEditor.setMapDimensions((short[])levels.elementAt(levelIndex), byArray[0], byArray[1] + 1);
                    MapEditor.setMapDimensions((short[])tags.elementAt(levelIndex), byArray[0], byArray[1] + 1);
                    break;
                }
                case 3: {
                    MapEditor.setMapDimensions((short[])levels.elementAt(levelIndex), byArray[0], byArray[1] - 1);
                    MapEditor.setMapDimensions((short[])tags.elementAt(levelIndex), byArray[0], byArray[1] - 1);
                }
            }
        } else if (n > Device.WIDTH - 50 && n2 > 8 * FontMgr.charHeight[Engine.font] && n2 < 12 * FontMgr.charHeight[Engine.font]) {
            int n6 = n2 - 8 * FontMgr.charHeight[Engine.font];
            int n7 = n6 / FontMgr.charHeight[Engine.font];
            short[] sArray = (short[])levels.elementAt(levelIndex);
            byte[] byArray = (byte[])levelDimensions.elementAt(levelIndex);
            short[] sArray2 = (short[])tags.elementAt(levelIndex);
            MapEditor.saveUndoStep();
            switch (n7) {
                case 0: {
                    MapEditor.shiftMap(sArray, byArray[0], byArray[1], 0);
                    MapEditor.shiftMap(sArray2, byArray[0], byArray[1], 0);
                    break;
                }
                case 1: {
                    MapEditor.shiftMap(sArray, byArray[0], byArray[1], 2);
                    MapEditor.shiftMap(sArray2, byArray[0], byArray[1], 2);
                    break;
                }
                case 2: {
                    MapEditor.shiftMap(sArray, byArray[0], byArray[1], 4);
                    MapEditor.shiftMap(sArray2, byArray[0], byArray[1], 4);
                    break;
                }
                case 3: {
                    MapEditor.shiftMap(sArray, byArray[0], byArray[1], 6);
                    MapEditor.shiftMap(sArray2, byArray[0], byArray[1], 6);
                }
            }
            MapEditor.mapChanged();
        } else if (n > Device.WIDTH - 40 && n2 > 13 * FontMgr.charHeight[Engine.font] && n2 < 16 * FontMgr.charHeight[Engine.font]) {
            int n8 = n2 - 13 * FontMgr.charHeight[Engine.font];
            int n9 = n8 / FontMgr.charHeight[Engine.font];
            if (n9 == 0) {
                boolean bl = showObjects = !showObjects;
                if (showObjects) {
                    MapEditor.showObjects();
                } else {
                    MapEditor.hideObjects();
                }
            } else if (n9 == 1) {
                showTags = !showTags;
            } else if (n9 == 2) {
                showRowCol = !showRowCol;
            }
        } else if (n > Device.WIDTH - 40 && n2 > 17 * FontMgr.charHeight[Engine.font] && n2 < 18 * FontMgr.charHeight[Engine.font]) {
            if (selectedObject != null) {
                gameWorld.removeObject(selectedObject, true);
                ((Vector)gameObjects.elementAt(levelIndex)).removeElement(selectedObject);
                gameWorld.sortObjects();
                selectedObject = null;
                MapEditor.mapChanged();
            }
        } else if (n < 40 && n2 < 2 * FontMgr.charHeight[Engine.font]) {
            MapEditor.undo();
        } else if (n < 40 && n2 < 9 * FontMgr.charHeight[Engine.font]) {
            int n10 = n2 - 2 * FontMgr.charHeight[Engine.font];
            MapEditor.setTool(n10 / FontMgr.charHeight[Engine.font]);
            marking = false;
        } else if (n2 > paletteTopY - FontMgr.charHeight[Engine.font] && n2 < paletteTopY && n < 300) {
            MapEditor.setPalette(n / 60);
        } else if (n2 > paletteTopY - 2 * FontMgr.charHeight[Engine.font] && n2 < paletteTopY - 1 * FontMgr.charHeight[Engine.font] && n < 60) {
            tileSheetSelectionGround = !tileSheetSelectionGround;
        } else if (n2 > paletteTopY - 2 * FontMgr.charHeight[Engine.font] && n2 < paletteTopY - 1 * FontMgr.charHeight[Engine.font] && n > 60 && n < 120) {
            tileSheetSelectionMiddle = !tileSheetSelectionMiddle;
        } else if (tileSheetSelectionGround && n2 > paletteTopY - 2 * FontMgr.charHeight[Engine.font] - tileSheetsGround.length * FontMgr.charHeight[Engine.font] && n2 < paletteTopY - 2 * FontMgr.charHeight[Engine.font] && n < 60) {
            tileIndex = 0;
            int n11 = n2 - (paletteTopY - 2 * FontMgr.charHeight[Engine.font] - tileSheetsGround.length * FontMgr.charHeight[Engine.font]);
            int n12 = n11 / FontMgr.charHeight[Engine.font];
            tileSheetGroundIndex.setElementAt(new Byte((byte)n12), levelIndex);
            MapEditor.setGroundTileSheet(n12);
            tileSheetSelectionGround = false;
        } else if (tileSheetSelectionMiddle && n2 > paletteTopY - 2 * FontMgr.charHeight[Engine.font] - tileSheetsMiddle.length * FontMgr.charHeight[Engine.font] && n2 < paletteTopY - 2 * FontMgr.charHeight[Engine.font] && n > 60 && n < 120) {
            tileIndex = 0;
            int n13 = n2 - (paletteTopY - 2 * FontMgr.charHeight[Engine.font] - tileSheetsMiddle.length * FontMgr.charHeight[Engine.font]);
            int n14 = n13 / FontMgr.charHeight[Engine.font];
            tileSheetMiddleIndex.setElementAt(new Byte((byte)n14), levelIndex);
            MapEditor.setMiddleTileSheet(n14);
            tileSheetSelectionMiddle = false;
        } else if (n2 > paletteTopY) {
            if (palette <= 2) {
                tileIndex = n / GameWorld.tileSize;
                int n15 = Device.WIDTH / GameWorld.tileSize;
                tileIndex += (n2 - paletteTopY) / GameWorld.tileSize * n15;
            } else if (palette == 3) {
                int n16 = Device.WIDTH / objectWidth;
                objectIndex = n / objectWidth + (n2 - paletteTopY) / 32 * n16;
                if (objectIndex < objectSprites.length) {
                    GameObject gameObject = GameObject.createFromTile(cursorRow, cursorCol);
                    gameObject.sprite = new SGSprite(objectSprites[objectIndex]);
                    gameObject.sprite.startAnimation(MapEditor.objectSprites[MapEditor.objectIndex].currentAnimation, 0);
                    ((Vector)gameObjects.elementAt(levelIndex)).addElement(gameObject);
                    gameWorld.addObject(gameObject, true);
                    gameWorld.sortObjects();
                    selectedObject = gameObject;
                    MapEditor.mapChanged();
                }
            } else if (palette == 4) {
                tagsTileIndex = n / GameWorld.tileSize;
                int n17 = Device.WIDTH / GameWorld.tileSize;
                tagsTileIndex += (n2 - paletteTopY) / GameWorld.tileSize * n17;
            }
        } else if (MapEditor.getTool() == 5) {
            movingView = true;
            movingStartMapViewOffsetX = GameWorld.mapView[0];
            movingStartMapViewOffsetY = GameWorld.mapView[1];
            movingViewOffsetX = n;
            movingViewOffsetY = n2;
        } else if (MapEditor.getTool() == 6) {
            int n18 = (n2 += GameWorld.mapView[1]) / GameWorld.tileSize;
            int n19 = (n += GameWorld.mapView[0]) / GameWorld.tileSize;
            byte[] byArray = (byte[])levelDimensions.elementAt(levelIndex);
            short[] sArray = (short[])levels.elementAt(levelIndex);
            tileIndex = sArray[byArray[1] * n18 + n19] + 1;
        } else {
            GameObject gameObject = MapEditor.getObjectAt(n + GameWorld.mapView[0], n2 + GameWorld.mapView[1]);
            if (gameObject != null) {
                selectedObject = gameObject;
                draggingObjectOffsetX = n - MapEditor.selectedObject.sprite.x;
                draggingObjectOffsetY = n2 - MapEditor.selectedObject.sprite.y;
                draggingObject = true;
                MapEditor.saveUndoStep();
            } else {
                cursorRow = (n2 += GameWorld.mapView[1]) / GameWorld.tileSize;
                cursorCol = (n += GameWorld.mapView[0]) / GameWorld.tileSize;
                switch (MapEditor.getTool()) {
                    case 0: {
                        MapEditor.setTile(cursorRow, cursorCol);
                        dragBlock = false;
                        break;
                    }
                    case 1: {
                        MapEditor.fillTiles(cursorRow, cursorCol, tileIndex);
                        break;
                    }
                    case 2: {
                        if (palette == 3) {
                            markStartRow = cursorRow;
                            markStartCol = cursorCol;
                            markEndRow = cursorRow;
                            markEndCol = cursorCol;
                        } else if (marking) {
                            markEndRow = cursorRow;
                            markEndCol = cursorCol;
                        } else {
                            markStartRow = cursorRow;
                            markStartCol = cursorCol;
                            markEndRow = cursorRow;
                            markEndCol = cursorCol;
                            marking = true;
                        }
                        dragBlock = false;
                    }
                }
                if (selectedObject != null) {
                    selectedObject = null;
                }
            }
        }
    }

    public static void pointerDragged(int n, int n2) {
        if (draggingObject) {
            selectedObject.setX(GameWorld.scaleToBase(n - draggingObjectOffsetX) << 8);
            selectedObject.setY(GameWorld.scaleToBase(n2 - draggingObjectOffsetY) << 8);
            gameWorld.sortObjects();
            if (selectedObject != GameWorld.player) {
                MapEditor.mapChanged();
            }
        } else if (!(palette > 2 && palette != 4 || MapEditor.getTool() != 0 && MapEditor.getTool() != 2)) {
            if (!dragBlock) {
                MapEditor.pointerPressed(n, n2);
            }
        } else if (movingView) {
            GameWorld.mapView[0] = movingStartMapViewOffsetX + (movingViewOffsetX - n);
            GameWorld.mapView[1] = movingStartMapViewOffsetY + (movingViewOffsetY - n2);
        }
    }

    public static GameObject getObjectAt(int n, int n2) {
        if (!showObjects) {
            return null;
        }
        Vector vector = (Vector)gameObjects.elementAt(levelIndex);
        for (int i = 0; i < vector.size(); ++i) {
            GameObject gameObject = (GameObject)vector.elementAt(i);
            if (n >= gameObject.sprite.getRightX() || n <= gameObject.sprite.getLeftX() || n2 >= gameObject.sprite.getBottomY() || n2 <= gameObject.sprite.getTopY()) continue;
            return gameObject;
        }
        return null;
    }

    public static void showObjects() {
        Vector vector = (Vector)gameObjects.elementAt(levelIndex);
        for (int i = 0; i < vector.size(); ++i) {
            GameObject gameObject = (GameObject)vector.elementAt(i);
            gameWorld.addObject(gameObject, true);
        }
        gameWorld.sortObjects();
    }

    public static void hideObjects() {
        MapEditor.gameWorld.objects.removeAllElements();
        selectedObject = null;
        gameWorld.sortObjects();
    }

    public static void setTool(int n) {
        if (palette == 4 && n != 0) {
            return;
        }
        int n2 = tool;
        tool = n;
        if (tool == 2) {
            markStartRow = cursorRow;
            markStartCol = cursorCol;
            markEndRow = cursorRow;
            markEndCol = cursorCol;
        } else if (tool == 3) {
            copyRows = Math.abs(markStartRow - markEndRow) + 1;
            copyCols = Math.abs(markStartCol - markEndCol) + 1;
            copyTiles = new short[copyRows * copyCols];
            for (int i = 0; i < copyRows; ++i) {
                for (int j = 0; j < copyCols; ++j) {
                    MapEditor.copyTiles[i * MapEditor.copyCols + j] = (short)GameWorld.getTile(markStartRow + i, markStartCol + j);
                }
            }
            tool = n2;
        } else if (tool == 4) {
            MapEditor.saveUndoStep();
            byte[] byArray = (byte[])levelDimensions.elementAt(levelIndex);
            for (int i = 0; i < copyRows; ++i) {
                for (int j = 0; j < copyCols; ++j) {
                    if (markStartRow + i >= byArray[0] || markStartCol + j >= byArray[1]) continue;
                    gameWorld.setTile(markStartRow + i, markStartCol + j, copyTiles[i * copyCols + j]);
                }
            }
            tool = n2;
            MapEditor.mapChanged();
        }
    }

    public static int getTool() {
        if (Engine.isPressed(16384)) {
            return 5;
        }
        if (Engine.isPressed(4096)) {
            return 6;
        }
        return tool;
    }

    public static void setPalette(int n) {
        palette = n;
        if (palette == 3) {
            MapEditor.setTool(2);
        } else if (palette == 4) {
            MapEditor.setTool(0);
        }
    }

    public static void pointerReleased(int n, int n2) {
        if (draggingObject) {
            draggingObject = false;
        }
        if (MapEditor.getTool() == 2) {
            marking = false;
        } else if (MapEditor.getTool() == 5) {
            movingView = false;
        }
        dragBlock = false;
    }

    public static int getTileIdx(int n, int n2) {
        int n3 = palette <= 2 ? tileIndex : tagsTileIndex;
        byte[] byArray = (byte[])levelDimensions.elementAt(levelIndex);
        if (n < 0 || n >= byArray[0] || n2 < 0 || n2 >= byArray[1]) {
            return -1;
        }
        int n4 = n3 = n3 == 0 ? -1 : n3 - 1;
        if (n3 != -1) {
            if (palette == 1) {
                n3 += 200;
            } else if (palette == 2) {
                n3 += 400;
            }
        }
        return n3;
    }

    public static void setTile(int n, int n2) {
        byte[] byArray;
        int n3 = MapEditor.getTileIdx(n, n2);
        short[] sArray = palette <= 2 ? (short[])levels.elementAt(levelIndex) : (short[])tags.elementAt(levelIndex);
        if (sArray[n * (byArray = (byte[])levelDimensions.elementAt(levelIndex))[1] + n2] == n3) {
            return;
        }
        if (palette <= 2) {
            MapEditor.saveUndoStep();
            gameWorld.setTile(cursorRow, cursorCol, n3);
        } else {
            for (int i = 0; i < sArray.length; ++i) {
                if (sArray[i] != n3) continue;
                sArray[i] = -1;
            }
            sArray[n * byArray[1] + n2] = (short)n3;
            if (tagsTileIndex > 0 && ++tagsTileIndex == tagsTilesSheet.length) {
                tagsTileIndex = 0;
            }
        }
        MapEditor.mapChanged();
    }

    public static void fillTiles(int n, int n2, int n3) {
        byte[] byArray = (byte[])levelDimensions.elementAt(levelIndex);
        if (n < 0 || n >= byArray[0] || n2 < 0 || n2 >= byArray[1]) {
            return;
        }
        n3 = n3 == 0 ? -1 : n3 - 1;
        short[] sArray = (short[])levels.elementAt(levelIndex);
        short s = sArray[n * byArray[1] + n2];
        if (s == n3) {
            return;
        }
        MapEditor.saveUndoStep();
        MapEditor.fill(n, n2, s, n3);
        MapEditor.mapChanged();
    }

    public static void fill(int n, int n2, int n3, int n4) {
        gameWorld.setTile(n, n2, n4);
        if (GameWorld.isOnMap(n - 1, n2)) {
            if (GameWorld.getTile(n - 1, n2) == n3) {
                MapEditor.fill(n - 1, n2, n3, n4);
            }
        }
        if (GameWorld.isOnMap(n, n2 + 1)) {
            if (GameWorld.getTile(n, n2 + 1) == n3) {
                MapEditor.fill(n, n2 + 1, n3, n4);
            }
        }
        if (GameWorld.isOnMap(n + 1, n2)) {
            if (GameWorld.getTile(n + 1, n2) == n3) {
                MapEditor.fill(n + 1, n2, n3, n4);
            }
        }
        if (GameWorld.isOnMap(n, n2 - 1)) {
            if (GameWorld.getTile(n, n2 - 1) == n3) {
                MapEditor.fill(n, n2 - 1, n3, n4);
            }
        }
    }

    public static void mapChanged() {
        saved.setElementAt(new Boolean(false), levelIndex);
    }

    public static void saveUndoStep() {
        short[] sArray = new short[GameWorld.map.length];
        System.arraycopy(GameWorld.map, 0, sArray, 0, GameWorld.map.length);
        ((Vector)undoSteps.elementAt(levelIndex)).addElement(sArray);
    }

    public static void undo() {
        Vector vector = (Vector)undoSteps.elementAt(levelIndex);
        if (vector.size() == 0) {
            return;
        }
        short[] sArray = (short[])vector.elementAt(vector.size() - 1);
        vector.removeElementAt(vector.size() - 1);
        levels.setElementAt(sArray, levelIndex);
        GameWorld.map = sArray;
        MapEditor.mapChanged();
    }

    public static void redo() {
    }

    public static int getObjectIndex(GameObject gameObject) {
        for (int i = 0; i < objectSprites.length; ++i) {
            if (!gameObject.sprite.spriteKey.equals(MapEditor.objectSprites[i].spriteKey)) continue;
            return i;
        }
        return -1;
    }

    public static void setGroundTileSheet(int n) {
        GameWorld.tiles[0] = new SGSprite[tileSheetsGround[n].length - 1];
        for (int i = 0; i < GameWorld.tiles[0].length; ++i) {
            GameWorld.tiles[0][i] = tileSheetsGround[n][i + 1];
        }
    }

    public static void setMiddleTileSheet(int n) {
        GameWorld.tiles[1] = new SGSprite[tileSheetsMiddle[n].length - 1];
        for (int i = 0; i < GameWorld.tiles[1].length; ++i) {
            GameWorld.tiles[1][i] = tileSheetsMiddle[n][i + 1];
        }
    }

    public static void setSharedTileSheet() {
        GameWorld.tiles[2] = new SGSprite[tileSheetShared.length - 1];
        for (int i = 0; i < GameWorld.tiles[2].length; ++i) {
            GameWorld.tiles[2][i] = tileSheetShared[i + 1];
        }
    }

    public static void setLevel(int n) {
        MapEditor.setGroundTileSheet(((Byte)tileSheetGroundIndex.elementAt(n)).byteValue());
        MapEditor.setMiddleTileSheet(((Byte)tileSheetMiddleIndex.elementAt(n)).byteValue());
        MapEditor.setSharedTileSheet();
        MapEditor.gameWorld.objects.removeAllElements();
        Vector vector = (Vector)gameObjects.elementAt(levelIndex);
        vector.removeElement(GameWorld.player);
        levelIndex = n;
        vector = (Vector)gameObjects.elementAt(levelIndex);
        if (showObjects) {
            vector.addElement(GameWorld.player);
            for (int i = 0; i < vector.size(); ++i) {
                gameWorld.addObject((GameObject)vector.elementAt(i), true);
            }
        }
        gameWorld.sortObjects();
        GameWorld.map = (short[])levels.elementAt(levelIndex);
        byte[] byArray = (byte[])levelDimensions.elementAt(levelIndex);
        GameWorld.mapRows = byArray[0];
        GameWorld.mapCols = byArray[1];
        GameWorld.level = n;
    }

    public static void addLevel() {
        short[] sArray = new short[400];
        short[] sArray2 = new short[400];
        for (int i = 0; i < 400; ++i) {
            sArray[i] = -1;
            sArray2[i] = -1;
        }
        levels.addElement(sArray);
        levelDimensions.addElement(new byte[]{20, 20});
        tileSheetGroundIndex.addElement(new Byte(0));
        tileSheetMiddleIndex.addElement(new Byte(0));
        saved.addElement(new Boolean(false));
        undoSteps.addElement(new Vector());
        gameObjects.addElement(new Vector());
        tags.addElement(sArray2);
        MapEditor.setLevel(levels.size() - 1);
    }

    public static void saveLevel(int n) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)("level" + n), (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(((Byte)tileSheetGroundIndex.elementAt(n)).byteValue());
            dataOutputStream.writeByte(((Byte)tileSheetMiddleIndex.elementAt(n)).byteValue());
            byte[] byArray = (byte[])levelDimensions.elementAt(n);
            dataOutputStream.writeByte(byArray[0]);
            dataOutputStream.writeByte(byArray[1]);
            short[] sArray = (short[])levels.elementAt(n);
            for (int i = 0; i < sArray.length; ++i) {
                dataOutputStream.writeShort(sArray[i]);
            }
            Vector vector = (Vector)gameObjects.elementAt(n);
            dataOutputStream.writeShort(vector.size() - 1);
            for (int i = 0; i < vector.size(); ++i) {
                GameObject gameObject = (GameObject)vector.elementAt(i);
                if (gameObject == GameWorld.player) continue;
                dataOutputStream.writeShort((byte)MapEditor.getObjectIndex(gameObject));
                dataOutputStream.writeShort(GameWorld.scaleToBase(gameObject.sprite.x));
                dataOutputStream.writeShort(GameWorld.scaleToBase(gameObject.sprite.y));
                dataOutputStream.writeByte(gameObject.sprite.currentAnimation);
            }
            byteArrayOutputStream.write(MapEditor.getTagData(n));
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            byteArrayOutputStream.close();
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray2, 0, byArray2.length);
            } else {
                recordStore.setRecord(1, byArray2, 0, byArray2.length);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        saved.setElementAt(new Boolean(true), n);
    }

    public static byte[] getTagData(int n) {
        try {
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            byte[] byArray = (byte[])levelDimensions.elementAt(n);
            short[] sArray = (short[])tags.elementAt(n);
            short[][] sArrayArray = new short[5][];
            int n3 = 0;
            if (sArray == null) {
                Engine.echo("tagData = null for level " + n);
            }
            for (n2 = 0; n2 < sArray.length; ++n2) {
                if (sArray[n2] == -1) continue;
                int n4 = n2 / byArray[1];
                int n5 = n2 % byArray[1];
                if (sArray[n2] < 0 || sArray[n2] > 4) continue;
                n3 = Math.max(n3, sArray[n2] + 1);
                sArrayArray[sArray[n2]] = new short[]{(short)n4, (short)n5};
            }
            dataOutputStream.writeByte(1);
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                dataOutputStream.writeByte(sArrayArray[n2][0]);
                dataOutputStream.writeByte(sArrayArray[n2][1]);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void saveAllLevels() {
    }

    public static boolean loadLevel(int n) {
        try {
            int n2;
            short s;
            short s2;
            int n3;
            int n4;
            RecordStore recordStore = RecordStore.openRecordStore((String)("level" + n), (boolean)false);
            if (recordStore == null || recordStore.getNumRecords() == 0) {
                return false;
            }
            MapEditor.addLevel();
            byte[] byArray = recordStore.getRecord(1);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            tileSheetGroundIndex.setElementAt(new Byte(dataInputStream.readByte()), n);
            tileSheetMiddleIndex.setElementAt(new Byte(dataInputStream.readByte()), n);
            levelDimensions.setElementAt(new byte[]{dataInputStream.readByte(), dataInputStream.readByte()}, n);
            byte[] byArray2 = (byte[])levelDimensions.elementAt(n);
            short[] sArray = new short[byArray2[0] * byArray2[1]];
            for (n4 = 0; n4 < sArray.length; ++n4) {
                sArray[n4] = dataInputStream.readShort();
            }
            levels.setElementAt(sArray, n);
            n4 = dataInputStream.readShort();
            for (int i = 0; i < n4; ++i) {
                n3 = dataInputStream.readShort();
                s2 = dataInputStream.readShort();
                s = dataInputStream.readShort();
                n2 = dataInputStream.readByte();
                GameObject gameObject = GameObject.createFromPosition(s2, s);
                gameObject.sprite = new SGSprite(objectSprites[n3]);
                gameObject.sprite.startAnimation(n2, 0);
                ((Vector)gameObjects.elementAt(n)).addElement(gameObject);
            }
            short[] sArray2 = new short[sArray.length];
            for (n3 = 0; n3 < sArray2.length; ++n3) {
                sArray2[n3] = -1;
            }
            tags.setElementAt(sArray2, n);
            n3 = dataInputStream.readByte();
            s2 = dataInputStream.readByte();
            s = dataInputStream.readByte();
            palette = 4;
            for (n2 = 0; n2 < s; ++n2) {
                tagsTileIndex = n2 + 1;
                byte by = dataInputStream.readByte();
                byte by2 = dataInputStream.readByte();
                MapEditor.setTile(by, by2);
            }
            tagsTileIndex = 0;
            palette = 0;
            dataInputStream.close();
            byteArrayInputStream.close();
            saved.setElementAt(new Boolean(true), n);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static void loadAllLevels() {
        levels = new Vector();
        levelDimensions = new Vector();
        tileSheetGroundIndex = new Vector();
        tileSheetMiddleIndex = new Vector();
        saved = new Vector();
        undoSteps = new Vector();
        gameObjects = new Vector();
        int n = 0;
        while (MapEditor.loadLevel(n)) {
            ++n;
        }
        if (n == 0) {
            MapEditor.addLevel();
            saved.setElementAt(new Boolean(true), n);
        }
    }

    public static void setMapDimensions(short[] sArray, int n, int n2) {
        int n3;
        if (n == 0 || n2 == 0) {
            return;
        }
        byte[] byArray = (byte[])levelDimensions.elementAt(levelIndex);
        byte by = byArray[0];
        byte by2 = byArray[1];
        short[] sArray2 = sArray;
        short[] sArray3 = new short[n * n2];
        for (n3 = 0; n3 < sArray3.length; ++n3) {
            sArray3[n3] = -1;
        }
        n3 = Math.min(n, by);
        int n4 = Math.min(n2, by2);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n5 = i * n2 + j;
                int n6 = i * by2 + j;
                if (n5 >= sArray3.length || n6 >= sArray2.length) continue;
                sArray3[n5] = sArray2[n6];
            }
        }
        if (sArray == levels.elementAt(levelIndex)) {
            levels.setElementAt(sArray3, levelIndex);
            levelDimensions.setElementAt(new byte[]{(byte)n, (byte)n2}, levelIndex);
            GameWorld.map = sArray3;
            GameWorld.mapRows = n;
            GameWorld.mapCols = n2;
            levelDimensionsCountdown = 25;
        } else {
            tags.setElementAt(sArray3, levelIndex);
        }
        MapEditor.mapChanged();
    }

    public static void shiftMap(short[] sArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (sArray == null) {
            return;
        }
        short[] sArray2 = new short[sArray.length];
        for (n8 = 0; n8 < sArray2.length; ++n8) {
            sArray2[n8] = -1;
        }
        if (n3 == 0 || n3 == 4) {
            for (n8 = 0; n8 < n2; ++n8) {
                for (n7 = 0; n7 < n; ++n7) {
                    n6 = n2 * n7 + n8;
                    n5 = n3 == 0 ? n2 * (n7 - 1) + n8 : n2 * (n7 + 1) + n8;
                    if (n5 < 0 || n5 >= sArray2.length || n8 != (n4 = n5 % n2)) continue;
                    sArray2[n5] = sArray[n6];
                }
            }
        } else {
            for (n8 = 0; n8 < n; ++n8) {
                for (n7 = 0; n7 < n2; ++n7) {
                    n6 = n2 * n8 + n7;
                    n5 = n3 == 2 ? n2 * n8 + (n7 + 1) : n2 * n8 + (n7 - 1);
                    if (n5 < 0 || n5 >= sArray2.length || n8 != (n4 = n5 / n2)) continue;
                    sArray2[n5] = sArray[n6];
                }
            }
        }
        if (sArray == levels.elementAt(levelIndex)) {
            levels.setElementAt(sArray2, levelIndex);
            GameWorld.map = sArray2;
            Vector vector = (Vector)gameObjects.elementAt(levelIndex);
            for (n7 = 0; n7 < vector.size(); ++n7) {
                GameObject gameObject = (GameObject)vector.elementAt(n7);
                if (n3 == 0) {
                    gameObject.moveY(-4096);
                    continue;
                }
                if (n3 == 2) {
                    gameObject.moveX(4096);
                    continue;
                }
                if (n3 == 4) {
                    gameObject.moveY(4096);
                    continue;
                }
                gameObject.moveX(-4096);
            }
        } else {
            tags.setElementAt(sArray2, levelIndex);
        }
    }

    public static void paint(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        int n5 = FontMgr.charHeight[Engine.font];
        byte[] byArray = (byte[])levelDimensions.elementAt(levelIndex);
        byte by = (Byte)tileSheetGroundIndex.elementAt(levelIndex);
        byte by2 = (Byte)tileSheetMiddleIndex.elementAt(levelIndex);
        if (showTags) {
            MapEditor.drawTiles(graphics, tagsTilesSheet, (short[])tags.elementAt(levelIndex));
        }
        if (showRowCol) {
            MapEditor.drawTiles(graphics, null, null);
        }
        graphics.setColor(0);
        for (n4 = -(GameWorld.mapView[0] % GameWorld.tileSize); n4 < Device.WIDTH; n4 += GameWorld.tileSize) {
            graphics.drawLine(n4, 0, n4, Device.HEIGHT);
        }
        for (n4 = -(GameWorld.mapView[1] % GameWorld.tileSize); n4 < Device.HEIGHT; n4 += GameWorld.tileSize) {
            graphics.drawLine(0, n4, Device.WIDTH, n4);
        }
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(n, n2, byArray[1] * GameWorld.tileSize, byArray[0] * GameWorld.tileSize);
        if (selectedObject == null) {
            graphics.setColor(65280);
            if (MapEditor.getTool() == 2) {
                n4 = Math.min(markStartCol, markEndCol) * GameWorld.tileSize;
                n3 = Math.min(markStartRow, markEndRow) * GameWorld.tileSize;
                int n6 = (Math.abs(markStartCol - markEndCol) + 1) * GameWorld.tileSize;
                int n7 = (Math.abs(markStartRow - markEndRow) + 1) * GameWorld.tileSize;
                graphics.drawRect(n4 + n, n3 + n2, n6, n7);
            }
        }
        if (selectedObject != null) {
            graphics.setColor(0xFFFFFF);
            graphics.drawRect(MapEditor.selectedObject.sprite.getLeftX() + n, MapEditor.selectedObject.sprite.getTopY() + n2, MapEditor.selectedObject.sprite.getWidth(), MapEditor.selectedObject.sprite.getHeight());
            FontMgr.drawString(Engine.font, graphics, "x: " + (MapEditor.selectedObject.x >> 8), MapEditor.selectedObject.sprite.getRightX() + 2 + n, MapEditor.selectedObject.sprite.getTopY() + n2, 20);
            FontMgr.drawString(Engine.font, graphics, "y: " + (MapEditor.selectedObject.y >> 8), MapEditor.selectedObject.sprite.getRightX() + 2 + n, MapEditor.selectedObject.sprite.getTopY() + FontMgr.charHeight[Engine.font] + n2, 20);
        }
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, paletteTopY, Device.WIDTH, Device.HEIGHT - paletteTopY);
        if (palette <= 2) {
            MapEditor.drawTilePalette(graphics, palette == 0 ? tileSheetsGround[by] : (palette == 1 ? tileSheetsMiddle[by2] : tileSheetShared), tileIndex);
        } else if (palette == 3) {
            for (n4 = 0; n4 < objectSprites.length; ++n4) {
                if (MapEditor.objectSprites[n4].spriteKey.equals("hill")) continue;
                n3 = Device.WIDTH / objectWidth;
                if (n4 < n3) {
                    graphics.setClip(n4 * objectWidth, paletteTopY, objectWidth, Device.HEIGHT - paletteTopY);
                    objectSprites[n4].paint(graphics, n4 * objectWidth + objectWidth / 2, paletteTopY + 16);
                } else {
                    graphics.setClip((n4 - n3) * objectWidth, paletteTopY + 32, objectWidth, Device.HEIGHT - paletteTopY);
                    objectSprites[n4].paint(graphics, (n4 - n3) * objectWidth + objectWidth / 2, paletteTopY + 48);
                }
                graphics.setClip(0, 0, Device.WIDTH, Device.HEIGHT);
            }
        } else if (palette == 4) {
            MapEditor.drawTilePalette(graphics, tagsTilesSheet, tagsTileIndex);
        }
        MapEditor.drawSquare(graphics, 0, paletteTopY - FontMgr.charHeight[Engine.font], 60, FontMgr.charHeight[Engine.font], "tiles ground", palette == 0);
        MapEditor.drawSquare(graphics, 60, paletteTopY - FontMgr.charHeight[Engine.font], 60, FontMgr.charHeight[Engine.font], "tiles middle", palette == 1);
        MapEditor.drawSquare(graphics, 120, paletteTopY - FontMgr.charHeight[Engine.font], 60, FontMgr.charHeight[Engine.font], "tiles shared", palette == 2);
        MapEditor.drawSquare(graphics, 180, paletteTopY - FontMgr.charHeight[Engine.font], 60, FontMgr.charHeight[Engine.font], "objects", palette == 3);
        MapEditor.drawSquare(graphics, 240, paletteTopY - FontMgr.charHeight[Engine.font], 60, FontMgr.charHeight[Engine.font], "tags", palette == 4);
        MapEditor.drawSquare(graphics, 0, paletteTopY - 2 * FontMgr.charHeight[Engine.font], 60, FontMgr.charHeight[Engine.font], "ground", tileSheetSelectionGround);
        if (tileSheetSelectionGround) {
            n4 = paletteTopY - 2 * FontMgr.charHeight[Engine.font] - tileSheetsGround.length * FontMgr.charHeight[Engine.font];
            for (n3 = 0; n3 < tileSheetsGround.length; ++n3) {
                MapEditor.drawSquare(graphics, 0, n4, 60, FontMgr.charHeight[Engine.font], tileSheetNamesGround[n3], by == n3);
                n4 += FontMgr.charHeight[Engine.font];
            }
        }
        MapEditor.drawSquare(graphics, 60, paletteTopY - 2 * FontMgr.charHeight[Engine.font], 60, FontMgr.charHeight[Engine.font], "middle", tileSheetSelectionMiddle);
        if (tileSheetSelectionMiddle) {
            n4 = paletteTopY - 2 * FontMgr.charHeight[Engine.font] - tileSheetsMiddle.length * FontMgr.charHeight[Engine.font];
            for (n3 = 0; n3 < tileSheetsMiddle.length; ++n3) {
                MapEditor.drawSquare(graphics, 60, n4, 60, FontMgr.charHeight[Engine.font], tileSheetNamesMiddle[n3], by2 == n3);
                n4 += FontMgr.charHeight[Engine.font];
            }
        }
        graphics.setColor(0);
        graphics.fillRect(0, 0, Device.WIDTH, FontMgr.charHeight[Engine.font]);
        graphics.setColor(0xFFFFFF);
        graphics.drawLine(0, FontMgr.charHeight[Engine.font], Device.WIDTH, FontMgr.charHeight[Engine.font]);
        for (n4 = 0; n4 < levels.size(); ++n4) {
            if (n4 == levelIndex) {
                graphics.setColor(0x535353);
                graphics.fillRect(n4 * 40 + 1, 0, 39, FontMgr.charHeight[Engine.font]);
            }
            String string = (Boolean)saved.elementAt(n4) != false ? "level" + n4 : "*level" + n4;
            FontMgr.drawString(Engine.font, graphics, string, n4 * 40 + 20, 0, 17);
            graphics.setColor(0xFFFFFF);
            graphics.drawLine((n4 + 1) * 40, 0, (n4 + 1) * 40, FontMgr.charHeight[Engine.font]);
        }
        graphics.drawLine(Device.WIDTH - 40, 0, Device.WIDTH - 40, FontMgr.charHeight[Engine.font]);
        FontMgr.drawString(Engine.font, graphics, "add", Device.WIDTH - 20, 0, 17);
        graphics.setColor(0);
        graphics.fillRect(Device.WIDTH - 40, 3 * n5, 40, n5);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(Device.WIDTH - 40, 3 * n5, 40, n5);
        FontMgr.drawString(Engine.font, graphics, "+row", Device.WIDTH - 20, 3 * n5, 17);
        graphics.setColor(0);
        graphics.fillRect(Device.WIDTH - 40, 4 * n5, 40, n5);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(Device.WIDTH - 40, 4 * n5, 40, n5);
        FontMgr.drawString(Engine.font, graphics, "-row", Device.WIDTH - 20, 4 * n5, 17);
        graphics.setColor(0);
        graphics.fillRect(Device.WIDTH - 40, 5 * n5, 40, n5);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(Device.WIDTH - 40, 5 * n5, 40, n5);
        FontMgr.drawString(Engine.font, graphics, "+col", Device.WIDTH - 20, 5 * n5, 17);
        graphics.setColor(0);
        graphics.fillRect(Device.WIDTH - 40, 6 * n5, 40, n5);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(Device.WIDTH - 40, 6 * n5, 40, n5);
        FontMgr.drawString(Engine.font, graphics, "-col", Device.WIDTH - 20, 6 * n5, 17);
        if (levelDimensionsCountdown > 0) {
            FontMgr.drawString(Engine.font, graphics, byArray[0] + " x " + byArray[1], Device.WIDTH - 44, 4 * n5 + n5 / 2, 24);
        }
        graphics.setColor(0);
        graphics.fillRect(Device.WIDTH - 50, 8 * n5, 50, n5);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(Device.WIDTH - 50, 8 * n5, 50, n5);
        FontMgr.drawString(Engine.font, graphics, "shift up", Device.WIDTH - 25, 8 * n5, 17);
        graphics.setColor(0);
        graphics.fillRect(Device.WIDTH - 50, 9 * n5, 50, n5);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(Device.WIDTH - 50, 9 * n5, 50, n5);
        FontMgr.drawString(Engine.font, graphics, "shift right", Device.WIDTH - 25, 9 * n5, 17);
        graphics.setColor(0);
        graphics.fillRect(Device.WIDTH - 50, 10 * n5, 50, n5);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(Device.WIDTH - 50, 10 * n5, 50, n5);
        FontMgr.drawString(Engine.font, graphics, "shift down", Device.WIDTH - 25, 10 * n5, 17);
        graphics.setColor(0);
        graphics.fillRect(Device.WIDTH - 50, 11 * n5, 50, n5);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(Device.WIDTH - 50, 11 * n5, 50, n5);
        FontMgr.drawString(Engine.font, graphics, "shift left", Device.WIDTH - 25, 11 * n5, 17);
        MapEditor.drawSquare(graphics, Device.WIDTH - 40, 13 * n5, 40, n5, "objects", showObjects);
        MapEditor.drawSquare(graphics, Device.WIDTH - 40, 14 * n5, 40, n5, "tags", showTags);
        MapEditor.drawSquare(graphics, Device.WIDTH - 40, 15 * n5, 40, n5, "col row", showRowCol);
        if (selectedObject != null) {
            MapEditor.drawSquare(graphics, Device.WIDTH - 40, 17 * n5, 40, n5, "del obj", false);
        }
        graphics.setColor(0);
        graphics.fillRect(Device.WIDTH - 40, FontMgr.charHeight[Engine.font], 40, FontMgr.charHeight[Engine.font]);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(Device.WIDTH - 40, FontMgr.charHeight[Engine.font], 40, FontMgr.charHeight[Engine.font]);
        FontMgr.drawString(Engine.font, graphics, "save", Device.WIDTH - 20, FontMgr.charHeight[Engine.font], 17);
        graphics.setColor(0);
        graphics.fillRect(0, FontMgr.charHeight[Engine.font], 40, FontMgr.charHeight[Engine.font]);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(0, FontMgr.charHeight[Engine.font], 40, FontMgr.charHeight[Engine.font]);
        FontMgr.drawString(Engine.font, graphics, "undo", 20, FontMgr.charHeight[Engine.font], 17);
        for (n4 = 0; n4 < 7; ++n4) {
            if (n4 == MapEditor.getTool()) {
                graphics.setColor(0x535353);
            } else {
                graphics.setColor(0);
            }
            graphics.fillRect(0, 2 * FontMgr.charHeight[Engine.font] + n4 * FontMgr.charHeight[Engine.font], 40, FontMgr.charHeight[Engine.font]);
            graphics.setColor(0xFFFFFF);
            graphics.drawRect(0, 2 * FontMgr.charHeight[Engine.font] + n4 * FontMgr.charHeight[Engine.font], 40, FontMgr.charHeight[Engine.font]);
            FontMgr.drawString(Engine.font, graphics, TOOL_NAMES[n4], 20, 2 * FontMgr.charHeight[Engine.font] + n4 * FontMgr.charHeight[Engine.font], 17);
        }
    }

    public static void drawSquare(Graphics graphics, int n, int n2, int n3, int n4, String string, boolean bl) {
        if (bl) {
            graphics.setColor(0x535353);
        } else {
            graphics.setColor(0);
        }
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(n, n2, n3, n4);
        FontMgr.drawString(Engine.font, graphics, string, n + n3 / 2, n2, 17);
    }

    public static void drawTilePalette(Graphics graphics, SGSprite[] sGSpriteArray, int n) {
        int n2 = 0;
        int n3 = paletteTopY;
        if (sGSpriteArray == null) {
            return;
        }
        for (int i = 0; i < sGSpriteArray.length; ++i) {
            int n4 = GameWorld.tileSize;
            if (sGSpriteArray[i] == null) {
                graphics.setColor(0);
                graphics.fillRect(n2, n3 + GameWorld.tileSize, GameWorld.tileSize, GameWorld.tileSize);
            } else {
                if (sGSpriteArray[i].getHeight() > GameWorld.tileSize) {
                    n4 *= 2;
                }
                sGSpriteArray[i].paint(graphics, n2 + GameWorld.tileSize / 2, n3 + n4);
            }
            if (i == n) {
                graphics.setColor(65280);
                graphics.drawRect(n2, n3, GameWorld.tileSize - 1, n4 - 1);
            }
            if ((n2 += GameWorld.tileSize) + GameWorld.tileSize <= Device.WIDTH) continue;
            n2 = 0;
            n3 += n4;
        }
    }

    public static void drawTiles(Graphics graphics, SGSprite[] sGSpriteArray, short[] sArray) {
        int n = -GameWorld.mapView[0];
        int n2 = -GameWorld.mapView[1];
        int n3 = Math.max(0, GameWorld.mapView[1] / GameWorld.tileSize);
        int n4 = Math.max(0, GameWorld.mapView[0] / GameWorld.tileSize);
        int n5 = Math.min(GameWorld.mapRows - 1, (GameWorld.mapView[1] + GameWorld.viewHeight) / GameWorld.tileSize + 1);
        int n6 = Math.min(GameWorld.mapCols - 1, (GameWorld.mapView[0] + Device.WIDTH) / GameWorld.tileSize + 1);
        for (int i = n3; i <= n5; ++i) {
            for (int j = n4; j <= n6; ++j) {
                if (sGSpriteArray == null) {
                    FontMgr.drawString(0, graphics, j + "," + i, j * GameWorld.tileSize + GameWorld.tileSize / 2 + n, i * GameWorld.tileSize + GameWorld.tileSize / 2 + n2, 3);
                    continue;
                }
                int n7 = sArray[i * GameWorld.mapCols + j];
                if (n7 != -1) {
                    ++n7;
                }
                if (n7 == -1 || n7 >= sGSpriteArray.length) continue;
                sGSpriteArray[n7].paint(graphics, j * GameWorld.tileSize + GameWorld.tileSize / 2 + n, i * GameWorld.tileSize + GameWorld.tileSize + n2);
            }
        }
    }

    static {
        TOOL_NAMES = new String[]{"brush", "fill", "marquee", "copy", "paste", "view", "eyedrop"};
        levels = new Vector();
        levelDimensions = new Vector();
        saved = new Vector();
        tags = new Vector();
        tileSheetGroundIndex = new Vector();
        tileSheetMiddleIndex = new Vector();
        gameObjects = new Vector();
        showObjects = true;
        showTags = false;
        showRowCol = false;
    }
}

