/*
 * Decompiled with CFR 0.152.
 */
package TheClub;

import TheClub.cCanvas;
import TheClub.cGameObject;
import TheClub.cGameResources;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class cLevel {
    private cCanvas m_cnvs;
    private cGameResources m_res;
    private static int canvasWidth;
    private static int canvasHeight;
    public static byte TILE_WIDTH;
    public static byte TILE_HEIGHT;
    public static byte[][] currentmaptiles_low;
    private static byte TILE_NUM_COL;
    private static byte TILE_NUM_ROW;
    private static int terrainScrollx;
    private static int terrainScrolly;
    private static int startTileX;
    private static int startTileY;
    private static int endTileX;
    private static int endTileY;
    private static int drawTileX;
    private static int drawTileY;

    public cLevel(cCanvas cCanvas2, cGameResources cGameResources2) {
        this.m_cnvs = cCanvas2;
        this.m_res = cGameResources2;
        canvasWidth = this.m_cnvs.m_iWidth;
        canvasHeight = this.m_cnvs.m_iHeight;
    }

    public byte loadLevel_Stage1() {
        return 1;
    }

    public boolean loadLevel_Stage2() {
        return true;
    }

    public void loadLevel_Stage3() {
        terrainScrollx = 0;
        terrainScrolly = 0;
        byte[] byArray = new byte[]{30, 60, 15, 60, 15};
        byte[] byArray2 = new byte[]{28, 15, 60, 15, 60};
        TILE_NUM_COL = byArray[cGameResources.currentLevel];
        TILE_NUM_ROW = byArray2[cGameResources.currentLevel];
    }

    public void loadLevel_Stage4() {
        currentmaptiles_low = new byte[TILE_NUM_ROW][TILE_NUM_COL];
        this.loadBinaryLevelTileMap("/res/level_" + (cGameResources.currentLevel / 5 + 1) + "" + (cGameResources.currentLevel % -15 + 1) + "_road_layer_tiles.dat", this.getClass());
    }

    public void loadLevel_Stage5() {
    }

    public void loadLevel_Stage6() {
    }

    public void drawLevel(Graphics graphics) {
        graphics.setColor(0xD0D0D0);
        graphics.fillRect(0, 0, this.m_cnvs.m_iWidth, this.m_cnvs.m_iHeight);
        startTileX = terrainScrollx / TILE_WIDTH - 1;
        startTileY = terrainScrolly / TILE_HEIGHT - 1;
        endTileX = (cGameResources.qABS(terrainScrollx) + canvasWidth) / TILE_WIDTH + 1;
        endTileY = (cGameResources.qABS(terrainScrolly) + canvasHeight) / TILE_HEIGHT + 1;
        if (endTileX >= TILE_NUM_COL) {
            endTileX = TILE_NUM_COL - 1;
        }
        if (endTileY >= TILE_NUM_ROW) {
            endTileY = TILE_NUM_ROW - 1;
        }
        if (startTileX < 0) {
            startTileX = 0;
        }
        if (startTileY < 0) {
            startTileY = 0;
        }
        drawTileY = endTileY;
        while (drawTileY + 1 > startTileY) {
            drawTileX = endTileX;
            while (drawTileX + 1 > startTileX) {
                if (currentmaptiles_low[drawTileY][drawTileX] != 0) {
                    if (currentmaptiles_low[drawTileY][drawTileX] > 16) {
                        cCanvas.dg.drawImage(cGameResources.road_layer_tiles[currentmaptiles_low[drawTileY][drawTileX] - 16 - 1], drawTileX * TILE_WIDTH - terrainScrollx, drawTileY * TILE_HEIGHT - terrainScrolly, 0, 8192);
                    } else {
                        graphics.drawImage(cGameResources.road_layer_tiles[currentmaptiles_low[drawTileY][drawTileX] - 1], drawTileX * TILE_WIDTH - terrainScrollx, drawTileY * TILE_HEIGHT - terrainScrolly, 0);
                    }
                }
                --drawTileX;
            }
            --drawTileY;
        }
    }

    public void setCamera(cGameObject cGameObject2) {
        if (cGameObject2 == null) {
            return;
        }
        terrainScrollx = cGameObject2.m_iXpos - (canvasWidth >> 1);
        terrainScrolly = cGameObject2.m_iYpos - (canvasHeight >> 1);
        if (terrainScrollx < 0) {
            terrainScrollx = 0;
        }
        if (terrainScrollx > TILE_WIDTH * TILE_NUM_COL - canvasWidth) {
            terrainScrollx = TILE_WIDTH * TILE_NUM_COL - canvasWidth;
        }
        if (terrainScrolly < 0) {
            terrainScrolly = 0;
        }
        if (terrainScrolly > TILE_HEIGHT * TILE_NUM_ROW - canvasHeight) {
            terrainScrolly = TILE_HEIGHT * TILE_NUM_ROW - canvasHeight;
        }
    }

    public int getterrainScrollx() {
        return terrainScrollx;
    }

    public int getterrainScrolly() {
        return terrainScrolly;
    }

    public void loadBinaryLevelTileMap(String string, Class clazz) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        try {
            InputStream inputStream = clazz.getResourceAsStream(string);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            while (true) {
                try {
                    n2 = dataInputStream.readByte();
                }
                catch (EOFException eOFException) {
                    break;
                }
                if (n2 > -1) {
                    n = n2;
                    cLevel.currentmaptiles_low[n4][n5] = n2;
                    ++n5;
                } else {
                    for (n3 = n2; n3 < 0; ++n3) {
                        cLevel.currentmaptiles_low[n4][n5] = n;
                        if (++n5 != TILE_NUM_COL) continue;
                        n5 = 0;
                        ++n4;
                    }
                }
                if (n5 != TILE_NUM_COL) continue;
                n5 = 0;
                ++n4;
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("IO Exception =: " + iOException);
        }
    }

    static {
        TILE_WIDTH = (byte)24;
        TILE_HEIGHT = (byte)24;
    }
}

