/*
 * Decompiled with CFR 0.152.
 */
package TheClub;

import TheClub.cCanvas;
import TheClub.cGameObject;
import TheClub.cGameResources;
import TheClub.cGfxUtils;
import TheClub.cSprite;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class cLevel {
    private cCanvas m_cnvs;
    private cGameResources m_res;
    private static int canvasWidth;
    private static int canvasHeight;
    private static final byte[] LOW_TILESET_XTILES;
    private static final byte[] LOW_TILESET_YTILES;
    private static final byte[] MED_TILESET_XTILES;
    private static final byte[] MED_TILESET_YTILES;
    private static final byte[] HIGH_TILESET_XTILES;
    private static final byte[] HIGH_TILESET_YTILES;
    public static byte TILE_WIDTH;
    public static byte TILE_HEIGHT;
    private static final byte[] levelxsizes;
    private static final byte[] levelysizes;
    private static final byte[] level_alpha_low_offset;
    private static final String[] str_LOW_TILESET_DAT;
    private static final String[] str_MED_TILESET_DAT;
    private static final String[] str_HIGH_TILESET_DAT;
    private static byte bRoofOffTile;
    private static Image[] road_layer_tiles;
    private static Image[] building_layer_tiles;
    private static cSprite alpha_layer_tiles;
    public static byte[][] currentmaptiles_low;
    public static byte[][] currentmaptiles_med;
    public static byte[][] currentmaptiles_high;
    private static byte TILE_NUM_COL;
    private static byte TILE_NUM_ROW;
    private static int terrainScrollx;
    private static int terrainScrolly;
    private static int startTileX;
    private static int startTileY;
    private static int endTileX;
    private static int endTileY;
    private static int drawTileX;
    private static int drawTileY;
    private static int loadTileCount;
    private static int tx;
    private static int ty;
    private static Image tempTileImage;
    private static int LOAD_TILE_INCREMENT;

    public cLevel(cCanvas cCanvas2, cGameResources cGameResources2) {
        this.m_cnvs = cCanvas2;
        this.m_res = cGameResources2;
        canvasWidth = this.m_cnvs.m_iWidth;
        canvasHeight = this.m_cnvs.m_iHeight;
        loadTileCount = -1;
    }

    public boolean loadLevel_Stage1() {
        if (loadTileCount == -1) {
            tempTileImage = null;
            try {
                tempTileImage = Image.createImage((String)("/res/level_" + (cGameResources.currentLevel / 5 + 1) + "_road_layer_tiles.png"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            road_layer_tiles = new Image[LOW_TILESET_XTILES[cGameResources.currentLevel / 5] * LOW_TILESET_YTILES[cGameResources.currentLevel / 5]];
            ++loadTileCount;
            ty = 0;
            return false;
        }
        tx = loadTileCount;
        for (int i = 0; i < LOAD_TILE_INCREMENT; ++i) {
            cLevel.road_layer_tiles[cLevel.loadTileCount] = cGfxUtils.getImageRegion(tempTileImage, tx * TILE_WIDTH, ty * TILE_HEIGHT, TILE_WIDTH, TILE_HEIGHT);
            if (++tx == LOW_TILESET_XTILES[cGameResources.currentLevel / 5]) {
                tx = 0;
                ++ty;
            }
            if (++loadTileCount != LOW_TILESET_XTILES[cGameResources.currentLevel / 5] * LOW_TILESET_YTILES[cGameResources.currentLevel / 5]) continue;
            tempTileImage = null;
            loadTileCount = -1;
            return true;
        }
        return false;
    }

    public boolean loadLevel_Stage2() {
        if (loadTileCount == -1) {
            tempTileImage = null;
            try {
                tempTileImage = Image.createImage((String)("/res/level_" + (cGameResources.currentLevel / 5 + 1) + "_building_layer_tiles.png"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            building_layer_tiles = new Image[MED_TILESET_XTILES[cGameResources.currentLevel / 5] * MED_TILESET_YTILES[cGameResources.currentLevel / 5]];
            ++loadTileCount;
            ty = 0;
            return false;
        }
        tx = loadTileCount;
        for (int i = 0; i < LOAD_TILE_INCREMENT; ++i) {
            cLevel.building_layer_tiles[cLevel.loadTileCount] = cGfxUtils.getImageRegion(tempTileImage, tx * TILE_WIDTH, ty * TILE_HEIGHT, TILE_WIDTH, TILE_HEIGHT);
            if (++tx == LOW_TILESET_XTILES[cGameResources.currentLevel / 5]) {
                tx = 0;
                ++ty;
            }
            if (++loadTileCount != MED_TILESET_XTILES[cGameResources.currentLevel / 5] * MED_TILESET_YTILES[cGameResources.currentLevel / 5]) continue;
            tempTileImage = null;
            loadTileCount = -1;
            return true;
        }
        return false;
    }

    public void loadLevel_Stage3() {
        alpha_layer_tiles = new cSprite(this.m_cnvs, this.m_res, "level_" + (cGameResources.currentLevel / 5 + 1) + "_alpha_layer_tiles.png");
        alpha_layer_tiles.extractFrames(HIGH_TILESET_XTILES[cGameResources.currentLevel / 5], (int)HIGH_TILESET_YTILES[cGameResources.currentLevel / 5]);
        terrainScrollx = 0;
        terrainScrolly = 0;
        TILE_NUM_COL = levelxsizes[cGameResources.currentLevel];
        TILE_NUM_ROW = levelysizes[cGameResources.currentLevel];
    }

    public void loadLevel_Stage4() {
        currentmaptiles_low = new byte[TILE_NUM_ROW][TILE_NUM_COL];
        this.loadBinaryLevelTileMap(str_LOW_TILESET_DAT[cGameResources.currentLevel], this.getClass(), 0);
    }

    public void loadLevel_Stage5() {
        currentmaptiles_med = new byte[TILE_NUM_ROW][TILE_NUM_COL];
        this.loadBinaryLevelTileMap(str_MED_TILESET_DAT[cGameResources.currentLevel], this.getClass(), 1);
    }

    public void loadLevel_Stage6() {
        currentmaptiles_high = new byte[TILE_NUM_ROW][TILE_NUM_COL];
        this.loadBinaryLevelTileMap(str_HIGH_TILESET_DAT[cGameResources.currentLevel], this.getClass(), 2);
    }

    /*
     * Unable to fully structure code
     */
    public void drawLow_HighEnd(Graphics var1_1) {
        block19: {
            block18: {
                cLevel.startTileX = cLevel.terrainScrollx / cLevel.TILE_WIDTH - 1;
                cLevel.startTileY = cLevel.terrainScrolly / cLevel.TILE_HEIGHT - 1;
                cLevel.endTileX = (cGameResources.qABS(cLevel.terrainScrollx) + cLevel.canvasWidth) / cLevel.TILE_WIDTH + 1;
                cLevel.endTileY = (cGameResources.qABS(cLevel.terrainScrolly) + cLevel.canvasHeight) / cLevel.TILE_HEIGHT + 1;
                if (cLevel.endTileX >= cLevel.TILE_NUM_COL) {
                    cLevel.endTileX = cLevel.TILE_NUM_COL - 1;
                }
                if (cLevel.endTileY >= cLevel.TILE_NUM_ROW) {
                    cLevel.endTileY = cLevel.TILE_NUM_ROW - 1;
                }
                if (cLevel.startTileX < 0) {
                    cLevel.startTileX = 0;
                }
                if (cLevel.startTileY < 0) {
                    cLevel.startTileY = 0;
                }
                if (cGameResources.level_openroof_fx != -1) break block18;
                cLevel.drawTileY = cLevel.endTileY;
                while (cLevel.drawTileY + 1 > cLevel.startTileY) {
                    cLevel.drawTileX = cLevel.endTileX;
                    while (cLevel.drawTileX + 1 > cLevel.startTileX) {
                        if (cGameResources.qABS(cLevel.currentmaptiles_low[cLevel.drawTileY][cLevel.drawTileX]) != 0 && cLevel.currentmaptiles_med[cLevel.drawTileY][cLevel.drawTileX] == 0) {
                            var1_1.drawImage(cLevel.road_layer_tiles[cGameResources.qABS(cLevel.currentmaptiles_low[cLevel.drawTileY][cLevel.drawTileX])], cLevel.drawTileX * cLevel.TILE_WIDTH - cLevel.terrainScrollx, cLevel.drawTileY * cLevel.TILE_HEIGHT - cLevel.terrainScrolly, 4 | 16);
                        }
                        if (cLevel.currentmaptiles_med[cLevel.drawTileY][cLevel.drawTileX] != 0) {
                            var1_1.drawImage(cLevel.building_layer_tiles[cLevel.currentmaptiles_med[cLevel.drawTileY][cLevel.drawTileX]], cLevel.drawTileX * cLevel.TILE_WIDTH - cLevel.terrainScrollx, cLevel.drawTileY * cLevel.TILE_HEIGHT - cLevel.terrainScrolly, 4 | 16);
                        }
                        if (cLevel.currentmaptiles_high[cLevel.drawTileY][cLevel.drawTileX] != 0) {
                            if (cLevel.currentmaptiles_high[cLevel.drawTileY][cLevel.drawTileX] <= cLevel.level_alpha_low_offset[cGameResources.currentLevel / 5]) {
                                cLevel.alpha_layer_tiles.DrawFrame(var1_1, cLevel.currentmaptiles_high[cLevel.drawTileY][cLevel.drawTileX], cLevel.drawTileX * cLevel.TILE_WIDTH - cLevel.terrainScrollx, cLevel.drawTileY * cLevel.TILE_HEIGHT - cLevel.terrainScrolly);
                            }
                        }
                        --cLevel.drawTileX;
                    }
                    --cLevel.drawTileY;
                }
                break block19;
            }
            cLevel.drawTileY = cLevel.endTileY;
            while (cLevel.drawTileY + 1 > cLevel.startTileY) {
                cLevel.drawTileX = cLevel.endTileX;
                while (cLevel.drawTileX + 1 > cLevel.startTileX) {
                    if (cLevel.drawTileY < cGameResources.level_openroof_fy) ** GOTO lbl-1000
                    if (cLevel.drawTileY > cGameResources.level_openroof_ty) ** GOTO lbl-1000
                    if (cLevel.drawTileX < cGameResources.level_openroof_fx) ** GOTO lbl-1000
                    if (cLevel.drawTileX > cGameResources.level_openroof_tx) lbl-1000:
                    // 4 sources

                    {
                        cLevel.bRoofOffTile = 0;
                    } else {
                        cLevel.bRoofOffTile = 1;
                    }
                    if (cGameResources.qABS(cLevel.currentmaptiles_low[cLevel.drawTileY][cLevel.drawTileX]) != 0 && (cLevel.currentmaptiles_med[cLevel.drawTileY][cLevel.drawTileX] == 0 || cLevel.bRoofOffTile == 1)) {
                        var1_1.drawImage(cLevel.road_layer_tiles[cGameResources.qABS(cLevel.currentmaptiles_low[cLevel.drawTileY][cLevel.drawTileX])], cLevel.drawTileX * cLevel.TILE_WIDTH - cLevel.terrainScrollx, cLevel.drawTileY * cLevel.TILE_HEIGHT - cLevel.terrainScrolly, 4 | 16);
                    }
                    if (cLevel.bRoofOffTile == 0 && cLevel.currentmaptiles_med[cLevel.drawTileY][cLevel.drawTileX] != 0) {
                        var1_1.drawImage(cLevel.building_layer_tiles[cLevel.currentmaptiles_med[cLevel.drawTileY][cLevel.drawTileX]], cLevel.drawTileX * cLevel.TILE_WIDTH - cLevel.terrainScrollx, cLevel.drawTileY * cLevel.TILE_HEIGHT - cLevel.terrainScrolly, 4 | 16);
                    }
                    if (cLevel.bRoofOffTile == 0 && cLevel.currentmaptiles_high[cLevel.drawTileY][cLevel.drawTileX] != 0) {
                        if (cLevel.currentmaptiles_high[cLevel.drawTileY][cLevel.drawTileX] <= cLevel.level_alpha_low_offset[cGameResources.currentLevel / 5]) {
                            cLevel.alpha_layer_tiles.DrawFrame(var1_1, cLevel.currentmaptiles_high[cLevel.drawTileY][cLevel.drawTileX], cLevel.drawTileX * cLevel.TILE_WIDTH - cLevel.terrainScrollx, cLevel.drawTileY * cLevel.TILE_HEIGHT - cLevel.terrainScrolly);
                        }
                    }
                    --cLevel.drawTileX;
                }
                --cLevel.drawTileY;
            }
        }
    }

    public void drawLowSpecial_HighEnd(Graphics graphics) {
        startTileX = terrainScrollx / TILE_WIDTH - 1;
        startTileY = terrainScrolly / TILE_HEIGHT - 1;
        endTileX = (cGameResources.qABS(terrainScrollx) + canvasWidth) / TILE_WIDTH + 1;
        endTileY = (cGameResources.qABS(terrainScrolly) + canvasHeight) / TILE_HEIGHT + 1;
        if (endTileX >= TILE_NUM_COL) {
            endTileX = TILE_NUM_COL - 1;
        }
        if (endTileY >= TILE_NUM_ROW) {
            endTileY = TILE_NUM_ROW - 1;
        }
        if (startTileX < 0) {
            startTileX = 0;
        }
        if (startTileY < 0) {
            startTileY = 0;
        }
        if (cGameResources.level_openroof_fx == -1) {
            drawTileY = endTileY;
            while (drawTileY + 1 > startTileY) {
                drawTileX = endTileX;
                while (drawTileX + 1 > startTileX) {
                    if (cGameResources.qABS(currentmaptiles_low[drawTileY][drawTileX]) != 0) {
                        graphics.drawImage(road_layer_tiles[cGameResources.qABS(currentmaptiles_low[drawTileY][drawTileX])], drawTileX * TILE_WIDTH - terrainScrollx, drawTileY * TILE_HEIGHT - terrainScrolly, 4 | 0x10);
                    }
                    if (currentmaptiles_high[drawTileY][drawTileX] != 0) {
                        alpha_layer_tiles.DrawFrame(graphics, currentmaptiles_high[drawTileY][drawTileX], drawTileX * TILE_WIDTH - terrainScrollx, drawTileY * TILE_HEIGHT - terrainScrolly);
                    }
                    --drawTileX;
                }
                --drawTileY;
            }
        } else {
            drawTileY = endTileY;
            while (drawTileY + 1 > startTileY) {
                drawTileX = endTileX;
                while (drawTileX + 1 > startTileX) {
                    if (cGameResources.qABS(currentmaptiles_low[drawTileY][drawTileX]) != 0) {
                        graphics.drawImage(road_layer_tiles[cGameResources.qABS(currentmaptiles_low[drawTileY][drawTileX])], drawTileX * TILE_WIDTH - terrainScrollx, drawTileY * TILE_HEIGHT - terrainScrolly, 4 | 0x10);
                    }
                    if (currentmaptiles_med[drawTileY][drawTileX] != 0) {
                        graphics.drawImage(building_layer_tiles[currentmaptiles_med[drawTileY][drawTileX]], drawTileX * TILE_WIDTH - terrainScrollx, drawTileY * TILE_HEIGHT - terrainScrolly, 4 | 0x10);
                    }
                    --drawTileX;
                }
                --drawTileY;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void drawHigh_HighEnd(Graphics var1_1) {
        block11: {
            block10: {
                if (cGameResources.level_openroof_fx != -1) break block10;
                cLevel.drawTileY = cLevel.endTileY;
                while (cLevel.drawTileY + 1 > cLevel.startTileY) {
                    cLevel.drawTileX = cLevel.endTileX;
                    while (cLevel.drawTileX + 1 > cLevel.startTileX) {
                        if (cLevel.currentmaptiles_high[cLevel.drawTileY][cLevel.drawTileX] != 0) {
                            if (cLevel.currentmaptiles_high[cLevel.drawTileY][cLevel.drawTileX] > cLevel.level_alpha_low_offset[cGameResources.currentLevel / 5]) {
                                cLevel.alpha_layer_tiles.DrawFrame(var1_1, cLevel.currentmaptiles_high[cLevel.drawTileY][cLevel.drawTileX], cLevel.drawTileX * cLevel.TILE_WIDTH - cLevel.terrainScrollx, cLevel.drawTileY * cLevel.TILE_HEIGHT - cLevel.terrainScrolly);
                            }
                        }
                        --cLevel.drawTileX;
                    }
                    --cLevel.drawTileY;
                }
                break block11;
            }
            cLevel.drawTileY = cLevel.endTileY;
            while (cLevel.drawTileY + 1 > cLevel.startTileY) {
                cLevel.drawTileX = cLevel.endTileX;
                while (cLevel.drawTileX + 1 > cLevel.startTileX) {
                    if (cLevel.drawTileY < cGameResources.level_openroof_fy) ** GOTO lbl-1000
                    if (cLevel.drawTileY > cGameResources.level_openroof_ty) ** GOTO lbl-1000
                    if (cLevel.drawTileX < cGameResources.level_openroof_fx) ** GOTO lbl-1000
                    if (cLevel.drawTileX > cGameResources.level_openroof_tx) lbl-1000:
                    // 4 sources

                    {
                        cLevel.bRoofOffTile = 0;
                    } else {
                        cLevel.bRoofOffTile = 1;
                    }
                    if (cLevel.bRoofOffTile == 0 && cLevel.currentmaptiles_high[cLevel.drawTileY][cLevel.drawTileX] != 0) {
                        if (cLevel.currentmaptiles_high[cLevel.drawTileY][cLevel.drawTileX] > cLevel.level_alpha_low_offset[cGameResources.currentLevel / 5]) {
                            cLevel.alpha_layer_tiles.DrawFrame(var1_1, cLevel.currentmaptiles_high[cLevel.drawTileY][cLevel.drawTileX], cLevel.drawTileX * cLevel.TILE_WIDTH - cLevel.terrainScrollx, cLevel.drawTileY * cLevel.TILE_HEIGHT - cLevel.terrainScrolly);
                        }
                    }
                    --cLevel.drawTileX;
                }
                --cLevel.drawTileY;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void drawHighSpecial_HighEnd(Graphics var1_1) {
        block11: {
            block10: {
                if (cGameResources.level_openroof_fx != -1) break block10;
                cLevel.drawTileY = cLevel.endTileY;
                while (cLevel.drawTileY + 1 > cLevel.startTileY) {
                    cLevel.drawTileX = cLevel.endTileX;
                    while (cLevel.drawTileX + 1 > cLevel.startTileX) {
                        if (cLevel.currentmaptiles_high[cLevel.drawTileY][cLevel.drawTileX] != 0) {
                            if (cLevel.currentmaptiles_high[cLevel.drawTileY][cLevel.drawTileX] > cLevel.level_alpha_low_offset[cGameResources.currentLevel / 5]) {
                                cLevel.alpha_layer_tiles.DrawFrame(var1_1, cLevel.currentmaptiles_high[cLevel.drawTileY][cLevel.drawTileX], cLevel.drawTileX * cLevel.TILE_WIDTH - cLevel.terrainScrollx, cLevel.drawTileY * cLevel.TILE_HEIGHT - cLevel.terrainScrolly);
                            }
                        }
                        --cLevel.drawTileX;
                    }
                    --cLevel.drawTileY;
                }
                break block11;
            }
            cLevel.drawTileY = cLevel.endTileY;
            while (cLevel.drawTileY + 1 > cLevel.startTileY) {
                cLevel.drawTileX = cLevel.endTileX;
                while (cLevel.drawTileX + 1 > cLevel.startTileX) {
                    if (cLevel.drawTileY < cGameResources.level_openroof_fy) ** GOTO lbl-1000
                    if (cLevel.drawTileY > cGameResources.level_openroof_ty) ** GOTO lbl-1000
                    if (cLevel.drawTileX < cGameResources.level_openroof_fx) ** GOTO lbl-1000
                    if (cLevel.drawTileX > cGameResources.level_openroof_tx) lbl-1000:
                    // 4 sources

                    {
                        cLevel.bRoofOffTile = 0;
                    } else {
                        cLevel.bRoofOffTile = 1;
                    }
                    if (cLevel.bRoofOffTile == 0 && cLevel.currentmaptiles_high[cLevel.drawTileY][cLevel.drawTileX] != 0) {
                        if (cLevel.currentmaptiles_high[cLevel.drawTileY][cLevel.drawTileX] > cLevel.level_alpha_low_offset[cGameResources.currentLevel / 5]) {
                            cLevel.alpha_layer_tiles.DrawFrame(var1_1, cLevel.currentmaptiles_high[cLevel.drawTileY][cLevel.drawTileX], cLevel.drawTileX * cLevel.TILE_WIDTH - cLevel.terrainScrollx, cLevel.drawTileY * cLevel.TILE_HEIGHT - cLevel.terrainScrolly);
                        }
                    }
                    --cLevel.drawTileX;
                }
                --cLevel.drawTileY;
            }
        }
    }

    public void setCamera(cGameObject cGameObject2) {
        if (cGameObject2 == null) {
            return;
        }
        terrainScrollx = cGameObject2.m_iXpos - (canvasWidth >> 1);
        terrainScrolly = cGameObject2.m_iYpos - (canvasHeight >> 1);
        if (terrainScrollx < 0) {
            terrainScrollx = 0;
        }
        if (terrainScrollx > TILE_WIDTH * TILE_NUM_COL - canvasWidth) {
            terrainScrollx = TILE_WIDTH * TILE_NUM_COL - canvasWidth;
        }
        if (terrainScrolly < 0) {
            terrainScrolly = 0;
        }
        if (terrainScrolly > TILE_HEIGHT * TILE_NUM_ROW - canvasHeight) {
            terrainScrolly = TILE_HEIGHT * TILE_NUM_ROW - canvasHeight;
        }
    }

    public int getterrainScrollx() {
        return terrainScrollx;
    }

    public int getterrainScrolly() {
        return terrainScrolly;
    }

    public void loadBinaryLevelTileMap(String string, Class clazz, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        byte by = 0;
        try {
            InputStream inputStream = clazz.getResourceAsStream(string);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            while (true) {
                try {
                    n3 = dataInputStream.readByte();
                }
                catch (EOFException eOFException) {
                    break;
                }
                if (n3 > -1 || n == 0) {
                    n2 = n3;
                    switch (n) {
                        case 0: {
                            cLevel.currentmaptiles_low[n5][by] = n3;
                            break;
                        }
                        case 1: {
                            cLevel.currentmaptiles_med[n5][by] = n3;
                            break;
                        }
                        case 2: {
                            cLevel.currentmaptiles_high[n5][by] = n3;
                        }
                    }
                    ++by;
                } else {
                    for (n4 = n3; n4 < 0; ++n4) {
                        switch (n) {
                            case 0: {
                                cLevel.currentmaptiles_low[n5][by] = n2;
                                break;
                            }
                            case 1: {
                                cLevel.currentmaptiles_med[n5][by] = n2;
                                break;
                            }
                            case 2: {
                                cLevel.currentmaptiles_high[n5][by] = n2;
                            }
                        }
                        if (++by != TILE_NUM_COL) continue;
                        by = 0;
                        ++n5;
                    }
                }
                if (by != TILE_NUM_COL) continue;
                by = 0;
                ++n5;
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("IO Exception =: " + iOException);
        }
    }

    public int collision_horizontal(cGameObject cGameObject2, int n, int n2, int n3) {
        int n4;
        int n5 = n + n3;
        boolean bl = false;
        cGameObject2.tilecoordy = n2 / TILE_HEIGHT;
        int n6 = n4 / TILE_WIDTH;
        for (n4 = n - n % TILE_WIDTH; n4 <= n5; n4 += TILE_WIDTH) {
            if (n6 < 0 || n6 > TILE_NUM_COL - 1 || cGameObject2.tilecoordy < 0 || cGameObject2.tilecoordy > TILE_NUM_ROW - 1) {
                return 0;
            }
            if (currentmaptiles_low[cGameObject2.tilecoordy][n6] < 0) {
                return 1;
            }
            ++n6;
        }
        return 0;
    }

    public int collision_vertical(cGameObject cGameObject2, int n, int n2, int n3) {
        int n4;
        int n5 = n2 + n3;
        boolean bl = false;
        cGameObject2.tilecoordx = n / TILE_WIDTH;
        int n6 = n4 / TILE_HEIGHT;
        for (n4 = n2 - n2 % TILE_HEIGHT; n4 <= n5; n4 += TILE_HEIGHT) {
            if (cGameObject2.tilecoordx < 0 || cGameObject2.tilecoordx > TILE_NUM_COL - 1 || n6 < 0 || n6 > TILE_NUM_ROW - 1) {
                return 0;
            }
            if (currentmaptiles_low[n6][cGameObject2.tilecoordx] < 0) {
                return 1;
            }
            ++n6;
        }
        return 0;
    }

    public void TileBasedCheckCollision(cGameObject cGameObject2, int n, int n2) {
        if (cGameObject2.m_massObj.vel.x > 0) {
            switch (this.collision_vertical(cGameObject2, (cGameObject2.m_massObj.pos.x >> 12) + (cGameObject2.m_massObj.vel.x >> 12) - (n >> 1) + n, (cGameObject2.m_massObj.pos.y >> 12) - (n2 >> 1), n2)) {
                case 1: {
                    cGameObject2.m_iFlags |= 0x2000;
                    cGameObject2.m_massObj.pos.x = cGameObject2.tilecoordx * TILE_WIDTH - n - 1 << 12;
                    cGameObject2.m_massObj.pos.x -= n >> 1 << 12;
                    cGameObject2.m_massObj.vel.x = 0;
                    break;
                }
                default: {
                    cGameObject2.m_massObj.pos.x += cGameObject2.m_massObj.vel.x;
                    break;
                }
            }
        } else if (cGameObject2.m_massObj.vel.x < 0) {
            switch (this.collision_vertical(cGameObject2, (cGameObject2.m_massObj.pos.x >> 12) + (cGameObject2.m_massObj.vel.x >> 12) - (n >> 1), (cGameObject2.m_massObj.pos.y >> 12) - (n2 >> 1), n2)) {
                case 1: {
                    cGameObject2.m_iFlags |= 0x2000;
                    cGameObject2.m_massObj.pos.x = (cGameObject2.tilecoordx + 1) * TILE_WIDTH << 12;
                    cGameObject2.m_massObj.pos.x += n >> 1 << 12;
                    cGameObject2.m_massObj.vel.x = 0;
                    break;
                }
                default: {
                    cGameObject2.m_massObj.pos.x += cGameObject2.m_massObj.vel.x;
                }
            }
        }
        if (cGameObject2.m_massObj.vel.y < 0) {
            switch (this.collision_horizontal(cGameObject2, (cGameObject2.m_massObj.pos.x >> 12) - (n >> 1), (cGameObject2.m_massObj.pos.y >> 12) + (cGameObject2.m_massObj.vel.y >> 12) - (n2 >> 1), n)) {
                case 1: {
                    cGameObject2.m_iFlags |= 0x2000;
                    cGameObject2.m_massObj.pos.y = (cGameObject2.tilecoordy + 1) * TILE_HEIGHT << 12;
                    cGameObject2.m_massObj.pos.y += n2 >> 1 << 12;
                    cGameObject2.m_massObj.vel.y = 0;
                    break;
                }
                default: {
                    cGameObject2.m_massObj.pos.y += cGameObject2.m_massObj.vel.y;
                    break;
                }
            }
        } else {
            switch (this.collision_horizontal(cGameObject2, (cGameObject2.m_massObj.pos.x >> 12) - (n >> 1), (cGameObject2.m_massObj.pos.y >> 12) + (cGameObject2.m_massObj.vel.y >> 12) - (n2 >> 1) + n2, n)) {
                case 1: {
                    cGameObject2.m_iFlags |= 0x2000;
                    cGameObject2.m_massObj.pos.y = cGameObject2.tilecoordy * TILE_HEIGHT - n2 - 1 << 12;
                    cGameObject2.m_massObj.pos.y -= n2 >> 1 << 12;
                    cGameObject2.m_massObj.vel.y = 4096;
                    break;
                }
                default: {
                    cGameObject2.m_massObj.pos.y += cGameObject2.m_massObj.vel.y;
                }
            }
        }
    }

    static {
        LOW_TILESET_XTILES = new byte[]{97, 116, 110};
        LOW_TILESET_YTILES = new byte[]{1, 1, 1};
        MED_TILESET_XTILES = new byte[]{79, 79, 87};
        MED_TILESET_YTILES = new byte[]{1, 1, 1};
        HIGH_TILESET_XTILES = new byte[]{54, 31, 98};
        HIGH_TILESET_YTILES = new byte[]{1, 1, 1};
        TILE_WIDTH = (byte)24;
        TILE_HEIGHT = (byte)24;
        levelxsizes = new byte[]{85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85};
        levelysizes = new byte[]{85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85};
        level_alpha_low_offset = new byte[]{40, 9, 13};
        str_LOW_TILESET_DAT = new String[]{"/res/level_11_road_layer_tiles.dat", "/res/level_12_road_layer_tiles.dat", "/res/level_13_road_layer_tiles.dat", "/res/level_14_road_layer_tiles.dat", "/res/level_15_road_layer_tiles.dat", "/res/level_21_road_layer_tiles.dat", "/res/level_22_road_layer_tiles.dat", "/res/level_23_road_layer_tiles.dat", "/res/level_24_road_layer_tiles.dat", "/res/level_25_road_layer_tiles.dat", "/res/level_31_road_layer_tiles.dat", "/res/level_32_road_layer_tiles.dat", "/res/level_33_road_layer_tiles.dat", "/res/level_34_road_layer_tiles.dat", "/res/level_35_road_layer_tiles.dat"};
        str_MED_TILESET_DAT = new String[]{"/res/level_11_building_layer_tiles.dat", "/res/level_12_building_layer_tiles.dat", "/res/level_13_building_layer_tiles.dat", "/res/level_14_building_layer_tiles.dat", "/res/level_15_building_layer_tiles.dat", "/res/level_21_building_layer_tiles.dat", "/res/level_22_building_layer_tiles.dat", "/res/level_23_building_layer_tiles.dat", "/res/level_24_building_layer_tiles.dat", "/res/level_25_building_layer_tiles.dat", "/res/level_31_building_layer_tiles.dat", "/res/level_32_building_layer_tiles.dat", "/res/level_33_building_layer_tiles.dat", "/res/level_34_building_layer_tiles.dat", "/res/level_35_building_layer_tiles.dat"};
        str_HIGH_TILESET_DAT = new String[]{"/res/level_11_alpha_layer_tiles.dat", "/res/level_12_alpha_layer_tiles.dat", "/res/level_13_alpha_layer_tiles.dat", "/res/level_14_alpha_layer_tiles.dat", "/res/level_15_alpha_layer_tiles.dat", "/res/level_21_alpha_layer_tiles.dat", "/res/level_22_alpha_layer_tiles.dat", "/res/level_23_alpha_layer_tiles.dat", "/res/level_24_alpha_layer_tiles.dat", "/res/level_25_alpha_layer_tiles.dat", "/res/level_31_alpha_layer_tiles.dat", "/res/level_32_alpha_layer_tiles.dat", "/res/level_33_alpha_layer_tiles.dat", "/res/level_34_alpha_layer_tiles.dat", "/res/level_35_alpha_layer_tiles.dat"};
        LOAD_TILE_INCREMENT = 20;
    }
}

