/*
 * Decompiled with CFR 0.152.
 */
package Coral.Util;

import Coral.Audio.iAudioLoader;
import Coral.Graphics2D.crlImagePacked;
import Coral.UI.crlUI;
import Coral.Util.cResProcessObj;
import Coral.Util.crlBinArray;
import Coral.Util.crlInt;
import Coral.Util.crlManagerBase;
import Coral.Util.crlString;
import Coral.Util.crlUtil;
import Coral.crlCanvas;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public class crlResourceManager
extends crlManagerBase
implements iAudioLoader {
    private static byte[] mScratchBuffer;
    private static String sSpongeName;
    private static String _resDirectory;
    private static String _pngExtension;
    private static String _spgExtension;
    private static String _binExtension;
    public static final String[] LANGUAGE_STRINGS;
    private static int iUserScratchSize;
    private static int iObj3DBaseID;
    private static final byte[] _tempArray;
    private static StringBuffer _mFnameBuffer;
    private long[] currentPack;
    private int currentPackPos;
    private InputStream mInputStream;
    private DataInputStream mDataStream;
    private boolean mCacheReady;
    private byte[] mCache;
    private cResProcessObj[] mProcObjMap;
    private boolean mEncrypted;
    private byte _mKey = (byte)22;
    private Hashtable mResource;
    private crlInt mIntObject;
    private int mRetry;
    private long mPrevID = -1L;
    private int mCacheBytesRead = 0;
    private int mCacheProgress = -1;
    public static crlString[] mLocaleText;
    private int locale = crlUI.mLocale;

    public int close() {
        for (int i = 0; i < this.mProcObjMap.length; ++i) {
            this.mProcObjMap[i] = null;
        }
        this.mProcObjMap = null;
        mLocaleText = null;
        this.mResource = null;
        this.mIntObject = null;
        _mFnameBuffer = null;
        this.mCache = null;
        return 0;
    }

    public final int update() {
        int n = 0;
        if (this._mStatus == 6) {
            n = this._updatePack();
        }
        return n;
    }

    public final crlBinArray getBinBySpongeID(long l) {
        this.mIntObject.setValue((int)l);
        return (crlBinArray)this.mResource.get(this.mIntObject);
    }

    public final crlBinArray getAudioBinByID(long l) {
        return this.getBinBySpongeID(l);
    }

    private final boolean alreadyLoaded(long l) {
        this.mIntObject.setValue((int)l);
        return this.mResource.containsKey(this.mIntObject);
    }

    private final int _updatePack() {
        long l;
        if (crlCanvas.mLoadInterrupted) {
            if (this.currentPackPos > 0 && (int)(this.currentPack[this.currentPackPos] >> 32) != -1) {
                --this.currentPackPos;
                this.unloadObject(this.currentPack[this.currentPackPos]);
                this.mPrevID = this.currentPackPos > 0 ? this.currentPack[this.currentPackPos - 1] : -1L;
            }
            crlCanvas.mLoadInterrupted = false;
        }
        if ((l = this.currentPack[this.currentPackPos]) != 0L) {
            if ((int)(l >> 32) == -1) {
                int n = (int)l;
                this.processObject(this.mPrevID, n);
                this.mPrevID = -1L;
            } else if (!this.alreadyLoaded(l)) {
                System.gc();
                this.mRetry = 3;
                boolean bl = false;
                while (!bl) {
                    this.loadObject(l);
                    this.mIntObject.setValue((int)l);
                    if (this.mResource.get(this.mIntObject) != null) {
                        bl = true;
                        this.mPrevID = l;
                        continue;
                    }
                    --this.mRetry;
                    if (this.mRetry < 0) {
                        return -1;
                    }
                    crlUtil.garbageWait();
                }
            } else {
                this.mPrevID = l;
            }
        }
        if (crlCanvas.mLoadInterrupted) {
            if (this.currentPackPos >= 0 && (int)(this.currentPack[this.currentPackPos] >> 32) != -1) {
                this.unloadObject(this.currentPack[this.currentPackPos]);
                crlUtil.garbageWait();
                --this.currentPackPos;
                this.mPrevID = this.currentPackPos > 0 ? this.currentPack[this.currentPackPos - 1] : -1L;
            }
            crlCanvas.mLoadInterrupted = false;
        }
        ++this.currentPackPos;
        if (this.currentPackPos == this.currentPack.length) {
            this._mStatus = 2;
            crlUtil.garbageWait();
        }
        return 0;
    }

    private final void processObject(long l, int n) {
        cResProcessObj cResProcessObj2 = this.mProcObjMap[n];
        try {
            cResProcessObj2.process(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void loadObjectFromStream(byte by, DataInputStream dataInputStream, int n, long l) throws IOException {
        switch (by) {
            case 1: {
                this.loadObjectPNG(dataInputStream, n, l);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                this.loadObjectBIN(dataInputStream, n, l);
                break;
            }
            case 11: {
                this.loadObjectIMP(dataInputStream, n, l);
                break;
            }
            case 9: {
                this.loadObjectSPG(dataInputStream, n, l);
                break;
            }
            case 10: {
                break;
            }
        }
    }

    private final void loadObjectFromMemory(byte by, int n, int n2, long l) throws Exception {
        switch (by) {
            case 1: {
                this.loadObjectPNGmemory(n, n2, l);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                this.loadObjectBINmemory(n, n2, l);
                break;
            }
            case 11: {
                this.loadObjectIMPmemory(n, n2, l);
                break;
            }
            case 9: {
                this.loadObjectSPGmemory(n, n2, l);
                break;
            }
            case 10: {
                break;
            }
        }
    }

    private final byte loadObject(long l) {
        byte by = -1;
        try {
            if (this.mCacheReady) {
                int n = (int)(l >> 32);
                int n2 = crlUtil.toInt(this.mCache, n);
                int n3 = crlUtil.toInt(this.mCache, n += 4);
                by = this.mCache[n += 4];
                ++n;
                if ((by & 0x40) == 64) {
                    by = (byte)(by & 0xFFFFFFBF);
                    this.mEncrypted = true;
                } else {
                    this.mEncrypted = false;
                }
                if ((by & 0xFFFFFF80) == -128) {
                    by = (byte)(by & 0x7F);
                    int n4 = crlUtil.toInt(this.mCache, n);
                    n += 4;
                    int n5 = _resDirectory.length();
                    for (int i = 0; i < n2 - 4; ++i) {
                        _mFnameBuffer.append((char)this.mCache[n++]);
                    }
                    this.loadObjectFromFile(by, _mFnameBuffer.toString(), n4, n3);
                    _mFnameBuffer.delete(n5, 128 - n5);
                } else {
                    this.loadObjectFromMemory(by, n, n2, n3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return by;
    }

    private final void loadObjectFromFile(byte by, String string, int n, int n2) throws IOException {
        this.mInputStream = this.getClass().getResourceAsStream(string);
        if (this.mInputStream == null) {
            crlUtil.garbageWait();
        }
        this.mDataStream = new DataInputStream(this.mInputStream);
        this.loadObjectFromStream(by, this.mDataStream, n, n2);
        this.mInputStream.close();
    }

    private final int loadObjectIMP(DataInputStream dataInputStream, int n, long l) throws IOException {
        int n2 = dataInputStream.readInt();
        n -= 4;
        byte[] byArray = new byte[n2];
        dataInputStream.readFully(byArray, 0, n2);
        byte[] byArray2 = new byte[n -= n2];
        dataInputStream.readFully(byArray2, 0, n);
        Image image = Image.createImage((byte[])byArray2, (int)0, (int)n);
        short[] sArray = new short[n2 / 2];
        for (int i = 0; i < n2 / 2; ++i) {
            sArray[i] = crlUtil.toShort(byArray, i * 2);
        }
        crlImagePacked crlImagePacked2 = new crlImagePacked();
        crlImagePacked2.open(image, sArray);
        this.mIntObject.setValue((int)l);
        this.mResource.put(this.mIntObject, crlImagePacked2);
        return 0;
    }

    private final int loadObjectIMPmemory(int n, int n2, long l) throws IOException {
        int n3 = crlUtil.toInt(this.mCache, n);
        n2 -= 4;
        n += 4;
        short[] sArray = new short[n3 / 2];
        for (int i = 0; i < n3 / 2; ++i) {
            sArray[i] = crlUtil.toShort(this.mCache, n);
            n += 2;
        }
        Image image = Image.createImage((byte[])this.mCache, (int)n, (int)(n2 -= n3));
        crlImagePacked crlImagePacked2 = new crlImagePacked();
        crlImagePacked2.open(image, sArray);
        this.mIntObject.setValue((int)l);
        this.mResource.put(this.mIntObject, crlImagePacked2);
        return 0;
    }

    private final int loadObjectSPG(DataInputStream dataInputStream, int n, long l) throws IOException {
        int n2 = 0;
        byte[] byArray = new byte[4];
        dataInputStream.readFully(byArray, 0, 4);
        n2 += 4;
        while (n2 < n) {
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            byte by = dataInputStream.readByte();
            this.loadObjectFromStream(by, dataInputStream, n3, n4);
            n2 += n3 + 9;
        }
        return 0;
    }

    private final int loadObjectSPGmemory(int n, int n2, long l) throws Exception {
        int n3 = 4;
        n += 4;
        int n4 = 0;
        while (n3 < n2) {
            int n5 = crlUtil.toInt(this.mCache, n);
            int n6 = crlUtil.toInt(this.mCache, n += 4);
            byte by = this.mCache[n += 4];
            this.loadObjectFromMemory(by, ++n, n5, n6);
            n3 += n5 + 9;
            n += n5;
            ++n4;
        }
        return 0;
    }

    private final int loadObjectBIN(DataInputStream dataInputStream, int n, long l) throws IOException {
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray, 0, n);
        crlBinArray crlBinArray2 = new crlBinArray();
        crlBinArray2.set(byArray, 0, n);
        this.mResource.put(this.mIntObject, crlBinArray2);
        this.mIntObject.setValue((int)l);
        this.mResource.put(this.mIntObject, crlBinArray2);
        return 0;
    }

    private final int loadObjectBINmemory(int n, int n2, long l) throws IOException {
        crlBinArray crlBinArray2 = new crlBinArray();
        crlBinArray2.set(this.mCache, n, n2);
        this.mResource.put(this.mIntObject, crlBinArray2);
        this.mIntObject.setValue((int)l);
        this.mResource.put(this.mIntObject, crlBinArray2);
        return 0;
    }

    private final int loadObjectPNG(DataInputStream dataInputStream, int n, long l) throws IOException {
        dataInputStream.readFully(mScratchBuffer, 0, n);
        Image image = Image.createImage((byte[])mScratchBuffer, (int)0, (int)n);
        this.mIntObject.setValue((int)l);
        this.mResource.put(this.mIntObject, image);
        return 0;
    }

    private final int loadObjectPNGmemory(int n, int n2, long l) throws Exception {
        Image image = Image.createImage((byte[])this.mCache, (int)n, (int)n2);
        this.mIntObject.setValue((int)l);
        this.mResource.put(this.mIntObject, image);
        return 0;
    }

    public final int unloadObject(long l) {
        this.mIntObject.setValue((int)l);
        if (this.mResource.remove(this.mIntObject) == null) {
            return -1;
        }
        return 0;
    }

    static {
        sSpongeName = "M_3D";
        _resDirectory = "/res/";
        _pngExtension = ".png";
        _spgExtension = ".spg";
        _binExtension = ".bin";
        LANGUAGE_STRINGS = new String[]{"en", "fr", "it", "de", "es", "nl", "pt"};
        iUserScratchSize = 16384;
        iObj3DBaseID = 65535;
        _tempArray = new byte[4];
    }
}

