/*
 * Decompiled with CFR 0.152.
 */
package engine.world;

import app.GameAppState;
import engine.world.EnemyParameters;
import engine.world.Point;
import engine.world.Region;
import engine.world.SectorEdge;
import engine.world.SplashScreen;
import engine.world.TiledLayer;
import framework.sound.Music;
import java.io.DataInputStream;

public class Level {
    public static final byte EDGE_TYPE_WALL = -1;
    public static final byte EDGE_TYPE_GAP = -100;
    public static final byte EDGE_TYPE_ELEVATOR_LVL4 = -10;
    public static final byte EDGE_TYPE_DOOR1_LVL4 = -20;
    public static final byte EDGE_TYPE_DOOR1_LVL7 = -21;
    public static final byte EDGE_TYPE_DOOR2_LVL7 = -22;
    public static final byte EDGE_TYPE_DOOR3_LVL7 = -23;
    public static final byte EDGE_TYPE_DOOR4_LVL7 = -24;
    public static final byte EDGE_TYPE_DOOR_EXIT_LVL4 = -25;
    public static final byte EDGE_TYPE_DOOR_EXIT_LVL6 = -26;
    public static final byte SECTOR_TYPE_FLOOR = 0;
    public static final byte SECTOR_TYPE_PLATFORM = 1;
    public static final byte SECTOR_TYPE_PLATFORM_SCROLL_LEFT = 6;
    public static final byte SECTOR_TYPE_PLATFORM_SCROLL_RIGHT = 7;
    public static final byte SECTOR_TYPE_LADDER = 2;
    public static final byte SECTOR_TYPE_FLOOR_SCROLL_LEFT = 3;
    public static final byte SECTOR_TYPE_FLOOR_SCROLL_RIGHT = 4;
    public static final byte SECTOR_TYPE_FLOOR_RAMP = 5;
    public TiledLayer tiledLayer;
    public int sectorNumber;
    public byte[] sectorType;
    public SectorEdge[] sectorEdgeTop;
    public SectorEdge[] sectorEdgeBottom;
    public Region[] region;
    public byte regionsNumber;
    public byte currentRegion;
    public short heroStartX;
    public short heroStartY;
    public short heroStartSector;
    private static int b = -1;
    public EnemyParameters[] params;
    public boolean levelCleared;

    public Level(TiledLayer tiledLayer, DataInputStream disLevelDescription, DataInputStream disRegions) {
        try {
            int i;
            this.tiledLayer = tiledLayer;
            this.sectorNumber = disLevelDescription.readByte();
            this.sectorType = new byte[this.sectorNumber];
            this.sectorEdgeTop = new SectorEdge[this.sectorNumber];
            this.sectorEdgeBottom = new SectorEdge[this.sectorNumber];
            for (int i2 = 0; i2 < this.sectorNumber; ++i2) {
                this.sectorType[i2] = disLevelDescription.readByte();
                this.sectorEdgeTop[i2] = new SectorEdge(disLevelDescription);
                this.sectorEdgeBottom[i2] = new SectorEdge(disLevelDescription);
            }
            this.heroStartX = disRegions.readShort();
            this.heroStartY = disRegions.readShort();
            this.heroStartSector = disRegions.readByte();
            int paramsCount = disRegions.readByte();
            this.params = new EnemyParameters[paramsCount];
            for (i = 0; i < paramsCount; ++i) {
                this.params[i] = new EnemyParameters();
                this.params[i].enemyType = disRegions.readByte();
                this.params[i].startingLife = disRegions.readByte();
                this.params[i].damage[0] = disRegions.readByte();
                this.params[i].damage[1] = disRegions.readByte();
                this.params[i].damage[2] = disRegions.readByte();
                this.params[i].damage[3] = disRegions.readByte();
                this.params[i].damage[4] = disRegions.readByte();
            }
            this.regionsNumber = disRegions.readByte();
            this.region = new Region[this.regionsNumber];
            for (i = 0; i < this.regionsNumber; ++i) {
                this.region[i] = new Region(disRegions);
            }
            this.currentRegion = 0;
            this.levelCleared = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Point getExitFromSector(int from, int to) {
        int i;
        if (GameAppState.levelNumber == 8 && from == 1) {
            if (to == 0) {
                Point p = new Point(438, 115);
                p.passingType = 0;
                return p;
            }
            if (to == 2) {
                Point p = new Point(506, 166);
                p.passingType = 0;
                return p;
            }
        }
        if (GameAppState.levelNumber == 5 && to > from) {
            if (from == 16) {
                Point p = new Point(1040, 169);
                p.passingType = (byte)2;
                return p;
            }
            if (from == 18) {
                Point p = new Point(1110, 137);
                p.passingType = (byte)2;
                return p;
            }
            if (from == 19) {
                Point p = new Point(1215, 121);
                p.passingType = 1;
                return p;
            }
            if (from == 20) {
                Point p = new Point(1175, 105);
                p.passingType = 1;
                return p;
            }
            if (from == 21) {
                Point p = new Point(1130, 89);
                p.passingType = (byte)2;
                return p;
            }
        }
        if (GameAppState.levelNumber == 5 && (to == 16 || to == 18 || to == 19) && from == 22) {
            Point p = new Point(1000, 56);
            return p;
        }
        SectorEdge edge = null;
        int line = 0;
        int dy = 0;
        boolean dx = false;
        for (i = 0; i < this.sectorEdgeTop[from].pointsNumber - 1; i = (int)((byte)(i + 1))) {
            if (this.sectorEdgeTop[from].edgeType[i] != to) continue;
            edge = this.sectorEdgeTop[from];
            line = i;
            dy = 1;
        }
        for (i = 0; i < this.sectorEdgeBottom[from].pointsNumber - 1; i = (int)((byte)(i + 1))) {
            if (this.sectorEdgeBottom[from].edgeType[i] != to) continue;
            edge = this.sectorEdgeBottom[from];
            line = i;
            dy = -1;
        }
        if (edge == null) {
            int i2;
            int sector = from;
            sector = from - to > 0 ? --sector : ++sector;
            for (i2 = 0; i2 < this.sectorEdgeTop[from].pointsNumber - 1; i2 = (int)((byte)(i2 + 1))) {
                if (this.sectorEdgeTop[from].edgeType[i2] != sector) continue;
                edge = this.sectorEdgeTop[from];
                line = i2;
                dy = 1;
            }
            for (i2 = 0; i2 < this.sectorEdgeBottom[from].pointsNumber - 1; i2 = (int)((byte)(i2 + 1))) {
                if (this.sectorEdgeBottom[from].edgeType[i2] != sector) continue;
                edge = this.sectorEdgeBottom[from];
                line = i2;
                dy = -1;
            }
        }
        if (edge == null) {
            return null;
        }
        short x = 0;
        short y = 0;
        if (this.sectorType[from] == 1 && this.sectorType[to] != 2) {
            if (line == 0) {
                dy = -1;
            } else if (line == edge.xPoint.length - 2) {
                dy = 1;
            }
            x = edge.xPoint[line];
            y = edge.yPoint[line];
        } else {
            x = (short)(edge.xPoint[line] + (edge.xPoint[line + 1] - edge.xPoint[line] >> 1));
            y = (short)(edge.yPoint[line] + (edge.yPoint[line + 1] - edge.yPoint[line] >> 1) - dy);
        }
        Point p = new Point(x, y);
        if (edge.nextSectorDeltaY[line] < 0) {
            if (dy == 1) {
                p.x = (short)(p.x - 25);
                p.passingType = (byte)2;
            } else {
                p.x = (short)(p.x + 25);
                p.passingType = 1;
            }
        } else if (edge.nextSectorDeltaX[line] > 0) {
            p.x = (short)(p.x - 5);
            p.passingType = (byte)2;
        } else if (edge.nextSectorDeltaX[line] < 0) {
            p.x = (short)(p.x + 5);
            p.passingType = 1;
        } else {
            p.x = dy == 1 ? (short)(p.x + 5) : (short)(p.x - 5);
            if (this.sectorType[edge.edgeType[line]] == 2) {
                p.y = dy == 1 ? (short)(p.y - 5) : (short)(p.y + 5);
            }
        }
        return p;
    }

    public void update(int deltaTime) {
        try {
            if (!(GameAppState.ileWrogow == 2 || this.currentRegion != GameAppState.hero.currentRegionX || this.currentRegion != GameAppState.hero.currentRegionY || GameAppState.levelNumber == 2 && this.currentRegion == 3 && GameAppState.heliEnabled)) {
                if (this.region[this.currentRegion].currentGroup < this.region[this.currentRegion].enemiesGroups) {
                    byte group = this.region[this.currentRegion].currentGroup;
                    if (GameAppState.levelNumber == 1 && this.currentRegion == 6 && this.region[this.currentRegion].enemiesSpawned < this.region[this.currentRegion].enemyCount[group]) {
                        GameAppState.changeMusic("/sfx/boss_lev1.mid", -1);
                    }
                    if (GameAppState.levelNumber == 1 && this.currentRegion == 3 && this.region[this.currentRegion].enemiesSpawned < this.region[this.currentRegion].enemyCount[group]) {
                        if (group == 0) {
                            GameAppState.animations[0].setState((byte)1);
                        }
                        if (group == 1) {
                            GameAppState.animations[1].setState((byte)1);
                        }
                    }
                    if (GameAppState.levelNumber == 4 && this.currentRegion == 2 && this.region[this.currentRegion].enemiesSpawned < this.region[this.currentRegion].enemyCount[group] && group == 2) {
                        GameAppState.animations[2].setState((byte)5);
                    }
                    if (GameAppState.levelNumber == 5 && this.currentRegion == 4 && this.region[this.currentRegion].enemiesSpawned < this.region[this.currentRegion].enemyCount[group]) {
                        GameAppState.animations[0].setState((byte)1);
                    }
                    while (!GameAppState.tractorEnabled && GameAppState.ileWrogow < 2 && this.region[this.currentRegion].enemiesSpawned < this.region[this.currentRegion].enemyCount[group]) {
                        byte enemy = this.region[this.currentRegion].enemiesSpawned;
                        int x = this.region[this.currentRegion].enemyStartX[group][enemy];
                        if (x == -1) {
                            x = GameAppState.cameraX - 20;
                        } else if (x == -2) {
                            x = GameAppState.cameraX + GameAppState.scaleUpValue(176) + 20;
                        }
                        GameAppState.addEnemy(x, this.region[this.currentRegion].enemyStartY[group][enemy], this.region[this.currentRegion].enemyStartSector[group][enemy], 0, this.region[this.currentRegion].enemyType[group][enemy], this.region[this.currentRegion].enemyWeapon[group][enemy]);
                        this.region[this.currentRegion].enemiesSpawned = (byte)(this.region[this.currentRegion].enemiesSpawned + 1);
                    }
                    if (this.region[this.currentRegion].enemiesSpawned == this.region[this.currentRegion].enemyCount[group] && GameAppState.ileWrogow == 0) {
                        for (int i = 0; i < GameAppState.weaponsCount; ++i) {
                            GameAppState.weapons[i] = null;
                        }
                        GameAppState.weaponsCount = 0;
                        GameAppState.hero.weapon = null;
                        this.region[this.currentRegion].currentGroup = (byte)(this.region[this.currentRegion].currentGroup + 1);
                        this.region[this.currentRegion].enemiesSpawned = 0;
                        if (GameAppState.levelNumber == 5 && this.currentRegion == 5 && this.region[this.currentRegion].currentGroup == 1) {
                            GameAppState.tractorEnabled = true;
                            GameAppState.changeMusic("/sfx/steam_machine.mid", -1);
                        }
                    }
                } else if (this.currentRegion < this.regionsNumber - 1 && GameAppState.levelNumber != 7) {
                    if (GameAppState.levelNumber != 4 || this.currentRegion != 0) {
                        GameAppState.showHand(this.region[this.currentRegion].nextSectorDirection);
                    }
                    if (GameAppState.levelNumber == 4 && this.currentRegion == 0) {
                        GameAppState.windaActive = true;
                    }
                    if (GameAppState.levelNumber == 4 && this.currentRegion == 2) {
                        GameAppState.animations[2].setState((byte)3);
                    }
                    if (GameAppState.levelNumber != 4 || this.currentRegion != 2) {
                        this.currentRegion = (byte)(this.currentRegion + 1);
                    }
                } else {
                    if (GameAppState.levelNumber == 7) {
                        if (this.currentRegion == 1) {
                            GameAppState.animations[6].setState((byte)3);
                        }
                        if (this.currentRegion == 3) {
                            GameAppState.animations[8].setState((byte)3);
                        }
                        if (this.currentRegion == 4 && GameAppState.ileWrogow == 0 && GameAppState.levelRequested == -1 && GameAppState.menuIdRequested == -1) {
                            if (GameAppState.difficulty == 1) {
                                GameAppState.menuIdRequested = (byte)112;
                                GameAppState.difficultiesPlayed = (byte)2;
                                GameAppState.savedGameExist = false;
                                GameAppState.fadeOutIn();
                            } else {
                                GameAppState.levelRequested = (byte)(GameAppState.levelNumber + 1);
                                GameAppState.fadeOutIn();
                            }
                        }
                    }
                    if (GameAppState.levelNumber == 2 && GameAppState.hero.fp_heroX > GameAppState.HELI2_X && GameAppState.fp_heli2PosY != GameAppState.HELI2_ENDY && !GameAppState.heli2Flying) {
                        GameAppState.heli2Flying = true;
                        this.levelCleared = true;
                        GameAppState.changeMusic("/sfx/clear.mid", 1);
                    }
                    if ((GameAppState.levelNumber == 1 || GameAppState.levelNumber == 3 || GameAppState.levelNumber == 5 || GameAppState.levelNumber == 8 || GameAppState.levelNumber == 9 || GameAppState.levelNumber == 11) && GameAppState.levelRequested == -1 && GameAppState.menuIdRequested == -1) {
                        if (GameAppState.levelNumber == 3) {
                            GameAppState.doorOpened = false;
                        }
                        if (!this.levelCleared) {
                            this.levelCleared = true;
                            GameAppState.changeMusic("/sfx/clear.mid", 1);
                            if (GameAppState.levelNumber == 8 || GameAppState.levelNumber == 11) {
                                GameAppState.changeMusic(null, 0);
                            }
                        }
                        if (Music.getIdOfMusicBeingPlayed() == null) {
                            if (GameAppState.levelNumber == 5 && GameAppState.difficulty == 0) {
                                GameAppState.menuIdRequested = (byte)112;
                                GameAppState.difficultiesPlayed = 1;
                                GameAppState.savedGameExist = false;
                                GameAppState.fadeOutIn();
                                this.levelCleared = false;
                            } else {
                                GameAppState.levelRequested = (byte)(GameAppState.levelNumber + 1);
                                GameAppState.fadeOutIn();
                                this.levelCleared = false;
                            }
                        }
                    }
                    if (GameAppState.levelNumber == 12) {
                        GameAppState.changeMusic("/sfx/endgame.mid", -1);
                        GameAppState.splash = new SplashScreen(new DataInputStream(this.getClass().getResourceAsStream("/level9ending1.splash")));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EnemyParameters findEnemyParameters(int enemyType) {
        for (int i = 0; i < this.params.length; ++i) {
            if (this.params[i].enemyType != enemyType) continue;
            return this.params[i];
        }
        return null;
    }

    public Point checkPoint(int x, int y, int currentSector) {
        block26: {
            try {
                int i;
                if (GameAppState.levelNumber == 7) {
                    if (this.currentRegion == 1) {
                        int xx = this.sectorEdgeTop[5].xPoint[0] + 16;
                        if (x < xx) {
                            return new Point(xx, 125);
                        }
                        return null;
                    }
                    if (this.currentRegion == 3) {
                        int xx = this.sectorEdgeTop[19].xPoint[0] + 16;
                        if (x < xx) {
                            return new Point(xx, 125);
                        }
                        return null;
                    }
                }
                if (x < 15) {
                    return new Point(17, y);
                }
                if (x + 15 > GameAppState.scaleUpValue(this.tiledLayer.layerWidth)) {
                    return new Point(60, y);
                }
                SectorEdge edgeTop = this.sectorEdgeTop[currentSector];
                SectorEdge edgeBottom = this.sectorEdgeBottom[currentSector];
                if (this.sectorType[currentSector] == 1) {
                    if (x < edgeTop.xPoint[0]) {
                        Point p = new Point(edgeTop.xPoint[0] + 2, y);
                        if (edgeTop.edgeType[0] == -100) {
                            p.passingType = (byte)3;
                        }
                        return p;
                    }
                    int last = edgeTop.pointsNumber - 2;
                    if (x > edgeTop.xPoint[last]) {
                        Point p = new Point(edgeTop.xPoint[last] + 2, y);
                        if (edgeTop.edgeType[last] == -100) {
                            p.passingType = (byte)3;
                        }
                        return p;
                    }
                    return null;
                }
                if (this.sectorType[currentSector] != 0 && this.sectorType[currentSector] != 3 && this.sectorType[currentSector] != 4 && this.sectorType[currentSector] != 5) break block26;
                int wallTop = 0;
                int wallBottom = 0;
                for (i = 1; i < edgeTop.pointsNumber; ++i) {
                    wallTop = i - 1;
                    if (x <= edgeTop.xPoint[i]) break;
                }
                for (i = 1; i < edgeBottom.pointsNumber; ++i) {
                    wallBottom = i - 1;
                    if (x <= edgeBottom.xPoint[i]) break;
                }
                int yMaxTop = Math.max(edgeTop.yPoint[wallTop], edgeTop.yPoint[wallTop + 1]);
                int yMinBottom = Math.min(edgeBottom.yPoint[wallBottom], edgeBottom.yPoint[wallBottom + 1]);
                if (x < edgeBottom.xPoint[wallBottom] && edgeBottom.xPoint[wallBottom] == edgeBottom.xPoint[wallBottom + 1]) {
                    return new Point(edgeBottom.xPoint[wallBottom] + 2, y - 2);
                }
                if (x > edgeTop.xPoint[wallTop + 1] && edgeTop.xPoint[wallTop + 1] == edgeTop.xPoint[wallTop]) {
                    return new Point(edgeTop.xPoint[wallTop + 1] - 2, y + 2);
                }
                if (y < yMaxTop) {
                    if (edgeTop.xPoint[wallTop + 1] != edgeTop.xPoint[wallTop] && edgeTop.yPoint[wallTop + 1] != edgeTop.yPoint[wallTop]) {
                        int yy = edgeTop.yPoint[wallTop] + (x - edgeTop.xPoint[wallTop]) * (edgeTop.yPoint[wallTop + 1] - edgeTop.yPoint[wallTop]) / (edgeTop.xPoint[wallTop + 1] - edgeTop.xPoint[wallTop]);
                        if (y < yy) {
                            int xx = edgeTop.xPoint[wallTop] + (y - edgeTop.yPoint[wallTop]) * (edgeTop.xPoint[wallTop + 1] - edgeTop.xPoint[wallTop]) / (edgeTop.yPoint[wallTop + 1] - edgeTop.yPoint[wallTop]);
                            xx = x > xx ? (xx -= 10) : (xx += 10);
                            return new Point(xx, yy);
                        }
                        break block26;
                    }
                    if (edgeTop.xPoint[wallTop + 1] == edgeTop.xPoint[wallTop]) {
                        return new Point(edgeTop.xPoint[wallTop + 1] - 5, y);
                    }
                    return new Point(x, edgeTop.yPoint[wallTop] + 5);
                }
                if (y <= yMinBottom) {
                    return null;
                }
                if (edgeBottom.xPoint[wallBottom + 1] != edgeBottom.xPoint[wallBottom] && edgeBottom.yPoint[wallBottom + 1] != edgeBottom.yPoint[wallBottom]) {
                    int yy = edgeBottom.yPoint[wallBottom] + (x - edgeBottom.xPoint[wallBottom]) * (edgeBottom.yPoint[wallBottom + 1] - edgeBottom.yPoint[wallBottom]) / (edgeBottom.xPoint[wallBottom + 1] - edgeBottom.xPoint[wallBottom]);
                    if (y > yy) {
                        int xx = edgeBottom.xPoint[wallBottom] + (y - edgeBottom.yPoint[wallBottom]) * (edgeBottom.xPoint[wallBottom + 1] - edgeBottom.xPoint[wallBottom]) / (edgeBottom.yPoint[wallBottom + 1] - edgeBottom.yPoint[wallBottom]);
                        xx = x > xx ? (xx -= 10) : (xx += 10);
                        return new Point(xx, yy);
                    }
                    break block26;
                }
                if (edgeBottom.xPoint[wallBottom + 1] == edgeBottom.xPoint[wallBottom]) {
                    return new Point(edgeBottom.xPoint[wallBottom + 1] + 5, y);
                }
                return new Point(x, edgeBottom.yPoint[wallBottom] - 5);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

