/*
 * Decompiled with CFR 0.152.
 */
package framework;

import app.GameAppState;
import framework.AppState;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class MainGameCanvas
extends GameCanvas
implements Runnable {
    public static final int SOFTKEY_LEFT = -6;
    public static final int SOFTKEY_RIGHT = -7;
    public static final int KEY_FIRE = -5;
    public static final int KEY_UP_ARROW = -1;
    public static final int KEY_DOWN_ARROW = -2;
    public static final int KEY_RIGHT_ARROW = -4;
    public static final int KEY_LEFT_ARROW = -3;
    public static final int KEY_STATE_UP = 2;
    public static final int KEY_STATE_DOWN = 64;
    public static final int KEY_STATE_RIGHT = 32;
    public static final int KEY_STATE_LEFT = 4;
    public static final int KEY_STATE_FIRE = 256;
    public static long totalTime;
    public static long lastTime;
    public static long currentTime;
    public long framesCount;
    private Thread gameThread;
    private boolean finishApp;
    private boolean finished;
    private boolean paused;
    private int deltaTime;
    private Hashtable statesMap;
    private AppState currentAppState;
    private AppState requestedAppState;
    private Object requestedAppStateParam;
    private Graphics g;
    private Thread appThread;

    public MainGameCanvas() {
        super(false);
        this.setFullScreenMode(true);
        this.statesMap = new Hashtable();
    }

    public void beginMainLoop() {
        if (this.finished || this.gameThread == null) {
            this.gameThread = new Thread(this);
            this.gameThread.start();
        }
        this.finishApp = false;
    }

    public void endMainLoop() {
        this.finishApp = true;
        if (!Thread.currentThread().equals(this.appThread)) {
            while (!this.finished) {
                this.sleep(50);
            }
        }
    }

    public void registerAppState(AppState state) {
        if (this.statesMap.containsKey(state.getName())) {
            throw new RuntimeException(":: State with name " + state.getName() + " has already been registered.");
        }
        this.statesMap.put(state.getName(), state);
    }

    public void requestAppStateChange(String stateName, Object param) {
        if (!this.statesMap.containsKey(stateName)) {
            this.requestAppStateChange("ErrorAppState", "Error: There's no such\nstate as " + stateName + ".");
            return;
        }
        this.requestedAppState = (AppState)this.statesMap.get(stateName);
        this.requestedAppStateParam = param;
        if (this.currentAppState == null) {
            this.changeAppState(this.requestedAppState, param);
        }
    }

    public void requestAppStateChange(String stateName) {
        this.requestAppStateChange(stateName, null);
    }

    public void run() {
        this.appThread = Thread.currentThread();
        this.finished = false;
        this.g = this.getGraphics();
        while (!this.finishApp) {
            if (this.requestedAppState != null) {
                do {
                    this.changeAppState(this.requestedAppState, this.requestedAppStateParam);
                } while (this.requestedAppState != null);
            }
            if (!this.paused) {
                currentTime = System.currentTimeMillis();
                if (lastTime == -1L) {
                    lastTime = currentTime;
                    continue;
                }
                this.deltaTime = (int)(currentTime - lastTime);
                if (this.deltaTime < GameAppState.MIN_INTERVAL_TIME) {
                    this.sleep(GameAppState.MIN_INTERVAL_TIME - this.deltaTime);
                    currentTime = System.currentTimeMillis();
                    this.deltaTime = (int)(currentTime - lastTime);
                }
                totalTime += (long)this.deltaTime;
                this.currentAppState.handleInput();
                this.currentAppState.update(this.deltaTime);
                this.currentAppState.render(this.g);
                lastTime = currentTime;
                ++this.framesCount;
                try {
                    this.flushGraphics();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Thread.yield();
                continue;
            }
            this.sleep(50);
        }
        this.finished = true;
    }

    void setPaused(boolean value) {
        this.paused = value;
        if (value) {
            lastTime = -1L;
        }
    }

    private void changeAppState(AppState gameState, Object param) {
        if (this.currentAppState != null) {
            this.currentAppState.deinitialize();
        }
        this.requestedAppState = null;
        this.requestedAppStateParam = null;
        this.currentAppState = gameState;
        if (!this.currentAppState.initialize(param) && this.requestedAppState == null) {
            this.requestAppStateChange("ErrorAppState", "Unknown error.\nHave you forgotten\nto request error state\nafter failed initialization?");
        }
        lastTime = -1L;
    }

    protected void keyPressed(int keyCode) {
        this.currentAppState.keyPressed(keyCode);
    }

    protected void keyReleased(int keyCode) {
        this.currentAppState.keyReleased(keyCode);
    }

    protected void showNotify() {
        if (this.paused) {
            this.currentAppState.pauseStateChanged(false);
        }
        this.g = this.getGraphics();
    }

    protected void hideNotify() {
        this.currentAppState.pauseStateChanged(true);
    }

    public String getCurrentAppStateName() {
        if (this.currentAppState != null) {
            return this.currentAppState.name;
        }
        return null;
    }

    public void applicationDestroyed() {
        if (this.currentAppState != null) {
            this.currentAppState.applicationDestroyed();
        }
    }

    private void sleep(int interval) {
        if (interval < 0) {
            return;
        }
        try {
            Thread.sleep(interval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean keyDown(int keyCode) {
        return keyCode == -2 || keyCode == 56;
    }

    public static boolean keyUp(int keyCode) {
        return keyCode == -1 || keyCode == 50;
    }

    public static boolean keyLeft(int keyCode) {
        return keyCode == -3 || keyCode == 52;
    }

    public static boolean keyRight(int keyCode) {
        return keyCode == -4 || keyCode == 54;
    }

    public static boolean keyFire(int keyCode) {
        return keyCode == -5 || keyCode == 53;
    }
}

