/*
 * Decompiled with CFR 0.152.
 */
package engine;

import java.io.DataInputStream;
import java.io.IOException;

public class TilesImage {
    public short[] colors;
    public short[][] layerTiles;

    public TilesImage(DataInputStream din) {
        try {
            int colorsNumber = din.readByte();
            this.colors = new short[colorsNumber];
            for (int i = 0; i < colorsNumber; ++i) {
                this.colors[i] = din.readShort();
            }
            int tilesCount = din.readShort();
            byte w = 0;
            byte h = 0;
            this.layerTiles = new short[tilesCount][];
            for (int i = 0; i < tilesCount; ++i) {
                w = din.readByte();
                h = din.readByte();
                this.layerTiles[i] = new short[w * h];
                for (int j = 0; j < this.layerTiles[i].length; ++j) {
                    this.layerTiles[i][j] = this.colors[din.readByte()];
                }
            }
            din.close();
            din = null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void clear() {
        this.layerTiles = null;
        this.colors = null;
    }
}

