/*
 * Decompiled with CFR 0.152.
 */
package BS;

import BS.BSCanvas;
import BS.DrawManager;
import BS.Resolution;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class StringManager {
    private static Image[] colorFont;
    public static final int Hc;
    public static final int WHITE_FONT = 0;
    public static final int PINK_FONT = 1;
    public static final int VIOLET_FONT = 2;
    public static Image[] imgFont;

    public static final void drawString(Graphics g, String text, int x, int y, int Anchor, int system_color) {
        int graph_color = 0;
        if (system_color == DrawManager.COLOR_MENU_STRING[0]) {
            graph_color = 1;
        } else if (system_color == DrawManager.COLOR_MENU_STRING[1] || system_color == DrawManager.COLOR_MENU_STRING[7] || system_color == DrawManager.COLOR_MENU_STRING[8]) {
            graph_color = 2;
        } else if (system_color == DrawManager.COLOR_MENU_STRING[6] || system_color == DrawManager.COLOR_MENU_STRING[9]) {
            graph_color = 0;
        }
        if (Anchor == 33 || Anchor == 17) {
            if (Anchor == 17) {
                StringManager.drawGraphCenterString(g, text, x, y + Hc, graph_color);
            } else if (Anchor == 3) {
                StringManager.drawGraphCenterString(g, text, x, y + Hc / 2, graph_color);
            } else {
                StringManager.drawGraphCenterString(g, text, x, y, graph_color);
            }
        } else if (Anchor == 40) {
            StringManager.drawGraphString(g, text, x - StringManager.getGraphStringWidth(text), y, graph_color);
        } else if (Anchor == 20) {
            StringManager.drawGraphString(g, text, x, y + Hc, graph_color);
        } else {
            StringManager.drawGraphString(g, text, x, y, graph_color);
        }
    }

    public static final int getStringWidth(String str) {
        return StringManager.getGraphStringWidth(str);
    }

    public static final int getStringWidth(int id) {
        String text = BSCanvas.idStoreLanguage >= 0 ? BSCanvas.TEXT[BSCanvas.idStoreLanguage][id] : BSCanvas.TEXT[0][id];
        return StringManager.getStringWidth(text);
    }

    public static final void drawString(Graphics g, int id, int x, int y, int Anchor, int system_color) {
        String text = BSCanvas.idStoreLanguage >= 0 ? BSCanvas.TEXT[BSCanvas.idStoreLanguage][id] : BSCanvas.TEXT[0][id];
        StringManager.drawString(g, text, x, y, Anchor, system_color);
    }

    public static void drawGraphCenterString(Graphics g, String str, int offsetX, int offsetY, int color) {
        StringManager.drawGraphString(g, str, offsetX - StringManager.getGraphStringWidth(str) / 2, offsetY, color);
    }

    public static final void drawGraphString(Graphics g, String text, int x, int y, int color) {
        int clip_x = g.getClipX();
        int clip_y = g.getClipY();
        int clip_dx = g.getClipWidth();
        int clip_dy = g.getClipHeight();
        if (x < clip_x && x < clip_x + clip_dx && (y -= StringManager.getGraphStringHeight(text)) >= clip_y && y <= clip_y + clip_dy && (y < g.getClipY() || y > g.getClipY() + g.getClipHeight())) {
            return;
        }
        for (int i = 0; i < text.length() && y < 320 && y > -Hc; ++i) {
            int index = text.charAt(i) - 32;
            if (index < 0 || Resolution.font[index] == null) continue;
            if (index == 0) {
                x += Resolution.font[index][2];
                continue;
            }
            try {
                DrawManager.DrawRegion(imgFont[color], Resolution.font[index][0], Resolution.font[index][1], Resolution.font[index][2], Hc, 0, x, y, 0, g);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (index == 14) {
                x += Resolution.font[index][2];
                continue;
            }
            x += Resolution.font[index][2] + 2;
        }
        g.setClip(clip_x, clip_y, clip_dx, clip_dy);
    }

    public static int getGraphStringWidth(String t) {
        int len = 0;
        int index = 0;
        for (int i = 0; i < t.length(); ++i) {
            try {
                index = t.charAt(i) - 32;
                if (index < 0) continue;
                if (index > 0 && i < t.length() - 1) {
                    len += Resolution.font[index][2] + 2;
                    continue;
                }
                len += Resolution.font[index][2];
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return len;
    }

    public static int getGraphStringWidth(int index) {
        return StringManager.getGraphStringWidth(BSCanvas.TEXT[BSCanvas.idStoreLanguage][index]);
    }

    public static int getGraphStringHeight(String t) {
        return Hc;
    }

    public static final int getCharHeight() {
        return Hc;
    }

    public static final int getCharWidth(char c) {
        int index = c - 32;
        if (index < 0) {
            return 0;
        }
        return Resolution.font[index][1];
    }

    public static final void drawSystemString(Graphics g, String str, int x, int y, int Anchor, int color) {
        g.setColor(color);
        g.drawString(str, x + 0, y + 0, Anchor);
    }

    public static final void drawSystemString(Graphics g, int id, int x, int y, int Anchor, int color) {
        String text = BSCanvas.idStoreLanguage >= 0 ? BSCanvas.TEXT[BSCanvas.idStoreLanguage][id] : BSCanvas.TEXT[0][id];
        g.setColor(color);
        g.drawString(text, x + 0, y + 0, Anchor);
    }

    public static int getWidthSystemString(int index) {
        return DrawManager.font.stringWidth(BSCanvas.TEXT[BSCanvas.idStoreLanguage][index]);
    }

    public static int getWidthSystemString(String str) {
        return DrawManager.font.stringWidth(str);
    }

    static {
        Hc = Resolution.GRAPHIC_FONT_HEIGHT;
        imgFont = new Image[3];
    }
}

