/*
 * Decompiled with CFR 0.152.
 */
package BS;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class SoundDevice {
    public static final byte SOUND_THEME = 0;
    public static final byte SOUND_IMPAT = 1;
    public static final byte SOUND_BILL = 2;
    public static final byte SOUND_END_LEVEL = 3;
    public static final byte SOUND_GOOD = 4;
    public static final byte SOUND_FAILURE = 5;
    public static byte bCurrentSound = (byte)-1;
    public static boolean soundIsPlaying = false;
    private static final String[] SOUND_FILES = new String[]{"/res/Theme.mid", "/res/Client-Impatient.mid", "/res/Bill.mid", "/res/End-Level.mid", "/res/Good.mid", "/res/Failure.mid"};
    public static final Player[] tabPlayer = new Player[6];
    private static VolumeControl volCtrl;
    private static boolean isPause;

    public void loadSound(byte sound) {
        if (tabPlayer[sound] == null) {
            bCurrentSound = sound;
            try {
                InputStream InStream = this.getClass().getResourceAsStream(SOUND_FILES[sound]);
                SoundDevice.tabPlayer[sound] = Manager.createPlayer((InputStream)InStream, (String)"audio/midi");
                tabPlayer[sound].prefetch();
                tabPlayer[sound].realize();
                this.setSoundLevel(50, sound);
            }
            catch (IOException e) {
                System.out.println("error : loadSound() -- IOException");
            }
            catch (MediaException m) {
                System.out.println("error : loadSound() -- MediaException");
            }
        }
    }

    public void playSound(byte sound, int loop) {
        bCurrentSound = sound;
        if (tabPlayer[sound] == null) {
            this.loadSound(sound);
        }
        try {
            tabPlayer[sound].setLoopCount(loop);
            tabPlayer[sound].start();
            soundIsPlaying = true;
        }
        catch (MediaException m) {
            System.out.println("error : playSound()");
        }
    }

    public void stopSound(byte sound, boolean resetSound) {
        if (tabPlayer[sound] != null) {
            try {
                tabPlayer[sound].stop();
                soundIsPlaying = false;
            }
            catch (MediaException m) {
                System.out.println("error : stopSound()");
            }
            if (resetSound) {
                tabPlayer[sound].close();
                SoundDevice.tabPlayer[sound] = null;
                this.loadSound(sound);
            }
        }
    }

    public void pauseSound(byte sound) {
        if (tabPlayer[sound] != null) {
            isPause = true;
            this.stopSound(sound, false);
        }
    }

    public void resumeSound(byte sound, int loop) {
        if (isPause) {
            isPause = false;
            this.playSound(sound, loop);
        }
    }

    public void releaseSound(byte sound) {
        if (tabPlayer[sound] != null) {
            this.stopSound(sound, false);
            tabPlayer[sound].close();
            SoundDevice.tabPlayer[sound] = null;
            System.gc();
        }
    }

    public void setSoundLevel(int level, byte sound) {
        volCtrl = (VolumeControl)tabPlayer[sound].getControl("VolumeControl");
        volCtrl.setLevel(level);
    }

    public boolean isPlaying(int sound) {
        if (tabPlayer[sound] != null) {
            return tabPlayer[sound].getState() == 400;
        }
        return false;
    }
}

